/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterfaceUtils;
import android.media.MediaDataSource;
import android.media.MediaMetadataRetriever;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class ExifInterface {
    private static final String TAG = "ExifInterface";
    private static final boolean DEBUG = Log.isLoggable("ExifInterface", 3);
    public static final String TAG_ARTIST = "Artist";
    public static final String TAG_BITS_PER_SAMPLE = "BitsPerSample";
    public static final String TAG_COMPRESSION = "Compression";
    public static final String TAG_COPYRIGHT = "Copyright";
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_IMAGE_DESCRIPTION = "ImageDescription";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT = "JPEGInterchangeFormat";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = "JPEGInterchangeFormatLength";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_PHOTOMETRIC_INTERPRETATION = "PhotometricInterpretation";
    public static final String TAG_PLANAR_CONFIGURATION = "PlanarConfiguration";
    public static final String TAG_PRIMARY_CHROMATICITIES = "PrimaryChromaticities";
    public static final String TAG_REFERENCE_BLACK_WHITE = "ReferenceBlackWhite";
    public static final String TAG_RESOLUTION_UNIT = "ResolutionUnit";
    public static final String TAG_ROWS_PER_STRIP = "RowsPerStrip";
    public static final String TAG_SAMPLES_PER_PIXEL = "SamplesPerPixel";
    public static final String TAG_SOFTWARE = "Software";
    public static final String TAG_STRIP_BYTE_COUNTS = "StripByteCounts";
    public static final String TAG_STRIP_OFFSETS = "StripOffsets";
    public static final String TAG_TRANSFER_FUNCTION = "TransferFunction";
    public static final String TAG_WHITE_POINT = "WhitePoint";
    public static final String TAG_X_RESOLUTION = "XResolution";
    public static final String TAG_Y_CB_CR_COEFFICIENTS = "YCbCrCoefficients";
    public static final String TAG_Y_CB_CR_POSITIONING = "YCbCrPositioning";
    public static final String TAG_Y_CB_CR_SUB_SAMPLING = "YCbCrSubSampling";
    public static final String TAG_Y_RESOLUTION = "YResolution";
    public static final String TAG_APERTURE_VALUE = "ApertureValue";
    public static final String TAG_BRIGHTNESS_VALUE = "BrightnessValue";
    public static final String TAG_CFA_PATTERN = "CFAPattern";
    public static final String TAG_COLOR_SPACE = "ColorSpace";
    public static final String TAG_COMPONENTS_CONFIGURATION = "ComponentsConfiguration";
    public static final String TAG_COMPRESSED_BITS_PER_PIXEL = "CompressedBitsPerPixel";
    public static final String TAG_CONTRAST = "Contrast";
    public static final String TAG_CUSTOM_RENDERED = "CustomRendered";
    public static final String TAG_DATETIME_DIGITIZED = "DateTimeDigitized";
    public static final String TAG_DATETIME_ORIGINAL = "DateTimeOriginal";
    public static final String TAG_DEVICE_SETTING_DESCRIPTION = "DeviceSettingDescription";
    public static final String TAG_DIGITAL_ZOOM_RATIO = "DigitalZoomRatio";
    public static final String TAG_EXIF_VERSION = "ExifVersion";
    public static final String TAG_EXPOSURE_BIAS_VALUE = "ExposureBiasValue";
    public static final String TAG_EXPOSURE_INDEX = "ExposureIndex";
    public static final String TAG_EXPOSURE_MODE = "ExposureMode";
    public static final String TAG_EXPOSURE_PROGRAM = "ExposureProgram";
    public static final String TAG_EXPOSURE_TIME = "ExposureTime";
    public static final String TAG_F_NUMBER = "FNumber";
    @Deprecated
    public static final String TAG_APERTURE = "FNumber";
    public static final String TAG_FILE_SOURCE = "FileSource";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_FLASH_ENERGY = "FlashEnergy";
    public static final String TAG_FLASHPIX_VERSION = "FlashpixVersion";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_FOCAL_LENGTH_IN_35MM_FILM = "FocalLengthIn35mmFilm";
    public static final String TAG_FOCAL_PLANE_RESOLUTION_UNIT = "FocalPlaneResolutionUnit";
    public static final String TAG_FOCAL_PLANE_X_RESOLUTION = "FocalPlaneXResolution";
    public static final String TAG_FOCAL_PLANE_Y_RESOLUTION = "FocalPlaneYResolution";
    public static final String TAG_GAIN_CONTROL = "GainControl";
    public static final String TAG_ISO_SPEED_RATINGS = "ISOSpeedRatings";
    @Deprecated
    public static final String TAG_ISO = "ISOSpeedRatings";
    public static final String TAG_IMAGE_UNIQUE_ID = "ImageUniqueID";
    public static final String TAG_LIGHT_SOURCE = "LightSource";
    public static final String TAG_MAKER_NOTE = "MakerNote";
    public static final String TAG_MAX_APERTURE_VALUE = "MaxApertureValue";
    public static final String TAG_METERING_MODE = "MeteringMode";
    public static final String TAG_NEW_SUBFILE_TYPE = "NewSubfileType";
    public static final String TAG_OECF = "OECF";
    public static final String TAG_OFFSET_TIME = "OffsetTime";
    public static final String TAG_OFFSET_TIME_ORIGINAL = "OffsetTimeOriginal";
    public static final String TAG_OFFSET_TIME_DIGITIZED = "OffsetTimeDigitized";
    public static final String TAG_PIXEL_X_DIMENSION = "PixelXDimension";
    public static final String TAG_PIXEL_Y_DIMENSION = "PixelYDimension";
    public static final String TAG_RELATED_SOUND_FILE = "RelatedSoundFile";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SCENE_CAPTURE_TYPE = "SceneCaptureType";
    public static final String TAG_SCENE_TYPE = "SceneType";
    public static final String TAG_SENSING_METHOD = "SensingMethod";
    public static final String TAG_SHARPNESS = "Sharpness";
    public static final String TAG_SHUTTER_SPEED_VALUE = "ShutterSpeedValue";
    public static final String TAG_SPATIAL_FREQUENCY_RESPONSE = "SpatialFrequencyResponse";
    public static final String TAG_SPECTRAL_SENSITIVITY = "SpectralSensitivity";
    public static final String TAG_SUBFILE_TYPE = "SubfileType";
    public static final String TAG_SUBSEC_TIME = "SubSecTime";
    public static final String TAG_SUBSEC_TIME_DIG = "SubSecTimeDigitized";
    public static final String TAG_SUBSEC_TIME_DIGITIZED = "SubSecTimeDigitized";
    public static final String TAG_SUBSEC_TIME_ORIG = "SubSecTimeOriginal";
    public static final String TAG_SUBSEC_TIME_ORIGINAL = "SubSecTimeOriginal";
    public static final String TAG_SUBJECT_AREA = "SubjectArea";
    public static final String TAG_SUBJECT_DISTANCE = "SubjectDistance";
    public static final String TAG_SUBJECT_DISTANCE_RANGE = "SubjectDistanceRange";
    public static final String TAG_SUBJECT_LOCATION = "SubjectLocation";
    public static final String TAG_USER_COMMENT = "UserComment";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_AREA_INFORMATION = "GPSAreaInformation";
    public static final String TAG_GPS_DOP = "GPSDOP";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_GPS_DEST_BEARING = "GPSDestBearing";
    public static final String TAG_GPS_DEST_BEARING_REF = "GPSDestBearingRef";
    public static final String TAG_GPS_DEST_DISTANCE = "GPSDestDistance";
    public static final String TAG_GPS_DEST_DISTANCE_REF = "GPSDestDistanceRef";
    public static final String TAG_GPS_DEST_LATITUDE = "GPSDestLatitude";
    public static final String TAG_GPS_DEST_LATITUDE_REF = "GPSDestLatitudeRef";
    public static final String TAG_GPS_DEST_LONGITUDE = "GPSDestLongitude";
    public static final String TAG_GPS_DEST_LONGITUDE_REF = "GPSDestLongitudeRef";
    public static final String TAG_GPS_DIFFERENTIAL = "GPSDifferential";
    public static final String TAG_GPS_IMG_DIRECTION = "GPSImgDirection";
    public static final String TAG_GPS_IMG_DIRECTION_REF = "GPSImgDirectionRef";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_GPS_MAP_DATUM = "GPSMapDatum";
    public static final String TAG_GPS_MEASURE_MODE = "GPSMeasureMode";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final String TAG_GPS_SATELLITES = "GPSSatellites";
    public static final String TAG_GPS_SPEED = "GPSSpeed";
    public static final String TAG_GPS_SPEED_REF = "GPSSpeedRef";
    public static final String TAG_GPS_STATUS = "GPSStatus";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_GPS_TRACK = "GPSTrack";
    public static final String TAG_GPS_TRACK_REF = "GPSTrackRef";
    public static final String TAG_GPS_VERSION_ID = "GPSVersionID";
    public static final String TAG_INTEROPERABILITY_INDEX = "InteroperabilityIndex";
    public static final String TAG_THUMBNAIL_IMAGE_LENGTH = "ThumbnailImageLength";
    public static final String TAG_THUMBNAIL_IMAGE_WIDTH = "ThumbnailImageWidth";
    public static final String TAG_THUMBNAIL_ORIENTATION = "ThumbnailOrientation";
    public static final String TAG_DNG_VERSION = "DNGVersion";
    public static final String TAG_DEFAULT_CROP_SIZE = "DefaultCropSize";
    public static final String TAG_ORF_THUMBNAIL_IMAGE = "ThumbnailImage";
    public static final String TAG_ORF_PREVIEW_IMAGE_START = "PreviewImageStart";
    public static final String TAG_ORF_PREVIEW_IMAGE_LENGTH = "PreviewImageLength";
    public static final String TAG_ORF_ASPECT_FRAME = "AspectFrame";
    public static final String TAG_RW2_SENSOR_BOTTOM_BORDER = "SensorBottomBorder";
    public static final String TAG_RW2_SENSOR_LEFT_BORDER = "SensorLeftBorder";
    public static final String TAG_RW2_SENSOR_RIGHT_BORDER = "SensorRightBorder";
    public static final String TAG_RW2_SENSOR_TOP_BORDER = "SensorTopBorder";
    public static final String TAG_RW2_ISO = "ISO";
    public static final String TAG_RW2_JPG_FROM_RAW = "JpgFromRaw";
    public static final String TAG_XMP = "Xmp";
    private static final String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    private static final String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    private static final String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    private static final String TAG_SUB_IFD_POINTER = "SubIFDPointer";
    private static final String TAG_ORF_CAMERA_SETTINGS_IFD_POINTER = "CameraSettingsIFDPointer";
    private static final String TAG_ORF_IMAGE_PROCESSING_IFD_POINTER = "ImageProcessingIFDPointer";
    private static final String TAG_HAS_THUMBNAIL = "HasThumbnail";
    private static final String TAG_THUMBNAIL_OFFSET = "ThumbnailOffset";
    private static final String TAG_THUMBNAIL_LENGTH = "ThumbnailLength";
    private static final String TAG_THUMBNAIL_DATA = "ThumbnailData";
    private static final int MAX_THUMBNAIL_SIZE = 512;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_ROTATE_270 = 8;
    public static final int WHITEBALANCE_AUTO = 0;
    public static final int WHITEBALANCE_MANUAL = 1;
    public static final int STREAM_TYPE_FULL_IMAGE_DATA = 0;
    public static final int STREAM_TYPE_EXIF_DATA_ONLY = 1;
    private static final int SIGNATURE_CHECK_SIZE = 5000;
    private static final byte[] JPEG_SIGNATURE = new byte[]{-1, -40, -1};
    private static final String RAF_SIGNATURE = "FUJIFILMCCD-RAW";
    private static final int RAF_OFFSET_TO_JPEG_IMAGE_OFFSET = 84;
    private static final int RAF_INFO_SIZE = 160;
    private static final int RAF_JPEG_LENGTH_VALUE_SIZE = 4;
    private static final byte[] HEIF_TYPE_FTYP = new byte[]{102, 116, 121, 112};
    private static final byte[] HEIF_BRAND_MIF1 = new byte[]{109, 105, 102, 49};
    private static final byte[] HEIF_BRAND_HEIC = new byte[]{104, 101, 105, 99};
    private static final byte[] HEIF_BRAND_AVIF = new byte[]{97, 118, 105, 102};
    private static final byte[] HEIF_BRAND_AVIS = new byte[]{97, 118, 105, 115};
    private static final short ORF_SIGNATURE_1 = 20306;
    private static final short ORF_SIGNATURE_2 = 21330;
    private static final byte[] ORF_MAKER_NOTE_HEADER_1 = new byte[]{79, 76, 89, 77, 80, 0};
    private static final byte[] ORF_MAKER_NOTE_HEADER_2 = new byte[]{79, 76, 89, 77, 80, 85, 83, 0, 73, 73};
    private static final int ORF_MAKER_NOTE_HEADER_1_SIZE = 8;
    private static final int ORF_MAKER_NOTE_HEADER_2_SIZE = 12;
    private static final short RW2_SIGNATURE = 85;
    private static final String PEF_SIGNATURE = "PENTAX";
    private static final int PEF_MAKER_NOTE_SKIP_SIZE = 6;
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] PNG_CHUNK_TYPE_EXIF = new byte[]{101, 88, 73, 102};
    private static final byte[] PNG_CHUNK_TYPE_IHDR = new byte[]{73, 72, 68, 82};
    private static final byte[] PNG_CHUNK_TYPE_IEND = new byte[]{73, 69, 78, 68};
    private static final int PNG_CHUNK_TYPE_BYTE_LENGTH = 4;
    private static final int PNG_CHUNK_CRC_BYTE_LENGTH = 4;
    private static final byte[] WEBP_SIGNATURE_1 = new byte[]{82, 73, 70, 70};
    private static final byte[] WEBP_SIGNATURE_2 = new byte[]{87, 69, 66, 80};
    private static final int WEBP_FILE_SIZE_BYTE_LENGTH = 4;
    private static final byte[] WEBP_CHUNK_TYPE_EXIF = new byte[]{69, 88, 73, 70};
    private static final byte[] WEBP_VP8_SIGNATURE = new byte[]{-99, 1, 42};
    private static final byte WEBP_VP8L_SIGNATURE = 47;
    private static final byte[] WEBP_CHUNK_TYPE_VP8X = "VP8X".getBytes(Charset.defaultCharset());
    private static final byte[] WEBP_CHUNK_TYPE_VP8L = "VP8L".getBytes(Charset.defaultCharset());
    private static final byte[] WEBP_CHUNK_TYPE_VP8 = "VP8 ".getBytes(Charset.defaultCharset());
    private static final byte[] WEBP_CHUNK_TYPE_ANIM = "ANIM".getBytes(Charset.defaultCharset());
    private static final byte[] WEBP_CHUNK_TYPE_ANMF = "ANMF".getBytes(Charset.defaultCharset());
    private static final int WEBP_CHUNK_TYPE_VP8X_DEFAULT_LENGTH = 10;
    private static final int WEBP_CHUNK_TYPE_BYTE_LENGTH = 4;
    private static final int WEBP_CHUNK_SIZE_BYTE_LENGTH = 4;
    @GuardedBy(value={"sFormatter"})
    private static SimpleDateFormat sFormatter;
    @GuardedBy(value={"sFormatterTz"})
    private static SimpleDateFormat sFormatterTz;
    private static final short BYTE_ALIGN_II = 18761;
    private static final short BYTE_ALIGN_MM = 19789;
    private static final byte START_CODE = 42;
    private static final int IFD_OFFSET = 8;
    private static final int IFD_FORMAT_BYTE = 1;
    private static final int IFD_FORMAT_STRING = 2;
    private static final int IFD_FORMAT_USHORT = 3;
    private static final int IFD_FORMAT_ULONG = 4;
    private static final int IFD_FORMAT_URATIONAL = 5;
    private static final int IFD_FORMAT_SBYTE = 6;
    private static final int IFD_FORMAT_UNDEFINED = 7;
    private static final int IFD_FORMAT_SSHORT = 8;
    private static final int IFD_FORMAT_SLONG = 9;
    private static final int IFD_FORMAT_SRATIONAL = 10;
    private static final int IFD_FORMAT_SINGLE = 11;
    private static final int IFD_FORMAT_DOUBLE = 12;
    private static final int IFD_FORMAT_IFD = 13;
    private static final String[] IFD_FORMAT_NAMES;
    private static final int[] IFD_FORMAT_BYTES_PER_FORMAT;
    private static final byte[] EXIF_ASCII_PREFIX;
    private static final int DATA_UNCOMPRESSED = 1;
    private static final int DATA_HUFFMAN_COMPRESSED = 2;
    private static final int DATA_JPEG = 6;
    private static final int DATA_JPEG_COMPRESSED = 7;
    private static final int DATA_DEFLATE_ZIP = 8;
    private static final int DATA_PACK_BITS_COMPRESSED = 32773;
    private static final int DATA_LOSSY_JPEG = 34892;
    private static final int[] BITS_PER_SAMPLE_RGB;
    private static final int[] BITS_PER_SAMPLE_GREYSCALE_1;
    private static final int[] BITS_PER_SAMPLE_GREYSCALE_2;
    private static final int PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO = 0;
    private static final int PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    private static final int PHOTOMETRIC_INTERPRETATION_RGB = 2;
    private static final int PHOTOMETRIC_INTERPRETATION_YCBCR = 6;
    private static final int ORIGINAL_RESOLUTION_IMAGE = 0;
    private static final int REDUCED_RESOLUTION_IMAGE = 1;
    private static final ExifTag[] IFD_TIFF_TAGS;
    private static final ExifTag[] IFD_EXIF_TAGS;
    private static final ExifTag[] IFD_GPS_TAGS;
    private static final ExifTag[] IFD_INTEROPERABILITY_TAGS;
    private static final ExifTag[] IFD_THUMBNAIL_TAGS;
    private static final ExifTag TAG_RAF_IMAGE_SIZE;
    private static final ExifTag[] ORF_MAKER_NOTE_TAGS;
    private static final ExifTag[] ORF_CAMERA_SETTINGS_TAGS;
    private static final ExifTag[] ORF_IMAGE_PROCESSING_TAGS;
    private static final ExifTag[] PEF_TAGS;
    private static final int IFD_TYPE_PRIMARY = 0;
    private static final int IFD_TYPE_EXIF = 1;
    private static final int IFD_TYPE_GPS = 2;
    private static final int IFD_TYPE_INTEROPERABILITY = 3;
    private static final int IFD_TYPE_THUMBNAIL = 4;
    private static final int IFD_TYPE_PREVIEW = 5;
    private static final int IFD_TYPE_ORF_MAKER_NOTE = 6;
    private static final int IFD_TYPE_ORF_CAMERA_SETTINGS = 7;
    private static final int IFD_TYPE_ORF_IMAGE_PROCESSING = 8;
    private static final int IFD_TYPE_PEF = 9;
    private static final ExifTag[][] EXIF_TAGS;
    private static final ExifTag[] EXIF_POINTER_TAGS;
    private static final HashMap[] sExifTagMapsForReading;
    private static final HashMap[] sExifTagMapsForWriting;
    private static final HashSet<String> sTagSetForCompatibility;
    private static final HashMap<Integer, Integer> sExifPointerTagMap;
    private static final Charset ASCII;
    private static final byte[] IDENTIFIER_EXIF_APP1;
    private static final byte[] IDENTIFIER_XMP_APP1;
    private static final byte MARKER = -1;
    private static final byte MARKER_SOI = -40;
    private static final byte MARKER_SOF0 = -64;
    private static final byte MARKER_SOF1 = -63;
    private static final byte MARKER_SOF2 = -62;
    private static final byte MARKER_SOF3 = -61;
    private static final byte MARKER_SOF5 = -59;
    private static final byte MARKER_SOF6 = -58;
    private static final byte MARKER_SOF7 = -57;
    private static final byte MARKER_SOF9 = -55;
    private static final byte MARKER_SOF10 = -54;
    private static final byte MARKER_SOF11 = -53;
    private static final byte MARKER_SOF13 = -51;
    private static final byte MARKER_SOF14 = -50;
    private static final byte MARKER_SOF15 = -49;
    private static final byte MARKER_SOS = -38;
    private static final byte MARKER_APP1 = -31;
    private static final byte MARKER_COM = -2;
    private static final byte MARKER_EOI = -39;
    private static final int IMAGE_TYPE_UNKNOWN = 0;
    private static final int IMAGE_TYPE_ARW = 1;
    private static final int IMAGE_TYPE_CR2 = 2;
    private static final int IMAGE_TYPE_DNG = 3;
    private static final int IMAGE_TYPE_JPEG = 4;
    private static final int IMAGE_TYPE_NEF = 5;
    private static final int IMAGE_TYPE_NRW = 6;
    private static final int IMAGE_TYPE_ORF = 7;
    private static final int IMAGE_TYPE_PEF = 8;
    private static final int IMAGE_TYPE_RAF = 9;
    private static final int IMAGE_TYPE_RW2 = 10;
    private static final int IMAGE_TYPE_SRW = 11;
    private static final int IMAGE_TYPE_HEIF = 12;
    private static final int IMAGE_TYPE_PNG = 13;
    private static final int IMAGE_TYPE_WEBP = 14;
    private String mFilename;
    private FileDescriptor mSeekableFileDescriptor;
    private AssetManager.AssetInputStream mAssetInputStream;
    private boolean mIsInputStream;
    private int mMimeType;
    private boolean mIsExifDataOnly;
    @UnsupportedAppUsage(publicAlternatives="Use {@link #getAttribute(java.lang.String)} instead.")
    private final HashMap[] mAttributes = new HashMap[EXIF_TAGS.length];
    private Set<Integer> mHandledIfdOffsets = new HashSet<Integer>(EXIF_TAGS.length);
    private ByteOrder mExifByteOrder = ByteOrder.BIG_ENDIAN;
    private boolean mHasThumbnail;
    private boolean mHasThumbnailStrips;
    private boolean mAreThumbnailStripsConsecutive;
    private int mThumbnailOffset;
    private int mThumbnailLength;
    private byte[] mThumbnailBytes;
    private int mThumbnailCompression;
    private int mExifOffset;
    private int mOrfMakerNoteOffset;
    private int mOrfThumbnailOffset;
    private int mOrfThumbnailLength;
    private int mRw2JpgFromRawOffset;
    private boolean mIsSupportedFile;
    private boolean mModified;
    private boolean mXmpIsFromSeparateMarker;
    private static final Pattern sNonZeroTimePattern;
    private static final Pattern sGpsTimestampPattern;

    public ExifInterface(File file2) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("file cannot be null");
        }
        this.initForFilename(file2.getAbsolutePath());
    }

    public ExifInterface(String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename cannot be null");
        }
        this.initForFilename(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExifInterface(FileDescriptor fileDescriptor) throws IOException {
        if (fileDescriptor == null) {
            throw new NullPointerException("fileDescriptor cannot be null");
        }
        ParcelFileDescriptor modernFd = FileUtils.convertToModernFd(fileDescriptor);
        if (modernFd != null) {
            fileDescriptor = modernFd.getFileDescriptor();
        }
        this.mAssetInputStream = null;
        this.mFilename = null;
        boolean isFdDuped = false;
        if (ExifInterface.isSeekableFD(fileDescriptor) && modernFd == null) {
            this.mSeekableFileDescriptor = fileDescriptor;
            try {
                fileDescriptor = Os.dup(fileDescriptor);
                isFdDuped = true;
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        } else {
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileDescriptor);
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            ExifInterfaceUtils.closeQuietly(in);
            if (isFdDuped) {
                ExifInterfaceUtils.closeFileDescriptor(fileDescriptor);
            }
            if (modernFd != null) {
                modernFd.close();
            }
            throw throwable;
        }
        ExifInterfaceUtils.closeQuietly(in);
        if (isFdDuped) {
            ExifInterfaceUtils.closeFileDescriptor(fileDescriptor);
        }
        if (modernFd != null) {
            modernFd.close();
        }
    }

    public ExifInterface(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public ExifInterface(InputStream inputStream, int streamType) throws IOException {
        this(inputStream, streamType == 1);
    }

    private ExifInterface(InputStream inputStream, boolean shouldBeExifDataOnly) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream cannot be null");
        }
        this.mFilename = null;
        if (shouldBeExifDataOnly) {
            if (!ExifInterface.isExifDataOnly((BufferedInputStream)(inputStream = new BufferedInputStream(inputStream, 5000)))) {
                Log.w(TAG, "Given data does not follow the structure of an Exif-only data.");
                return;
            }
            this.mIsExifDataOnly = true;
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = null;
        } else if (inputStream instanceof AssetManager.AssetInputStream) {
            this.mAssetInputStream = (AssetManager.AssetInputStream)inputStream;
            this.mSeekableFileDescriptor = null;
        } else if (inputStream instanceof FileInputStream && ExifInterface.isSeekableFD(((FileInputStream)inputStream).getFD())) {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = ((FileInputStream)inputStream).getFD();
        } else {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = null;
        }
        this.loadAttributes(inputStream);
    }

    public static boolean isSupportedMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType shouldn't be null");
        }
        switch (mimeType.toLowerCase(Locale.ROOT)) {
            case "image/jpeg": 
            case "image/x-adobe-dng": 
            case "image/x-canon-cr2": 
            case "image/x-nikon-nef": 
            case "image/x-nikon-nrw": 
            case "image/x-sony-arw": 
            case "image/x-panasonic-rw2": 
            case "image/x-olympus-orf": 
            case "image/x-pentax-pef": 
            case "image/x-samsung-srw": 
            case "image/x-fuji-raf": 
            case "image/heic": 
            case "image/heif": 
            case "image/png": 
            case "image/webp": {
                return true;
            }
        }
        return false;
    }

    private ExifAttribute getExifAttribute(String tag2) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            Object value2 = this.mAttributes[i].get(tag2);
            if (value2 == null) continue;
            return (ExifAttribute)value2;
        }
        return null;
    }

    public String getAttribute(String tag2) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        ExifAttribute attribute = this.getExifAttribute(tag2);
        if (attribute != null) {
            if (!sTagSetForCompatibility.contains(tag2)) {
                return attribute.getStringValue(this.mExifByteOrder);
            }
            if (tag2.equals(TAG_GPS_TIMESTAMP)) {
                if (attribute.format != 5 && attribute.format != 10) {
                    return null;
                }
                Rational[] array2 = (Rational[])attribute.getValue(this.mExifByteOrder);
                if (array2.length != 3) {
                    return null;
                }
                return String.format("%02d:%02d:%02d", (int)((float)array2[0].numerator / (float)array2[0].denominator), (int)((float)array2[1].numerator / (float)array2[1].denominator), (int)((float)array2[2].numerator / (float)array2[2].denominator));
            }
            try {
                return Double.toString(attribute.getDoubleValue(this.mExifByteOrder));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public int getAttributeInt(String tag2, int defaultValue) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        ExifAttribute exifAttribute = this.getExifAttribute(tag2);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getIntValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getAttributeDouble(String tag2, double defaultValue) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        ExifAttribute exifAttribute = this.getExifAttribute(tag2);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getDoubleValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setAttribute(String tag2, String value2) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        if (value2 != null && sTagSetForCompatibility.contains(tag2)) {
            if (tag2.equals(TAG_GPS_TIMESTAMP)) {
                Matcher m = sGpsTimestampPattern.matcher(value2);
                if (!m.find()) {
                    Log.w(TAG, "Invalid value for " + tag2 + " : " + value2);
                    return;
                }
                value2 = Integer.parseInt(m.group(1)) + "/1," + Integer.parseInt(m.group(2)) + "/1," + Integer.parseInt(m.group(3)) + "/1";
            } else {
                try {
                    double doubleValue = Double.parseDouble(value2);
                    value2 = (long)(doubleValue * 10000.0) + "/10000";
                }
                catch (NumberFormatException e) {
                    Log.w(TAG, "Invalid value for " + tag2 + " : " + value2);
                    return;
                }
            }
        }
        block12: for (int i = 0; i < EXIF_TAGS.length; ++i) {
            int dataFormat;
            Object obj;
            if (i == 4 && !this.mHasThumbnail || (obj = sExifTagMapsForWriting[i].get(tag2)) == null) continue;
            if (value2 == null) {
                this.mAttributes[i].remove(tag2);
                continue;
            }
            ExifTag exifTag = (ExifTag)obj;
            Pair<Integer, Integer> guess = ExifInterface.guessDataFormat(value2);
            if (exifTag.primaryFormat == (Integer)guess.first || exifTag.primaryFormat == (Integer)guess.second) {
                dataFormat = exifTag.primaryFormat;
            } else if (exifTag.secondaryFormat != -1 && (exifTag.secondaryFormat == (Integer)guess.first || exifTag.secondaryFormat == (Integer)guess.second)) {
                dataFormat = exifTag.secondaryFormat;
            } else if (exifTag.primaryFormat == 1 || exifTag.primaryFormat == 7 || exifTag.primaryFormat == 2) {
                dataFormat = exifTag.primaryFormat;
            } else {
                if (!DEBUG) continue;
                Log.d(TAG, "Given tag (" + tag2 + ") value didn't match with one of expected formats: " + IFD_FORMAT_NAMES[exifTag.primaryFormat] + (exifTag.secondaryFormat == -1 ? "" : ", " + IFD_FORMAT_NAMES[exifTag.secondaryFormat]) + " (guess: " + IFD_FORMAT_NAMES[(Integer)guess.first] + ((Integer)guess.second == -1 ? "" : ", " + IFD_FORMAT_NAMES[(Integer)guess.second]) + ")");
                continue;
            }
            switch (dataFormat) {
                case 1: {
                    this.mAttributes[i].put(tag2, ExifAttribute.createByte(value2));
                    continue block12;
                }
                case 2: 
                case 7: {
                    this.mAttributes[i].put(tag2, ExifAttribute.createString(value2));
                    continue block12;
                }
                case 3: {
                    int j;
                    String[] values2 = value2.split(",");
                    int[] intArray = new int[values2.length];
                    for (j = 0; j < values2.length; ++j) {
                        intArray[j] = Integer.parseInt(values2[j]);
                    }
                    this.mAttributes[i].put(tag2, ExifAttribute.createUShort(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 9: {
                    int j;
                    String[] values2 = value2.split(",");
                    int[] intArray = new int[values2.length];
                    for (j = 0; j < values2.length; ++j) {
                        intArray[j] = Integer.parseInt(values2[j]);
                    }
                    this.mAttributes[i].put(tag2, ExifAttribute.createSLong(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 4: {
                    int j;
                    String[] values2 = value2.split(",");
                    long[] longArray = new long[values2.length];
                    for (j = 0; j < values2.length; ++j) {
                        longArray[j] = Long.parseLong(values2[j]);
                    }
                    this.mAttributes[i].put(tag2, ExifAttribute.createULong(longArray, this.mExifByteOrder));
                    continue block12;
                }
                case 5: {
                    String[] numbers;
                    int j;
                    String[] values2 = value2.split(",");
                    Rational[] rationalArray = new Rational[values2.length];
                    for (j = 0; j < values2.length; ++j) {
                        numbers = values2[j].split("/");
                        rationalArray[j] = new Rational((long)Double.parseDouble(numbers[0]), (long)Double.parseDouble(numbers[1]));
                    }
                    this.mAttributes[i].put(tag2, ExifAttribute.createURational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 10: {
                    String[] numbers;
                    int j;
                    String[] values2 = value2.split(",");
                    Rational[] rationalArray = new Rational[values2.length];
                    for (j = 0; j < values2.length; ++j) {
                        numbers = values2[j].split("/");
                        rationalArray[j] = new Rational((long)Double.parseDouble(numbers[0]), (long)Double.parseDouble(numbers[1]));
                    }
                    this.mAttributes[i].put(tag2, ExifAttribute.createSRational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 12: {
                    int j;
                    String[] values2 = value2.split(",");
                    double[] doubleArray = new double[values2.length];
                    for (j = 0; j < values2.length; ++j) {
                        doubleArray[j] = Double.parseDouble(values2[j]);
                    }
                    this.mAttributes[i].put(tag2, ExifAttribute.createDouble(doubleArray, this.mExifByteOrder));
                    continue block12;
                }
                default: {
                    if (!DEBUG) continue block12;
                    Log.d(TAG, "Data format isn't one of expected formats: " + dataFormat);
                    continue block12;
                }
            }
        }
    }

    private boolean updateAttribute(String tag2, ExifAttribute value2) {
        boolean updated = false;
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            if (!this.mAttributes[i].containsKey(tag2)) continue;
            this.mAttributes[i].put(tag2, value2);
            updated = true;
        }
        return updated;
    }

    private void removeAttribute(String tag2) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            this.mAttributes[i].remove(tag2);
        }
    }

    private void loadAttributes(InputStream in) {
        if (in == null) {
            throw new NullPointerException("inputstream shouldn't be null");
        }
        try {
            for (int i = 0; i < EXIF_TAGS.length; ++i) {
                this.mAttributes[i] = new HashMap();
            }
            if (!this.mIsExifDataOnly) {
                in = new BufferedInputStream(in, 5000);
                this.mMimeType = this.getMimeType((BufferedInputStream)in);
            }
            ByteOrderedDataInputStream inputStream = new ByteOrderedDataInputStream(in);
            if (!this.mIsExifDataOnly) {
                switch (this.mMimeType) {
                    case 4: {
                        this.getJpegAttributes(inputStream, 0, 0);
                        break;
                    }
                    case 9: {
                        this.getRafAttributes(inputStream);
                        break;
                    }
                    case 12: {
                        this.getHeifAttributes(inputStream);
                        break;
                    }
                    case 7: {
                        this.getOrfAttributes(inputStream);
                        break;
                    }
                    case 10: {
                        this.getRw2Attributes(inputStream);
                        break;
                    }
                    case 13: {
                        this.getPngAttributes(inputStream);
                        break;
                    }
                    case 14: {
                        this.getWebpAttributes(inputStream);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 11: {
                        this.getRawAttributes(inputStream);
                        break;
                    }
                }
            } else {
                this.getStandaloneAttributes(inputStream);
            }
            this.setThumbnailData(inputStream);
            this.mIsSupportedFile = true;
        }
        catch (IOException | OutOfMemoryError e) {
            this.mIsSupportedFile = false;
            Log.w(TAG, "Invalid image: ExifInterface got an unsupported image format file(ExifInterface supports JPEG and some RAW image formats only) or a corrupted JPEG file to ExifInterface.", e);
        }
        finally {
            this.addDefaultValuesForCompatibility();
            if (DEBUG) {
                this.printAttributes();
            }
        }
    }

    private static boolean isSeekableFD(FileDescriptor fd) {
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
            return true;
        }
        catch (ErrnoException e) {
            if (DEBUG) {
                Log.d(TAG, "The file descriptor for the given input is not seekable");
            }
            return false;
        }
    }

    private void printAttributes() {
        for (int i = 0; i < this.mAttributes.length; ++i) {
            Log.d(TAG, "The size of tag group[" + i + "]: " + this.mAttributes[i].size());
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute tagValue = (ExifAttribute)entry.getValue();
                Log.d(TAG, "tagName: " + entry.getKey() + ", tagType: " + tagValue.toString() + ", tagValue: '" + tagValue.getStringValue(this.mExifByteOrder) + "'");
            }
        }
    }

    public void saveAttributes() throws IOException {
        if (!this.isSupportedFormatForSavingAttributes()) {
            throw new IOException("ExifInterface only supports saving attributes for JPEG, PNG, WebP, and DNG formats.");
        }
        if (this.mIsInputStream || this.mSeekableFileDescriptor == null && this.mFilename == null) {
            throw new IOException("ExifInterface does not support saving attributes for the current input.");
        }
        if (this.mHasThumbnail && this.mHasThumbnailStrips && !this.mAreThumbnailStripsConsecutive) {
            throw new IOException("ExifInterface does not support saving attributes when the image file has non-consecutive thumbnail strips");
        }
        this.mModified = true;
        this.mThumbnailBytes = this.getThumbnail();
        FileInputStream in = null;
        FileOutputStream out = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", "tmp");
            if (this.mFilename != null) {
                in = new FileInputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                in = new FileInputStream(this.mSeekableFileDescriptor);
            }
            out = new FileOutputStream(tempFile);
            ExifInterfaceUtils.copy(in, out);
        }
        catch (Exception e) {
            try {
                throw new IOException("Failed to copy original file to temp file", e);
            }
            catch (Throwable throwable) {
                ExifInterfaceUtils.closeQuietly(in);
                ExifInterfaceUtils.closeQuietly(out);
                throw throwable;
            }
        }
        ExifInterfaceUtils.closeQuietly(in);
        ExifInterfaceUtils.closeQuietly(out);
        in = null;
        out = null;
        try {
            in = new FileInputStream(tempFile);
            if (this.mFilename != null) {
                out = new FileOutputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                out = new FileOutputStream(this.mSeekableFileDescriptor);
            }
            try (BufferedInputStream bufferedIn = new BufferedInputStream(in);
                 BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
                if (this.mMimeType == 4) {
                    this.saveJpegAttributes(bufferedIn, bufferedOut);
                } else if (this.mMimeType == 13) {
                    this.savePngAttributes(bufferedIn, bufferedOut);
                } else if (this.mMimeType == 14) {
                    this.saveWebpAttributes(bufferedIn, bufferedOut);
                } else if (this.mMimeType == 3 || this.mMimeType == 0) {
                    ByteOrderedDataOutputStream dataOutputStream = new ByteOrderedDataOutputStream(bufferedOut, ByteOrder.BIG_ENDIAN);
                    this.writeExifSegment(dataOutputStream);
                }
            }
        }
        catch (Exception e) {
            in = new FileInputStream(tempFile);
            if (this.mFilename != null) {
                out = new FileOutputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                try {
                    Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                }
                catch (ErrnoException exception) {
                    throw new IOException("Failed to save new file. Original file may be corrupted since error occurred while trying to restore it.", exception);
                }
                out = new FileOutputStream(this.mSeekableFileDescriptor);
            }
            ExifInterfaceUtils.copy(in, out);
            ExifInterfaceUtils.closeQuietly(in);
            ExifInterfaceUtils.closeQuietly(out);
            throw new IOException("Failed to save new file", e);
        }
        finally {
            ExifInterfaceUtils.closeQuietly(in);
            ExifInterfaceUtils.closeQuietly(out);
            tempFile.delete();
        }
        this.mThumbnailBytes = null;
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    public boolean hasAttribute(String tag2) {
        return this.getExifAttribute(tag2) != null;
    }

    public byte[] getThumbnail() {
        if (this.mThumbnailCompression == 6 || this.mThumbnailCompression == 7) {
            return this.getThumbnailBytes();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte[] getThumbnailBytes() {
        block17: {
            block19: {
                if (!this.mHasThumbnail) {
                    return null;
                }
                if (this.mThumbnailBytes != null) {
                    return this.mThumbnailBytes;
                }
                in = null;
                newFileDescriptor = null;
                if (this.mAssetInputStream == null) break block17;
                in = this.mAssetInputStream;
                if (!in.markSupported()) break block19;
                in.reset();
                ** GOTO lbl31
            }
            Log.d("ExifInterface", "Cannot read thumbnail from inputstream without mark/reset support");
            var3_3 = null;
            ExifInterfaceUtils.closeQuietly(in);
            if (newFileDescriptor != null) {
                ExifInterfaceUtils.closeFileDescriptor(newFileDescriptor);
            }
            return var3_3;
        }
        try {
            if (this.mFilename != null) {
                in = new FileInputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                newFileDescriptor = Os.dup(this.mSeekableFileDescriptor);
                Os.lseek(newFileDescriptor, 0L, OsConstants.SEEK_SET);
                in = new FileInputStream(newFileDescriptor);
            }
lbl31:
            // 5 sources

            if (in == null) {
                throw new FileNotFoundException();
            }
            if (in.skip(this.mThumbnailOffset) != (long)this.mThumbnailOffset) {
                throw new IOException("Corrupted image");
            }
            buffer = new byte[this.mThumbnailLength];
            if (in.read(buffer) != this.mThumbnailLength) {
                throw new IOException("Corrupted image");
            }
            this.mThumbnailBytes = buffer;
            var4_6 = buffer;
        }
        catch (ErrnoException | IOException e) {
            try {
                Log.d("ExifInterface", "Encountered exception while getting thumbnail", e);
            }
            catch (Throwable var5_7) {
                ExifInterfaceUtils.closeQuietly(in);
                if (newFileDescriptor != null) {
                    ExifInterfaceUtils.closeFileDescriptor(newFileDescriptor);
                }
                throw var5_7;
            }
            ExifInterfaceUtils.closeQuietly(in);
            if (newFileDescriptor != null) {
                ExifInterfaceUtils.closeFileDescriptor(newFileDescriptor);
            } else {
                ** GOTO lbl57
            }
        }
        ExifInterfaceUtils.closeQuietly(in);
        if (newFileDescriptor != null) {
            ExifInterfaceUtils.closeFileDescriptor(newFileDescriptor);
        }
        return var4_6;
        return null;
    }

    public Bitmap getThumbnailBitmap() {
        if (!this.mHasThumbnail) {
            return null;
        }
        if (this.mThumbnailBytes == null) {
            this.mThumbnailBytes = this.getThumbnailBytes();
        }
        if (this.mThumbnailCompression == 6 || this.mThumbnailCompression == 7) {
            return BitmapFactory.decodeByteArray(this.mThumbnailBytes, 0, this.mThumbnailLength);
        }
        if (this.mThumbnailCompression == 1) {
            int[] rgbValues = new int[this.mThumbnailBytes.length / 3];
            int alpha = 0;
            for (int i = 0; i < rgbValues.length; ++i) {
                rgbValues[i] = alpha + (this.mThumbnailBytes[3 * i] << 16) + (this.mThumbnailBytes[3 * i + 1] << 8) + this.mThumbnailBytes[3 * i + 2];
            }
            ExifAttribute imageLengthAttribute = (ExifAttribute)this.mAttributes[4].get(TAG_THUMBNAIL_IMAGE_LENGTH);
            ExifAttribute imageWidthAttribute = (ExifAttribute)this.mAttributes[4].get(TAG_THUMBNAIL_IMAGE_WIDTH);
            if (imageLengthAttribute != null && imageWidthAttribute != null) {
                int imageLength = imageLengthAttribute.getIntValue(this.mExifByteOrder);
                int imageWidth = imageWidthAttribute.getIntValue(this.mExifByteOrder);
                return Bitmap.createBitmap(rgbValues, imageWidth, imageLength, Bitmap.Config.ARGB_8888);
            }
        }
        return null;
    }

    public boolean isThumbnailCompressed() {
        if (!this.mHasThumbnail) {
            return false;
        }
        return this.mThumbnailCompression == 6 || this.mThumbnailCompression == 7;
    }

    public long[] getThumbnailRange() {
        if (this.mModified) {
            throw new IllegalStateException("The underlying file has been modified since being parsed");
        }
        if (this.mHasThumbnail) {
            if (this.mHasThumbnailStrips && !this.mAreThumbnailStripsConsecutive) {
                return null;
            }
            return new long[]{this.mThumbnailOffset, this.mThumbnailLength};
        }
        return null;
    }

    public long[] getAttributeRange(String tag2) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        if (this.mModified) {
            throw new IllegalStateException("The underlying file has been modified since being parsed");
        }
        ExifAttribute attribute = this.getExifAttribute(tag2);
        if (attribute != null) {
            return new long[]{attribute.bytesOffset, attribute.bytes.length};
        }
        return null;
    }

    public byte[] getAttributeBytes(String tag2) {
        if (tag2 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        ExifAttribute attribute = this.getExifAttribute(tag2);
        if (attribute != null) {
            return attribute.bytes;
        }
        return null;
    }

    public boolean getLatLong(float[] output) {
        String latValue = this.getAttribute(TAG_GPS_LATITUDE);
        String latRef = this.getAttribute(TAG_GPS_LATITUDE_REF);
        String lngValue = this.getAttribute(TAG_GPS_LONGITUDE);
        String lngRef = this.getAttribute(TAG_GPS_LONGITUDE_REF);
        if (latValue != null && latRef != null && lngValue != null && lngRef != null) {
            try {
                output[0] = ExifInterface.convertRationalLatLonToFloat(latValue, latRef);
                output[1] = ExifInterface.convertRationalLatLonToFloat(lngValue, lngRef);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public double getAltitude(double defaultValue) {
        double altitude = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int ref = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, -1);
        if (altitude >= 0.0 && ref >= 0) {
            return altitude * (double)(ref == 1 ? -1 : 1);
        }
        return defaultValue;
    }

    public long getDateTime() {
        return ExifInterface.parseDateTime(this.getAttribute(TAG_DATETIME), this.getAttribute(TAG_SUBSEC_TIME), this.getAttribute(TAG_OFFSET_TIME));
    }

    public long getDateTimeDigitized() {
        return ExifInterface.parseDateTime(this.getAttribute(TAG_DATETIME_DIGITIZED), this.getAttribute("SubSecTimeDigitized"), this.getAttribute(TAG_OFFSET_TIME_DIGITIZED));
    }

    public long getDateTimeOriginal() {
        return ExifInterface.parseDateTime(this.getAttribute(TAG_DATETIME_ORIGINAL), this.getAttribute("SubSecTimeOriginal"), this.getAttribute(TAG_OFFSET_TIME_ORIGINAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long parseDateTime(String dateTimeString, String subSecs, String offsetString) {
        if (dateTimeString == null || !sNonZeroTimePattern.matcher(dateTimeString).matches()) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime;
            SimpleDateFormat simpleDateFormat = sFormatter;
            synchronized (simpleDateFormat) {
                datetime = sFormatter.parse(dateTimeString, pos);
            }
            if (offsetString != null) {
                dateTimeString = dateTimeString + " " + offsetString;
                ParsePosition position = new ParsePosition(0);
                SimpleDateFormat simpleDateFormat2 = sFormatterTz;
                synchronized (simpleDateFormat2) {
                    datetime = sFormatterTz.parse(dateTimeString, position);
                }
            }
            if (datetime == null) {
                return -1L;
            }
            long msecs = datetime.getTime();
            if (subSecs != null) {
                try {
                    long sub;
                    for (sub = Long.parseLong(subSecs); sub > 1000L; sub /= 10L) {
                    }
                    msecs += sub;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return msecs;
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGpsDateTime() {
        String date = this.getAttribute(TAG_GPS_DATESTAMP);
        String time = this.getAttribute(TAG_GPS_TIMESTAMP);
        if (date == null || time == null || !sNonZeroTimePattern.matcher(date).matches() && !sNonZeroTimePattern.matcher(time).matches()) {
            return -1L;
        }
        String dateTimeString = date + ' ' + time;
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime;
            SimpleDateFormat simpleDateFormat = sFormatter;
            synchronized (simpleDateFormat) {
                datetime = sFormatter.parse(dateTimeString, pos);
            }
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            return -1L;
        }
    }

    public static float convertRationalLatLonToFloat(String rationalString, String ref) {
        try {
            String[] parts = rationalString.split(",");
            String[] pair = parts[0].split("/");
            double degrees = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[1].split("/");
            double minutes = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[2].split("/");
            double seconds = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (ref.equals("S") || ref.equals("W")) {
                return (float)(-result);
            }
            return (float)result;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForFilename(String filename) throws IOException {
        FileInputStream in = null;
        ParcelFileDescriptor modernFd = null;
        this.mAssetInputStream = null;
        this.mFilename = filename;
        this.mIsInputStream = false;
        try {
            in = new FileInputStream(filename);
            modernFd = FileUtils.convertToModernFd(in.getFD());
            if (modernFd != null) {
                ExifInterfaceUtils.closeQuietly(in);
                in = new FileInputStream(modernFd.getFileDescriptor());
                this.mSeekableFileDescriptor = null;
            } else if (ExifInterface.isSeekableFD(in.getFD())) {
                this.mSeekableFileDescriptor = in.getFD();
            }
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            ExifInterfaceUtils.closeQuietly(in);
            if (modernFd != null) {
                modernFd.close();
            }
            throw throwable;
        }
        ExifInterfaceUtils.closeQuietly(in);
        if (modernFd != null) {
            modernFd.close();
        }
    }

    private int getMimeType(BufferedInputStream in) throws IOException {
        in.mark(5000);
        byte[] signatureCheckBytes = new byte[5000];
        in.read(signatureCheckBytes);
        in.reset();
        if (ExifInterface.isJpegFormat(signatureCheckBytes)) {
            return 4;
        }
        if (this.isRafFormat(signatureCheckBytes)) {
            return 9;
        }
        if (this.isHeifFormat(signatureCheckBytes)) {
            return 12;
        }
        if (this.isOrfFormat(signatureCheckBytes)) {
            return 7;
        }
        if (this.isRw2Format(signatureCheckBytes)) {
            return 10;
        }
        if (this.isPngFormat(signatureCheckBytes)) {
            return 13;
        }
        if (this.isWebpFormat(signatureCheckBytes)) {
            return 14;
        }
        return 0;
    }

    private static boolean isJpegFormat(byte[] signatureCheckBytes) throws IOException {
        for (int i = 0; i < JPEG_SIGNATURE.length; ++i) {
            if (signatureCheckBytes[i] == JPEG_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isRafFormat(byte[] signatureCheckBytes) throws IOException {
        byte[] rafSignatureBytes = RAF_SIGNATURE.getBytes();
        for (int i = 0; i < rafSignatureBytes.length; ++i) {
            if (signatureCheckBytes[i] == rafSignatureBytes[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHeifFormat(byte[] signatureCheckBytes) throws IOException {
        ByteOrderedDataInputStream signatureInputStream = null;
        try {
            long chunkDataSize;
            signatureInputStream = new ByteOrderedDataInputStream(signatureCheckBytes);
            long chunkSize = signatureInputStream.readInt();
            byte[] chunkType = new byte[4];
            signatureInputStream.read(chunkType);
            if (!Arrays.equals(chunkType, HEIF_TYPE_FTYP)) {
                boolean bl = false;
                return bl;
            }
            long chunkDataOffset = 8L;
            if (chunkSize == 1L) {
                chunkSize = signatureInputStream.readLong();
                if (chunkSize < 16L) {
                    boolean bl = false;
                    return bl;
                }
                chunkDataOffset += 8L;
            }
            if (chunkSize > (long)signatureCheckBytes.length) {
                chunkSize = signatureCheckBytes.length;
            }
            if ((chunkDataSize = chunkSize - chunkDataOffset) < 8L) {
                boolean bl = false;
                return bl;
            }
            byte[] brand = new byte[4];
            boolean isMif1 = false;
            boolean isHeic = false;
            boolean isAvif = false;
            for (long i = 0L; i < chunkDataSize / 4L; ++i) {
                if (signatureInputStream.read(brand) != brand.length) {
                    boolean bl = false;
                    return bl;
                }
                if (i == 1L) continue;
                if (Arrays.equals(brand, HEIF_BRAND_MIF1)) {
                    isMif1 = true;
                } else if (Arrays.equals(brand, HEIF_BRAND_HEIC)) {
                    isHeic = true;
                } else if (Arrays.equals(brand, HEIF_BRAND_AVIF) || Arrays.equals(brand, HEIF_BRAND_AVIS)) {
                    isAvif = true;
                }
                if (!isMif1 || !isHeic && !isAvif) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                Log.d(TAG, "Exception parsing HEIF file type box.", e);
            }
        }
        finally {
            if (signatureInputStream != null) {
                signatureInputStream.close();
                signatureInputStream = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOrfFormat(byte[] signatureCheckBytes) throws IOException {
        try (ByteOrderedDataInputStream signatureInputStream = null;){
            signatureInputStream = new ByteOrderedDataInputStream(signatureCheckBytes);
            this.mExifByteOrder = this.readByteOrder(signatureInputStream);
            signatureInputStream.setByteOrder(this.mExifByteOrder);
            short orfSignature = signatureInputStream.readShort();
            boolean bl = orfSignature == 20306 || orfSignature == 21330;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRw2Format(byte[] signatureCheckBytes) throws IOException {
        try (ByteOrderedDataInputStream signatureInputStream = null;){
            signatureInputStream = new ByteOrderedDataInputStream(signatureCheckBytes);
            this.mExifByteOrder = this.readByteOrder(signatureInputStream);
            signatureInputStream.setByteOrder(this.mExifByteOrder);
            short signatureByte = signatureInputStream.readShort();
            signatureInputStream.close();
            boolean bl = signatureByte == 85;
            return bl;
        }
        return false;
    }

    private boolean isPngFormat(byte[] signatureCheckBytes) throws IOException {
        for (int i = 0; i < PNG_SIGNATURE.length; ++i) {
            if (signatureCheckBytes[i] == PNG_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isWebpFormat(byte[] signatureCheckBytes) throws IOException {
        int i;
        for (i = 0; i < WEBP_SIGNATURE_1.length; ++i) {
            if (signatureCheckBytes[i] == WEBP_SIGNATURE_1[i]) continue;
            return false;
        }
        for (i = 0; i < WEBP_SIGNATURE_2.length; ++i) {
            if (signatureCheckBytes[i + WEBP_SIGNATURE_1.length + 4] == WEBP_SIGNATURE_2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isExifDataOnly(BufferedInputStream in) throws IOException {
        in.mark(IDENTIFIER_EXIF_APP1.length);
        byte[] signatureCheckBytes = new byte[IDENTIFIER_EXIF_APP1.length];
        in.read(signatureCheckBytes);
        in.reset();
        for (int i = 0; i < IDENTIFIER_EXIF_APP1.length; ++i) {
            if (signatureCheckBytes[i] == IDENTIFIER_EXIF_APP1[i]) continue;
            return false;
        }
        return true;
    }

    private void getJpegAttributes(ByteOrderedDataInputStream in, int jpegOffset, int imageType) throws IOException {
        if (DEBUG) {
            Log.d(TAG, "getJpegAttributes starting with: " + in);
        }
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        in.seek(jpegOffset);
        int bytesRead = jpegOffset;
        byte marker = in.readByte();
        if (marker != -1) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        if (in.readByte() != -40) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        while (true) {
            if ((marker = in.readByte()) != -1) {
                throw new IOException("Invalid marker:" + Integer.toHexString(marker & 0xFF));
            }
            ++bytesRead;
            marker = in.readByte();
            if (DEBUG) {
                Log.d(TAG, "Found JPEG segment indicator: " + Integer.toHexString(marker & 0xFF));
            }
            ++bytesRead;
            if (marker == -39 || marker == -38) break;
            int length = in.readUnsignedShort() - 2;
            bytesRead += 2;
            if (DEBUG) {
                Log.d(TAG, "JPEG segment: " + Integer.toHexString(marker & 0xFF) + " (length: " + (length + 2) + ")");
            }
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            switch (marker) {
                case -31: {
                    byte[] value2;
                    long offset2;
                    int start = bytesRead;
                    byte[] bytes = new byte[length];
                    in.readFully(bytes);
                    bytesRead += length;
                    length = 0;
                    if (ExifInterfaceUtils.startsWith(bytes, IDENTIFIER_EXIF_APP1)) {
                        offset2 = start + IDENTIFIER_EXIF_APP1.length;
                        value2 = Arrays.copyOfRange(bytes, IDENTIFIER_EXIF_APP1.length, bytes.length);
                        this.mExifOffset = (int)offset2;
                        this.readExifSegment(value2, imageType);
                        break;
                    }
                    if (!ExifInterfaceUtils.startsWith(bytes, IDENTIFIER_XMP_APP1)) break;
                    offset2 = start + IDENTIFIER_XMP_APP1.length;
                    value2 = Arrays.copyOfRange(bytes, IDENTIFIER_XMP_APP1.length, bytes.length);
                    if (this.getAttribute(TAG_XMP) != null) break;
                    this.mAttributes[0].put(TAG_XMP, new ExifAttribute(1, value2.length, offset2, value2));
                    this.mXmpIsFromSeparateMarker = true;
                    break;
                }
                case -2: {
                    byte[] bytes = new byte[length];
                    if (in.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    length = 0;
                    if (this.getAttribute(TAG_USER_COMMENT) != null) break;
                    this.mAttributes[1].put(TAG_USER_COMMENT, ExifAttribute.createString(new String(bytes, ASCII)));
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    if (in.skipBytes(1) != 1) {
                        throw new IOException("Invalid SOFx");
                    }
                    this.mAttributes[imageType].put(imageType != 4 ? TAG_IMAGE_LENGTH : TAG_THUMBNAIL_IMAGE_LENGTH, ExifAttribute.createULong(in.readUnsignedShort(), this.mExifByteOrder));
                    this.mAttributes[imageType].put(imageType != 4 ? TAG_IMAGE_WIDTH : TAG_THUMBNAIL_IMAGE_WIDTH, ExifAttribute.createULong(in.readUnsignedShort(), this.mExifByteOrder));
                    length -= 5;
                    break;
                }
            }
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            if (in.skipBytes(length) != length) {
                throw new IOException("Invalid JPEG segment");
            }
            bytesRead += length;
        }
        in.setByteOrder(this.mExifByteOrder);
    }

    private void getRawAttributes(ByteOrderedDataInputStream in) throws IOException {
        ExifAttribute makerNoteAttribute;
        this.parseTiffHeaders(in, in.available());
        this.readImageFileDirectory(in, 0);
        this.updateImageSizeValues(in, 0);
        this.updateImageSizeValues(in, 5);
        this.updateImageSizeValues(in, 4);
        this.validateImages();
        if (this.mMimeType == 8 && (makerNoteAttribute = (ExifAttribute)this.mAttributes[1].get(TAG_MAKER_NOTE)) != null) {
            ByteOrderedDataInputStream makerNoteDataInputStream = new ByteOrderedDataInputStream(makerNoteAttribute.bytes);
            makerNoteDataInputStream.setByteOrder(this.mExifByteOrder);
            makerNoteDataInputStream.seek(6L);
            this.readImageFileDirectory(makerNoteDataInputStream, 9);
            ExifAttribute colorSpaceAttribute = (ExifAttribute)this.mAttributes[9].get(TAG_COLOR_SPACE);
            if (colorSpaceAttribute != null) {
                this.mAttributes[1].put(TAG_COLOR_SPACE, colorSpaceAttribute);
            }
        }
    }

    private void getRafAttributes(ByteOrderedDataInputStream in) throws IOException {
        in.skipBytes(84);
        byte[] jpegOffsetBytes = new byte[4];
        byte[] cfaHeaderOffsetBytes = new byte[4];
        in.read(jpegOffsetBytes);
        in.skipBytes(4);
        in.read(cfaHeaderOffsetBytes);
        int rafJpegOffset = ByteBuffer.wrap(jpegOffsetBytes).getInt();
        int rafCfaHeaderOffset = ByteBuffer.wrap(cfaHeaderOffsetBytes).getInt();
        this.getJpegAttributes(in, rafJpegOffset, 5);
        in.seek(rafCfaHeaderOffset);
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        int numberOfDirectoryEntry = in.readInt();
        if (DEBUG) {
            Log.d(TAG, "numberOfDirectoryEntry: " + numberOfDirectoryEntry);
        }
        for (int i = 0; i < numberOfDirectoryEntry; ++i) {
            int tagNumber = in.readUnsignedShort();
            int numberOfBytes = in.readUnsignedShort();
            if (tagNumber == ExifInterface.TAG_RAF_IMAGE_SIZE.number) {
                short imageLength = in.readShort();
                short imageWidth = in.readShort();
                ExifAttribute imageLengthAttribute = ExifAttribute.createUShort(imageLength, this.mExifByteOrder);
                ExifAttribute imageWidthAttribute = ExifAttribute.createUShort(imageWidth, this.mExifByteOrder);
                this.mAttributes[0].put(TAG_IMAGE_LENGTH, imageLengthAttribute);
                this.mAttributes[0].put(TAG_IMAGE_WIDTH, imageWidthAttribute);
                if (DEBUG) {
                    Log.d(TAG, "Updated to length: " + imageLength + ", width: " + imageWidth);
                }
                return;
            }
            in.skipBytes(numberOfBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHeifAttributes(final ByteOrderedDataInputStream in) throws IOException {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            retriever.setDataSource(new MediaDataSource(){
                long mPosition;

                @Override
                public void close() throws IOException {
                }

                @Override
                public int readAt(long position, byte[] buffer, int offset2, int size) throws IOException {
                    if (size == 0) {
                        return 0;
                    }
                    if (position < 0L) {
                        return -1;
                    }
                    try {
                        int bytesRead;
                        if (this.mPosition != position) {
                            if (this.mPosition >= 0L && position >= this.mPosition + (long)in.available()) {
                                return -1;
                            }
                            in.seek(position);
                            this.mPosition = position;
                        }
                        if (size > in.available()) {
                            size = in.available();
                        }
                        if ((bytesRead = in.read(buffer, offset2, size)) >= 0) {
                            this.mPosition += (long)bytesRead;
                            return bytesRead;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.mPosition = -1L;
                    return -1;
                }

                @Override
                public long getSize() throws IOException {
                    return -1L;
                }
            });
            String exifOffsetStr = retriever.extractMetadata(33);
            String exifLengthStr = retriever.extractMetadata(34);
            String hasImage = retriever.extractMetadata(26);
            String hasVideo = retriever.extractMetadata(17);
            String width2 = null;
            String height2 = null;
            String rotation = null;
            String METADATA_VALUE_YES = "yes";
            if ("yes".equals(hasImage)) {
                width2 = retriever.extractMetadata(29);
                height2 = retriever.extractMetadata(30);
                rotation = retriever.extractMetadata(31);
            } else if ("yes".equals(hasVideo)) {
                width2 = retriever.extractMetadata(18);
                height2 = retriever.extractMetadata(19);
                rotation = retriever.extractMetadata(24);
            }
            if (width2 != null) {
                this.mAttributes[0].put(TAG_IMAGE_WIDTH, ExifAttribute.createUShort(Integer.parseInt(width2), this.mExifByteOrder));
            }
            if (height2 != null) {
                this.mAttributes[0].put(TAG_IMAGE_LENGTH, ExifAttribute.createUShort(Integer.parseInt(height2), this.mExifByteOrder));
            }
            if (rotation != null) {
                int orientation2 = 1;
                switch (Integer.parseInt(rotation)) {
                    case 90: {
                        orientation2 = 6;
                        break;
                    }
                    case 180: {
                        orientation2 = 3;
                        break;
                    }
                    case 270: {
                        orientation2 = 8;
                    }
                }
                this.mAttributes[0].put(TAG_ORIENTATION, ExifAttribute.createUShort(orientation2, this.mExifByteOrder));
            }
            if (exifOffsetStr != null && exifLengthStr != null) {
                int offset2 = Integer.parseInt(exifOffsetStr);
                int length = Integer.parseInt(exifLengthStr);
                if (length <= 6) {
                    throw new IOException("Invalid exif length");
                }
                in.seek(offset2);
                byte[] identifier = new byte[6];
                if (in.read(identifier) != 6) {
                    throw new IOException("Can't read identifier");
                }
                offset2 += 6;
                length -= 6;
                if (!Arrays.equals(identifier, IDENTIFIER_EXIF_APP1)) {
                    throw new IOException("Invalid identifier");
                }
                byte[] bytes = new byte[length];
                if (in.read(bytes) != length) {
                    throw new IOException("Can't read exif");
                }
                this.mExifOffset = offset2;
                this.readExifSegment(bytes, 0);
            }
            String xmpOffsetStr = retriever.extractMetadata(41);
            String xmpLengthStr = retriever.extractMetadata(42);
            if (xmpOffsetStr != null && xmpLengthStr != null) {
                int offset3 = Integer.parseInt(xmpOffsetStr);
                int length = Integer.parseInt(xmpLengthStr);
                in.seek(offset3);
                byte[] xmpBytes = new byte[length];
                if (in.read(xmpBytes) != length) {
                    throw new IOException("Failed to read XMP from HEIF");
                }
                if (this.getAttribute(TAG_XMP) == null) {
                    this.mAttributes[0].put(TAG_XMP, new ExifAttribute(1, xmpBytes.length, offset3, xmpBytes));
                }
            }
            if (DEBUG) {
                Log.d(TAG, "Heif meta: " + width2 + "x" + height2 + ", rotation " + rotation);
            }
        }
        finally {
            retriever.release();
        }
    }

    private void getStandaloneAttributes(ByteOrderedDataInputStream in) throws IOException {
        in.skipBytes(IDENTIFIER_EXIF_APP1.length);
        byte[] data = new byte[in.available()];
        in.readFully(data);
        this.mExifOffset = IDENTIFIER_EXIF_APP1.length;
        this.readExifSegment(data, 0);
    }

    private void getOrfAttributes(ByteOrderedDataInputStream in) throws IOException {
        this.getRawAttributes(in);
        ExifAttribute makerNoteAttribute = (ExifAttribute)this.mAttributes[1].get(TAG_MAKER_NOTE);
        if (makerNoteAttribute != null) {
            ExifAttribute aspectFrameAttribute;
            ByteOrderedDataInputStream makerNoteDataInputStream = new ByteOrderedDataInputStream(makerNoteAttribute.bytes);
            makerNoteDataInputStream.setByteOrder(this.mExifByteOrder);
            byte[] makerNoteHeader1Bytes = new byte[ORF_MAKER_NOTE_HEADER_1.length];
            makerNoteDataInputStream.readFully(makerNoteHeader1Bytes);
            makerNoteDataInputStream.seek(0L);
            byte[] makerNoteHeader2Bytes = new byte[ORF_MAKER_NOTE_HEADER_2.length];
            makerNoteDataInputStream.readFully(makerNoteHeader2Bytes);
            if (Arrays.equals(makerNoteHeader1Bytes, ORF_MAKER_NOTE_HEADER_1)) {
                makerNoteDataInputStream.seek(8L);
            } else if (Arrays.equals(makerNoteHeader2Bytes, ORF_MAKER_NOTE_HEADER_2)) {
                makerNoteDataInputStream.seek(12L);
            }
            this.readImageFileDirectory(makerNoteDataInputStream, 6);
            ExifAttribute imageLengthAttribute = (ExifAttribute)this.mAttributes[7].get(TAG_ORF_PREVIEW_IMAGE_START);
            ExifAttribute bitsPerSampleAttribute = (ExifAttribute)this.mAttributes[7].get(TAG_ORF_PREVIEW_IMAGE_LENGTH);
            if (imageLengthAttribute != null && bitsPerSampleAttribute != null) {
                this.mAttributes[5].put(TAG_JPEG_INTERCHANGE_FORMAT, imageLengthAttribute);
                this.mAttributes[5].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, bitsPerSampleAttribute);
            }
            if ((aspectFrameAttribute = (ExifAttribute)this.mAttributes[8].get(TAG_ORF_ASPECT_FRAME)) != null) {
                int[] aspectFrameValues = new int[4];
                aspectFrameValues = (int[])aspectFrameAttribute.getValue(this.mExifByteOrder);
                if (aspectFrameValues[2] > aspectFrameValues[0] && aspectFrameValues[3] > aspectFrameValues[1]) {
                    int primaryImageWidth = aspectFrameValues[2] - aspectFrameValues[0] + 1;
                    int primaryImageLength = aspectFrameValues[3] - aspectFrameValues[1] + 1;
                    if (primaryImageWidth < primaryImageLength) {
                        primaryImageWidth += primaryImageLength;
                        primaryImageLength = primaryImageWidth - primaryImageLength;
                        primaryImageWidth -= primaryImageLength;
                    }
                    ExifAttribute primaryImageWidthAttribute = ExifAttribute.createUShort(primaryImageWidth, this.mExifByteOrder);
                    ExifAttribute primaryImageLengthAttribute = ExifAttribute.createUShort(primaryImageLength, this.mExifByteOrder);
                    this.mAttributes[0].put(TAG_IMAGE_WIDTH, primaryImageWidthAttribute);
                    this.mAttributes[0].put(TAG_IMAGE_LENGTH, primaryImageLengthAttribute);
                }
            }
        }
    }

    private void getRw2Attributes(ByteOrderedDataInputStream in) throws IOException {
        this.getRawAttributes(in);
        ExifAttribute jpgFromRawAttribute = (ExifAttribute)this.mAttributes[0].get(TAG_RW2_JPG_FROM_RAW);
        if (jpgFromRawAttribute != null) {
            this.getJpegAttributes(in, this.mRw2JpgFromRawOffset, 5);
        }
        ExifAttribute rw2IsoAttribute = (ExifAttribute)this.mAttributes[0].get(TAG_RW2_ISO);
        ExifAttribute exifIsoAttribute = (ExifAttribute)this.mAttributes[1].get("ISOSpeedRatings");
        if (rw2IsoAttribute != null && exifIsoAttribute == null) {
            this.mAttributes[1].put("ISOSpeedRatings", rw2IsoAttribute);
        }
    }

    private void getPngAttributes(ByteOrderedDataInputStream in) throws IOException {
        if (DEBUG) {
            Log.d(TAG, "getPngAttributes starting with: " + in);
        }
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        int bytesRead = 0;
        in.skipBytes(PNG_SIGNATURE.length);
        bytesRead += PNG_SIGNATURE.length;
        try {
            while (true) {
                int length = in.readInt();
                bytesRead += 4;
                byte[] type = new byte[4];
                if (in.read(type) != type.length) {
                    throw new IOException("Encountered invalid length while parsing PNG chunktype");
                }
                if ((bytesRead += 4) == 16 && !Arrays.equals(type, PNG_CHUNK_TYPE_IHDR)) {
                    throw new IOException("Encountered invalid PNG file--IHDR chunk should appearas the first chunk");
                }
                if (Arrays.equals(type, PNG_CHUNK_TYPE_IEND)) break;
                if (Arrays.equals(type, PNG_CHUNK_TYPE_EXIF)) {
                    byte[] data = new byte[length];
                    if (in.read(data) != length) {
                        throw new IOException("Failed to read given length for given PNG chunk type: " + ExifInterfaceUtils.byteArrayToHexString(type));
                    }
                    int dataCrcValue = in.readInt();
                    CRC32 crc = new CRC32();
                    crc.update(type);
                    crc.update(data);
                    if ((int)crc.getValue() != dataCrcValue) {
                        throw new IOException("Encountered invalid CRC value for PNG-EXIF chunk.\n recorded CRC value: " + dataCrcValue + ", calculated CRC value: " + crc.getValue());
                    }
                    this.mExifOffset = bytesRead;
                    this.readExifSegment(data, 0);
                    this.validateImages();
                    break;
                }
                in.skipBytes(length + 4);
                bytesRead += length + 4;
            }
        }
        catch (EOFException e) {
            throw new IOException("Encountered corrupt PNG file.");
        }
    }

    private void getWebpAttributes(ByteOrderedDataInputStream in) throws IOException {
        if (DEBUG) {
            Log.d(TAG, "getWebpAttributes starting with: " + in);
        }
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        in.skipBytes(WEBP_SIGNATURE_1.length);
        int fileSize = in.readInt() + 8;
        int bytesRead = 8;
        bytesRead += in.skipBytes(WEBP_SIGNATURE_2.length);
        try {
            while (true) {
                byte[] code;
                if (in.read(code = new byte[4]) != code.length) {
                    throw new IOException("Encountered invalid length while parsing WebP chunktype");
                }
                bytesRead += 4;
                int chunkSize = in.readInt();
                bytesRead += 4;
                if (Arrays.equals(WEBP_CHUNK_TYPE_EXIF, code)) {
                    byte[] payload = new byte[chunkSize];
                    if (in.read(payload) != chunkSize) {
                        throw new IOException("Failed to read given length for given PNG chunk type: " + ExifInterfaceUtils.byteArrayToHexString(code));
                    }
                    this.mExifOffset = bytesRead;
                    this.readExifSegment(payload, 0);
                    this.mExifOffset = bytesRead;
                } else {
                    int n = chunkSize = chunkSize % 2 == 1 ? chunkSize + 1 : chunkSize;
                    if (bytesRead + chunkSize != fileSize) {
                        if (bytesRead + chunkSize > fileSize) {
                            throw new IOException("Encountered WebP file with invalid chunk size");
                        }
                        int skipped = in.skipBytes(chunkSize);
                        if (skipped != chunkSize) {
                            throw new IOException("Encountered WebP file with invalid chunk size");
                        }
                        bytesRead += skipped;
                        continue;
                    }
                }
                break;
            }
        }
        catch (EOFException e) {
            throw new IOException("Encountered corrupt WebP file.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void saveJpegAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (ExifInterface.DEBUG) {
            Log.d("ExifInterface", "saveJpegAttributes starting with (inputStream: " + inputStream + ", outputStream: " + outputStream + ")");
        }
        dataInputStream = new DataInputStream(inputStream);
        dataOutputStream = new ByteOrderedDataOutputStream(outputStream, ByteOrder.BIG_ENDIAN);
        if (dataInputStream.readByte() != -1) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-1);
        if (dataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-40);
        xmpAttribute = null;
        if (this.getAttribute("Xmp") != null && this.mXmpIsFromSeparateMarker) {
            xmpAttribute = (ExifAttribute)this.mAttributes[0].remove("Xmp");
        }
        dataOutputStream.writeByte(-1);
        dataOutputStream.writeByte(-31);
        this.writeExifSegment(dataOutputStream);
        if (xmpAttribute != null) {
            this.mAttributes[0].put("Xmp", xmpAttribute);
        }
        bytes = new byte[4096];
        block4: while (true) {
            if ((marker = dataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker");
            }
            marker = dataInputStream.readByte();
            switch (marker) {
                case -31: {
                    length = dataInputStream.readUnsignedShort() - 2;
                    if (length < 0) {
                        throw new IOException("Invalid length");
                    }
                    identifier = new byte[6];
                    if (length >= 6) {
                        if (dataInputStream.read(identifier) != 6) {
                            throw new IOException("Invalid exif");
                        }
                        if (Arrays.equals(identifier, ExifInterface.IDENTIFIER_EXIF_APP1)) {
                            if (dataInputStream.skipBytes(length - 6) == length - 6) continue block4;
                            throw new IOException("Invalid length");
                        }
                    }
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    dataOutputStream.writeUnsignedShort(length + 2);
                    if (length >= 6) {
                        length -= 6;
                        dataOutputStream.write(identifier);
                    }
                    while (true) {
                        if (length <= 0 || (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) < 0) continue block4;
                        dataOutputStream.write(bytes, 0, read);
                        length -= read;
                    }
                }
                case -39: 
                case -38: {
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    ExifInterfaceUtils.copy(dataInputStream, dataOutputStream);
                    return;
                }
            }
            dataOutputStream.writeByte(-1);
            dataOutputStream.writeByte(marker);
            length = dataInputStream.readUnsignedShort();
            dataOutputStream.writeUnsignedShort(length);
            if ((length -= 2) < 0) {
                throw new IOException("Invalid length");
            }
            while (true) {
                if (length > 0 && (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) >= 0) ** break;
                continue block4;
                dataOutputStream.write(bytes, 0, read);
                length -= read;
            }
            break;
        }
    }

    private void savePngAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (DEBUG) {
            Log.d(TAG, "savePngAttributes starting with (inputStream: " + inputStream + ", outputStream: " + outputStream + ")");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ByteOrderedDataOutputStream dataOutputStream = new ByteOrderedDataOutputStream(outputStream, ByteOrder.BIG_ENDIAN);
        ExifInterfaceUtils.copy(dataInputStream, dataOutputStream, PNG_SIGNATURE.length);
        if (this.mExifOffset == 0) {
            int ihdrChunkLength = dataInputStream.readInt();
            dataOutputStream.writeInt(ihdrChunkLength);
            ExifInterfaceUtils.copy(dataInputStream, dataOutputStream, 4 + ihdrChunkLength + 4);
        } else {
            int copyLength = this.mExifOffset - PNG_SIGNATURE.length - 4 - 4;
            ExifInterfaceUtils.copy(dataInputStream, dataOutputStream, copyLength);
            int exifChunkLength = dataInputStream.readInt();
            dataInputStream.skipBytes(4 + exifChunkLength + 4);
        }
        try (ByteArrayOutputStream exifByteArrayOutputStream = new ByteArrayOutputStream();){
            ByteOrderedDataOutputStream exifDataOutputStream = new ByteOrderedDataOutputStream(exifByteArrayOutputStream, ByteOrder.BIG_ENDIAN);
            this.writeExifSegment(exifDataOutputStream);
            byte[] exifBytes = ((ByteArrayOutputStream)exifDataOutputStream.mOutputStream).toByteArray();
            dataOutputStream.write(exifBytes);
            CRC32 crc = new CRC32();
            crc.update(exifBytes, 4, exifBytes.length - 4);
            dataOutputStream.writeInt((int)crc.getValue());
        }
        ExifInterfaceUtils.copy(dataInputStream, dataOutputStream);
    }

    private void saveWebpAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (DEBUG) {
            Log.d(TAG, "saveWebpAttributes starting with (inputStream: " + inputStream + ", outputStream: " + outputStream + ")");
        }
        ByteOrderedDataInputStream totalInputStream = new ByteOrderedDataInputStream(inputStream, ByteOrder.LITTLE_ENDIAN);
        ByteOrderedDataOutputStream totalOutputStream = new ByteOrderedDataOutputStream(outputStream, ByteOrder.LITTLE_ENDIAN);
        ExifInterfaceUtils.copy(totalInputStream, totalOutputStream, WEBP_SIGNATURE_1.length);
        totalInputStream.skipBytes(4 + WEBP_SIGNATURE_2.length);
        ByteArrayOutputStream nonHeaderByteArrayOutputStream = null;
        try {
            ByteOrderedDataOutputStream nonHeaderOutputStream;
            block24: {
                nonHeaderByteArrayOutputStream = new ByteArrayOutputStream();
                nonHeaderOutputStream = new ByteOrderedDataOutputStream(nonHeaderByteArrayOutputStream, ByteOrder.LITTLE_ENDIAN);
                if (this.mExifOffset != 0) {
                    int bytesRead = WEBP_SIGNATURE_1.length + 4 + WEBP_SIGNATURE_2.length;
                    ExifInterfaceUtils.copy(totalInputStream, nonHeaderOutputStream, this.mExifOffset - bytesRead - 4 - 4);
                    totalInputStream.skipBytes(4);
                    int exifChunkLength = totalInputStream.readInt();
                    totalInputStream.skipBytes(exifChunkLength);
                    int n = this.writeExifSegment(nonHeaderOutputStream);
                } else {
                    byte[] firstChunkType = new byte[4];
                    if (totalInputStream.read(firstChunkType) != firstChunkType.length) {
                        throw new IOException("Encountered invalid length while parsing WebP chunk type");
                    }
                    if (Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8X)) {
                        int size = totalInputStream.readInt();
                        byte[] data = new byte[size % 2 == 1 ? size + 1 : size];
                        totalInputStream.read(data);
                        data[0] = (byte)(data[0] | 8);
                        boolean containsAnimation = (data[0] >> 1 & 1) == 1;
                        nonHeaderOutputStream.write(WEBP_CHUNK_TYPE_VP8X);
                        nonHeaderOutputStream.writeInt(size);
                        nonHeaderOutputStream.write(data);
                        if (containsAnimation) {
                            this.copyChunksUpToGivenChunkType(totalInputStream, nonHeaderOutputStream, WEBP_CHUNK_TYPE_ANIM, null);
                            while (true) {
                                byte[] type = new byte[4];
                                int read = inputStream.read(type);
                                if (!Arrays.equals(type, WEBP_CHUNK_TYPE_ANMF)) {
                                    this.writeExifSegment(nonHeaderOutputStream);
                                    break block24;
                                }
                                this.copyWebPChunk(totalInputStream, nonHeaderOutputStream, type);
                            }
                        }
                        this.copyChunksUpToGivenChunkType(totalInputStream, nonHeaderOutputStream, WEBP_CHUNK_TYPE_VP8, WEBP_CHUNK_TYPE_VP8L);
                        this.writeExifSegment(nonHeaderOutputStream);
                    } else if (Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8) || Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8L)) {
                        int size;
                        int bytesToRead = size = totalInputStream.readInt();
                        if (size % 2 == 1) {
                            ++bytesToRead;
                        }
                        int widthAndHeight = 0;
                        int width2 = 0;
                        int height2 = 0;
                        int alpha = 0;
                        byte[] vp8Frame = new byte[3];
                        if (Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8)) {
                            totalInputStream.read(vp8Frame);
                            byte[] vp8Signature = new byte[3];
                            if (totalInputStream.read(vp8Signature) != vp8Signature.length || !Arrays.equals(WEBP_VP8_SIGNATURE, vp8Signature)) {
                                throw new IOException("Encountered error while checking VP8 signature");
                            }
                            widthAndHeight = totalInputStream.readInt();
                            width2 = widthAndHeight << 18 >> 18;
                            height2 = widthAndHeight << 2 >> 18;
                            bytesToRead -= vp8Frame.length + vp8Signature.length + 4;
                        } else if (Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8L)) {
                            byte vp8lSignature = totalInputStream.readByte();
                            if (vp8lSignature != 47) {
                                throw new IOException("Encountered error while checking VP8L signature");
                            }
                            widthAndHeight = totalInputStream.readInt();
                            width2 = (widthAndHeight << 18 >> 18) + 1;
                            height2 = (widthAndHeight << 4 >> 18) + 1;
                            alpha = widthAndHeight & 8;
                            bytesToRead -= 5;
                        }
                        nonHeaderOutputStream.write(WEBP_CHUNK_TYPE_VP8X);
                        nonHeaderOutputStream.writeInt(10);
                        byte[] data = new byte[10];
                        data[0] = (byte)(data[0] | 8);
                        data[0] = (byte)(data[0] | alpha << 4);
                        data[4] = (byte)(--width2);
                        data[5] = (byte)(width2 >> 8);
                        data[6] = (byte)(width2 >> 16);
                        data[7] = (byte)(--height2);
                        data[8] = (byte)(height2 >> 8);
                        data[9] = (byte)(height2 >> 16);
                        nonHeaderOutputStream.write(data);
                        nonHeaderOutputStream.write(firstChunkType);
                        nonHeaderOutputStream.writeInt(size);
                        if (Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8)) {
                            nonHeaderOutputStream.write(vp8Frame);
                            nonHeaderOutputStream.write(WEBP_VP8_SIGNATURE);
                            nonHeaderOutputStream.writeInt(widthAndHeight);
                        } else if (Arrays.equals(firstChunkType, WEBP_CHUNK_TYPE_VP8L)) {
                            nonHeaderOutputStream.write(47);
                            nonHeaderOutputStream.writeInt(widthAndHeight);
                        }
                        ExifInterfaceUtils.copy(totalInputStream, nonHeaderOutputStream, bytesToRead);
                        this.writeExifSegment(nonHeaderOutputStream);
                    }
                }
            }
            ExifInterfaceUtils.copy(totalInputStream, nonHeaderOutputStream);
            totalOutputStream.writeInt(nonHeaderByteArrayOutputStream.size() + WEBP_SIGNATURE_2.length);
            totalOutputStream.write(WEBP_SIGNATURE_2);
            nonHeaderByteArrayOutputStream.writeTo(totalOutputStream);
        }
        catch (Exception e) {
            throw new IOException("Failed to save WebP file", e);
        }
        finally {
            ExifInterfaceUtils.closeQuietly(nonHeaderByteArrayOutputStream);
        }
    }

    private void copyChunksUpToGivenChunkType(ByteOrderedDataInputStream inputStream, ByteOrderedDataOutputStream outputStream, byte[] firstGivenType, byte[] secondGivenType) throws IOException {
        byte[] type;
        do {
            if (inputStream.read(type = new byte[4]) != type.length) {
                throw new IOException("Encountered invalid length while copying WebP chunks up tochunk type " + new String(firstGivenType, ASCII) + (secondGivenType == null ? "" : " or " + new String(secondGivenType, ASCII)));
            }
            this.copyWebPChunk(inputStream, outputStream, type);
        } while (!Arrays.equals(type, firstGivenType) && (secondGivenType == null || !Arrays.equals(type, secondGivenType)));
    }

    private void copyWebPChunk(ByteOrderedDataInputStream inputStream, ByteOrderedDataOutputStream outputStream, byte[] type) throws IOException {
        int size = inputStream.readInt();
        outputStream.write(type);
        outputStream.writeInt(size);
        ExifInterfaceUtils.copy(inputStream, outputStream, size % 2 == 1 ? size + 1 : size);
    }

    private void readExifSegment(byte[] exifBytes, int imageType) throws IOException {
        ByteOrderedDataInputStream dataInputStream = new ByteOrderedDataInputStream(exifBytes);
        this.parseTiffHeaders(dataInputStream, exifBytes.length);
        this.readImageFileDirectory(dataInputStream, imageType);
    }

    private void addDefaultValuesForCompatibility() {
        String valueOfDateTimeOriginal = this.getAttribute(TAG_DATETIME_ORIGINAL);
        if (valueOfDateTimeOriginal != null && this.getAttribute(TAG_DATETIME) == null) {
            this.mAttributes[0].put(TAG_DATETIME, ExifAttribute.createString(valueOfDateTimeOriginal));
        }
        if (this.getAttribute(TAG_IMAGE_WIDTH) == null) {
            this.mAttributes[0].put(TAG_IMAGE_WIDTH, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_IMAGE_LENGTH) == null) {
            this.mAttributes[0].put(TAG_IMAGE_LENGTH, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_ORIENTATION) == null) {
            this.mAttributes[0].put(TAG_ORIENTATION, ExifAttribute.createUShort(0, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_LIGHT_SOURCE) == null) {
            this.mAttributes[1].put(TAG_LIGHT_SOURCE, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
    }

    private ByteOrder readByteOrder(ByteOrderedDataInputStream dataInputStream) throws IOException {
        short byteOrder = dataInputStream.readShort();
        switch (byteOrder) {
            case 18761: {
                if (DEBUG) {
                    Log.d(TAG, "readExifSegment: Byte Align II");
                }
                return ByteOrder.LITTLE_ENDIAN;
            }
            case 19789: {
                if (DEBUG) {
                    Log.d(TAG, "readExifSegment: Byte Align MM");
                }
                return ByteOrder.BIG_ENDIAN;
            }
        }
        throw new IOException("Invalid byte order: " + Integer.toHexString(byteOrder));
    }

    private void parseTiffHeaders(ByteOrderedDataInputStream dataInputStream, int exifBytesLength) throws IOException {
        this.mExifByteOrder = this.readByteOrder(dataInputStream);
        dataInputStream.setByteOrder(this.mExifByteOrder);
        int startCode = dataInputStream.readUnsignedShort();
        if (this.mMimeType != 7 && this.mMimeType != 10 && startCode != 42) {
            throw new IOException("Invalid start code: " + Integer.toHexString(startCode));
        }
        int firstIfdOffset = dataInputStream.readInt();
        if (firstIfdOffset < 8 || firstIfdOffset >= exifBytesLength) {
            throw new IOException("Invalid first Ifd offset: " + firstIfdOffset);
        }
        if ((firstIfdOffset -= 8) > 0 && dataInputStream.skipBytes(firstIfdOffset) != firstIfdOffset) {
            throw new IOException("Couldn't jump to first Ifd: " + firstIfdOffset);
        }
    }

    private void readImageFileDirectory(ByteOrderedDataInputStream dataInputStream, int ifdType) throws IOException {
        this.mHandledIfdOffsets.add(dataInputStream.mPosition);
        if (dataInputStream.mPosition + 2 > dataInputStream.mLength) {
            return;
        }
        short numberOfDirectoryEntry = dataInputStream.readShort();
        if (dataInputStream.mPosition + 12 * numberOfDirectoryEntry > dataInputStream.mLength || numberOfDirectoryEntry <= 0) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "numberOfDirectoryEntry: " + numberOfDirectoryEntry);
        }
        for (short i = 0; i < numberOfDirectoryEntry; i = (short)(i + 1)) {
            int tagNumber = dataInputStream.readUnsignedShort();
            int dataFormat = dataInputStream.readUnsignedShort();
            int numberOfComponents = dataInputStream.readInt();
            long nextEntryOffset = dataInputStream.peek() + 4;
            ExifTag tag2 = (ExifTag)sExifTagMapsForReading[ifdType].get(tagNumber);
            if (DEBUG) {
                Log.d(TAG, String.format("ifdType: %d, tagNumber: %d, tagName: %s, dataFormat: %d, numberOfComponents: %d", ifdType, tagNumber, tag2 != null ? tag2.name : null, dataFormat, numberOfComponents));
            }
            long byteCount = 0L;
            boolean valid = false;
            if (tag2 == null) {
                if (DEBUG) {
                    Log.d(TAG, "Skip the tag entry since tag number is not defined: " + tagNumber);
                }
            } else if (dataFormat <= 0 || dataFormat >= IFD_FORMAT_BYTES_PER_FORMAT.length) {
                if (DEBUG) {
                    Log.d(TAG, "Skip the tag entry since data format is invalid: " + dataFormat);
                }
            } else {
                byteCount = (long)numberOfComponents * (long)IFD_FORMAT_BYTES_PER_FORMAT[dataFormat];
                if (byteCount < 0L || byteCount > Integer.MAX_VALUE) {
                    if (DEBUG) {
                        Log.d(TAG, "Skip the tag entry since the number of components is invalid: " + numberOfComponents);
                    }
                } else {
                    valid = true;
                }
            }
            if (!valid) {
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            if (byteCount > 4L) {
                int offset2 = dataInputStream.readInt();
                if (DEBUG) {
                    Log.d(TAG, "seek to data offset: " + offset2);
                }
                if (this.mMimeType == 7) {
                    if (tag2.name == TAG_MAKER_NOTE) {
                        this.mOrfMakerNoteOffset = offset2;
                    } else if (ifdType == 6 && tag2.name == TAG_ORF_THUMBNAIL_IMAGE) {
                        this.mOrfThumbnailOffset = offset2;
                        this.mOrfThumbnailLength = numberOfComponents;
                        ExifAttribute compressionAttribute = ExifAttribute.createUShort(6, this.mExifByteOrder);
                        ExifAttribute jpegInterchangeFormatAttribute = ExifAttribute.createULong(this.mOrfThumbnailOffset, this.mExifByteOrder);
                        ExifAttribute jpegInterchangeFormatLengthAttribute = ExifAttribute.createULong(this.mOrfThumbnailLength, this.mExifByteOrder);
                        this.mAttributes[4].put(TAG_COMPRESSION, compressionAttribute);
                        this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT, jpegInterchangeFormatAttribute);
                        this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, jpegInterchangeFormatLengthAttribute);
                    }
                } else if (this.mMimeType == 10 && tag2.name == TAG_RW2_JPG_FROM_RAW) {
                    this.mRw2JpgFromRawOffset = offset2;
                }
                if ((long)offset2 + byteCount <= (long)dataInputStream.mLength) {
                    dataInputStream.seek(offset2);
                } else {
                    if (DEBUG) {
                        Log.d(TAG, "Skip the tag entry since data offset is invalid: " + offset2);
                    }
                    dataInputStream.seek(nextEntryOffset);
                    continue;
                }
            }
            Integer nextIfdType = sExifPointerTagMap.get(tagNumber);
            if (DEBUG) {
                Log.d(TAG, "nextIfdType: " + nextIfdType + " byteCount: " + byteCount);
            }
            if (nextIfdType != null) {
                long offset3 = -1L;
                switch (dataFormat) {
                    case 3: {
                        offset3 = dataInputStream.readUnsignedShort();
                        break;
                    }
                    case 8: {
                        offset3 = dataInputStream.readShort();
                        break;
                    }
                    case 4: {
                        offset3 = dataInputStream.readUnsignedInt();
                        break;
                    }
                    case 9: 
                    case 13: {
                        offset3 = dataInputStream.readInt();
                        break;
                    }
                }
                if (DEBUG) {
                    Log.d(TAG, String.format("Offset: %d, tagName: %s", offset3, tag2.name));
                }
                if (offset3 > 0L && offset3 < (long)dataInputStream.mLength) {
                    if (!this.mHandledIfdOffsets.contains((int)offset3)) {
                        dataInputStream.seek(offset3);
                        this.readImageFileDirectory(dataInputStream, nextIfdType);
                    } else if (DEBUG) {
                        Log.d(TAG, "Skip jump into the IFD since it has already been read: IfdType " + nextIfdType + " (at " + offset3 + ")");
                    }
                } else if (DEBUG) {
                    Log.d(TAG, "Skip jump into the IFD since its offset is invalid: " + offset3);
                }
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            int bytesOffset = dataInputStream.peek() + this.mExifOffset;
            byte[] bytes = new byte[(int)byteCount];
            dataInputStream.readFully(bytes);
            ExifAttribute attribute = new ExifAttribute(dataFormat, numberOfComponents, bytesOffset, bytes);
            this.mAttributes[ifdType].put(tag2.name, attribute);
            if (tag2.name == TAG_DNG_VERSION) {
                this.mMimeType = 3;
            }
            if ((tag2.name == TAG_MAKE || tag2.name == TAG_MODEL) && attribute.getStringValue(this.mExifByteOrder).contains(PEF_SIGNATURE) || tag2.name == TAG_COMPRESSION && attribute.getIntValue(this.mExifByteOrder) == 65535) {
                this.mMimeType = 8;
            }
            if ((long)dataInputStream.peek() == nextEntryOffset) continue;
            dataInputStream.seek(nextEntryOffset);
        }
        if (dataInputStream.peek() + 4 <= dataInputStream.mLength) {
            int nextIfdOffset = dataInputStream.readInt();
            if (DEBUG) {
                Log.d(TAG, String.format("nextIfdOffset: %d", nextIfdOffset));
            }
            if ((long)nextIfdOffset > 0L && nextIfdOffset < dataInputStream.mLength) {
                if (!this.mHandledIfdOffsets.contains(nextIfdOffset)) {
                    dataInputStream.seek(nextIfdOffset);
                    if (this.mAttributes[4].isEmpty()) {
                        this.readImageFileDirectory(dataInputStream, 4);
                    } else if (this.mAttributes[5].isEmpty()) {
                        this.readImageFileDirectory(dataInputStream, 5);
                    }
                } else if (DEBUG) {
                    Log.d(TAG, "Stop reading file since re-reading an IFD may cause an infinite loop: " + nextIfdOffset);
                }
            } else if (DEBUG) {
                Log.d(TAG, "Stop reading file since a wrong offset may cause an infinite loop: " + nextIfdOffset);
            }
        }
    }

    private void retrieveJpegImageSize(ByteOrderedDataInputStream in, int imageType) throws IOException {
        ExifAttribute jpegInterchangeFormatAttribute;
        ExifAttribute imageLengthAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_IMAGE_LENGTH);
        ExifAttribute imageWidthAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_IMAGE_WIDTH);
        if ((imageLengthAttribute == null || imageWidthAttribute == null) && (jpegInterchangeFormatAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_JPEG_INTERCHANGE_FORMAT)) != null) {
            int jpegInterchangeFormat = jpegInterchangeFormatAttribute.getIntValue(this.mExifByteOrder);
            this.getJpegAttributes(in, jpegInterchangeFormat, imageType);
        }
    }

    private void setThumbnailData(ByteOrderedDataInputStream in) throws IOException {
        HashMap thumbnailData = this.mAttributes[4];
        ExifAttribute compressionAttribute = (ExifAttribute)thumbnailData.get(TAG_COMPRESSION);
        if (compressionAttribute != null) {
            this.mThumbnailCompression = compressionAttribute.getIntValue(this.mExifByteOrder);
            switch (this.mThumbnailCompression) {
                case 6: {
                    this.handleThumbnailFromJfif(in, thumbnailData);
                    break;
                }
                case 1: 
                case 7: {
                    if (!this.isSupportedDataType(thumbnailData)) break;
                    this.handleThumbnailFromStrips(in, thumbnailData);
                }
            }
        } else {
            this.handleThumbnailFromJfif(in, thumbnailData);
        }
    }

    private void handleThumbnailFromJfif(ByteOrderedDataInputStream in, HashMap thumbnailData) throws IOException {
        ExifAttribute jpegInterchangeFormatAttribute = (ExifAttribute)thumbnailData.get(TAG_JPEG_INTERCHANGE_FORMAT);
        ExifAttribute jpegInterchangeFormatLengthAttribute = (ExifAttribute)thumbnailData.get(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
        if (jpegInterchangeFormatAttribute != null && jpegInterchangeFormatLengthAttribute != null) {
            int thumbnailOffset = jpegInterchangeFormatAttribute.getIntValue(this.mExifByteOrder);
            int thumbnailLength = jpegInterchangeFormatLengthAttribute.getIntValue(this.mExifByteOrder);
            if (this.mMimeType == 7) {
                thumbnailOffset += this.mOrfMakerNoteOffset;
            }
            thumbnailLength = Math.min(thumbnailLength, in.getLength() - thumbnailOffset);
            if (thumbnailOffset > 0 && thumbnailLength > 0) {
                this.mHasThumbnail = true;
                this.mThumbnailOffset = thumbnailOffset + this.mExifOffset;
                this.mThumbnailLength = thumbnailLength;
                this.mThumbnailCompression = 6;
                if (this.mFilename == null && this.mAssetInputStream == null && this.mSeekableFileDescriptor == null) {
                    byte[] thumbnailBytes = new byte[this.mThumbnailLength];
                    in.seek(this.mThumbnailOffset);
                    in.readFully(thumbnailBytes);
                    this.mThumbnailBytes = thumbnailBytes;
                }
            }
            if (DEBUG) {
                Log.d(TAG, "Setting thumbnail attributes with offset: " + thumbnailOffset + ", length: " + thumbnailLength);
            }
        }
    }

    private void handleThumbnailFromStrips(ByteOrderedDataInputStream in, HashMap thumbnailData) throws IOException {
        ExifAttribute stripOffsetsAttribute = (ExifAttribute)thumbnailData.get(TAG_STRIP_OFFSETS);
        ExifAttribute stripByteCountsAttribute = (ExifAttribute)thumbnailData.get(TAG_STRIP_BYTE_COUNTS);
        if (stripOffsetsAttribute != null && stripByteCountsAttribute != null) {
            long[] stripOffsets = ExifInterfaceUtils.convertToLongArray(stripOffsetsAttribute.getValue(this.mExifByteOrder));
            long[] stripByteCounts = ExifInterfaceUtils.convertToLongArray(stripByteCountsAttribute.getValue(this.mExifByteOrder));
            if (stripOffsets == null || stripOffsets.length == 0) {
                Log.w(TAG, "stripOffsets should not be null or have zero length.");
                return;
            }
            if (stripByteCounts == null || stripByteCounts.length == 0) {
                Log.w(TAG, "stripByteCounts should not be null or have zero length.");
                return;
            }
            if (stripOffsets.length != stripByteCounts.length) {
                Log.w(TAG, "stripOffsets and stripByteCounts should have same length.");
                return;
            }
            byte[] totalStripBytes = new byte[(int)Arrays.stream(stripByteCounts).sum()];
            int bytesRead = 0;
            int bytesAdded = 0;
            this.mAreThumbnailStripsConsecutive = true;
            this.mHasThumbnailStrips = true;
            this.mHasThumbnail = true;
            for (int i = 0; i < stripOffsets.length; ++i) {
                int skipBytes;
                int stripOffset = (int)stripOffsets[i];
                int stripByteCount = (int)stripByteCounts[i];
                if (i < stripOffsets.length - 1 && (long)(stripOffset + stripByteCount) != stripOffsets[i + 1]) {
                    this.mAreThumbnailStripsConsecutive = false;
                }
                if ((skipBytes = stripOffset - bytesRead) < 0) {
                    Log.d(TAG, "Invalid strip offset value");
                }
                in.seek(skipBytes);
                bytesRead += skipBytes;
                byte[] stripBytes = new byte[stripByteCount];
                in.read(stripBytes);
                bytesRead += stripByteCount;
                System.arraycopy(stripBytes, 0, totalStripBytes, bytesAdded, stripBytes.length);
                bytesAdded += stripBytes.length;
            }
            this.mThumbnailBytes = totalStripBytes;
            if (this.mAreThumbnailStripsConsecutive) {
                this.mThumbnailOffset = (int)stripOffsets[0] + this.mExifOffset;
                this.mThumbnailLength = totalStripBytes.length;
            }
        }
    }

    private boolean isSupportedDataType(HashMap thumbnailData) throws IOException {
        ExifAttribute bitsPerSampleAttribute = (ExifAttribute)thumbnailData.get(TAG_BITS_PER_SAMPLE);
        if (bitsPerSampleAttribute != null) {
            int photometricInterpretationValue;
            ExifAttribute photometricInterpretationAttribute;
            int[] bitsPerSampleValue = (int[])bitsPerSampleAttribute.getValue(this.mExifByteOrder);
            if (Arrays.equals(BITS_PER_SAMPLE_RGB, bitsPerSampleValue)) {
                return true;
            }
            if (this.mMimeType == 3 && (photometricInterpretationAttribute = (ExifAttribute)thumbnailData.get(TAG_PHOTOMETRIC_INTERPRETATION)) != null && ((photometricInterpretationValue = photometricInterpretationAttribute.getIntValue(this.mExifByteOrder)) == 1 && Arrays.equals(bitsPerSampleValue, BITS_PER_SAMPLE_GREYSCALE_2) || photometricInterpretationValue == 6 && Arrays.equals(bitsPerSampleValue, BITS_PER_SAMPLE_RGB))) {
                return true;
            }
        }
        if (DEBUG) {
            Log.d(TAG, "Unsupported data type value");
        }
        return false;
    }

    private boolean isThumbnail(HashMap map2) throws IOException {
        ExifAttribute imageLengthAttribute = (ExifAttribute)map2.get(TAG_IMAGE_LENGTH);
        ExifAttribute imageWidthAttribute = (ExifAttribute)map2.get(TAG_IMAGE_WIDTH);
        if (imageLengthAttribute != null && imageWidthAttribute != null) {
            int imageLengthValue = imageLengthAttribute.getIntValue(this.mExifByteOrder);
            int imageWidthValue = imageWidthAttribute.getIntValue(this.mExifByteOrder);
            if (imageLengthValue <= 512 && imageWidthValue <= 512) {
                return true;
            }
        }
        return false;
    }

    private void validateImages() throws IOException {
        this.swapBasedOnImageSize(0, 5);
        this.swapBasedOnImageSize(0, 4);
        this.swapBasedOnImageSize(5, 4);
        ExifAttribute pixelXDimAttribute = (ExifAttribute)this.mAttributes[1].get(TAG_PIXEL_X_DIMENSION);
        ExifAttribute pixelYDimAttribute = (ExifAttribute)this.mAttributes[1].get(TAG_PIXEL_Y_DIMENSION);
        if (pixelXDimAttribute != null && pixelYDimAttribute != null) {
            this.mAttributes[0].put(TAG_IMAGE_WIDTH, pixelXDimAttribute);
            this.mAttributes[0].put(TAG_IMAGE_LENGTH, pixelYDimAttribute);
        }
        if (this.mAttributes[4].isEmpty() && this.isThumbnail(this.mAttributes[5])) {
            this.mAttributes[4] = this.mAttributes[5];
            this.mAttributes[5] = new HashMap();
        }
        if (!this.isThumbnail(this.mAttributes[4])) {
            Log.d(TAG, "No image meets the size requirements of a thumbnail image.");
        }
        this.replaceInvalidTags(0, TAG_THUMBNAIL_ORIENTATION, TAG_ORIENTATION);
        this.replaceInvalidTags(0, TAG_THUMBNAIL_IMAGE_LENGTH, TAG_IMAGE_LENGTH);
        this.replaceInvalidTags(0, TAG_THUMBNAIL_IMAGE_WIDTH, TAG_IMAGE_WIDTH);
        this.replaceInvalidTags(5, TAG_THUMBNAIL_ORIENTATION, TAG_ORIENTATION);
        this.replaceInvalidTags(5, TAG_THUMBNAIL_IMAGE_LENGTH, TAG_IMAGE_LENGTH);
        this.replaceInvalidTags(5, TAG_THUMBNAIL_IMAGE_WIDTH, TAG_IMAGE_WIDTH);
        this.replaceInvalidTags(4, TAG_ORIENTATION, TAG_THUMBNAIL_ORIENTATION);
        this.replaceInvalidTags(4, TAG_IMAGE_LENGTH, TAG_THUMBNAIL_IMAGE_LENGTH);
        this.replaceInvalidTags(4, TAG_IMAGE_WIDTH, TAG_THUMBNAIL_IMAGE_WIDTH);
    }

    private void updateImageSizeValues(ByteOrderedDataInputStream in, int imageType) throws IOException {
        ExifAttribute defaultCropSizeAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_DEFAULT_CROP_SIZE);
        ExifAttribute topBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_RW2_SENSOR_TOP_BORDER);
        ExifAttribute leftBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_RW2_SENSOR_LEFT_BORDER);
        ExifAttribute bottomBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_RW2_SENSOR_BOTTOM_BORDER);
        ExifAttribute rightBorderAttribute = (ExifAttribute)this.mAttributes[imageType].get(TAG_RW2_SENSOR_RIGHT_BORDER);
        if (defaultCropSizeAttribute != null) {
            ExifAttribute defaultCropSizeYAttribute;
            ExifAttribute defaultCropSizeXAttribute;
            if (defaultCropSizeAttribute.format == 5) {
                Rational[] defaultCropSizeValue = (Rational[])defaultCropSizeAttribute.getValue(this.mExifByteOrder);
                defaultCropSizeXAttribute = ExifAttribute.createURational(defaultCropSizeValue[0], this.mExifByteOrder);
                defaultCropSizeYAttribute = ExifAttribute.createURational(defaultCropSizeValue[1], this.mExifByteOrder);
            } else {
                int[] defaultCropSizeValue = (int[])defaultCropSizeAttribute.getValue(this.mExifByteOrder);
                defaultCropSizeXAttribute = ExifAttribute.createUShort(defaultCropSizeValue[0], this.mExifByteOrder);
                defaultCropSizeYAttribute = ExifAttribute.createUShort(defaultCropSizeValue[1], this.mExifByteOrder);
            }
            this.mAttributes[imageType].put(TAG_IMAGE_WIDTH, defaultCropSizeXAttribute);
            this.mAttributes[imageType].put(TAG_IMAGE_LENGTH, defaultCropSizeYAttribute);
        } else if (topBorderAttribute != null && leftBorderAttribute != null && bottomBorderAttribute != null && rightBorderAttribute != null) {
            int topBorderValue = topBorderAttribute.getIntValue(this.mExifByteOrder);
            int bottomBorderValue = bottomBorderAttribute.getIntValue(this.mExifByteOrder);
            int rightBorderValue = rightBorderAttribute.getIntValue(this.mExifByteOrder);
            int leftBorderValue = leftBorderAttribute.getIntValue(this.mExifByteOrder);
            if (bottomBorderValue > topBorderValue && rightBorderValue > leftBorderValue) {
                int length = bottomBorderValue - topBorderValue;
                int width2 = rightBorderValue - leftBorderValue;
                ExifAttribute imageLengthAttribute = ExifAttribute.createUShort(length, this.mExifByteOrder);
                ExifAttribute imageWidthAttribute = ExifAttribute.createUShort(width2, this.mExifByteOrder);
                this.mAttributes[imageType].put(TAG_IMAGE_LENGTH, imageLengthAttribute);
                this.mAttributes[imageType].put(TAG_IMAGE_WIDTH, imageWidthAttribute);
            }
        } else {
            this.retrieveJpegImageSize(in, imageType);
        }
    }

    private int writeExifSegment(ByteOrderedDataOutputStream dataOutputStream) throws IOException {
        int[] ifdOffsets = new int[EXIF_TAGS.length];
        int[] ifdDataSizes = new int[EXIF_TAGS.length];
        for (ExifTag tag2 : EXIF_POINTER_TAGS) {
            this.removeAttribute(tag2.name);
        }
        if (this.mHasThumbnail) {
            if (this.mHasThumbnailStrips) {
                this.removeAttribute(TAG_STRIP_OFFSETS);
                this.removeAttribute(TAG_STRIP_BYTE_COUNTS);
            } else {
                this.removeAttribute(TAG_JPEG_INTERCHANGE_FORMAT);
                this.removeAttribute(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
            }
        }
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            for (Object obj : this.mAttributes[ifdType].entrySet().toArray()) {
                Map.Entry entry = (Map.Entry)obj;
                if (entry.getValue() != null) continue;
                this.mAttributes[ifdType].remove(entry.getKey());
            }
        }
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.mHasThumbnail) {
            if (this.mHasThumbnailStrips) {
                this.mAttributes[4].put(TAG_STRIP_OFFSETS, ExifAttribute.createUShort(0, this.mExifByteOrder));
                this.mAttributes[4].put(TAG_STRIP_BYTE_COUNTS, ExifAttribute.createUShort(this.mThumbnailLength, this.mExifByteOrder));
            } else {
                this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT, ExifAttribute.createULong(0L, this.mExifByteOrder));
                this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, ExifAttribute.createULong(this.mThumbnailLength, this.mExifByteOrder));
            }
        }
        int i = 0;
        while (i < EXIF_TAGS.length) {
            int sum = 0;
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute exifAttribute = (ExifAttribute)entry.getValue();
                int size = exifAttribute.size();
                if (size <= 4) continue;
                sum += size;
            }
            int n = i++;
            ifdDataSizes[n] = ifdDataSizes[n] + sum;
        }
        int position = 8;
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            if (this.mAttributes[ifdType].isEmpty()) continue;
            ifdOffsets[ifdType] = position;
            position += 2 + this.mAttributes[ifdType].size() * 12 + 4 + ifdDataSizes[ifdType];
        }
        if (this.mHasThumbnail) {
            int thumbnailOffset = position;
            if (this.mHasThumbnailStrips) {
                this.mAttributes[4].put(TAG_STRIP_OFFSETS, ExifAttribute.createUShort(thumbnailOffset, this.mExifByteOrder));
            } else {
                this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT, ExifAttribute.createULong(thumbnailOffset, this.mExifByteOrder));
            }
            this.mThumbnailOffset = thumbnailOffset + this.mExifOffset;
            position += this.mThumbnailLength;
        }
        int totalSize = position;
        if (this.mMimeType == 4) {
            totalSize += 8;
        }
        if (DEBUG) {
            for (int i2 = 0; i2 < EXIF_TAGS.length; ++i2) {
                Log.d(TAG, String.format("index: %d, offsets: %d, tag count: %d, data sizes: %d, total size: %d", i2, ifdOffsets[i2], this.mAttributes[i2].size(), ifdDataSizes[i2], totalSize));
            }
        }
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(ifdOffsets[1], this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(ifdOffsets[2], this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(ifdOffsets[3], this.mExifByteOrder));
        }
        switch (this.mMimeType) {
            case 4: {
                dataOutputStream.writeUnsignedShort(totalSize);
                dataOutputStream.write(IDENTIFIER_EXIF_APP1);
                break;
            }
            case 13: {
                dataOutputStream.writeInt(totalSize);
                dataOutputStream.write(PNG_CHUNK_TYPE_EXIF);
                break;
            }
            case 14: {
                dataOutputStream.write(WEBP_CHUNK_TYPE_EXIF);
                dataOutputStream.writeInt(totalSize);
            }
        }
        dataOutputStream.writeShort(this.mExifByteOrder == ByteOrder.BIG_ENDIAN ? (short)19789 : 18761);
        dataOutputStream.setByteOrder(this.mExifByteOrder);
        dataOutputStream.writeUnsignedShort(42);
        dataOutputStream.writeUnsignedInt(8L);
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            if (this.mAttributes[ifdType].isEmpty()) continue;
            dataOutputStream.writeUnsignedShort(this.mAttributes[ifdType].size());
            int dataOffset = ifdOffsets[ifdType] + 2 + this.mAttributes[ifdType].size() * 12 + 4;
            for (Map.Entry entry : this.mAttributes[ifdType].entrySet()) {
                ExifTag tag3 = (ExifTag)sExifTagMapsForWriting[ifdType].get(entry.getKey());
                int tagNumber = tag3.number;
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                int size = attribute.size();
                dataOutputStream.writeUnsignedShort(tagNumber);
                dataOutputStream.writeUnsignedShort(attribute.format);
                dataOutputStream.writeInt(attribute.numberOfComponents);
                if (size > 4) {
                    dataOutputStream.writeUnsignedInt(dataOffset);
                    dataOffset += size;
                    continue;
                }
                dataOutputStream.write(attribute.bytes);
                if (size >= 4) continue;
                for (int i3 = size; i3 < 4; ++i3) {
                    dataOutputStream.writeByte(0);
                }
            }
            if (ifdType == 0 && !this.mAttributes[4].isEmpty()) {
                dataOutputStream.writeUnsignedInt(ifdOffsets[4]);
            } else {
                dataOutputStream.writeUnsignedInt(0L);
            }
            for (Map.Entry entry : this.mAttributes[ifdType].entrySet()) {
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                if (attribute.bytes.length <= 4) continue;
                dataOutputStream.write(attribute.bytes, 0, attribute.bytes.length);
            }
        }
        if (this.mHasThumbnail) {
            dataOutputStream.write(this.getThumbnailBytes());
        }
        if (this.mMimeType == 14 && totalSize % 2 == 1) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return totalSize;
    }

    private static Pair<Integer, Integer> guessDataFormat(String entryValue) {
        if (entryValue.contains(",")) {
            String[] entryValues = entryValue.split(",");
            Pair<Integer, Integer> dataFormat = ExifInterface.guessDataFormat(entryValues[0]);
            if ((Integer)dataFormat.first == 2) {
                return dataFormat;
            }
            for (int i = 1; i < entryValues.length; ++i) {
                Pair<Integer, Integer> guessDataFormat = ExifInterface.guessDataFormat(entryValues[i]);
                int first = -1;
                int second = -1;
                if (guessDataFormat.first == dataFormat.first || guessDataFormat.second == dataFormat.first) {
                    first = (Integer)dataFormat.first;
                }
                if ((Integer)dataFormat.second != -1 && (guessDataFormat.first == dataFormat.second || guessDataFormat.second == dataFormat.second)) {
                    second = (Integer)dataFormat.second;
                }
                if (first == -1 && second == -1) {
                    return new Pair<Integer, Integer>(2, -1);
                }
                if (first == -1) {
                    dataFormat = new Pair<Integer, Integer>(second, -1);
                    continue;
                }
                if (second != -1) continue;
                dataFormat = new Pair<Integer, Integer>(first, -1);
            }
            return dataFormat;
        }
        if (entryValue.contains("/")) {
            String[] rationalNumber = entryValue.split("/");
            if (rationalNumber.length == 2) {
                try {
                    long numerator = (long)Double.parseDouble(rationalNumber[0]);
                    long denominator = (long)Double.parseDouble(rationalNumber[1]);
                    if (numerator < 0L || denominator < 0L) {
                        return new Pair<Integer, Integer>(10, -1);
                    }
                    if (numerator > Integer.MAX_VALUE || denominator > Integer.MAX_VALUE) {
                        return new Pair<Integer, Integer>(5, -1);
                    }
                    return new Pair<Integer, Integer>(10, 5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Pair<Integer, Integer>(2, -1);
        }
        try {
            Long longValue = Long.parseLong(entryValue);
            if (longValue >= 0L && longValue <= 65535L) {
                return new Pair<Integer, Integer>(3, 4);
            }
            if (longValue < 0L) {
                return new Pair<Integer, Integer>(9, -1);
            }
            return new Pair<Integer, Integer>(4, -1);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(entryValue);
                return new Pair<Integer, Integer>(12, -1);
            }
            catch (NumberFormatException numberFormatException2) {
                return new Pair<Integer, Integer>(2, -1);
            }
        }
    }

    private void swapBasedOnImageSize(int firstIfdType, int secondIfdType) throws IOException {
        if (this.mAttributes[firstIfdType].isEmpty() || this.mAttributes[secondIfdType].isEmpty()) {
            if (DEBUG) {
                Log.d(TAG, "Cannot perform swap since only one image data exists");
            }
            return;
        }
        ExifAttribute firstImageLengthAttribute = (ExifAttribute)this.mAttributes[firstIfdType].get(TAG_IMAGE_LENGTH);
        ExifAttribute firstImageWidthAttribute = (ExifAttribute)this.mAttributes[firstIfdType].get(TAG_IMAGE_WIDTH);
        ExifAttribute secondImageLengthAttribute = (ExifAttribute)this.mAttributes[secondIfdType].get(TAG_IMAGE_LENGTH);
        ExifAttribute secondImageWidthAttribute = (ExifAttribute)this.mAttributes[secondIfdType].get(TAG_IMAGE_WIDTH);
        if (firstImageLengthAttribute == null || firstImageWidthAttribute == null) {
            if (DEBUG) {
                Log.d(TAG, "First image does not contain valid size information");
            }
        } else if (secondImageLengthAttribute == null || secondImageWidthAttribute == null) {
            if (DEBUG) {
                Log.d(TAG, "Second image does not contain valid size information");
            }
        } else {
            int firstImageLengthValue = firstImageLengthAttribute.getIntValue(this.mExifByteOrder);
            int firstImageWidthValue = firstImageWidthAttribute.getIntValue(this.mExifByteOrder);
            int secondImageLengthValue = secondImageLengthAttribute.getIntValue(this.mExifByteOrder);
            int secondImageWidthValue = secondImageWidthAttribute.getIntValue(this.mExifByteOrder);
            if (firstImageLengthValue < secondImageLengthValue && firstImageWidthValue < secondImageWidthValue) {
                HashMap tempMap = this.mAttributes[firstIfdType];
                this.mAttributes[firstIfdType] = this.mAttributes[secondIfdType];
                this.mAttributes[secondIfdType] = tempMap;
            }
        }
    }

    private void replaceInvalidTags(int ifdType, String invalidTag, String validTag) {
        if (!this.mAttributes[ifdType].isEmpty() && this.mAttributes[ifdType].get(invalidTag) != null) {
            this.mAttributes[ifdType].put(validTag, this.mAttributes[ifdType].get(invalidTag));
            this.mAttributes[ifdType].remove(invalidTag);
        }
    }

    private boolean isSupportedFormatForSavingAttributes() {
        return this.mIsSupportedFile && (this.mMimeType == 4 || this.mMimeType == 13 || this.mMimeType == 14 || this.mMimeType == 3 || this.mMimeType == 0);
    }

    static {
        IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE", "IFD"};
        IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 1};
        EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
        BITS_PER_SAMPLE_RGB = new int[]{8, 8, 8};
        BITS_PER_SAMPLE_GREYSCALE_1 = new int[]{4};
        BITS_PER_SAMPLE_GREYSCALE_2 = new int[]{8};
        IFD_TIFF_TAGS = new ExifTag[]{new ExifTag(TAG_NEW_SUBFILE_TYPE, 254, 4), new ExifTag(TAG_SUBFILE_TYPE, 255, 4), new ExifTag(TAG_IMAGE_WIDTH, 256, 3, 4), new ExifTag(TAG_IMAGE_LENGTH, 257, 3, 4), new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3), new ExifTag(TAG_COMPRESSION, 259, 3), new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3), new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2), new ExifTag(TAG_MAKE, 271, 2), new ExifTag(TAG_MODEL, 272, 2), new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4), new ExifTag(TAG_ORIENTATION, 274, 3), new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3), new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4), new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4), new ExifTag(TAG_X_RESOLUTION, 282, 5), new ExifTag(TAG_Y_RESOLUTION, 283, 5), new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3), new ExifTag(TAG_RESOLUTION_UNIT, 296, 3), new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3), new ExifTag(TAG_SOFTWARE, 305, 2), new ExifTag(TAG_DATETIME, 306, 2), new ExifTag(TAG_ARTIST, 315, 2), new ExifTag(TAG_WHITE_POINT, 318, 5), new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5), new ExifTag(TAG_SUB_IFD_POINTER, 330, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4), new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5), new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3), new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3), new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5), new ExifTag(TAG_COPYRIGHT, 33432, 2), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_RW2_SENSOR_TOP_BORDER, 4, 4), new ExifTag(TAG_RW2_SENSOR_LEFT_BORDER, 5, 4), new ExifTag(TAG_RW2_SENSOR_BOTTOM_BORDER, 6, 4), new ExifTag(TAG_RW2_SENSOR_RIGHT_BORDER, 7, 4), new ExifTag(TAG_RW2_ISO, 23, 3), new ExifTag(TAG_RW2_JPG_FROM_RAW, 46, 7), new ExifTag(TAG_XMP, 700, 1)};
        IFD_EXIF_TAGS = new ExifTag[]{new ExifTag(TAG_EXPOSURE_TIME, 33434, 5), new ExifTag("FNumber", 33437, 5), new ExifTag(TAG_EXPOSURE_PROGRAM, 34850, 3), new ExifTag(TAG_SPECTRAL_SENSITIVITY, 34852, 2), new ExifTag("ISOSpeedRatings", 34855, 3), new ExifTag(TAG_OECF, 34856, 7), new ExifTag(TAG_EXIF_VERSION, 36864, 2), new ExifTag(TAG_DATETIME_ORIGINAL, 36867, 2), new ExifTag(TAG_DATETIME_DIGITIZED, 36868, 2), new ExifTag(TAG_OFFSET_TIME, 36880, 2), new ExifTag(TAG_OFFSET_TIME_ORIGINAL, 36881, 2), new ExifTag(TAG_OFFSET_TIME_DIGITIZED, 36882, 2), new ExifTag(TAG_COMPONENTS_CONFIGURATION, 37121, 7), new ExifTag(TAG_COMPRESSED_BITS_PER_PIXEL, 37122, 5), new ExifTag(TAG_SHUTTER_SPEED_VALUE, 37377, 10), new ExifTag(TAG_APERTURE_VALUE, 37378, 5), new ExifTag(TAG_BRIGHTNESS_VALUE, 37379, 10), new ExifTag(TAG_EXPOSURE_BIAS_VALUE, 37380, 10), new ExifTag(TAG_MAX_APERTURE_VALUE, 37381, 5), new ExifTag(TAG_SUBJECT_DISTANCE, 37382, 5), new ExifTag(TAG_METERING_MODE, 37383, 3), new ExifTag(TAG_LIGHT_SOURCE, 37384, 3), new ExifTag(TAG_FLASH, 37385, 3), new ExifTag(TAG_FOCAL_LENGTH, 37386, 5), new ExifTag(TAG_SUBJECT_AREA, 37396, 3), new ExifTag(TAG_MAKER_NOTE, 37500, 7), new ExifTag(TAG_USER_COMMENT, 37510, 7), new ExifTag(TAG_SUBSEC_TIME, 37520, 2), new ExifTag("SubSecTimeOriginal", 37521, 2), new ExifTag("SubSecTimeDigitized", 37522, 2), new ExifTag(TAG_FLASHPIX_VERSION, 40960, 7), new ExifTag(TAG_COLOR_SPACE, 40961, 3), new ExifTag(TAG_PIXEL_X_DIMENSION, 40962, 3, 4), new ExifTag(TAG_PIXEL_Y_DIMENSION, 40963, 3, 4), new ExifTag(TAG_RELATED_SOUND_FILE, 40964, 2), new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4), new ExifTag(TAG_FLASH_ENERGY, 41483, 5), new ExifTag(TAG_SPATIAL_FREQUENCY_RESPONSE, 41484, 7), new ExifTag(TAG_FOCAL_PLANE_X_RESOLUTION, 41486, 5), new ExifTag(TAG_FOCAL_PLANE_Y_RESOLUTION, 41487, 5), new ExifTag(TAG_FOCAL_PLANE_RESOLUTION_UNIT, 41488, 3), new ExifTag(TAG_SUBJECT_LOCATION, 41492, 3), new ExifTag(TAG_EXPOSURE_INDEX, 41493, 5), new ExifTag(TAG_SENSING_METHOD, 41495, 3), new ExifTag(TAG_FILE_SOURCE, 41728, 7), new ExifTag(TAG_SCENE_TYPE, 41729, 7), new ExifTag(TAG_CFA_PATTERN, 41730, 7), new ExifTag(TAG_CUSTOM_RENDERED, 41985, 3), new ExifTag(TAG_EXPOSURE_MODE, 41986, 3), new ExifTag(TAG_WHITE_BALANCE, 41987, 3), new ExifTag(TAG_DIGITAL_ZOOM_RATIO, 41988, 5), new ExifTag(TAG_FOCAL_LENGTH_IN_35MM_FILM, 41989, 3), new ExifTag(TAG_SCENE_CAPTURE_TYPE, 41990, 3), new ExifTag(TAG_GAIN_CONTROL, 41991, 3), new ExifTag(TAG_CONTRAST, 41992, 3), new ExifTag(TAG_SATURATION, 41993, 3), new ExifTag(TAG_SHARPNESS, 41994, 3), new ExifTag(TAG_DEVICE_SETTING_DESCRIPTION, 41995, 7), new ExifTag(TAG_SUBJECT_DISTANCE_RANGE, 41996, 3), new ExifTag(TAG_IMAGE_UNIQUE_ID, 42016, 2), new ExifTag(TAG_DNG_VERSION, 50706, 1), new ExifTag(TAG_DEFAULT_CROP_SIZE, 50720, 3, 4)};
        IFD_GPS_TAGS = new ExifTag[]{new ExifTag(TAG_GPS_VERSION_ID, 0, 1), new ExifTag(TAG_GPS_LATITUDE_REF, 1, 2), new ExifTag(TAG_GPS_LATITUDE, 2, 5), new ExifTag(TAG_GPS_LONGITUDE_REF, 3, 2), new ExifTag(TAG_GPS_LONGITUDE, 4, 5), new ExifTag(TAG_GPS_ALTITUDE_REF, 5, 1), new ExifTag(TAG_GPS_ALTITUDE, 6, 5), new ExifTag(TAG_GPS_TIMESTAMP, 7, 5), new ExifTag(TAG_GPS_SATELLITES, 8, 2), new ExifTag(TAG_GPS_STATUS, 9, 2), new ExifTag(TAG_GPS_MEASURE_MODE, 10, 2), new ExifTag(TAG_GPS_DOP, 11, 5), new ExifTag(TAG_GPS_SPEED_REF, 12, 2), new ExifTag(TAG_GPS_SPEED, 13, 5), new ExifTag(TAG_GPS_TRACK_REF, 14, 2), new ExifTag(TAG_GPS_TRACK, 15, 5), new ExifTag(TAG_GPS_IMG_DIRECTION_REF, 16, 2), new ExifTag(TAG_GPS_IMG_DIRECTION, 17, 5), new ExifTag(TAG_GPS_MAP_DATUM, 18, 2), new ExifTag(TAG_GPS_DEST_LATITUDE_REF, 19, 2), new ExifTag(TAG_GPS_DEST_LATITUDE, 20, 5), new ExifTag(TAG_GPS_DEST_LONGITUDE_REF, 21, 2), new ExifTag(TAG_GPS_DEST_LONGITUDE, 22, 5), new ExifTag(TAG_GPS_DEST_BEARING_REF, 23, 2), new ExifTag(TAG_GPS_DEST_BEARING, 24, 5), new ExifTag(TAG_GPS_DEST_DISTANCE_REF, 25, 2), new ExifTag(TAG_GPS_DEST_DISTANCE, 26, 5), new ExifTag(TAG_GPS_PROCESSING_METHOD, 27, 7), new ExifTag(TAG_GPS_AREA_INFORMATION, 28, 7), new ExifTag(TAG_GPS_DATESTAMP, 29, 2), new ExifTag(TAG_GPS_DIFFERENTIAL, 30, 3)};
        IFD_INTEROPERABILITY_TAGS = new ExifTag[]{new ExifTag(TAG_INTEROPERABILITY_INDEX, 1, 2)};
        IFD_THUMBNAIL_TAGS = new ExifTag[]{new ExifTag(TAG_NEW_SUBFILE_TYPE, 254, 4), new ExifTag(TAG_SUBFILE_TYPE, 255, 4), new ExifTag(TAG_THUMBNAIL_IMAGE_WIDTH, 256, 3, 4), new ExifTag(TAG_THUMBNAIL_IMAGE_LENGTH, 257, 3, 4), new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3), new ExifTag(TAG_COMPRESSION, 259, 3), new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3), new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2), new ExifTag(TAG_MAKE, 271, 2), new ExifTag(TAG_MODEL, 272, 2), new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4), new ExifTag(TAG_THUMBNAIL_ORIENTATION, 274, 3), new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3), new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4), new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4), new ExifTag(TAG_X_RESOLUTION, 282, 5), new ExifTag(TAG_Y_RESOLUTION, 283, 5), new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3), new ExifTag(TAG_RESOLUTION_UNIT, 296, 3), new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3), new ExifTag(TAG_SOFTWARE, 305, 2), new ExifTag(TAG_DATETIME, 306, 2), new ExifTag(TAG_ARTIST, 315, 2), new ExifTag(TAG_WHITE_POINT, 318, 5), new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5), new ExifTag(TAG_SUB_IFD_POINTER, 330, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4), new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5), new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3), new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3), new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5), new ExifTag(TAG_XMP, 700, 1), new ExifTag(TAG_COPYRIGHT, 33432, 2), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_DNG_VERSION, 50706, 1), new ExifTag(TAG_DEFAULT_CROP_SIZE, 50720, 3, 4)};
        TAG_RAF_IMAGE_SIZE = new ExifTag(TAG_STRIP_OFFSETS, 273, 3);
        ORF_MAKER_NOTE_TAGS = new ExifTag[]{new ExifTag(TAG_ORF_THUMBNAIL_IMAGE, 256, 7), new ExifTag(TAG_ORF_CAMERA_SETTINGS_IFD_POINTER, 8224, 4), new ExifTag(TAG_ORF_IMAGE_PROCESSING_IFD_POINTER, 8256, 4)};
        ORF_CAMERA_SETTINGS_TAGS = new ExifTag[]{new ExifTag(TAG_ORF_PREVIEW_IMAGE_START, 257, 4), new ExifTag(TAG_ORF_PREVIEW_IMAGE_LENGTH, 258, 4)};
        ORF_IMAGE_PROCESSING_TAGS = new ExifTag[]{new ExifTag(TAG_ORF_ASPECT_FRAME, 4371, 3)};
        PEF_TAGS = new ExifTag[]{new ExifTag(TAG_COLOR_SPACE, 55, 3)};
        EXIF_TAGS = new ExifTag[][]{IFD_TIFF_TAGS, IFD_EXIF_TAGS, IFD_GPS_TAGS, IFD_INTEROPERABILITY_TAGS, IFD_THUMBNAIL_TAGS, IFD_TIFF_TAGS, ORF_MAKER_NOTE_TAGS, ORF_CAMERA_SETTINGS_TAGS, ORF_IMAGE_PROCESSING_TAGS, PEF_TAGS};
        EXIF_POINTER_TAGS = new ExifTag[]{new ExifTag(TAG_SUB_IFD_POINTER, 330, 4), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4), new ExifTag(TAG_ORF_CAMERA_SETTINGS_IFD_POINTER, 8224, 1), new ExifTag(TAG_ORF_IMAGE_PROCESSING_IFD_POINTER, 8256, 1)};
        sExifTagMapsForReading = new HashMap[EXIF_TAGS.length];
        sExifTagMapsForWriting = new HashMap[EXIF_TAGS.length];
        sTagSetForCompatibility = new HashSet<String>(Arrays.asList("FNumber", TAG_DIGITAL_ZOOM_RATIO, TAG_EXPOSURE_TIME, TAG_SUBJECT_DISTANCE, TAG_GPS_TIMESTAMP));
        sExifPointerTagMap = new HashMap();
        ASCII = Charset.forName("US-ASCII");
        IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes(ASCII);
        IDENTIFIER_XMP_APP1 = "http://ns.adobe.com/xap/1.0/\u0000".getBytes(ASCII);
        sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", Locale.US);
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        sFormatterTz = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss XXX", Locale.US);
        sFormatterTz.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (int ifdType = 0; ifdType < EXIF_TAGS.length; ++ifdType) {
            ExifInterface.sExifTagMapsForReading[ifdType] = new HashMap();
            ExifInterface.sExifTagMapsForWriting[ifdType] = new HashMap();
            for (ExifTag tag2 : EXIF_TAGS[ifdType]) {
                sExifTagMapsForReading[ifdType].put(tag2.number, tag2);
                sExifTagMapsForWriting[ifdType].put(tag2.name, tag2);
            }
        }
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[0].number, 5);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[1].number, 1);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[2].number, 2);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[3].number, 3);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[4].number, 7);
        sExifPointerTagMap.put(ExifInterface.EXIF_POINTER_TAGS[5].number, 8);
        sNonZeroTimePattern = Pattern.compile(".*[1-9].*");
        sGpsTimestampPattern = Pattern.compile("^([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
    }

    private static class ByteOrderedDataOutputStream
    extends FilterOutputStream {
        final OutputStream mOutputStream;
        private ByteOrder mByteOrder;

        public ByteOrderedDataOutputStream(OutputStream out, ByteOrder byteOrder) {
            super(out);
            this.mOutputStream = out;
            this.mByteOrder = byteOrder;
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.mOutputStream.write(bytes);
        }

        @Override
        public void write(byte[] bytes, int offset2, int length) throws IOException {
            this.mOutputStream.write(bytes, offset2, length);
        }

        public void writeByte(int val) throws IOException {
            this.mOutputStream.write(val);
        }

        public void writeShort(short val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        public void writeInt(int val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 24 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 24 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        public void writeUnsignedShort(int val) throws IOException {
            this.writeShort((short)val);
        }

        public void writeUnsignedInt(long val) throws IOException {
            this.writeInt((int)val);
        }
    }

    private static class ByteOrderedDataInputStream
    extends InputStream
    implements DataInput {
        private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
        private static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
        private DataInputStream mDataInputStream;
        private InputStream mInputStream;
        private ByteOrder mByteOrder = ByteOrder.BIG_ENDIAN;
        private final int mLength;
        private int mPosition;

        public ByteOrderedDataInputStream(InputStream in) throws IOException {
            this(in, ByteOrder.BIG_ENDIAN);
        }

        ByteOrderedDataInputStream(InputStream in, ByteOrder byteOrder) throws IOException {
            this.mInputStream = in;
            this.mDataInputStream = new DataInputStream(in);
            this.mLength = this.mDataInputStream.available();
            this.mPosition = 0;
            this.mDataInputStream.mark(this.mLength);
            this.mByteOrder = byteOrder;
        }

        public ByteOrderedDataInputStream(byte[] bytes) throws IOException {
            this(new ByteArrayInputStream(bytes));
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        public void seek(long byteCount) throws IOException {
            if ((long)this.mPosition > byteCount) {
                this.mPosition = 0;
                this.mDataInputStream.reset();
                this.mDataInputStream.mark(this.mLength);
            } else {
                byteCount -= (long)this.mPosition;
            }
            if (this.skipBytes((int)byteCount) != (int)byteCount) {
                throw new IOException("Couldn't seek up to the byteCount");
            }
        }

        public int peek() {
            return this.mPosition;
        }

        @Override
        public int available() throws IOException {
            return this.mDataInputStream.available();
        }

        @Override
        public int read() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.read();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.readUnsignedByte();
        }

        @Override
        public String readLine() throws IOException {
            Log.d(ExifInterface.TAG, "Currently unsupported");
            return null;
        }

        @Override
        public boolean readBoolean() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.readBoolean();
        }

        @Override
        public char readChar() throws IOException {
            this.mPosition += 2;
            return this.mDataInputStream.readChar();
        }

        @Override
        public String readUTF() throws IOException {
            this.mPosition += 2;
            return this.mDataInputStream.readUTF();
        }

        @Override
        public void readFully(byte[] buffer, int offset2, int length) throws IOException {
            this.mPosition += length;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            if (this.mDataInputStream.read(buffer, offset2, length) != length) {
                throw new IOException("Couldn't read up to the length of buffer");
            }
        }

        @Override
        public void readFully(byte[] buffer) throws IOException {
            this.mPosition += buffer.length;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            if (this.mDataInputStream.read(buffer, 0, buffer.length) != buffer.length) {
                throw new IOException("Couldn't read up to the length of buffer");
            }
        }

        @Override
        public byte readByte() throws IOException {
            ++this.mPosition;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch = this.mDataInputStream.read();
            if (ch < 0) {
                throw new EOFException();
            }
            return (byte)ch;
        }

        @Override
        public short readShort() throws IOException {
            int ch2;
            this.mPosition += 2;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (short)((ch2 << 8) + ch1);
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (short)((ch1 << 8) + ch2);
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        @Override
        public int readInt() throws IOException {
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 4;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read()) | (ch3 = this.mDataInputStream.read()) | (ch4 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        @Override
        public int skipBytes(int byteCount) throws IOException {
            int totalSkipped;
            int skipped;
            int totalBytesToSkip = Math.min(byteCount, this.mLength - this.mPosition);
            for (totalSkipped = 0; totalSkipped < totalBytesToSkip && (skipped = this.mDataInputStream.skipBytes(totalBytesToSkip - totalSkipped)) > 0; totalSkipped += skipped) {
            }
            this.mPosition += totalSkipped;
            return totalSkipped;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            int ch2;
            this.mPosition += 2;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 8) + ch2;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        public long readUnsignedInt() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        @Override
        public long readLong() throws IOException {
            int ch8;
            int ch7;
            int ch6;
            int ch5;
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 8;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = this.mDataInputStream.read();
            if ((ch1 | (ch2 = this.mDataInputStream.read()) | (ch3 = this.mDataInputStream.read()) | (ch4 = this.mDataInputStream.read()) | (ch5 = this.mDataInputStream.read()) | (ch6 = this.mDataInputStream.read()) | (ch7 = this.mDataInputStream.read()) | (ch8 = this.mDataInputStream.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return ((long)ch8 << 56) + ((long)ch7 << 48) + ((long)ch6 << 40) + ((long)ch5 << 32) + ((long)ch4 << 24) + ((long)ch3 << 16) + ((long)ch2 << 8) + (long)ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + ((long)ch6 << 16) + ((long)ch7 << 8) + (long)ch8;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public int getLength() {
            return this.mLength;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IfdType {
    }

    private static class ExifTag {
        public final int number;
        public final String name;
        public final int primaryFormat;
        public final int secondaryFormat;

        private ExifTag(String name, int number, int format) {
            this.name = name;
            this.number = number;
            this.primaryFormat = format;
            this.secondaryFormat = -1;
        }

        private ExifTag(String name, int number, int primaryFormat, int secondaryFormat) {
            this.name = name;
            this.number = number;
            this.primaryFormat = primaryFormat;
            this.secondaryFormat = secondaryFormat;
        }
    }

    private static class ExifAttribute {
        public final int format;
        public final int numberOfComponents;
        public final long bytesOffset;
        public final byte[] bytes;
        public static final long BYTES_OFFSET_UNKNOWN = -1L;

        private ExifAttribute(int format, int numberOfComponents, byte[] bytes) {
            this(format, numberOfComponents, -1L, bytes);
        }

        private ExifAttribute(int format, int numberOfComponents, long bytesOffset, byte[] bytes) {
            this.format = format;
            this.numberOfComponents = numberOfComponents;
            this.bytesOffset = bytesOffset;
            this.bytes = bytes;
        }

        public static ExifAttribute createUShort(int[] values2, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * values2.length]);
            buffer.order(byteOrder);
            for (int value2 : values2) {
                buffer.putShort((short)value2);
            }
            return new ExifAttribute(3, values2.length, buffer.array());
        }

        public static ExifAttribute createUShort(int value2, ByteOrder byteOrder) {
            return ExifAttribute.createUShort(new int[]{value2}, byteOrder);
        }

        public static ExifAttribute createULong(long[] values2, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * values2.length]);
            buffer.order(byteOrder);
            for (long value2 : values2) {
                buffer.putInt((int)value2);
            }
            return new ExifAttribute(4, values2.length, buffer.array());
        }

        public static ExifAttribute createULong(long value2, ByteOrder byteOrder) {
            return ExifAttribute.createULong(new long[]{value2}, byteOrder);
        }

        public static ExifAttribute createSLong(int[] values2, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * values2.length]);
            buffer.order(byteOrder);
            for (int value2 : values2) {
                buffer.putInt(value2);
            }
            return new ExifAttribute(9, values2.length, buffer.array());
        }

        public static ExifAttribute createSLong(int value2, ByteOrder byteOrder) {
            return ExifAttribute.createSLong(new int[]{value2}, byteOrder);
        }

        public static ExifAttribute createByte(String value2) {
            if (value2.length() == 1 && value2.charAt(0) >= '0' && value2.charAt(0) <= '1') {
                byte[] bytes = new byte[]{(byte)(value2.charAt(0) - 48)};
                return new ExifAttribute(1, bytes.length, bytes);
            }
            byte[] ascii = value2.getBytes(ASCII);
            return new ExifAttribute(1, ascii.length, ascii);
        }

        public static ExifAttribute createString(String value2) {
            byte[] ascii = (value2 + '\u0000').getBytes(ASCII);
            return new ExifAttribute(2, ascii.length, ascii);
        }

        public static ExifAttribute createURational(Rational[] values2, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * values2.length]);
            buffer.order(byteOrder);
            for (Rational value2 : values2) {
                buffer.putInt((int)value2.numerator);
                buffer.putInt((int)value2.denominator);
            }
            return new ExifAttribute(5, values2.length, buffer.array());
        }

        public static ExifAttribute createURational(Rational value2, ByteOrder byteOrder) {
            return ExifAttribute.createURational(new Rational[]{value2}, byteOrder);
        }

        public static ExifAttribute createSRational(Rational[] values2, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * values2.length]);
            buffer.order(byteOrder);
            for (Rational value2 : values2) {
                buffer.putInt((int)value2.numerator);
                buffer.putInt((int)value2.denominator);
            }
            return new ExifAttribute(10, values2.length, buffer.array());
        }

        public static ExifAttribute createSRational(Rational value2, ByteOrder byteOrder) {
            return ExifAttribute.createSRational(new Rational[]{value2}, byteOrder);
        }

        public static ExifAttribute createDouble(double[] values2, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * values2.length]);
            buffer.order(byteOrder);
            for (double value2 : values2) {
                buffer.putDouble(value2);
            }
            return new ExifAttribute(12, values2.length, buffer.array());
        }

        public static ExifAttribute createDouble(double value2, ByteOrder byteOrder) {
            return ExifAttribute.createDouble(new double[]{value2}, byteOrder);
        }

        public String toString() {
            return "(" + IFD_FORMAT_NAMES[this.format] + ", data length:" + this.bytes.length + ")";
        }

        private Object getValue(ByteOrder byteOrder) {
            try {
                ByteOrderedDataInputStream inputStream = new ByteOrderedDataInputStream(this.bytes);
                inputStream.setByteOrder(byteOrder);
                switch (this.format) {
                    case 1: 
                    case 6: {
                        if (this.bytes.length == 1 && this.bytes[0] >= 0 && this.bytes[0] <= 1) {
                            return new String(new char[]{(char)(this.bytes[0] + 48)});
                        }
                        return new String(this.bytes, ASCII);
                    }
                    case 2: 
                    case 7: {
                        byte ch;
                        int index = 0;
                        if (this.numberOfComponents >= EXIF_ASCII_PREFIX.length) {
                            boolean same = true;
                            for (int i = 0; i < EXIF_ASCII_PREFIX.length; ++i) {
                                if (this.bytes[i] == EXIF_ASCII_PREFIX[i]) continue;
                                same = false;
                                break;
                            }
                            if (same) {
                                index = EXIF_ASCII_PREFIX.length;
                            }
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        while (index < this.numberOfComponents && (ch = this.bytes[index]) != 0) {
                            if (ch >= 32) {
                                stringBuilder.append((char)ch);
                            } else {
                                stringBuilder.append('?');
                            }
                            ++index;
                        }
                        return stringBuilder.toString();
                    }
                    case 3: {
                        int[] values2 = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values2[i] = inputStream.readUnsignedShort();
                        }
                        return values2;
                    }
                    case 4: {
                        long[] values3 = new long[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values3[i] = inputStream.readUnsignedInt();
                        }
                        return values3;
                    }
                    case 5: {
                        Rational[] values4 = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readUnsignedInt();
                            long denominator = inputStream.readUnsignedInt();
                            values4[i] = new Rational(numerator, denominator);
                        }
                        return values4;
                    }
                    case 8: {
                        int[] values5 = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values5[i] = inputStream.readShort();
                        }
                        return values5;
                    }
                    case 9: {
                        int[] values6 = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values6[i] = inputStream.readInt();
                        }
                        return values6;
                    }
                    case 10: {
                        Rational[] values7 = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readInt();
                            long denominator = inputStream.readInt();
                            values7[i] = new Rational(numerator, denominator);
                        }
                        return values7;
                    }
                    case 11: {
                        double[] values8 = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values8[i] = inputStream.readFloat();
                        }
                        return values8;
                    }
                    case 12: {
                        double[] values9 = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values9[i] = inputStream.readDouble();
                        }
                        return values9;
                    }
                }
                return null;
            }
            catch (IOException e) {
                Log.w(ExifInterface.TAG, "IOException occurred during reading a value", e);
                return null;
            }
        }

        public double getDoubleValue(ByteOrder byteOrder) {
            Object value2 = this.getValue(byteOrder);
            if (value2 == null) {
                throw new NumberFormatException("NULL can't be converted to a double value");
            }
            if (value2 instanceof String) {
                return Double.parseDouble((String)value2);
            }
            if (value2 instanceof long[]) {
                long[] array2 = (long[])value2;
                if (array2.length == 1) {
                    return array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value2 instanceof int[]) {
                int[] array3 = (int[])value2;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value2 instanceof double[]) {
                double[] array4 = (double[])value2;
                if (array4.length == 1) {
                    return array4[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value2 instanceof Rational[]) {
                Rational[] array5 = (Rational[])value2;
                if (array5.length == 1) {
                    return array5[0].calculate();
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a double value");
        }

        public int getIntValue(ByteOrder byteOrder) {
            Object value2 = this.getValue(byteOrder);
            if (value2 == null) {
                throw new NumberFormatException("NULL can't be converted to a integer value");
            }
            if (value2 instanceof String) {
                return Integer.parseInt((String)value2);
            }
            if (value2 instanceof long[]) {
                long[] array2 = (long[])value2;
                if (array2.length == 1) {
                    return (int)array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value2 instanceof int[]) {
                int[] array3 = (int[])value2;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a integer value");
        }

        public String getStringValue(ByteOrder byteOrder) {
            Object value2 = this.getValue(byteOrder);
            if (value2 == null) {
                return null;
            }
            if (value2 instanceof String) {
                return (String)value2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (value2 instanceof long[]) {
                long[] array2 = (long[])value2;
                for (int i = 0; i < array2.length; ++i) {
                    stringBuilder.append(array2[i]);
                    if (i + 1 == array2.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value2 instanceof int[]) {
                int[] array3 = (int[])value2;
                for (int i = 0; i < array3.length; ++i) {
                    stringBuilder.append(array3[i]);
                    if (i + 1 == array3.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value2 instanceof double[]) {
                double[] array4 = (double[])value2;
                for (int i = 0; i < array4.length; ++i) {
                    stringBuilder.append(array4[i]);
                    if (i + 1 == array4.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value2 instanceof Rational[]) {
                Rational[] array5 = (Rational[])value2;
                for (int i = 0; i < array5.length; ++i) {
                    stringBuilder.append(array5[i].numerator);
                    stringBuilder.append('/');
                    stringBuilder.append(array5[i].denominator);
                    if (i + 1 == array5.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            return null;
        }

        public int size() {
            return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
        }
    }

    private static class Rational {
        public final long numerator;
        public final long denominator;

        private Rational(long numerator, long denominator) {
            if (denominator == 0L) {
                this.numerator = 0L;
                this.denominator = 1L;
                return;
            }
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }

        public double calculate() {
            return (double)this.numerator / (double)this.denominator;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExifStreamType {
    }
}

