/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.ITranscodingClient;
import android.media.ITranscodingClientCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMediaTranscodingService
extends IInterface {
    public static final String DESCRIPTOR = "android$media$IMediaTranscodingService".replace('$', '.');
    public static final int ERROR_PERMISSION_DENIED = 1;
    public static final int ERROR_ALREADY_EXISTS = 2;
    public static final int ERROR_ILLEGAL_ARGUMENT = 3;
    public static final int ERROR_DISCONNECTED = 4;
    public static final int ERROR_TIMED_OUT = 5;
    public static final int ERROR_DISABLED = 6;
    public static final int ERROR_INVALID_OPERATION = 7;
    public static final int USE_CALLING_UID = -1;
    public static final int USE_CALLING_PID = -1;

    public ITranscodingClient registerClient(ITranscodingClientCallback var1, String var2, String var3) throws RemoteException;

    public int getNumOfClients() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaTranscodingService {
        static final int TRANSACTION_registerClient = 1;
        static final int TRANSACTION_getNumOfClients = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaTranscodingService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaTranscodingService) {
                return (IMediaTranscodingService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ITranscodingClientCallback _arg0 = ITranscodingClientCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    ITranscodingClient _result = this.registerClient(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    int _result = this.getNumOfClients();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IMediaTranscodingService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ITranscodingClient registerClient(ITranscodingClientCallback callback2, String clientName, String opPackageName) throws RemoteException {
                ITranscodingClient _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    _data.writeString(clientName);
                    _data.writeString(opPackageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ITranscodingClient.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNumOfClients() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IMediaTranscodingService {
        @Override
        public ITranscodingClient registerClient(ITranscodingClientCallback callback2, String clientName, String opPackageName) throws RemoteException {
            return null;
        }

        @Override
        public int getNumOfClients() throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

