/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.INearbyMediaDevicesUpdateCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INearbyMediaDevicesProvider
extends IInterface {
    public static final String DESCRIPTOR = "android.media.INearbyMediaDevicesProvider";

    public void registerNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback var1) throws RemoteException;

    public void unregisterNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INearbyMediaDevicesProvider {
        static final int TRANSACTION_registerNearbyDevicesCallback = 3;
        static final int TRANSACTION_unregisterNearbyDevicesCallback = 4;

        public Stub() {
            this.attachInterface(this, INearbyMediaDevicesProvider.DESCRIPTOR);
        }

        public static INearbyMediaDevicesProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INearbyMediaDevicesProvider.DESCRIPTOR);
            if (iin != null && iin instanceof INearbyMediaDevicesProvider) {
                return (INearbyMediaDevicesProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 3: {
                    return "registerNearbyDevicesCallback";
                }
                case 4: {
                    return "unregisterNearbyDevicesCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INearbyMediaDevicesProvider.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 3: {
                    INearbyMediaDevicesUpdateCallback _arg0 = INearbyMediaDevicesUpdateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerNearbyDevicesCallback(_arg0);
                    break;
                }
                case 4: {
                    INearbyMediaDevicesUpdateCallback _arg0 = INearbyMediaDevicesUpdateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterNearbyDevicesCallback(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements INearbyMediaDevicesProvider {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INearbyMediaDevicesProvider.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyMediaDevicesProvider.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyMediaDevicesProvider.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INearbyMediaDevicesProvider {
        @Override
        public void registerNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback callback2) throws RemoteException {
        }

        @Override
        public void unregisterNearbyDevicesCallback(INearbyMediaDevicesUpdateCallback callback2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

