/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SuppressLint;
import android.graphics.GraphicBuffer;
import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.hardware.SyncFence;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageUtils;
import android.media.PublicFormatUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.Size;
import android.view.Surface;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.NioUtils_Delegate;
import dalvik.system.VMRuntime;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ImageWriter
implements AutoCloseable {
    private final Object mListenerLock = new Object();
    private OnImageReleasedListener mListener;
    private ListenerHandler mListenerHandler;
    private long mNativeContext;
    private int mWidth;
    private int mHeight;
    private final int mMaxImages;
    private long mUsage = 48L;
    private int mHardwareBufferFormat;
    private int mDataSpace;
    private int mWriterFormat;
    private List<Image> mDequeuedImages = new CopyOnWriteArrayList<Image>();
    private int mEstimatedNativeAllocBytes;

    public static ImageWriter newInstance(Surface surface2, int maxImages) {
        return new ImageWriter(surface2, maxImages, true, 0, -1, -1);
    }

    public static ImageWriter newInstance(Surface surface2, int maxImages, int format, int width2, int height2) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException("Invalid format is specified: " + format);
        }
        return new ImageWriter(surface2, maxImages, false, format, width2, height2);
    }

    public static ImageWriter newInstance(Surface surface2, int maxImages, int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException("Invalid format is specified: " + format);
        }
        return new ImageWriter(surface2, maxImages, false, format, -1, -1);
    }

    private void initializeImageWriter(Surface surface2, int maxImages, boolean useSurfaceImageFormatInfo, boolean useLegacyImageFormat, int imageFormat, int hardwareBufferFormat, int dataSpace, int width2, int height2, long usage) {
        if (surface2 == null || maxImages < 1) {
            throw new IllegalArgumentException("Illegal input argument: surface " + surface2 + ", maxImages: " + maxImages);
        }
        this.mNativeContext = this.nativeInit(new WeakReference<ImageWriter>(this), surface2, maxImages, width2, height2, useSurfaceImageFormatInfo, hardwareBufferFormat, dataSpace, usage);
        if (useSurfaceImageFormatInfo) {
            imageFormat = SurfaceUtils.getSurfaceFormat(surface2);
            this.mHardwareBufferFormat = PublicFormatUtils.getHalFormat(imageFormat);
            this.mDataSpace = PublicFormatUtils.getHalDataspace(imageFormat);
        }
        if (imageFormat == 33) {
            int surfaceDataspace = SurfaceUtils.getSurfaceDataspace(surface2);
            switch (surfaceDataspace) {
                case 4096: {
                    imageFormat = 257;
                    break;
                }
                case 4098: {
                    imageFormat = 1768253795;
                    break;
                }
                case 4099: {
                    imageFormat = 1212500294;
                    break;
                }
                default: {
                    imageFormat = 256;
                }
            }
            this.mHardwareBufferFormat = PublicFormatUtils.getHalFormat(imageFormat);
            this.mDataSpace = PublicFormatUtils.getHalDataspace(imageFormat);
        }
        Size surfSize = SurfaceUtils.getSurfaceSize(surface2);
        this.mWidth = width2 == -1 ? surfSize.getWidth() : width2;
        this.mHeight = height2 == -1 ? surfSize.getHeight() : height2;
        this.mEstimatedNativeAllocBytes = ImageUtils.getEstimatedNativeAllocBytes(this.mWidth, this.mHeight, useLegacyImageFormat ? imageFormat : hardwareBufferFormat, 1);
        VMRuntime.getRuntime().registerNativeAllocation(this.mEstimatedNativeAllocBytes);
    }

    private ImageWriter(Surface surface2, int maxImages, boolean useSurfaceImageFormatInfo, int imageFormat, int width2, int height2) {
        this.mMaxImages = maxImages;
        this.mHardwareBufferFormat = PublicFormatUtils.getHalFormat(imageFormat);
        this.mDataSpace = PublicFormatUtils.getHalDataspace(imageFormat);
        this.initializeImageWriter(surface2, maxImages, useSurfaceImageFormatInfo, true, imageFormat, this.mHardwareBufferFormat, this.mDataSpace, width2, height2, this.mUsage);
    }

    private ImageWriter(Surface surface2, int maxImages, boolean useSurfaceImageFormatInfo, int imageFormat, int width2, int height2, long usage) {
        this.mMaxImages = maxImages;
        this.mUsage = usage;
        this.mHardwareBufferFormat = PublicFormatUtils.getHalFormat(imageFormat);
        this.mDataSpace = PublicFormatUtils.getHalDataspace(imageFormat);
        this.initializeImageWriter(surface2, maxImages, useSurfaceImageFormatInfo, true, imageFormat, this.mHardwareBufferFormat, this.mDataSpace, width2, height2, usage);
    }

    private ImageWriter(Surface surface2, int maxImages, boolean useSurfaceImageFormatInfo, int hardwareBufferFormat, int dataSpace, int width2, int height2, long usage) {
        int imageFormat;
        this.mMaxImages = maxImages;
        this.mUsage = usage;
        if (useSurfaceImageFormatInfo) {
            imageFormat = 0;
            this.mHardwareBufferFormat = PublicFormatUtils.getHalFormat(imageFormat);
            this.mDataSpace = PublicFormatUtils.getHalDataspace(imageFormat);
        } else {
            imageFormat = PublicFormatUtils.getPublicFormat(hardwareBufferFormat, dataSpace);
            this.mHardwareBufferFormat = hardwareBufferFormat;
            this.mDataSpace = dataSpace;
        }
        this.initializeImageWriter(surface2, maxImages, useSurfaceImageFormatInfo, false, imageFormat, hardwareBufferFormat, dataSpace, width2, height2, usage);
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Image dequeueInputImage() {
        if (this.mDequeuedImages.size() >= this.mMaxImages) {
            throw new IllegalStateException("Already dequeued max number of Images " + this.mMaxImages);
        }
        WriterSurfaceImage newImage = new WriterSurfaceImage(this);
        this.nativeDequeueInputImage(this.mNativeContext, newImage);
        this.mDequeuedImages.add(newImage);
        newImage.mIsImageValid = true;
        return newImage;
    }

    public void queueInputImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        boolean ownedByMe = this.isImageOwnedByMe(image);
        if (ownedByMe && !((WriterSurfaceImage)image).mIsImageValid) {
            throw new IllegalStateException("Image from ImageWriter is invalid");
        }
        if (!ownedByMe) {
            if (image.getOwner() instanceof ImageReader) {
                ImageReader prevOwner = (ImageReader)image.getOwner();
                prevOwner.detachImage(image);
            } else if (image.getOwner() != null) {
                throw new IllegalArgumentException("Only images from ImageReader can be queued to ImageWriter, other image source is not supported yet!");
            }
            this.attachAndQueueInputImage(image);
            image.close();
            return;
        }
        Rect crop = image.getCropRect();
        this.nativeQueueInputImage(this.mNativeContext, image, image.getTimestamp(), image.getDataSpace(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
        if (ownedByMe) {
            this.mDequeuedImages.remove(image);
            WriterSurfaceImage wi = (WriterSurfaceImage)image;
            wi.clearSurfacePlanes();
            wi.mIsImageValid = false;
        }
    }

    public int getFormat() {
        return this.mWriterFormat;
    }

    public long getUsage() {
        return this.mUsage;
    }

    public int getHardwareBufferFormat() {
        return this.mHardwareBufferFormat;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public int getDataSpace() {
        return this.mDataSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageReleasedListener(OnImageReleasedListener listener2, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener2 != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(looper);
                }
                this.mListener = listener2;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    @Override
    public void close() {
        this.setOnImageReleasedListener(null, null);
        for (Image image : this.mDequeuedImages) {
            image.close();
        }
        this.mDequeuedImages.clear();
        this.nativeClose(this.mNativeContext);
        this.mNativeContext = 0L;
        if (this.mEstimatedNativeAllocBytes > 0) {
            VMRuntime.getRuntime().registerNativeFree(this.mEstimatedNativeAllocBytes);
            this.mEstimatedNativeAllocBytes = 0;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void attachAndQueueInputImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        if (this.isImageOwnedByMe(image)) {
            throw new IllegalArgumentException("Can not attach an image that is owned ImageWriter already");
        }
        if (!image.isAttachable()) {
            throw new IllegalStateException("Image was not detached from last owner, or image  is not detachable");
        }
        Rect crop = image.getCropRect();
        if (image.getNativeContext() != 0L) {
            this.nativeAttachAndQueueImage(this.mNativeContext, image.getNativeContext(), image.getFormat(), image.getTimestamp(), image.getDataSpace(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
        } else {
            GraphicBuffer gb = GraphicBuffer.createFromHardwareBuffer(image.getHardwareBuffer());
            this.nativeAttachAndQueueGraphicBuffer(this.mNativeContext, gb, image.getFormat(), image.getTimestamp(), image.getDataSpace(), crop.left, crop.top, crop.right, crop.bottom, image.getTransform(), image.getScalingMode());
            gb.destroy();
            image.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageWriter iw = (ImageWriter)weakSelf.get();
        if (iw == null) {
            return;
        }
        Object object = iw.mListenerLock;
        synchronized (object) {
            handler = iw.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private void abortImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image shouldn't be null");
        }
        if (!this.mDequeuedImages.contains(image)) {
            throw new IllegalStateException("It is illegal to abort some image that is not dequeued yet");
        }
        WriterSurfaceImage wi = (WriterSurfaceImage)image;
        if (!wi.mIsImageValid) {
            return;
        }
        this.cancelImage(this.mNativeContext, image);
        this.mDequeuedImages.remove(image);
        wi.clearSurfacePlanes();
        wi.mIsImageValid = false;
    }

    private boolean isImageOwnedByMe(Image image) {
        if (!(image instanceof WriterSurfaceImage)) {
            return false;
        }
        WriterSurfaceImage wi = (WriterSurfaceImage)image;
        return wi.getOwner() == this;
    }

    private synchronized long nativeInit(Object object, Surface surface2, int n, int n2, int n3, boolean bl, int n4, int n5, long l) {
        return OverrideMethod.invokeL("android.media.ImageWriter#nativeInit(Ljava/lang/Object;Landroid/view/Surface;IIIZIIJ)J", true, this);
    }

    private synchronized void nativeClose(long l) {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeClose(J)V", true, this);
    }

    private synchronized void nativeDequeueInputImage(long l, Image image) {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeDequeueInputImage(JLandroid/media/Image;)V", true, this);
    }

    private synchronized void nativeQueueInputImage(long l, Image image, long l2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeQueueInputImage(JLandroid/media/Image;JIIIIIII)V", true, this);
    }

    private synchronized int nativeAttachAndQueueImage(long l, long l2, int n, long l3, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return OverrideMethod.invokeI("android.media.ImageWriter#nativeAttachAndQueueImage(JJIJIIIIIII)I", true, this);
    }

    private synchronized int nativeAttachAndQueueGraphicBuffer(long l, GraphicBuffer graphicBuffer, int n, long l2, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return OverrideMethod.invokeI("android.media.ImageWriter#nativeAttachAndQueueGraphicBuffer(JLandroid/graphics/GraphicBuffer;IJIIIIIII)I", true, this);
    }

    private synchronized void cancelImage(long l, Image image) {
        OverrideMethod.invokeV("android.media.ImageWriter#cancelImage(JLandroid/media/Image;)V", true, this);
    }

    private static void nativeClassInit() {
        OverrideMethod.invokeV("android.media.ImageWriter#nativeClassInit()V", true, null);
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        ImageWriter.nativeClassInit();
    }

    private static class WriterSurfaceImage
    extends Image {
        private ImageWriter mOwner;
        private long mNativeBuffer;
        private int mNativeFenceFd = -1;
        private SurfacePlane[] mPlanes;
        private int mHeight = -1;
        private int mWidth = -1;
        private int mFormat = -1;
        private int mDataSpace = 0;
        private final long DEFAULT_TIMESTAMP = Long.MIN_VALUE;
        private long mTimestamp = Long.MIN_VALUE;
        private int mTransform = 0;
        private int mScalingMode = 0;

        public WriterSurfaceImage(ImageWriter writer) {
            this.mOwner = writer;
            this.mWidth = writer.mWidth;
            this.mHeight = writer.mHeight;
            this.mDataSpace = writer.mDataSpace;
        }

        @Override
        public int getDataSpace() {
            this.throwISEIfImageIsInvalid();
            return this.mDataSpace;
        }

        @Override
        public void setDataSpace(int dataSpace) {
            this.throwISEIfImageIsInvalid();
            this.mDataSpace = dataSpace;
        }

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            if (this.mFormat == -1) {
                this.mFormat = this.nativeGetFormat(this.mDataSpace);
            }
            return this.mFormat;
        }

        @Override
        public int getWidth() {
            this.throwISEIfImageIsInvalid();
            if (this.mWidth == -1) {
                this.mWidth = this.nativeGetWidth();
            }
            return this.mWidth;
        }

        @Override
        public int getHeight() {
            this.throwISEIfImageIsInvalid();
            if (this.mHeight == -1) {
                this.mHeight = this.nativeGetHeight();
            }
            return this.mHeight;
        }

        @Override
        public int getTransform() {
            this.throwISEIfImageIsInvalid();
            return this.mTransform;
        }

        @Override
        public int getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return this.mScalingMode;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        public void setTimestamp(long timestamp) {
            this.throwISEIfImageIsInvalid();
            this.mTimestamp = timestamp;
        }

        @Override
        public HardwareBuffer getHardwareBuffer() {
            this.throwISEIfImageIsInvalid();
            return this.nativeGetHardwareBuffer();
        }

        @Override
        public SyncFence getFence() throws IOException {
            this.throwISEIfImageIsInvalid();
            if (this.mNativeFenceFd != -1) {
                return SyncFence.create(ParcelFileDescriptor.fromFd(this.mNativeFenceFd));
            }
            return SyncFence.createEmpty();
        }

        @Override
        public void setFence(SyncFence fence) throws IOException {
            this.throwISEIfImageIsInvalid();
            this.nativeSetFenceFd(fence.getFdDup().detachFd());
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            if (this.mPlanes == null) {
                int numPlanes = ImageUtils.getNumPlanesForFormat(this.getFormat());
                this.mPlanes = this.nativeCreatePlanes(numPlanes, this.getOwner().getFormat(), this.getOwner().getDataSpace());
            }
            return (Image.Plane[])this.mPlanes.clone();
        }

        @Override
        public boolean isAttachable() {
            this.throwISEIfImageIsInvalid();
            return false;
        }

        @Override
        ImageWriter getOwner() {
            this.throwISEIfImageIsInvalid();
            return this.mOwner;
        }

        @Override
        long getNativeContext() {
            this.throwISEIfImageIsInvalid();
            return this.mNativeBuffer;
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                this.getOwner().abortImage(this);
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void clearSurfacePlanes() {
            if (this.mIsImageValid && this.mPlanes != null) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private synchronized SurfacePlane[] nativeCreatePlanes(int n, int n2, int n3) {
            return (SurfacePlane[])OverrideMethod.invokeA("android.media.ImageWriter$WriterSurfaceImage#nativeCreatePlanes(III)[Landroid/media/ImageWriter$WriterSurfaceImage$SurfacePlane;", true, this);
        }

        private synchronized int nativeGetWidth() {
            return OverrideMethod.invokeI("android.media.ImageWriter$WriterSurfaceImage#nativeGetWidth()I", true, this);
        }

        private synchronized int nativeGetHeight() {
            return OverrideMethod.invokeI("android.media.ImageWriter$WriterSurfaceImage#nativeGetHeight()I", true, this);
        }

        private synchronized int nativeGetFormat(int n) {
            return OverrideMethod.invokeI("android.media.ImageWriter$WriterSurfaceImage#nativeGetFormat(I)I", true, this);
        }

        private synchronized HardwareBuffer nativeGetHardwareBuffer() {
            return (HardwareBuffer)OverrideMethod.invokeA("android.media.ImageWriter$WriterSurfaceImage#nativeGetHardwareBuffer()Landroid/hardware/HardwareBuffer;", true, this);
        }

        private synchronized void nativeSetFenceFd(int n) {
            OverrideMethod.invokeV("android.media.ImageWriter$WriterSurfaceImage#nativeSetFenceFd(I)V", true, this);
        }

        private class SurfacePlane
        extends Image.Plane {
            private ByteBuffer mBuffer;
            private final int mPixelStride;
            private final int mRowStride;

            private SurfacePlane(int rowStride, int pixelStride, ByteBuffer buffer) {
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
                this.mBuffer = buffer;
                this.mBuffer.order(ByteOrder.nativeOrder());
            }

            @Override
            public int getRowStride() {
                WriterSurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mRowStride;
            }

            @Override
            public int getPixelStride() {
                WriterSurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mPixelStride;
            }

            @Override
            public ByteBuffer getBuffer() {
                WriterSurfaceImage.this.throwISEIfImageIsInvalid();
                return this.mBuffer;
            }

            private void clearBuffer() {
                if (this.mBuffer == null) {
                    return;
                }
                if (this.mBuffer.isDirect()) {
                    NioUtils_Delegate.freeDirectBuffer(this.mBuffer);
                }
                this.mBuffer = null;
            }
        }
    }

    public static class Builder {
        private Surface mSurface;
        private int mWidth = -1;
        private int mHeight = -1;
        private int mMaxImages = 1;
        private int mImageFormat = 0;
        private long mUsage = -1L;
        private int mHardwareBufferFormat = 1;
        private int mDataSpace = 0;
        private boolean mUseSurfaceImageFormatInfo = true;
        private boolean mUseLegacyImageFormat = false;

        public Builder(Surface surface2) {
            this.mSurface = surface2;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setWidthAndHeight(int width2, int height2) {
            this.mWidth = width2;
            this.mHeight = height2;
            return this;
        }

        public Builder setMaxImages(int maxImages) {
            this.mMaxImages = maxImages;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setImageFormat(int imageFormat) {
            if (!ImageFormat.isPublicFormat(imageFormat) && !PixelFormat.isPublicFormat(imageFormat)) {
                throw new IllegalArgumentException("Invalid imageFormat is specified: " + imageFormat);
            }
            this.mImageFormat = imageFormat;
            this.mUseLegacyImageFormat = true;
            this.mHardwareBufferFormat = 1;
            this.mDataSpace = 0;
            this.mUseSurfaceImageFormatInfo = false;
            return this;
        }

        public Builder setHardwareBufferFormat(int hardwareBufferFormat) {
            this.mHardwareBufferFormat = hardwareBufferFormat;
            this.mImageFormat = 0;
            this.mUseLegacyImageFormat = false;
            this.mUseSurfaceImageFormatInfo = false;
            return this;
        }

        public Builder setDataSpace(int dataSpace) {
            this.mDataSpace = dataSpace;
            this.mImageFormat = 0;
            this.mUseLegacyImageFormat = false;
            this.mUseSurfaceImageFormatInfo = false;
            return this;
        }

        public Builder setUsage(long usage) {
            this.mUsage = usage;
            return this;
        }

        public ImageWriter build() {
            if (this.mUseLegacyImageFormat) {
                return new ImageWriter(this.mSurface, this.mMaxImages, this.mUseSurfaceImageFormatInfo, this.mImageFormat, this.mWidth, this.mHeight, this.mUsage);
            }
            return new ImageWriter(this.mSurface, this.mMaxImages, this.mUseSurfaceImageFormatInfo, this.mHardwareBufferFormat, this.mDataSpace, this.mWidth, this.mHeight, this.mUsage);
        }
    }

    private class ListenerHandler
    extends Handler {
        public ListenerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            OnImageReleasedListener listener2;
            Object object = ImageWriter.this.mListenerLock;
            synchronized (object) {
                listener2 = ImageWriter.this.mListener;
            }
            if (listener2 != null) {
                listener2.onImageReleased(ImageWriter.this);
            }
        }
    }

    public static interface OnImageReleasedListener {
        public void onImageReleased(ImageWriter var1);
    }
}

