/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.hardware.cas.V1_0.HidlCasPluginDescriptor;
import android.hardware.cas.V1_0.ICas;
import android.hardware.cas.V1_2.ICas;
import android.hardware.cas.V1_2.ICasListener;
import android.hardware.cas.V1_2.IMediaCasService;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.media.tv.tunerresourcemanager.CasSessionRequest;
import android.media.tv.tunerresourcemanager.ResourceClientProfile;
import android.media.tv.tunerresourcemanager.TunerResourceManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.util.Singleton;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MediaCas
implements AutoCloseable {
    private static final String TAG = "MediaCas";
    private ICas mICas;
    private android.hardware.cas.V1_1.ICas mICasV11;
    private android.hardware.cas.V1_2.ICas mICasV12;
    private EventListener mListener;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private int mPriorityHint;
    private String mTvInputServiceSessionId;
    private int mClientId;
    private int mCasSystemId;
    private int mUserId;
    private TunerResourceManager mTunerResourceManager = null;
    private final Map<Session, Integer> mSessionMap = new HashMap<Session, Integer>();
    public static final int SCRAMBLING_MODE_RESERVED = 0;
    public static final int SCRAMBLING_MODE_DVB_CSA1 = 1;
    public static final int SCRAMBLING_MODE_DVB_CSA2 = 2;
    public static final int SCRAMBLING_MODE_DVB_CSA3_STANDARD = 3;
    public static final int SCRAMBLING_MODE_DVB_CSA3_MINIMAL = 4;
    public static final int SCRAMBLING_MODE_DVB_CSA3_ENHANCE = 5;
    public static final int SCRAMBLING_MODE_DVB_CISSA_V1 = 6;
    public static final int SCRAMBLING_MODE_DVB_IDSA = 7;
    public static final int SCRAMBLING_MODE_MULTI2 = 8;
    public static final int SCRAMBLING_MODE_AES128 = 9;
    public static final int SCRAMBLING_MODE_AES_ECB = 10;
    public static final int SCRAMBLING_MODE_AES_SCTE52 = 11;
    public static final int SCRAMBLING_MODE_TDES_ECB = 12;
    public static final int SCRAMBLING_MODE_TDES_SCTE52 = 13;
    public static final int SESSION_USAGE_LIVE = 0;
    public static final int SESSION_USAGE_PLAYBACK = 1;
    public static final int SESSION_USAGE_RECORD = 2;
    public static final int SESSION_USAGE_TIMESHIFT = 3;
    public static final int PLUGIN_STATUS_PHYSICAL_MODULE_CHANGED = 0;
    public static final int PLUGIN_STATUS_SESSION_NUMBER_CHANGED = 1;
    private static final Singleton<android.hardware.cas.V1_0.IMediaCasService> sService = new Singleton<android.hardware.cas.V1_0.IMediaCasService>(){

        @Override
        protected android.hardware.cas.V1_0.IMediaCasService create() {
            try {
                Log.d(MediaCas.TAG, "Trying to get cas@1.2 service");
                IMediaCasService serviceV12 = IMediaCasService.getService(true);
                if (serviceV12 != null) {
                    return serviceV12;
                }
            }
            catch (Exception eV1_2) {
                Log.d(MediaCas.TAG, "Failed to get cas@1.2 service");
            }
            try {
                Log.d(MediaCas.TAG, "Trying to get cas@1.1 service");
                android.hardware.cas.V1_1.IMediaCasService serviceV11 = android.hardware.cas.V1_1.IMediaCasService.getService(true);
                if (serviceV11 != null) {
                    return serviceV11;
                }
            }
            catch (Exception eV1_1) {
                Log.d(MediaCas.TAG, "Failed to get cas@1.1 service");
            }
            try {
                Log.d(MediaCas.TAG, "Trying to get cas@1.0 service");
                return android.hardware.cas.V1_0.IMediaCasService.getService(true);
            }
            catch (Exception eV1_0) {
                Log.d(MediaCas.TAG, "Failed to get cas@1.0 service");
                return null;
            }
        }
    };
    private final ICasListener.Stub mBinder = new ICasListener.Stub(){

        @Override
        public void onEvent(int event, int arg, ArrayList<Byte> data) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(0, event, arg, data));
            }
        }

        @Override
        public void onSessionEvent(ArrayList<Byte> sessionId, int event, int arg, ArrayList<Byte> data) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                Message msg = MediaCas.this.mEventHandler.obtainMessage();
                msg.what = 1;
                msg.arg1 = event;
                msg.arg2 = arg;
                Bundle bundle = new Bundle();
                bundle.putByteArray("sessionId", MediaCas.this.toBytes(sessionId));
                bundle.putByteArray("data", MediaCas.this.toBytes(data));
                msg.setData(bundle);
                MediaCas.this.mEventHandler.sendMessage(msg);
            }
        }

        @Override
        public void onStatusUpdate(byte status, int arg) throws RemoteException {
            if (MediaCas.this.mEventHandler != null) {
                MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(2, status, arg));
            }
        }
    };
    private final TunerResourceManager.ResourcesReclaimListener mResourceListener = new TunerResourceManager.ResourcesReclaimListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReclaimResources() {
            Map<Session, Integer> map2 = MediaCas.this.mSessionMap;
            synchronized (map2) {
                ArrayList<Session> sessionList = new ArrayList<Session>(MediaCas.this.mSessionMap.keySet());
                for (Session casSession : sessionList) {
                    casSession.close();
                }
            }
            MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(3));
        }
    };

    static android.hardware.cas.V1_0.IMediaCasService getService() {
        return sService.get();
    }

    private void validateInternalStates() {
        if (this.mICas == null) {
            throw new IllegalStateException();
        }
    }

    private void cleanupAndRethrowIllegalState() {
        this.mICas = null;
        this.mICasV11 = null;
        this.mICasV12 = null;
        throw new IllegalStateException();
    }

    private ArrayList<Byte> toByteArray(byte[] data, int offset2, int length) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>(length);
        for (int i = 0; i < length; ++i) {
            byteArray.add(data[offset2 + i]);
        }
        return byteArray;
    }

    private ArrayList<Byte> toByteArray(byte[] data) {
        if (data == null) {
            return new ArrayList<Byte>();
        }
        return this.toByteArray(data, 0, data.length);
    }

    private byte[] toBytes(ArrayList<Byte> byteArray) {
        byte[] data = null;
        if (byteArray != null) {
            data = new byte[byteArray.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = byteArray.get(i);
            }
        }
        return data;
    }

    Session createFromSessionId(ArrayList<Byte> sessionId) {
        if (sessionId == null || sessionId.size() == 0) {
            return null;
        }
        return new Session(sessionId);
    }

    public static boolean isSystemIdSupported(int CA_system_id) {
        android.hardware.cas.V1_0.IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                return service.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public static PluginDescriptor[] enumeratePlugins() {
        android.hardware.cas.V1_0.IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                ArrayList<HidlCasPluginDescriptor> descriptors = service.enumeratePlugins();
                if (descriptors.size() == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.size()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = new PluginDescriptor(descriptors.get(i));
                }
                return results;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlugin(int casSystemId) throws MediaCasException.UnsupportedCasException {
        block9: {
            try {
                this.mCasSystemId = casSystemId;
                this.mUserId = Process.myUid();
                android.hardware.cas.V1_0.IMediaCasService service = MediaCas.getService();
                IMediaCasService serviceV12 = IMediaCasService.castFrom(service);
                if (serviceV12 == null) {
                    android.hardware.cas.V1_1.IMediaCasService serviceV11 = android.hardware.cas.V1_1.IMediaCasService.castFrom(service);
                    if (serviceV11 == null) {
                        Log.d(TAG, "Used cas@1_0 interface to create plugin");
                        this.mICas = service.createPlugin(casSystemId, this.mBinder);
                    } else {
                        Log.d(TAG, "Used cas@1.1 interface to create plugin");
                        this.mICasV11 = serviceV11.createPluginExt(casSystemId, this.mBinder);
                        this.mICas = this.mICasV11;
                    }
                } else {
                    Log.d(TAG, "Used cas@1.2 interface to create plugin");
                    this.mICasV12 = android.hardware.cas.V1_2.ICas.castFrom(serviceV12.createPluginExt(casSystemId, this.mBinder));
                    this.mICasV11 = this.mICasV12;
                    this.mICas = this.mICasV12;
                }
            }
            catch (Exception e) {
                Log.e(TAG, "Failed to create plugin: " + e);
                this.mICas = null;
            }
            finally {
                if (this.mICas != null) break block9;
                throw new MediaCasException.UnsupportedCasException("Unsupported casSystemId " + casSystemId);
            }
        }
    }

    private void registerClient(Context context, String tvInputServiceSessionId, int priorityHint) {
        this.mTunerResourceManager = (TunerResourceManager)context.getSystemService("tv_tuner_resource_mgr");
        if (this.mTunerResourceManager != null) {
            int[] clientId = new int[1];
            ResourceClientProfile profile = new ResourceClientProfile();
            profile.tvInputSessionId = tvInputServiceSessionId;
            profile.useCase = priorityHint;
            this.mTunerResourceManager.registerClientProfile(profile, context.getMainExecutor(), this.mResourceListener, clientId);
            this.mClientId = clientId[0];
        }
    }

    public MediaCas(int casSystemId) throws MediaCasException.UnsupportedCasException {
        this.createPlugin(casSystemId);
    }

    public MediaCas(Context context, int casSystemId, String tvInputServiceSessionId, int priorityHint) throws MediaCasException.UnsupportedCasException {
        Objects.requireNonNull(context, "context must not be null");
        this.createPlugin(casSystemId);
        this.registerClient(context, tvInputServiceSessionId, priorityHint);
    }

    public MediaCas(Context context, int casSystemId, String tvInputServiceSessionId, int priorityHint, Handler handler, EventListener listener2) throws MediaCasException.UnsupportedCasException {
        Objects.requireNonNull(context, "context must not be null");
        this.setEventListener(listener2, handler);
        this.createPlugin(casSystemId);
        this.registerClient(context, tvInputServiceSessionId, priorityHint);
    }

    IHwBinder getBinder() {
        this.validateInternalStates();
        return this.mICas.asBinder();
    }

    public void setEventListener(EventListener listener2, Handler handler) {
        Looper looper;
        this.mListener = listener2;
        if (this.mListener == null) {
            this.mEventHandler = null;
            return;
        }
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null && (looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
                this.mHandlerThread = new HandlerThread("MediaCasEventThread", -2);
                this.mHandlerThread.start();
            }
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(looper);
    }

    public void setPrivateData(byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.setPrivateData(this.toByteArray(data, 0, data.length)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    private int getSessionResourceHandle() throws MediaCasException {
        this.validateInternalStates();
        int[] sessionResourceHandle = new int[]{-1};
        if (this.mTunerResourceManager != null) {
            CasSessionRequest casSessionRequest = new CasSessionRequest();
            casSessionRequest.clientId = this.mClientId;
            casSessionRequest.casSystemId = this.mCasSystemId;
            if (!this.mTunerResourceManager.requestCasSession(casSessionRequest, sessionResourceHandle)) {
                throw new MediaCasException.InsufficientResourceException("insufficient resource to Open Session");
            }
        }
        return sessionResourceHandle[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSessionToResourceMap(Session session, int sessionResourceHandle) {
        if (sessionResourceHandle != -1) {
            Map<Session, Integer> map2 = this.mSessionMap;
            synchronized (map2) {
                this.mSessionMap.put(session, sessionResourceHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionFromResourceMap(Session session) {
        Map<Session, Integer> map2 = this.mSessionMap;
        synchronized (map2) {
            if (this.mSessionMap.get(session) != null) {
                this.mTunerResourceManager.releaseCasSession(this.mSessionMap.get(session), this.mClientId);
                this.mSessionMap.remove(session);
            }
        }
    }

    public Session openSession() throws MediaCasException {
        int sessionResourceHandle = this.getSessionResourceHandle();
        try {
            OpenSessionCallback cb = new OpenSessionCallback();
            this.mICas.openSession(cb);
            MediaCasException.throwExceptionIfNeeded(cb.mStatus);
            this.addSessionToResourceMap(cb.mSession, sessionResourceHandle);
            Log.d(TAG, "Write Stats Log for succeed to Open Session.");
            FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 1);
            return cb.mSession;
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            Log.d(TAG, "Write Stats Log for fail to Open Session.");
            FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 2);
            return null;
        }
    }

    public Session openSession(int sessionUsage, int scramblingMode) throws MediaCasException {
        int sessionResourceHandle = this.getSessionResourceHandle();
        if (this.mICasV12 == null) {
            Log.d(TAG, "Open Session with scrambling mode is only supported by cas@1.2+ interface");
            throw new MediaCasException.UnsupportedCasException("Open Session with scrambling mode is not supported");
        }
        try {
            OpenSession_1_2_Callback cb = new OpenSession_1_2_Callback();
            this.mICasV12.openSession_1_2(sessionUsage, scramblingMode, cb);
            MediaCasException.throwExceptionIfNeeded(cb.mStatus);
            this.addSessionToResourceMap(cb.mSession, sessionResourceHandle);
            Log.d(TAG, "Write Stats Log for succeed to Open Session.");
            FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 1);
            return cb.mSession;
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            Log.d(TAG, "Write Stats Log for fail to Open Session.");
            FrameworkStatsLog.write(280, this.mUserId, this.mCasSystemId, 2);
            return null;
        }
    }

    public void processEmm(byte[] data, int offset2, int length) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.processEmm(this.toByteArray(data, offset2, length)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void processEmm(byte[] data) throws MediaCasException {
        this.processEmm(data, 0, data.length);
    }

    public void sendEvent(int event, int arg, byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.sendEvent(event, arg, this.toByteArray(data)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void provision(String provisionString) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.provision(provisionString));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void refreshEntitlements(int refreshType, byte[] refreshData) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.refreshEntitlements(refreshType, this.toByteArray(refreshData)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void forceResourceLost() {
        if (this.mResourceListener != null) {
            this.mResourceListener.onReclaimResources();
        }
    }

    @Override
    public void close() {
        if (this.mICas != null) {
            try {
                this.mICas.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICas = null;
            }
        }
        if (this.mTunerResourceManager != null) {
            this.mTunerResourceManager.unregisterClientProfile(this.mClientId);
            this.mTunerResourceManager = null;
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    private class OpenSession_1_2_Callback
    implements ICas.openSession_1_2Callback {
        public Session mSession;
        public int mStatus;

        private OpenSession_1_2_Callback() {
        }

        @Override
        public void onValues(int status, ArrayList<Byte> sessionId) {
            this.mStatus = status;
            this.mSession = MediaCas.this.createFromSessionId(sessionId);
        }
    }

    private class OpenSessionCallback
    implements ICas.openSessionCallback {
        public Session mSession;
        public int mStatus;

        private OpenSessionCallback() {
        }

        @Override
        public void onValues(int status, ArrayList<Byte> sessionId) {
            this.mStatus = status;
            this.mSession = MediaCas.this.createFromSessionId(sessionId);
        }
    }

    public static interface EventListener {
        public void onEvent(MediaCas var1, int var2, int var3, byte[] var4);

        default public void onSessionEvent(MediaCas mediaCas, Session session, int event, int arg, byte[] data) {
            Log.d(MediaCas.TAG, "Received MediaCas Session event");
        }

        default public void onPluginStatusUpdate(MediaCas mediaCas, int status, int arg) {
            Log.d(MediaCas.TAG, "Received MediaCas Plugin Status event");
        }

        default public void onResourceLost(MediaCas mediaCas) {
            Log.d(MediaCas.TAG, "Received MediaCas Resource Reclaim event");
        }
    }

    public class Session
    implements AutoCloseable {
        final ArrayList<Byte> mSessionId;
        boolean mIsClosed = false;

        Session(ArrayList<Byte> sessionId) {
            this.mSessionId = new ArrayList<Byte>(sessionId);
        }

        private void validateSessionInternalStates() {
            if (MediaCas.this.mICas == null) {
                throw new IllegalStateException();
            }
            if (this.mIsClosed) {
                MediaCasStateException.throwExceptionIfNeeded(3);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Session) {
                return this.mSessionId.equals(((Session)obj).mSessionId);
            }
            return false;
        }

        public void setPrivateData(byte[] data) throws MediaCasException {
            this.validateSessionInternalStates();
            try {
                MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICas.setSessionPrivateData(this.mSessionId, MediaCas.this.toByteArray(data, 0, data.length)));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(byte[] data, int offset2, int length) throws MediaCasException {
            this.validateSessionInternalStates();
            try {
                MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICas.processEcm(this.mSessionId, MediaCas.this.toByteArray(data, offset2, length)));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(byte[] data) throws MediaCasException {
            this.processEcm(data, 0, data.length);
        }

        public void sendSessionEvent(int event, int arg, byte[] data) throws MediaCasException {
            this.validateSessionInternalStates();
            if (MediaCas.this.mICasV11 == null) {
                Log.d(MediaCas.TAG, "Send Session Event isn't supported by cas@1.0 interface");
                throw new MediaCasException.UnsupportedCasException("Send Session Event is not supported");
            }
            try {
                MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICasV11.sendSessionEvent(this.mSessionId, event, arg, MediaCas.this.toByteArray(data)));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public byte[] getSessionId() {
            this.validateSessionInternalStates();
            return MediaCas.this.toBytes(this.mSessionId);
        }

        @Override
        public void close() {
            this.validateSessionInternalStates();
            try {
                MediaCasStateException.throwExceptionIfNeeded(MediaCas.this.mICas.closeSession(this.mSessionId));
                this.mIsClosed = true;
                MediaCas.this.removeSessionFromResourceMap(this);
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }
    }

    public static class PluginDescriptor {
        private final int mCASystemId;
        private final String mName;

        private PluginDescriptor() {
            this.mCASystemId = 65535;
            this.mName = null;
        }

        PluginDescriptor(HidlCasPluginDescriptor descriptor) {
            this.mCASystemId = descriptor.caSystemId;
            this.mName = descriptor.name;
        }

        public int getSystemId() {
            return this.mCASystemId;
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "PluginDescriptor {" + this.mCASystemId + ", " + this.mName + "}";
        }
    }

    private class EventHandler
    extends Handler {
        private static final int MSG_CAS_EVENT = 0;
        private static final int MSG_CAS_SESSION_EVENT = 1;
        private static final int MSG_CAS_STATUS_EVENT = 2;
        private static final int MSG_CAS_RESOURCE_LOST = 3;
        private static final String SESSION_KEY = "sessionId";
        private static final String DATA_KEY = "data";

        public EventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                MediaCas.this.mListener.onEvent(MediaCas.this, msg.arg1, msg.arg2, MediaCas.this.toBytes((ArrayList)msg.obj));
            } else if (msg.what == 1) {
                Bundle bundle = msg.getData();
                ArrayList<Byte> sessionId = MediaCas.this.toByteArray(bundle.getByteArray(SESSION_KEY));
                MediaCas.this.mListener.onSessionEvent(MediaCas.this, MediaCas.this.createFromSessionId(sessionId), msg.arg1, msg.arg2, bundle.getByteArray(DATA_KEY));
            } else if (msg.what == 2) {
                if (msg.arg1 == 1 && MediaCas.this.mTunerResourceManager != null) {
                    MediaCas.this.mTunerResourceManager.updateCasInfo(MediaCas.this.mCasSystemId, msg.arg2);
                }
                MediaCas.this.mListener.onPluginStatusUpdate(MediaCas.this, msg.arg1, msg.arg2);
            } else if (msg.what == 3) {
                MediaCas.this.mListener.onResourceLost(MediaCas.this);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PluginStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionUsage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScramblingMode {
    }
}

