/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Bitmap;
import android.media.MediaMetadata;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseIntArray;

@Deprecated
public abstract class MediaMetadataEditor {
    private static final String TAG = "MediaMetadataEditor";
    public static final int BITMAP_KEY_ARTWORK = 100;
    public static final int RATING_KEY_BY_OTHERS = 101;
    public static final int RATING_KEY_BY_USER = 0x10000001;
    public static final int KEY_EDITABLE_MASK = 0x1FFFFFFF;
    protected long mEditableKeys;
    protected boolean mMetadataChanged = false;
    protected boolean mApplied = false;
    protected boolean mArtworkChanged = false;
    protected Bitmap mEditorArtwork;
    protected Bundle mEditorMetadata;
    protected MediaMetadata.Builder mMetadataBuilder;
    protected static final int METADATA_TYPE_INVALID = -1;
    protected static final int METADATA_TYPE_LONG = 0;
    protected static final int METADATA_TYPE_STRING = 1;
    protected static final int METADATA_TYPE_BITMAP = 2;
    protected static final int METADATA_TYPE_RATING = 3;
    protected static final SparseIntArray METADATA_KEYS_TYPE = new SparseIntArray(17);

    protected MediaMetadataEditor() {
    }

    public abstract void apply();

    public synchronized void clear() {
        if (this.mApplied) {
            Log.e(TAG, "Can't clear a previously applied MediaMetadataEditor");
            return;
        }
        this.mEditorMetadata.clear();
        this.mEditorArtwork = null;
        this.mMetadataBuilder = new MediaMetadata.Builder();
    }

    public synchronized void addEditableKey(int key) {
        if (this.mApplied) {
            Log.e(TAG, "Can't change editable keys of a previously applied MetadataEditor");
            return;
        }
        if (key == 0x10000001) {
            this.mEditableKeys |= (long)(0x1FFFFFFF & key);
            this.mMetadataChanged = true;
        } else {
            Log.e(TAG, "Metadata key " + key + " cannot be edited");
        }
    }

    public synchronized void removeEditableKeys() {
        if (this.mApplied) {
            Log.e(TAG, "Can't remove all editable keys of a previously applied MetadataEditor");
            return;
        }
        if (this.mEditableKeys != 0L) {
            this.mEditableKeys = 0L;
            this.mMetadataChanged = true;
        }
    }

    public synchronized int[] getEditableKeys() {
        if (this.mEditableKeys == 0x10000001L) {
            int[] keys = new int[]{0x10000001};
            return keys;
        }
        return null;
    }

    public synchronized MediaMetadataEditor putString(int key, String value2) throws IllegalArgumentException {
        if (this.mApplied) {
            Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
            return this;
        }
        if (METADATA_KEYS_TYPE.get(key, -1) != 1) {
            throw new IllegalArgumentException("Invalid type 'String' for key " + key);
        }
        this.mEditorMetadata.putString(String.valueOf(key), value2);
        this.mMetadataChanged = true;
        return this;
    }

    public synchronized MediaMetadataEditor putLong(int key, long value2) throws IllegalArgumentException {
        if (this.mApplied) {
            Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
            return this;
        }
        if (METADATA_KEYS_TYPE.get(key, -1) != 0) {
            throw new IllegalArgumentException("Invalid type 'long' for key " + key);
        }
        this.mEditorMetadata.putLong(String.valueOf(key), value2);
        this.mMetadataChanged = true;
        return this;
    }

    public synchronized MediaMetadataEditor putBitmap(int key, Bitmap bitmap) throws IllegalArgumentException {
        if (this.mApplied) {
            Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
            return this;
        }
        if (key != 100) {
            throw new IllegalArgumentException("Invalid type 'Bitmap' for key " + key);
        }
        this.mEditorArtwork = bitmap;
        this.mArtworkChanged = true;
        return this;
    }

    public synchronized MediaMetadataEditor putObject(int key, Object value2) throws IllegalArgumentException {
        if (this.mApplied) {
            Log.e(TAG, "Can't edit a previously applied MediaMetadataEditor");
            return this;
        }
        switch (METADATA_KEYS_TYPE.get(key, -1)) {
            case 0: {
                if (value2 instanceof Long) {
                    return this.putLong(key, (Long)value2);
                }
                throw new IllegalArgumentException("Not a non-null Long for key " + key);
            }
            case 1: {
                if (value2 == null || value2 instanceof String) {
                    return this.putString(key, (String)value2);
                }
                throw new IllegalArgumentException("Not a String for key " + key);
            }
            case 3: {
                this.mEditorMetadata.putParcelable(String.valueOf(key), (Parcelable)value2);
                this.mMetadataChanged = true;
                break;
            }
            case 2: {
                if (value2 == null || value2 instanceof Bitmap) {
                    return this.putBitmap(key, (Bitmap)value2);
                }
                throw new IllegalArgumentException("Not a Bitmap for key " + key);
            }
            default: {
                throw new IllegalArgumentException("Invalid key " + key);
            }
        }
        return this;
    }

    public synchronized long getLong(int key, long defaultValue) throws IllegalArgumentException {
        if (METADATA_KEYS_TYPE.get(key, -1) != 0) {
            throw new IllegalArgumentException("Invalid type 'long' for key " + key);
        }
        return this.mEditorMetadata.getLong(String.valueOf(key), defaultValue);
    }

    public synchronized String getString(int key, String defaultValue) throws IllegalArgumentException {
        if (METADATA_KEYS_TYPE.get(key, -1) != 1) {
            throw new IllegalArgumentException("Invalid type 'String' for key " + key);
        }
        return this.mEditorMetadata.getString(String.valueOf(key), defaultValue);
    }

    public synchronized Bitmap getBitmap(int key, Bitmap defaultValue) throws IllegalArgumentException {
        if (key != 100) {
            throw new IllegalArgumentException("Invalid type 'Bitmap' for key " + key);
        }
        return this.mEditorArtwork != null ? this.mEditorArtwork : defaultValue;
    }

    public synchronized Object getObject(int key, Object defaultValue) throws IllegalArgumentException {
        switch (METADATA_KEYS_TYPE.get(key, -1)) {
            case 0: {
                if (this.mEditorMetadata.containsKey(String.valueOf(key))) {
                    return this.mEditorMetadata.getLong(String.valueOf(key));
                }
                return defaultValue;
            }
            case 1: {
                if (this.mEditorMetadata.containsKey(String.valueOf(key))) {
                    return this.mEditorMetadata.getString(String.valueOf(key));
                }
                return defaultValue;
            }
            case 3: {
                if (this.mEditorMetadata.containsKey(String.valueOf(key))) {
                    return this.mEditorMetadata.getParcelable(String.valueOf(key));
                }
                return defaultValue;
            }
            case 2: {
                if (key != 100) break;
                return this.mEditorArtwork != null ? this.mEditorArtwork : defaultValue;
            }
        }
        throw new IllegalArgumentException("Invalid key " + key);
    }

    static {
        METADATA_KEYS_TYPE.put(0, 0);
        METADATA_KEYS_TYPE.put(14, 0);
        METADATA_KEYS_TYPE.put(9, 0);
        METADATA_KEYS_TYPE.put(8, 0);
        METADATA_KEYS_TYPE.put(1, 1);
        METADATA_KEYS_TYPE.put(13, 1);
        METADATA_KEYS_TYPE.put(7, 1);
        METADATA_KEYS_TYPE.put(2, 1);
        METADATA_KEYS_TYPE.put(3, 1);
        METADATA_KEYS_TYPE.put(15, 1);
        METADATA_KEYS_TYPE.put(4, 1);
        METADATA_KEYS_TYPE.put(5, 1);
        METADATA_KEYS_TYPE.put(6, 1);
        METADATA_KEYS_TYPE.put(11, 1);
        METADATA_KEYS_TYPE.put(100, 2);
        METADATA_KEYS_TYPE.put(101, 3);
        METADATA_KEYS_TYPE.put(0x10000001, 3);
    }
}

