/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaRouter2Utils;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RoutingSessionInfo
implements Parcelable {
    public static final Parcelable.Creator<RoutingSessionInfo> CREATOR = new Parcelable.Creator<RoutingSessionInfo>(){

        @Override
        public RoutingSessionInfo createFromParcel(Parcel in) {
            return new RoutingSessionInfo(in);
        }

        public RoutingSessionInfo[] newArray(int size) {
            return new RoutingSessionInfo[size];
        }
    };
    private static final String TAG = "RoutingSessionInfo";
    final String mId;
    final CharSequence mName;
    final String mOwnerPackageName;
    final String mClientPackageName;
    final String mProviderId;
    final List<String> mSelectedRoutes;
    final List<String> mSelectableRoutes;
    final List<String> mDeselectableRoutes;
    final List<String> mTransferableRoutes;
    final int mVolumeHandling;
    final int mVolumeMax;
    final int mVolume;
    final Bundle mControlHints;
    final boolean mIsSystemSession;

    RoutingSessionInfo(Builder builder2) {
        Objects.requireNonNull(builder2, "builder must not be null.");
        this.mId = builder2.mId;
        this.mName = builder2.mName;
        this.mOwnerPackageName = builder2.mOwnerPackageName;
        this.mClientPackageName = builder2.mClientPackageName;
        this.mProviderId = builder2.mProviderId;
        this.mSelectedRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder2.mSelectedRoutes));
        this.mSelectableRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder2.mSelectableRoutes));
        this.mDeselectableRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder2.mDeselectableRoutes));
        this.mTransferableRoutes = Collections.unmodifiableList(this.convertToUniqueRouteIds(builder2.mTransferableRoutes));
        this.mVolumeHandling = builder2.mVolumeHandling;
        this.mVolumeMax = builder2.mVolumeMax;
        this.mVolume = builder2.mVolume;
        this.mControlHints = builder2.mControlHints;
        this.mIsSystemSession = builder2.mIsSystemSession;
    }

    RoutingSessionInfo(Parcel src) {
        Objects.requireNonNull(src, "src must not be null.");
        this.mId = RoutingSessionInfo.ensureString(src.readString());
        this.mName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(src);
        this.mOwnerPackageName = src.readString();
        this.mClientPackageName = RoutingSessionInfo.ensureString(src.readString());
        this.mProviderId = src.readString();
        this.mSelectedRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mSelectableRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mDeselectableRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mTransferableRoutes = RoutingSessionInfo.ensureList(src.createStringArrayList());
        this.mVolumeHandling = src.readInt();
        this.mVolumeMax = src.readInt();
        this.mVolume = src.readInt();
        this.mControlHints = src.readBundle();
        this.mIsSystemSession = src.readBoolean();
    }

    private static String ensureString(String str) {
        return str != null ? str : "";
    }

    private static <T> List<T> ensureList(List<? extends T> list) {
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getId() {
        if (this.mProviderId != null) {
            return MediaRouter2Utils.toUniqueId(this.mProviderId, this.mId);
        }
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public String getOriginalId() {
        return this.mId;
    }

    public String getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    public String getProviderId() {
        return this.mProviderId;
    }

    public List<String> getSelectedRoutes() {
        return this.mSelectedRoutes;
    }

    public List<String> getSelectableRoutes() {
        return this.mSelectableRoutes;
    }

    public List<String> getDeselectableRoutes() {
        return this.mDeselectableRoutes;
    }

    public List<String> getTransferableRoutes() {
        return this.mTransferableRoutes;
    }

    public int getVolumeHandling() {
        return this.mVolumeHandling;
    }

    public int getVolumeMax() {
        return this.mVolumeMax;
    }

    public int getVolume() {
        return this.mVolume;
    }

    public Bundle getControlHints() {
        return this.mControlHints;
    }

    public boolean isSystemSession() {
        return this.mIsSystemSession;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeCharSequence(this.mName);
        dest.writeString(this.mOwnerPackageName);
        dest.writeString(this.mClientPackageName);
        dest.writeString(this.mProviderId);
        dest.writeStringList(this.mSelectedRoutes);
        dest.writeStringList(this.mSelectableRoutes);
        dest.writeStringList(this.mDeselectableRoutes);
        dest.writeStringList(this.mTransferableRoutes);
        dest.writeInt(this.mVolumeHandling);
        dest.writeInt(this.mVolumeMax);
        dest.writeInt(this.mVolume);
        dest.writeBundle(this.mControlHints);
        dest.writeBoolean(this.mIsSystemSession);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RoutingSessionInfo)) {
            return false;
        }
        RoutingSessionInfo other = (RoutingSessionInfo)obj;
        return Objects.equals(this.mId, other.mId) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mOwnerPackageName, other.mOwnerPackageName) && Objects.equals(this.mClientPackageName, other.mClientPackageName) && Objects.equals(this.mProviderId, other.mProviderId) && Objects.equals(this.mSelectedRoutes, other.mSelectedRoutes) && Objects.equals(this.mSelectableRoutes, other.mSelectableRoutes) && Objects.equals(this.mDeselectableRoutes, other.mDeselectableRoutes) && Objects.equals(this.mTransferableRoutes, other.mTransferableRoutes) && this.mVolumeHandling == other.mVolumeHandling && this.mVolumeMax == other.mVolumeMax && this.mVolume == other.mVolume;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mName, this.mOwnerPackageName, this.mClientPackageName, this.mProviderId, this.mSelectedRoutes, this.mSelectableRoutes, this.mDeselectableRoutes, this.mTransferableRoutes, this.mVolumeMax, this.mVolumeHandling, this.mVolume);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("RoutingSessionInfo{ ").append("sessionId=").append(this.getId()).append(", name=").append(this.getName()).append(", clientPackageName=").append(this.getClientPackageName()).append(", selectedRoutes={").append(String.join((CharSequence)",", this.getSelectedRoutes())).append("}").append(", selectableRoutes={").append(String.join((CharSequence)",", this.getSelectableRoutes())).append("}").append(", deselectableRoutes={").append(String.join((CharSequence)",", this.getDeselectableRoutes())).append("}").append(", transferableRoutes={").append(String.join((CharSequence)",", this.getTransferableRoutes())).append("}").append(", volumeHandling=").append(this.getVolumeHandling()).append(", volumeMax=").append(this.getVolumeMax()).append(", volume=").append(this.getVolume()).append(" }");
        return result.toString();
    }

    private List<String> convertToUniqueRouteIds(List<String> routeIds) {
        if (routeIds == null) {
            Log.w(TAG, "routeIds is null. Returning an empty list");
            return Collections.emptyList();
        }
        if (this.mProviderId == null) {
            return routeIds;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String routeId : routeIds) {
            result.add(MediaRouter2Utils.toUniqueId(this.mProviderId, routeId));
        }
        return result;
    }

    public static class Builder {
        final String mId;
        CharSequence mName;
        String mOwnerPackageName;
        String mClientPackageName;
        String mProviderId;
        final List<String> mSelectedRoutes;
        final List<String> mSelectableRoutes;
        final List<String> mDeselectableRoutes;
        final List<String> mTransferableRoutes;
        int mVolumeHandling = 0;
        int mVolumeMax;
        int mVolume;
        Bundle mControlHints;
        boolean mIsSystemSession;

        public Builder(String id2, String clientPackageName) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id must not be empty");
            }
            this.mId = id2;
            this.mClientPackageName = Objects.requireNonNull(clientPackageName, "clientPackageName must not be null");
            this.mSelectedRoutes = new ArrayList<String>();
            this.mSelectableRoutes = new ArrayList<String>();
            this.mDeselectableRoutes = new ArrayList<String>();
            this.mTransferableRoutes = new ArrayList<String>();
        }

        public Builder(RoutingSessionInfo sessionInfo) {
            Objects.requireNonNull(sessionInfo, "sessionInfo must not be null");
            this.mId = sessionInfo.mId;
            this.mName = sessionInfo.mName;
            this.mClientPackageName = sessionInfo.mClientPackageName;
            this.mProviderId = sessionInfo.mProviderId;
            this.mSelectedRoutes = new ArrayList<String>(sessionInfo.mSelectedRoutes);
            this.mSelectableRoutes = new ArrayList<String>(sessionInfo.mSelectableRoutes);
            this.mDeselectableRoutes = new ArrayList<String>(sessionInfo.mDeselectableRoutes);
            this.mTransferableRoutes = new ArrayList<String>(sessionInfo.mTransferableRoutes);
            if (this.mProviderId != null) {
                this.mSelectedRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
                this.mSelectableRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
                this.mDeselectableRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
                this.mTransferableRoutes.replaceAll(MediaRouter2Utils::getOriginalId);
            }
            this.mVolumeHandling = sessionInfo.mVolumeHandling;
            this.mVolumeMax = sessionInfo.mVolumeMax;
            this.mVolume = sessionInfo.mVolume;
            this.mControlHints = sessionInfo.mControlHints;
            this.mIsSystemSession = sessionInfo.mIsSystemSession;
        }

        public Builder setName(CharSequence name) {
            this.mName = name;
            return this;
        }

        public Builder setOwnerPackageName(String packageName) {
            this.mOwnerPackageName = packageName;
            return this;
        }

        public Builder setClientPackageName(String packageName) {
            this.mClientPackageName = packageName;
            return this;
        }

        public Builder setProviderId(String providerId) {
            if (TextUtils.isEmpty(providerId)) {
                throw new IllegalArgumentException("providerId must not be empty");
            }
            this.mProviderId = providerId;
            return this;
        }

        public Builder clearSelectedRoutes() {
            this.mSelectedRoutes.clear();
            return this;
        }

        public Builder addSelectedRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectedRoutes.add(routeId);
            return this;
        }

        public Builder removeSelectedRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectedRoutes.remove(routeId);
            return this;
        }

        public Builder clearSelectableRoutes() {
            this.mSelectableRoutes.clear();
            return this;
        }

        public Builder addSelectableRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectableRoutes.add(routeId);
            return this;
        }

        public Builder removeSelectableRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mSelectableRoutes.remove(routeId);
            return this;
        }

        public Builder clearDeselectableRoutes() {
            this.mDeselectableRoutes.clear();
            return this;
        }

        public Builder addDeselectableRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mDeselectableRoutes.add(routeId);
            return this;
        }

        public Builder removeDeselectableRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mDeselectableRoutes.remove(routeId);
            return this;
        }

        public Builder clearTransferableRoutes() {
            this.mTransferableRoutes.clear();
            return this;
        }

        public Builder addTransferableRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mTransferableRoutes.add(routeId);
            return this;
        }

        public Builder removeTransferableRoute(String routeId) {
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("routeId must not be empty");
            }
            this.mTransferableRoutes.remove(routeId);
            return this;
        }

        public Builder setVolumeHandling(int volumeHandling) {
            this.mVolumeHandling = volumeHandling;
            return this;
        }

        public Builder setVolumeMax(int volumeMax) {
            this.mVolumeMax = volumeMax;
            return this;
        }

        public Builder setVolume(int volume) {
            this.mVolume = volume;
            return this;
        }

        public Builder setControlHints(Bundle controlHints) {
            this.mControlHints = controlHints;
            return this;
        }

        public Builder setSystemSession(boolean isSystemSession) {
            this.mIsSystemSession = isSystemSession;
            return this;
        }

        public RoutingSessionInfo build() {
            if (this.mSelectedRoutes.isEmpty()) {
                throw new IllegalArgumentException("selectedRoutes must not be empty");
            }
            return new RoutingSessionInfo(this);
        }
    }
}

