/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.os.Parcel;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TimedText {
    private static final int FIRST_PUBLIC_KEY = 1;
    private static final int KEY_DISPLAY_FLAGS = 1;
    private static final int KEY_STYLE_FLAGS = 2;
    private static final int KEY_BACKGROUND_COLOR_RGBA = 3;
    private static final int KEY_HIGHLIGHT_COLOR_RGBA = 4;
    private static final int KEY_SCROLL_DELAY = 5;
    private static final int KEY_WRAP_TEXT = 6;
    private static final int KEY_START_TIME = 7;
    private static final int KEY_STRUCT_BLINKING_TEXT_LIST = 8;
    private static final int KEY_STRUCT_FONT_LIST = 9;
    private static final int KEY_STRUCT_HIGHLIGHT_LIST = 10;
    private static final int KEY_STRUCT_HYPER_TEXT_LIST = 11;
    private static final int KEY_STRUCT_KARAOKE_LIST = 12;
    private static final int KEY_STRUCT_STYLE_LIST = 13;
    private static final int KEY_STRUCT_TEXT_POS = 14;
    private static final int KEY_STRUCT_JUSTIFICATION = 15;
    private static final int KEY_STRUCT_TEXT = 16;
    private static final int LAST_PUBLIC_KEY = 16;
    private static final int FIRST_PRIVATE_KEY = 101;
    private static final int KEY_GLOBAL_SETTING = 101;
    private static final int KEY_LOCAL_SETTING = 102;
    private static final int KEY_START_CHAR = 103;
    private static final int KEY_END_CHAR = 104;
    private static final int KEY_FONT_ID = 105;
    private static final int KEY_FONT_SIZE = 106;
    private static final int KEY_TEXT_COLOR_RGBA = 107;
    private static final int LAST_PRIVATE_KEY = 107;
    private static final String TAG = "TimedText";
    private final HashMap<Integer, Object> mKeyObjectMap = new HashMap();
    private int mDisplayFlags = -1;
    private int mBackgroundColorRGBA = -1;
    private int mHighlightColorRGBA = -1;
    private int mScrollDelay = -1;
    private int mWrapText = -1;
    private List<CharPos> mBlinkingPosList = null;
    private List<CharPos> mHighlightPosList = null;
    private List<Karaoke> mKaraokeList = null;
    private List<Font> mFontList = null;
    private List<Style> mStyleList = null;
    private List<HyperText> mHyperTextList = null;
    private Rect mTextBounds = null;
    private String mTextChars = null;
    private Justification mJustification;

    public TimedText(Parcel parcel) {
        if (!this.parseParcel(parcel)) {
            this.mKeyObjectMap.clear();
            throw new IllegalArgumentException("parseParcel() fails");
        }
    }

    public TimedText(String text, Rect bounds2) {
        this.mTextChars = text;
        this.mTextBounds = bounds2;
    }

    public String getText() {
        return this.mTextChars;
    }

    public Rect getBounds() {
        return this.mTextBounds;
    }

    private boolean parseParcel(Parcel parcel) {
        parcel.setDataPosition(0);
        if (parcel.dataAvail() == 0) {
            return false;
        }
        int type = parcel.readInt();
        if (type == 102) {
            type = parcel.readInt();
            if (type != 7) {
                return false;
            }
            int mStartTimeMs = parcel.readInt();
            this.mKeyObjectMap.put(type, mStartTimeMs);
            type = parcel.readInt();
            if (type != 16) {
                return false;
            }
            int textLen = parcel.readInt();
            byte[] text = parcel.createByteArray();
            this.mTextChars = text == null || text.length == 0 ? null : new String(text);
        } else if (type != 101) {
            Log.w(TAG, "Invalid timed text key found: " + type);
            return false;
        }
        while (parcel.dataAvail() > 0) {
            int key = parcel.readInt();
            if (!this.isValidKey(key)) {
                Log.w(TAG, "Invalid timed text key found: " + key);
                return false;
            }
            Object object = null;
            switch (key) {
                case 13: {
                    this.readStyle(parcel);
                    object = this.mStyleList;
                    break;
                }
                case 9: {
                    this.readFont(parcel);
                    object = this.mFontList;
                    break;
                }
                case 10: {
                    this.readHighlight(parcel);
                    object = this.mHighlightPosList;
                    break;
                }
                case 12: {
                    this.readKaraoke(parcel);
                    object = this.mKaraokeList;
                    break;
                }
                case 11: {
                    this.readHyperText(parcel);
                    object = this.mHyperTextList;
                    break;
                }
                case 8: {
                    this.readBlinkingText(parcel);
                    object = this.mBlinkingPosList;
                    break;
                }
                case 6: {
                    this.mWrapText = parcel.readInt();
                    object = this.mWrapText;
                    break;
                }
                case 4: {
                    this.mHighlightColorRGBA = parcel.readInt();
                    object = this.mHighlightColorRGBA;
                    break;
                }
                case 1: {
                    this.mDisplayFlags = parcel.readInt();
                    object = this.mDisplayFlags;
                    break;
                }
                case 15: {
                    int horizontal = parcel.readInt();
                    int vertical = parcel.readInt();
                    this.mJustification = new Justification(horizontal, vertical);
                    object = this.mJustification;
                    break;
                }
                case 3: {
                    this.mBackgroundColorRGBA = parcel.readInt();
                    object = this.mBackgroundColorRGBA;
                    break;
                }
                case 14: {
                    int top = parcel.readInt();
                    int left = parcel.readInt();
                    int bottom2 = parcel.readInt();
                    int right2 = parcel.readInt();
                    this.mTextBounds = new Rect(left, top, right2, bottom2);
                    break;
                }
                case 5: {
                    this.mScrollDelay = parcel.readInt();
                    object = this.mScrollDelay;
                    break;
                }
            }
            if (object == null) continue;
            if (this.mKeyObjectMap.containsKey(key)) {
                this.mKeyObjectMap.remove(key);
            }
            this.mKeyObjectMap.put(key, object);
        }
        return true;
    }

    private void readStyle(Parcel parcel) {
        boolean endOfStyle = false;
        int startChar = -1;
        int endChar = -1;
        int fontId = -1;
        boolean isBold = false;
        boolean isItalic = false;
        boolean isUnderlined = false;
        int fontSize = -1;
        int colorRGBA = -1;
        block8: while (!endOfStyle && parcel.dataAvail() > 0) {
            int key = parcel.readInt();
            switch (key) {
                case 103: {
                    startChar = parcel.readInt();
                    continue block8;
                }
                case 104: {
                    endChar = parcel.readInt();
                    continue block8;
                }
                case 105: {
                    fontId = parcel.readInt();
                    continue block8;
                }
                case 2: {
                    int flags = parcel.readInt();
                    isBold = flags % 2 == 1;
                    isItalic = flags % 4 >= 2;
                    isUnderlined = flags / 4 == 1;
                    continue block8;
                }
                case 106: {
                    fontSize = parcel.readInt();
                    continue block8;
                }
                case 107: {
                    colorRGBA = parcel.readInt();
                    continue block8;
                }
            }
            parcel.setDataPosition(parcel.dataPosition() - 4);
            endOfStyle = true;
        }
        Style style2 = new Style(startChar, endChar, fontId, isBold, isItalic, isUnderlined, fontSize, colorRGBA);
        if (this.mStyleList == null) {
            this.mStyleList = new ArrayList<Style>();
        }
        this.mStyleList.add(style2);
    }

    private void readFont(Parcel parcel) {
        int entryCount = parcel.readInt();
        for (int i = 0; i < entryCount; ++i) {
            int id2 = parcel.readInt();
            int nameLen = parcel.readInt();
            byte[] text = parcel.createByteArray();
            String name = new String(text, 0, nameLen);
            Font font = new Font(id2, name);
            if (this.mFontList == null) {
                this.mFontList = new ArrayList<Font>();
            }
            this.mFontList.add(font);
        }
    }

    private void readHighlight(Parcel parcel) {
        int startChar = parcel.readInt();
        int endChar = parcel.readInt();
        CharPos pos = new CharPos(startChar, endChar);
        if (this.mHighlightPosList == null) {
            this.mHighlightPosList = new ArrayList<CharPos>();
        }
        this.mHighlightPosList.add(pos);
    }

    private void readKaraoke(Parcel parcel) {
        int entryCount = parcel.readInt();
        for (int i = 0; i < entryCount; ++i) {
            int startTimeMs = parcel.readInt();
            int endTimeMs = parcel.readInt();
            int startChar = parcel.readInt();
            int endChar = parcel.readInt();
            Karaoke kara = new Karaoke(startTimeMs, endTimeMs, startChar, endChar);
            if (this.mKaraokeList == null) {
                this.mKaraokeList = new ArrayList<Karaoke>();
            }
            this.mKaraokeList.add(kara);
        }
    }

    private void readHyperText(Parcel parcel) {
        int startChar = parcel.readInt();
        int endChar = parcel.readInt();
        int len = parcel.readInt();
        byte[] url = parcel.createByteArray();
        String urlString = new String(url, 0, len);
        len = parcel.readInt();
        byte[] alt = parcel.createByteArray();
        String altString = new String(alt, 0, len);
        HyperText hyperText = new HyperText(startChar, endChar, urlString, altString);
        if (this.mHyperTextList == null) {
            this.mHyperTextList = new ArrayList<HyperText>();
        }
        this.mHyperTextList.add(hyperText);
    }

    private void readBlinkingText(Parcel parcel) {
        int startChar = parcel.readInt();
        int endChar = parcel.readInt();
        CharPos blinkingPos = new CharPos(startChar, endChar);
        if (this.mBlinkingPosList == null) {
            this.mBlinkingPosList = new ArrayList<CharPos>();
        }
        this.mBlinkingPosList.add(blinkingPos);
    }

    private boolean isValidKey(int key) {
        return key >= 1 && key <= 16 || key >= 101 && key <= 107;
    }

    private boolean containsKey(int key) {
        return this.isValidKey(key) && this.mKeyObjectMap.containsKey(key);
    }

    private Set keySet() {
        return this.mKeyObjectMap.keySet();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Object getObject(int key) {
        if (this.containsKey(key)) {
            return this.mKeyObjectMap.get(key);
        }
        throw new IllegalArgumentException("Invalid key: " + key);
    }

    public static class HyperText {
        public final int startChar;
        public final int endChar;
        public final String URL;
        public final String altString;

        public HyperText(int startChar, int endChar, String url, String alt) {
            this.startChar = startChar;
            this.endChar = endChar;
            this.URL = url;
            this.altString = alt;
        }
    }

    public static class Karaoke {
        public final int startTimeMs;
        public final int endTimeMs;
        public final int startChar;
        public final int endChar;

        public Karaoke(int startTimeMs, int endTimeMs, int startChar, int endChar) {
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
            this.startChar = startChar;
            this.endChar = endChar;
        }
    }

    public static class Font {
        public final int ID;
        public final String name;

        public Font(int id2, String name) {
            this.ID = id2;
            this.name = name;
        }
    }

    public static class Style {
        public final int startChar;
        public final int endChar;
        public final int fontID;
        public final boolean isBold;
        public final boolean isItalic;
        public final boolean isUnderlined;
        public final int fontSize;
        public final int colorRGBA;

        public Style(int startChar, int endChar, int fontId, boolean isBold, boolean isItalic, boolean isUnderlined, int fontSize, int colorRGBA) {
            this.startChar = startChar;
            this.endChar = endChar;
            this.fontID = fontId;
            this.isBold = isBold;
            this.isItalic = isItalic;
            this.isUnderlined = isUnderlined;
            this.fontSize = fontSize;
            this.colorRGBA = colorRGBA;
        }
    }

    public static class Justification {
        public final int horizontalJustification;
        public final int verticalJustification;

        public Justification(int horizontal, int vertical) {
            this.horizontalJustification = horizontal;
            this.verticalJustification = vertical;
        }
    }

    public static class CharPos {
        public final int startChar;
        public final int endChar;

        public CharPos(int startChar, int endChar) {
            this.startChar = startChar;
            this.endChar = endChar;
        }
    }
}

