/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TextTrackCueSpan;
import android.media.Tokenizer;
import java.util.Vector;

class UnstyledTextExtractor
implements Tokenizer.OnTokenListener {
    StringBuilder mLine = new StringBuilder();
    Vector<TextTrackCueSpan[]> mLines = new Vector();
    Vector<TextTrackCueSpan> mCurrentLine = new Vector();
    long mLastTimestamp;

    UnstyledTextExtractor() {
        this.init();
    }

    private void init() {
        this.mLine.delete(0, this.mLine.length());
        this.mLines.clear();
        this.mCurrentLine.clear();
        this.mLastTimestamp = -1L;
    }

    @Override
    public void onData(String s) {
        this.mLine.append(s);
    }

    @Override
    public void onStart(String tag2, String[] classes2, String annotation) {
    }

    @Override
    public void onEnd(String tag2) {
    }

    @Override
    public void onTimeStamp(long timestampMs) {
        if (this.mLine.length() > 0 && timestampMs != this.mLastTimestamp) {
            this.mCurrentLine.add(new TextTrackCueSpan(this.mLine.toString(), this.mLastTimestamp));
            this.mLine.delete(0, this.mLine.length());
        }
        this.mLastTimestamp = timestampMs;
    }

    @Override
    public void onLineEnd() {
        if (this.mLine.length() > 0) {
            this.mCurrentLine.add(new TextTrackCueSpan(this.mLine.toString(), this.mLastTimestamp));
            this.mLine.delete(0, this.mLine.length());
        }
        TextTrackCueSpan[] spans = new TextTrackCueSpan[this.mCurrentLine.size()];
        this.mCurrentLine.toArray(spans);
        this.mCurrentLine.clear();
        this.mLines.add(spans);
    }

    public TextTrackCueSpan[][] getText() {
        if (this.mLine.length() > 0 || this.mCurrentLine.size() > 0) {
            this.onLineEnd();
        }
        TextTrackCueSpan[][] lines = new TextTrackCueSpan[this.mLines.size()][];
        this.mLines.toArray((T[])lines);
        this.init();
        return lines;
    }
}

