/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class VolumeProvider {
    public static final int VOLUME_CONTROL_FIXED = 0;
    public static final int VOLUME_CONTROL_RELATIVE = 1;
    public static final int VOLUME_CONTROL_ABSOLUTE = 2;
    private final int mControlType;
    private final int mMaxVolume;
    private final String mControlId;
    private int mCurrentVolume;
    private Callback mCallback;

    public VolumeProvider(int volumeControl, int maxVolume, int currentVolume) {
        this(volumeControl, maxVolume, currentVolume, null);
    }

    public VolumeProvider(int volumeControl, int maxVolume, int currentVolume, String volumeControlId) {
        this.mControlType = volumeControl;
        this.mMaxVolume = maxVolume;
        this.mCurrentVolume = currentVolume;
        this.mControlId = volumeControlId;
    }

    public int getVolumeControl() {
        return this.mControlType;
    }

    public int getMaxVolume() {
        return this.mMaxVolume;
    }

    public int getCurrentVolume() {
        return this.mCurrentVolume;
    }

    public void setCurrentVolume(int currentVolume) {
        this.mCurrentVolume = currentVolume;
        if (this.mCallback != null) {
            this.mCallback.onVolumeChanged(this);
        }
    }

    public String getVolumeControlId() {
        return this.mControlId;
    }

    public void onSetVolumeTo(int volume) {
    }

    public void onAdjustVolume(int direction) {
    }

    public void setCallback(Callback callback2) {
        this.mCallback = callback2;
    }

    public static abstract class Callback {
        public abstract void onVolumeChanged(VolumeProvider var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ControlType {
    }
}

