/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TextTrackCue;
import android.media.TextTrackRegion;
import android.media.WebVttCueListener;
import android.util.Log;
import java.util.Vector;

class WebVttParser {
    private static final String TAG = "WebVttParser";
    private Phase mPhase;
    private TextTrackCue mCue;
    private Vector<String> mCueTexts;
    private WebVttCueListener mListener;
    private String mBuffer = "";
    private final Phase mSkipRest = new Phase(){

        @Override
        public void parse(String line) {
        }
    };
    private final Phase mParseStart = new Phase(){

        @Override
        public void parse(String line) {
            if (line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (!(line.equals("WEBVTT") || line.startsWith("WEBVTT ") || line.startsWith("WEBVTT\t"))) {
                WebVttParser.this.log_warning("Not a WEBVTT header", line);
                WebVttParser.this.mPhase = WebVttParser.this.mSkipRest;
            } else {
                WebVttParser.this.mPhase = WebVttParser.this.mParseHeader;
            }
        }
    };
    private final Phase mParseHeader = new Phase(){

        TextTrackRegion parseRegion(String s) {
            TextTrackRegion region = new TextTrackRegion();
            for (String setting : s.split(" +")) {
                int equalAt = setting.indexOf(61);
                if (equalAt <= 0 || equalAt == setting.length() - 1) continue;
                String name = setting.substring(0, equalAt);
                String value2 = setting.substring(equalAt + 1);
                if (name.equals("id")) {
                    region.mId = value2;
                    continue;
                }
                if (name.equals("width")) {
                    try {
                        region.mWidth = WebVttParser.parseFloatPercentage(value2);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("region setting", name, "has invalid value", e.getMessage(), value2);
                    }
                    continue;
                }
                if (name.equals("lines")) {
                    if (value2.matches(".*[^0-9].*")) {
                        WebVttParser.this.log_warning("lines", name, "contains an invalid character", value2);
                        continue;
                    }
                    try {
                        region.mLines = Integer.parseInt(value2);
                        assert (region.mLines >= 0);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("region setting", name, "is not numeric", value2);
                    }
                    continue;
                }
                if (name.equals("regionanchor") || name.equals("viewportanchor")) {
                    float y;
                    float x;
                    int commaAt = value2.indexOf(",");
                    if (commaAt < 0) {
                        WebVttParser.this.log_warning("region setting", name, "contains no comma", value2);
                        continue;
                    }
                    String anchorX = value2.substring(0, commaAt);
                    String anchorY = value2.substring(commaAt + 1);
                    try {
                        x = WebVttParser.parseFloatPercentage(anchorX);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("region setting", name, "has invalid x component", e.getMessage(), anchorX);
                        continue;
                    }
                    try {
                        y = WebVttParser.parseFloatPercentage(anchorY);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("region setting", name, "has invalid y component", e.getMessage(), anchorY);
                        continue;
                    }
                    if (name.charAt(0) == 'r') {
                        region.mAnchorPointX = x;
                        region.mAnchorPointY = y;
                        continue;
                    }
                    region.mViewportAnchorPointX = x;
                    region.mViewportAnchorPointY = y;
                    continue;
                }
                if (!name.equals("scroll")) continue;
                if (value2.equals("up")) {
                    region.mScrollValue = 301;
                    continue;
                }
                WebVttParser.this.log_warning("region setting", name, "has invalid value", value2);
            }
            return region;
        }

        @Override
        public void parse(String line) {
            if (line.length() == 0) {
                WebVttParser.this.mPhase = WebVttParser.this.mParseCueId;
            } else if (line.contains("-->")) {
                WebVttParser.this.mPhase = WebVttParser.this.mParseCueTime;
                WebVttParser.this.mPhase.parse(line);
            } else {
                int colonAt = line.indexOf(58);
                if (colonAt <= 0 || colonAt >= line.length() - 1) {
                    WebVttParser.this.log_warning("meta data header has invalid format", line);
                }
                String name = line.substring(0, colonAt);
                String value2 = line.substring(colonAt + 1);
                if (name.equals("Region")) {
                    TextTrackRegion region = this.parseRegion(value2);
                    WebVttParser.this.mListener.onRegionParsed(region);
                }
            }
        }
    };
    private final Phase mParseCueId = new Phase(){

        @Override
        public void parse(String line) {
            if (line.length() == 0) {
                return;
            }
            assert (WebVttParser.this.mCue == null);
            if (line.equals("NOTE") || line.startsWith("NOTE ")) {
                WebVttParser.this.mPhase = WebVttParser.this.mParseCueText;
            }
            WebVttParser.this.mCue = new TextTrackCue();
            WebVttParser.this.mCueTexts.clear();
            WebVttParser.this.mPhase = WebVttParser.this.mParseCueTime;
            if (line.contains("-->")) {
                WebVttParser.this.mPhase.parse(line);
            } else {
                WebVttParser.this.mCue.mId = line;
            }
        }
    };
    private final Phase mParseCueTime = new Phase(){

        @Override
        public void parse(String line) {
            int arrowAt = line.indexOf("-->");
            if (arrowAt < 0) {
                WebVttParser.this.mCue = null;
                WebVttParser.this.mPhase = WebVttParser.this.mParseCueId;
                return;
            }
            String start = line.substring(0, arrowAt).trim();
            String rest = line.substring(arrowAt + 3).replaceFirst("^\\s+", "").replaceFirst("\\s+", " ");
            int spaceAt = rest.indexOf(32);
            String end = spaceAt > 0 ? rest.substring(0, spaceAt) : rest;
            rest = spaceAt > 0 ? rest.substring(spaceAt + 1) : "";
            WebVttParser.this.mCue.mStartTimeMs = WebVttParser.parseTimestampMs(start);
            WebVttParser.this.mCue.mEndTimeMs = WebVttParser.parseTimestampMs(end);
            for (String setting : rest.split(" +")) {
                int colonAt = setting.indexOf(58);
                if (colonAt <= 0 || colonAt == setting.length() - 1) continue;
                String name = setting.substring(0, colonAt);
                String value2 = setting.substring(colonAt + 1);
                if (name.equals("region")) {
                    WebVttParser.this.mCue.mRegionId = value2;
                    continue;
                }
                if (name.equals("vertical")) {
                    if (value2.equals("rl")) {
                        WebVttParser.this.mCue.mWritingDirection = 101;
                        continue;
                    }
                    if (value2.equals("lr")) {
                        WebVttParser.this.mCue.mWritingDirection = 102;
                        continue;
                    }
                    WebVttParser.this.log_warning("cue setting", name, "has invalid value", value2);
                    continue;
                }
                if (name.equals("line")) {
                    try {
                        assert (value2.indexOf(32) < 0);
                        if (value2.endsWith("%")) {
                            WebVttParser.this.mCue.mSnapToLines = false;
                            WebVttParser.this.mCue.mLinePosition = WebVttParser.parseIntPercentage(value2);
                            continue;
                        }
                        if (value2.matches(".*[^0-9].*")) {
                            WebVttParser.this.log_warning("cue setting", name, "contains an invalid character", value2);
                            continue;
                        }
                        WebVttParser.this.mCue.mSnapToLines = true;
                        WebVttParser.this.mCue.mLinePosition = Integer.parseInt(value2);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("cue setting", name, "is not numeric or percentage", value2);
                    }
                    continue;
                }
                if (name.equals("position")) {
                    try {
                        WebVttParser.this.mCue.mTextPosition = WebVttParser.parseIntPercentage(value2);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("cue setting", name, "is not numeric or percentage", value2);
                    }
                    continue;
                }
                if (name.equals("size")) {
                    try {
                        WebVttParser.this.mCue.mSize = WebVttParser.parseIntPercentage(value2);
                    }
                    catch (NumberFormatException e) {
                        WebVttParser.this.log_warning("cue setting", name, "is not numeric or percentage", value2);
                    }
                    continue;
                }
                if (!name.equals("align")) continue;
                if (value2.equals("start")) {
                    WebVttParser.this.mCue.mAlignment = 201;
                    continue;
                }
                if (value2.equals("middle")) {
                    WebVttParser.this.mCue.mAlignment = 200;
                    continue;
                }
                if (value2.equals("end")) {
                    WebVttParser.this.mCue.mAlignment = 202;
                    continue;
                }
                if (value2.equals("left")) {
                    WebVttParser.this.mCue.mAlignment = 203;
                    continue;
                }
                if (value2.equals("right")) {
                    WebVttParser.this.mCue.mAlignment = 204;
                    continue;
                }
                WebVttParser.this.log_warning("cue setting", name, "has invalid value", value2);
            }
            if (WebVttParser.this.mCue.mLinePosition != null || WebVttParser.this.mCue.mSize != 100 || WebVttParser.this.mCue.mWritingDirection != 100) {
                WebVttParser.this.mCue.mRegionId = "";
            }
            WebVttParser.this.mPhase = WebVttParser.this.mParseCueText;
        }
    };
    private final Phase mParseCueText = new Phase(){

        @Override
        public void parse(String line) {
            if (line.length() == 0) {
                WebVttParser.this.yieldCue();
                WebVttParser.this.mPhase = WebVttParser.this.mParseCueId;
                return;
            }
            if (WebVttParser.this.mCue != null) {
                WebVttParser.this.mCueTexts.add(line);
            }
        }
    };

    WebVttParser(WebVttCueListener listener2) {
        this.mPhase = this.mParseStart;
        this.mListener = listener2;
        this.mCueTexts = new Vector();
    }

    public static float parseFloatPercentage(String s) throws NumberFormatException {
        if (!s.endsWith("%")) {
            throw new NumberFormatException("does not end in %");
        }
        if ((s = s.substring(0, s.length() - 1)).matches(".*[^0-9.].*")) {
            throw new NumberFormatException("contains an invalid character");
        }
        try {
            float value2 = Float.parseFloat(s);
            if (value2 < 0.0f || value2 > 100.0f) {
                throw new NumberFormatException("is out of range");
            }
            return value2;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("is not a number");
        }
    }

    public static int parseIntPercentage(String s) throws NumberFormatException {
        if (!s.endsWith("%")) {
            throw new NumberFormatException("does not end in %");
        }
        if ((s = s.substring(0, s.length() - 1)).matches(".*[^0-9].*")) {
            throw new NumberFormatException("contains an invalid character");
        }
        try {
            int value2 = Integer.parseInt(s);
            if (value2 < 0 || value2 > 100) {
                throw new NumberFormatException("is out of range");
            }
            return value2;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("is not a number");
        }
    }

    public static long parseTimestampMs(String s) throws NumberFormatException {
        if (!s.matches("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}")) {
            throw new NumberFormatException("has invalid format");
        }
        String[] parts = s.split("\\.", 2);
        long value2 = 0L;
        for (String group : parts[0].split(":")) {
            value2 = value2 * 60L + Long.parseLong(group);
        }
        return value2 * 1000L + Long.parseLong(parts[1]);
    }

    public static String timeToString(long timeMs) {
        return String.format("%d:%02d:%02d.%03d", timeMs / 3600000L, timeMs / 60000L % 60L, timeMs / 1000L % 60L, timeMs % 1000L);
    }

    public void parse(String s) {
        boolean trailingCR = false;
        this.mBuffer = (this.mBuffer + s.replace("\u0000", "\ufffd")).replace("\r\n", "\n");
        if (this.mBuffer.endsWith("\r")) {
            trailingCR = true;
            this.mBuffer = this.mBuffer.substring(0, this.mBuffer.length() - 1);
        }
        String[] lines = this.mBuffer.split("[\r\n]");
        for (int i = 0; i < lines.length - 1; ++i) {
            this.mPhase.parse(lines[i]);
        }
        this.mBuffer = lines[lines.length - 1];
        if (trailingCR) {
            this.mBuffer = this.mBuffer + "\r";
        }
    }

    public void eos() {
        if (this.mBuffer.endsWith("\r")) {
            this.mBuffer = this.mBuffer.substring(0, this.mBuffer.length() - 1);
        }
        this.mPhase.parse(this.mBuffer);
        this.mBuffer = "";
        this.yieldCue();
        this.mPhase = this.mParseStart;
    }

    public void yieldCue() {
        if (this.mCue != null && this.mCueTexts.size() > 0) {
            this.mCue.mStrings = new String[this.mCueTexts.size()];
            this.mCueTexts.toArray(this.mCue.mStrings);
            this.mCueTexts.clear();
            this.mListener.onCueParsed(this.mCue);
        }
        this.mCue = null;
    }

    private void log_warning(String nameType, String name, String message, String subMessage, String value2) {
        Log.w(this.getClass().getName(), nameType + " '" + name + "' " + message + " ('" + value2 + "' " + subMessage + ")");
    }

    private void log_warning(String nameType, String name, String message, String value2) {
        Log.w(this.getClass().getName(), nameType + " '" + name + "' " + message + " ('" + value2 + "')");
    }

    private void log_warning(String message, String value2) {
        Log.w(this.getClass().getName(), message + " ('" + value2 + "')");
    }

    static interface Phase {
        public void parse(String var1);
    }
}

