/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;
import android.widget.LinearLayout;
import com.android.internal.widget.SubtitleView;
import java.util.ArrayList;
import java.util.Vector;

class WebVttRenderingWidget
extends ViewGroup
implements SubtitleTrack.RenderingWidget {
    private static final boolean DEBUG = false;
    private static final CaptioningManager.CaptionStyle DEFAULT_CAPTION_STYLE = CaptioningManager.CaptionStyle.DEFAULT;
    private static final int DEBUG_REGION_BACKGROUND = -2147483393;
    private static final int DEBUG_CUE_BACKGROUND = -2130771968;
    private static final float LINE_HEIGHT_RATIO = 0.0533f;
    private final ArrayMap<TextTrackRegion, RegionLayout> mRegionBoxes = new ArrayMap();
    private final ArrayMap<TextTrackCue, CueLayout> mCueBoxes = new ArrayMap();
    private final CaptioningManager mManager;
    private SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    private CaptioningManager.CaptionStyle mCaptionStyle;
    private float mFontSize;
    private boolean mHasChangeListener;
    private final CaptioningManager.CaptioningChangeListener mCaptioningListener = new CaptioningManager.CaptioningChangeListener(){

        @Override
        public void onFontScaleChanged(float fontScale) {
            float fontSize = fontScale * (float)WebVttRenderingWidget.this.getHeight() * 0.0533f;
            WebVttRenderingWidget.this.setCaptionStyle(WebVttRenderingWidget.this.mCaptionStyle, fontSize);
        }

        @Override
        public void onUserStyleChanged(CaptioningManager.CaptionStyle userStyle) {
            WebVttRenderingWidget.this.setCaptionStyle(userStyle, WebVttRenderingWidget.this.mFontSize);
        }
    };

    public WebVttRenderingWidget(Context context) {
        this(context, null);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WebVttRenderingWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setLayerType(1, null);
        this.mManager = (CaptioningManager)context.getSystemService("captioning");
        this.mCaptionStyle = this.mManager.getUserStyle();
        this.mFontSize = this.mManager.getFontScale() * (float)this.getHeight() * 0.0533f;
    }

    @Override
    public void setSize(int width2, int height2) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec(width2, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(height2, 0x40000000);
        this.measure(widthSpec, heightSpec);
        this.layout(0, 0, width2, height2);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.manageChangeListener();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.manageChangeListener();
    }

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener listener2) {
        this.mListener = listener2;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
        this.manageChangeListener();
    }

    private void manageChangeListener() {
        boolean needsListener;
        boolean bl = needsListener = this.isAttachedToWindow() && this.getVisibility() == 0;
        if (this.mHasChangeListener != needsListener) {
            this.mHasChangeListener = needsListener;
            if (needsListener) {
                this.mManager.addCaptioningChangeListener(this.mCaptioningListener);
                CaptioningManager.CaptionStyle captionStyle = this.mManager.getUserStyle();
                float fontSize = this.mManager.getFontScale() * (float)this.getHeight() * 0.0533f;
                this.setCaptionStyle(captionStyle, fontSize);
            } else {
                this.mManager.removeCaptioningChangeListener(this.mCaptioningListener);
            }
        }
    }

    public void setActiveCues(Vector<SubtitleTrack.Cue> activeCues) {
        Context context = this.getContext();
        CaptioningManager.CaptionStyle captionStyle = this.mCaptionStyle;
        float fontSize = this.mFontSize;
        this.prepForPrune();
        int count = activeCues.size();
        for (int i = 0; i < count; ++i) {
            TextTrackCue cue = (TextTrackCue)activeCues.get(i);
            TextTrackRegion region = cue.mRegion;
            if (region != null) {
                RegionLayout regionBox = this.mRegionBoxes.get(region);
                if (regionBox == null) {
                    regionBox = new RegionLayout(context, region, captionStyle, fontSize);
                    this.mRegionBoxes.put(region, regionBox);
                    this.addView((View)regionBox, -2, -2);
                }
                regionBox.put(cue);
                continue;
            }
            CueLayout cueBox = this.mCueBoxes.get(cue);
            if (cueBox == null) {
                cueBox = new CueLayout(context, cue, captionStyle, fontSize);
                this.mCueBoxes.put(cue, cueBox);
                this.addView((View)cueBox, -2, -2);
            }
            cueBox.update();
            cueBox.setOrder(i);
        }
        this.prune();
        int width2 = this.getWidth();
        int height2 = this.getHeight();
        this.setSize(width2, height2);
        if (this.mListener != null) {
            this.mListener.onChanged(this);
        }
    }

    private void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float fontSize) {
        this.mCaptionStyle = captionStyle = DEFAULT_CAPTION_STYLE.applyStyle(captionStyle);
        this.mFontSize = fontSize;
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            cueBox.setCaptionStyle(captionStyle, fontSize);
        }
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            regionBox.setCaptionStyle(captionStyle, fontSize);
        }
    }

    private void prune() {
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            if (!regionBox.prune()) continue;
            this.removeView(regionBox);
            this.mRegionBoxes.removeAt(i);
            --regionCount;
            --i;
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            if (cueBox.isActive()) continue;
            this.removeView(cueBox);
            this.mCueBoxes.removeAt(i);
            --cueCount;
            --i;
        }
    }

    private void prepForPrune() {
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            regionBox.prepForPrune();
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            cueBox.prepForPrune();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            regionBox.measureForParent(widthMeasureSpec, heightMeasureSpec);
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            cueBox.measureForParent(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int viewportWidth = r - l;
        int viewportHeight = b - t;
        this.setCaptionStyle(this.mCaptionStyle, this.mManager.getFontScale() * 0.0533f * (float)viewportHeight);
        int regionCount = this.mRegionBoxes.size();
        for (int i = 0; i < regionCount; ++i) {
            RegionLayout regionBox = this.mRegionBoxes.valueAt(i);
            this.layoutRegion(viewportWidth, viewportHeight, regionBox);
        }
        int cueCount = this.mCueBoxes.size();
        for (int i = 0; i < cueCount; ++i) {
            CueLayout cueBox = this.mCueBoxes.valueAt(i);
            this.layoutCue(viewportWidth, viewportHeight, cueBox);
        }
    }

    private void layoutRegion(int viewportWidth, int viewportHeight, RegionLayout regionBox) {
        TextTrackRegion region = regionBox.getRegion();
        int regionHeight = regionBox.getMeasuredHeight();
        int regionWidth = regionBox.getMeasuredWidth();
        float x = region.mViewportAnchorPointX;
        float y = region.mViewportAnchorPointY;
        int left = (int)(x * (float)(viewportWidth - regionWidth) / 100.0f);
        int top = (int)(y * (float)(viewportHeight - regionHeight) / 100.0f);
        regionBox.layout(left, top, left + regionWidth, top + regionHeight);
    }

    private void layoutCue(int viewportWidth, int viewportHeight, CueLayout cueBox) {
        int xPosition;
        TextTrackCue cue = cueBox.getCue();
        int direction = this.getLayoutDirection();
        int absAlignment = WebVttRenderingWidget.resolveCueAlignment(direction, cue.mAlignment);
        boolean cueSnapToLines = cue.mSnapToLines;
        int size = 100 * cueBox.getMeasuredWidth() / viewportWidth;
        switch (absAlignment) {
            case 203: {
                xPosition = cue.mTextPosition;
                break;
            }
            case 204: {
                xPosition = cue.mTextPosition - size;
                break;
            }
            default: {
                xPosition = cue.mTextPosition - size / 2;
            }
        }
        if (direction == 1) {
            xPosition = 100 - xPosition;
        }
        if (cueSnapToLines) {
            float rightEdge;
            int paddingLeft = 100 * this.getPaddingLeft() / viewportWidth;
            int paddingRight = 100 * this.getPaddingRight() / viewportWidth;
            if (xPosition < paddingLeft && xPosition + size > paddingLeft) {
                xPosition += paddingLeft;
                size -= paddingLeft;
            }
            if ((float)xPosition < (rightEdge = (float)(100 - paddingRight)) && (float)(xPosition + size) > rightEdge) {
                size -= paddingRight;
            }
        }
        int left = xPosition * viewportWidth / 100;
        int width2 = size * viewportWidth / 100;
        int yPosition = this.calculateLinePosition(cueBox);
        int height2 = cueBox.getMeasuredHeight();
        int top = yPosition < 0 ? viewportHeight + yPosition * height2 : yPosition * (viewportHeight - height2) / 100;
        cueBox.layout(left, top, left + width2, top + height2);
    }

    private int calculateLinePosition(CueLayout cueBox) {
        boolean autoPosition;
        TextTrackCue cue = cueBox.getCue();
        Integer linePosition = cue.mLinePosition;
        boolean snapToLines = cue.mSnapToLines;
        boolean bl = autoPosition = linePosition == null;
        if (!(snapToLines || autoPosition || linePosition >= 0 && linePosition <= 100)) {
            return 100;
        }
        if (!autoPosition) {
            return linePosition;
        }
        if (!snapToLines) {
            return 100;
        }
        return -(cueBox.mOrder + 1);
    }

    private static int resolveCueAlignment(int layoutDirection, int alignment) {
        switch (alignment) {
            case 201: {
                return layoutDirection == 0 ? 203 : 204;
            }
            case 202: {
                return layoutDirection == 0 ? 204 : 203;
            }
        }
        return alignment;
    }

    private static class SpanLayout
    extends SubtitleView {
        private final SpannableStringBuilder mBuilder = new SpannableStringBuilder();
        private final TextTrackCueSpan[] mSpans;

        public SpanLayout(Context context, TextTrackCueSpan[] spans) {
            super(context);
            this.mSpans = spans;
            this.update();
        }

        public void update() {
            SpannableStringBuilder builder2 = this.mBuilder;
            TextTrackCueSpan[] spans = this.mSpans;
            builder2.clear();
            builder2.clearSpans();
            for (TextTrackCueSpan span : spans) {
                int i;
                if (!span.mEnabled) continue;
                builder2.append(spans[i].mText);
            }
            this.setText(builder2);
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            this.setBackgroundColor(captionStyle.backgroundColor);
            this.setForegroundColor(captionStyle.foregroundColor);
            this.setEdgeColor(captionStyle.edgeColor);
            this.setEdgeType(captionStyle.edgeType);
            this.setTypeface(captionStyle.getTypeface());
            this.setTextSize(fontSize);
        }
    }

    private static class CueLayout
    extends LinearLayout {
        public final TextTrackCue mCue;
        private CaptioningManager.CaptionStyle mCaptionStyle;
        private float mFontSize;
        private boolean mActive;
        private int mOrder;

        public CueLayout(Context context, TextTrackCue cue, CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            super(context);
            this.mCue = cue;
            this.mCaptionStyle = captionStyle;
            this.mFontSize = fontSize;
            boolean horizontal = cue.mWritingDirection == 100;
            this.setOrientation(horizontal ? 1 : 0);
            switch (cue.mAlignment) {
                case 202: {
                    this.setGravity(0x800005);
                    break;
                }
                case 203: {
                    this.setGravity(3);
                    break;
                }
                case 200: {
                    this.setGravity(horizontal ? 1 : 16);
                    break;
                }
                case 204: {
                    this.setGravity(5);
                    break;
                }
                case 201: {
                    this.setGravity(0x800003);
                }
            }
            this.update();
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle style2, float fontSize) {
            this.mCaptionStyle = style2;
            this.mFontSize = fontSize;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof SpanLayout)) continue;
                ((SpanLayout)child).setCaptionStyle(style2, fontSize);
            }
        }

        public void prepForPrune() {
            this.mActive = false;
        }

        public void update() {
            Layout.Alignment alignment;
            this.mActive = true;
            this.removeAllViews();
            int cueAlignment = WebVttRenderingWidget.resolveCueAlignment(this.getLayoutDirection(), this.mCue.mAlignment);
            switch (cueAlignment) {
                case 203: {
                    alignment = Layout.Alignment.ALIGN_LEFT;
                    break;
                }
                case 204: {
                    alignment = Layout.Alignment.ALIGN_RIGHT;
                    break;
                }
                default: {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                }
            }
            CaptioningManager.CaptionStyle captionStyle = this.mCaptionStyle;
            float fontSize = this.mFontSize;
            TextTrackCueSpan[][] lines = this.mCue.mLines;
            int lineCount = lines.length;
            for (int i = 0; i < lineCount; ++i) {
                SpanLayout lineBox = new SpanLayout(this.getContext(), lines[i]);
                lineBox.setAlignment(alignment);
                lineBox.setCaptionStyle(captionStyle, fontSize);
                this.addView((View)lineBox, -2, -2);
            }
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        public void measureForParent(int widthMeasureSpec, int heightMeasureSpec) {
            int maximumSize;
            TextTrackCue cue = this.mCue;
            int specWidth = View.MeasureSpec.getSize(widthMeasureSpec);
            int specHeight = View.MeasureSpec.getSize(heightMeasureSpec);
            int direction = this.getLayoutDirection();
            int absAlignment = WebVttRenderingWidget.resolveCueAlignment(direction, cue.mAlignment);
            switch (absAlignment) {
                case 203: {
                    maximumSize = 100 - cue.mTextPosition;
                    break;
                }
                case 204: {
                    maximumSize = cue.mTextPosition;
                    break;
                }
                case 200: {
                    if (cue.mTextPosition <= 50) {
                        maximumSize = cue.mTextPosition * 2;
                        break;
                    }
                    maximumSize = (100 - cue.mTextPosition) * 2;
                    break;
                }
                default: {
                    maximumSize = 0;
                }
            }
            int size = Math.min(cue.mSize, maximumSize) * specWidth / 100;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(size, Integer.MIN_VALUE);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(specHeight, Integer.MIN_VALUE);
            this.measure(widthMeasureSpec, heightMeasureSpec);
        }

        public void setOrder(int order) {
            this.mOrder = order;
        }

        public boolean isActive() {
            return this.mActive;
        }

        public TextTrackCue getCue() {
            return this.mCue;
        }
    }

    private static class RegionLayout
    extends LinearLayout {
        private final ArrayList<CueLayout> mRegionCueBoxes = new ArrayList();
        private final TextTrackRegion mRegion;
        private CaptioningManager.CaptionStyle mCaptionStyle;
        private float mFontSize;

        public RegionLayout(Context context, TextTrackRegion region, CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            super(context);
            this.mRegion = region;
            this.mCaptionStyle = captionStyle;
            this.mFontSize = fontSize;
            this.setOrientation(1);
            this.setBackgroundColor(captionStyle.windowColor);
        }

        public void setCaptionStyle(CaptioningManager.CaptionStyle captionStyle, float fontSize) {
            this.mCaptionStyle = captionStyle;
            this.mFontSize = fontSize;
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                cueBox.setCaptionStyle(captionStyle, fontSize);
            }
            this.setBackgroundColor(captionStyle.windowColor);
        }

        public void measureForParent(int widthMeasureSpec, int heightMeasureSpec) {
            TextTrackRegion region = this.mRegion;
            int specWidth = View.MeasureSpec.getSize(widthMeasureSpec);
            int specHeight = View.MeasureSpec.getSize(heightMeasureSpec);
            int width2 = (int)region.mWidth;
            int size = width2 * specWidth / 100;
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(size, Integer.MIN_VALUE);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(specHeight, Integer.MIN_VALUE);
            this.measure(widthMeasureSpec, heightMeasureSpec);
        }

        public void prepForPrune() {
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                cueBox.prepForPrune();
            }
        }

        public void put(TextTrackCue cue) {
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                if (cueBox.getCue() != cue) continue;
                cueBox.update();
                return;
            }
            CueLayout cueBox = new CueLayout(this.getContext(), cue, this.mCaptionStyle, this.mFontSize);
            this.mRegionCueBoxes.add(cueBox);
            this.addView((View)cueBox, -2, -2);
            if (this.getChildCount() > this.mRegion.mLines) {
                this.removeViewAt(0);
            }
        }

        public boolean prune() {
            int cueCount = this.mRegionCueBoxes.size();
            for (int i = 0; i < cueCount; ++i) {
                CueLayout cueBox = this.mRegionCueBoxes.get(i);
                if (cueBox.isActive()) continue;
                this.mRegionCueBoxes.remove(i);
                this.removeView(cueBox);
                --cueCount;
                --i;
            }
            return this.mRegionCueBoxes.isEmpty();
        }

        public TextTrackRegion getRegion() {
            return this.mRegion;
        }
    }
}

