/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleTrack;
import android.media.TextTrackCue;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.media.Tokenizer;
import android.media.UnstyledTextExtractor;
import android.media.WebVttCueListener;
import android.media.WebVttParser;
import android.media.WebVttRenderingWidget;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class WebVttTrack
extends SubtitleTrack
implements WebVttCueListener {
    private static final String TAG = "WebVttTrack";
    private final WebVttParser mParser = new WebVttParser(this);
    private final UnstyledTextExtractor mExtractor = new UnstyledTextExtractor();
    private final Tokenizer mTokenizer = new Tokenizer(this.mExtractor);
    private final Vector<Long> mTimestamps = new Vector();
    private final WebVttRenderingWidget mRenderingWidget;
    private final Map<String, TextTrackRegion> mRegions = new HashMap<String, TextTrackRegion>();
    private Long mCurrentRunID;

    WebVttTrack(WebVttRenderingWidget renderingWidget, MediaFormat format) {
        super(format);
        this.mRenderingWidget = renderingWidget;
    }

    @Override
    public WebVttRenderingWidget getRenderingWidget() {
        return this.mRenderingWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onData(byte[] data, boolean eos, long runID) {
        try {
            String str = new String(data, "UTF-8");
            WebVttParser webVttParser = this.mParser;
            synchronized (webVttParser) {
                if (this.mCurrentRunID != null && runID != this.mCurrentRunID) {
                    throw new IllegalStateException("Run #" + this.mCurrentRunID + " in progress.  Cannot process run #" + runID);
                }
                this.mCurrentRunID = runID;
                this.mParser.parse(str);
                if (eos) {
                    this.finishedRun(runID);
                    this.mParser.eos();
                    this.mRegions.clear();
                    this.mCurrentRunID = null;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.w(TAG, "subtitle data is not UTF-8 encoded: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCueParsed(TextTrackCue cue) {
        WebVttParser webVttParser = this.mParser;
        synchronized (webVttParser) {
            if (cue.mRegionId.length() != 0) {
                cue.mRegion = this.mRegions.get(cue.mRegionId);
            }
            if (this.DEBUG) {
                Log.v(TAG, "adding cue " + cue);
            }
            this.mTokenizer.reset();
            for (String s : cue.mStrings) {
                this.mTokenizer.tokenize(s);
            }
            cue.mLines = this.mExtractor.getText();
            if (this.DEBUG) {
                Log.v(TAG, cue.appendLinesToBuilder(cue.appendStringsToBuilder(new StringBuilder()).append(" simplified to: ")).toString());
            }
            String[] stringArray = cue.mLines;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line;
                for (String span : line = stringArray[i]) {
                    if (((TextTrackCueSpan)((Object)span)).mTimestampMs <= cue.mStartTimeMs || ((TextTrackCueSpan)((Object)span)).mTimestampMs >= cue.mEndTimeMs || this.mTimestamps.contains(((TextTrackCueSpan)((Object)span)).mTimestampMs)) continue;
                    this.mTimestamps.add(((TextTrackCueSpan)((Object)span)).mTimestampMs);
                }
            }
            if (this.mTimestamps.size() > 0) {
                cue.mInnerTimesMs = new long[this.mTimestamps.size()];
                for (int ix = 0; ix < this.mTimestamps.size(); ++ix) {
                    cue.mInnerTimesMs[ix] = this.mTimestamps.get(ix);
                }
                this.mTimestamps.clear();
            } else {
                cue.mInnerTimesMs = null;
            }
            cue.mRunID = this.mCurrentRunID;
        }
        this.addCue(cue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRegionParsed(TextTrackRegion region) {
        WebVttParser webVttParser = this.mParser;
        synchronized (webVttParser) {
            this.mRegions.put(region.mId, region);
        }
    }

    @Override
    public void updateView(Vector<SubtitleTrack.Cue> activeCues) {
        if (!this.mVisible) {
            return;
        }
        if (this.DEBUG && this.mTimeProvider != null) {
            try {
                Log.d(TAG, "at " + this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L + " ms the active cues are:");
            }
            catch (IllegalStateException e) {
                Log.d(TAG, "at (illegal state) the active cues are:");
            }
        }
        if (this.mRenderingWidget != null) {
            this.mRenderingWidget.setActiveCues(activeCues);
        }
    }
}

