/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.AudioRouting;
import android.media.AudioTrack;
import android.media.IAudioService;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.media.projection.MediaProjection;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@SystemApi
public class AudioPolicy {
    private static final String TAG = "AudioPolicy";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    public static final int POLICY_STATUS_UNREGISTERED = 1;
    public static final int POLICY_STATUS_REGISTERED = 2;
    private int mStatus;
    private String mRegistrationId;
    private AudioPolicyStatusListener mStatusListener;
    private boolean mIsFocusPolicy;
    private boolean mIsTestFocusPolicy;
    @GuardedBy(value={"mLock"})
    private ArrayList<WeakReference<AudioTrack>> mInjectors;
    @GuardedBy(value={"mLock"})
    private ArrayList<WeakReference<AudioRecord>> mCaptors;
    public static final int FOCUS_POLICY_DUCKING_IN_APP = 0;
    public static final int FOCUS_POLICY_DUCKING_DEFAULT = 0;
    public static final int FOCUS_POLICY_DUCKING_IN_POLICY = 1;
    private AudioPolicyFocusListener mFocusListener;
    private final AudioPolicyVolumeCallback mVolCb;
    private Context mContext;
    private AudioPolicyConfig mConfig;
    private final MediaProjection mProjection;
    private final IAudioPolicyCallback mPolicyCb = new IAudioPolicyCallback.Stub(){

        @Override
        public void notifyAudioFocusGrant(AudioFocusInfo afi, int requestResult) {
            AudioPolicy.this.sendMsg(1, afi, requestResult);
        }

        @Override
        public void notifyAudioFocusLoss(AudioFocusInfo afi, boolean wasNotified) {
            AudioPolicy.this.sendMsg(2, afi, wasNotified ? 1 : 0);
        }

        @Override
        public void notifyAudioFocusRequest(AudioFocusInfo afi, int requestResult) {
            AudioPolicy.this.sendMsg(4, afi, requestResult);
        }

        @Override
        public void notifyAudioFocusAbandon(AudioFocusInfo afi) {
            AudioPolicy.this.sendMsg(5, afi, 0);
        }

        @Override
        public void notifyMixStateUpdate(String regId, int state) {
            for (AudioMix mix : AudioPolicy.this.mConfig.getMixes()) {
                if (!mix.getRegistration().equals(regId)) continue;
                mix.mMixState = state;
                AudioPolicy.this.sendMsg(3, mix, 0);
            }
        }

        @Override
        public void notifyVolumeAdjust(int adjustment) {
            AudioPolicy.this.sendMsg(6, null, adjustment);
        }

        @Override
        public void notifyUnregistration() {
            AudioPolicy.this.setRegistration(null);
        }
    };
    private final EventHandler mEventHandler;
    private static final int MSG_POLICY_STATUS_CHANGE = 0;
    private static final int MSG_FOCUS_GRANT = 1;
    private static final int MSG_FOCUS_LOSS = 2;
    private static final int MSG_MIX_STATE_UPDATE = 3;
    private static final int MSG_FOCUS_REQUEST = 4;
    private static final int MSG_FOCUS_ABANDON = 5;
    private static final int MSG_VOL_ADJUST = 6;
    private static IAudioService sService;

    public AudioPolicyConfig getConfig() {
        return this.mConfig;
    }

    public boolean hasFocusListener() {
        return this.mFocusListener != null;
    }

    public boolean isFocusPolicy() {
        return this.mIsFocusPolicy;
    }

    public boolean isTestFocusPolicy() {
        return this.mIsTestFocusPolicy;
    }

    public boolean isVolumeController() {
        return this.mVolCb != null;
    }

    public MediaProjection getMediaProjection() {
        return this.mProjection;
    }

    private AudioPolicy(AudioPolicyConfig config, Context context, Looper looper, AudioPolicyFocusListener fl, AudioPolicyStatusListener sl, boolean isFocusPolicy, boolean isTestFocusPolicy, AudioPolicyVolumeCallback vc, MediaProjection projection) {
        this.mConfig = config;
        this.mStatus = 1;
        this.mContext = context;
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, looper);
        } else {
            this.mEventHandler = null;
            Log.e(TAG, "No event handler due to looper without a thread");
        }
        this.mFocusListener = fl;
        this.mStatusListener = sl;
        this.mIsFocusPolicy = isFocusPolicy;
        this.mIsTestFocusPolicy = isTestFocusPolicy;
        this.mVolCb = vc;
        this.mProjection = projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int attachMixes(List<AudioMix> mixes) {
        if (mixes == null) {
            throw new IllegalArgumentException("Illegal null list of AudioMix");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot alter unregistered AudioPolicy");
            }
            ArrayList<AudioMix> zeMixes = new ArrayList<AudioMix>(mixes.size());
            for (AudioMix mix : mixes) {
                if (mix == null) {
                    throw new IllegalArgumentException("Illegal null AudioMix in attachMixes");
                }
                zeMixes.add(mix);
            }
            AudioPolicyConfig cfg = new AudioPolicyConfig(zeMixes);
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.addMixForPolicy(cfg, this.cb());
                if (status == 0) {
                    this.mConfig.add(zeMixes);
                }
                return status;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in attachMixes", e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detachMixes(List<AudioMix> mixes) {
        if (mixes == null) {
            throw new IllegalArgumentException("Illegal null list of AudioMix");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot alter unregistered AudioPolicy");
            }
            ArrayList<AudioMix> zeMixes = new ArrayList<AudioMix>(mixes.size());
            for (AudioMix mix : mixes) {
                if (mix == null) {
                    throw new IllegalArgumentException("Illegal null AudioMix in detachMixes");
                }
                zeMixes.add(mix);
            }
            AudioPolicyConfig cfg = new AudioPolicyConfig(zeMixes);
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.removeMixForPolicy(cfg, this.cb());
                if (status == 0) {
                    this.mConfig.remove(zeMixes);
                }
                return status;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in detachMixes", e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean setUidDeviceAffinity(int uid, List<AudioDeviceInfo> devices) {
        if (devices == null) {
            throw new IllegalArgumentException("Illegal null list of audio devices");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot use unregistered AudioPolicy");
            }
            int[] deviceTypes = new int[devices.size()];
            String[] deviceAdresses = new String[devices.size()];
            int i = 0;
            for (AudioDeviceInfo device : devices) {
                if (device == null) {
                    throw new IllegalArgumentException("Illegal null AudioDeviceInfo in setUidDeviceAffinity");
                }
                deviceTypes[i] = AudioDeviceInfo.convertDeviceTypeToInternalDevice(device.getType());
                deviceAdresses[i] = device.getAddress();
                ++i;
            }
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.setUidDeviceAffinity(this.cb(), uid, deviceTypes, deviceAdresses);
                return status == 0;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in setUidDeviceAffinity", e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean removeUidDeviceAffinity(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot use unregistered AudioPolicy");
            }
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.removeUidDeviceAffinity(this.cb(), uid);
                return status == 0;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in removeUidDeviceAffinity", e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean removeUserIdDeviceAffinity(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot use unregistered AudioPolicy");
            }
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.removeUserIdDeviceAffinity(this.cb(), userId);
                return status == 0;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in removeUserIdDeviceAffinity", e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean setUserIdDeviceAffinity(int userId, List<AudioDeviceInfo> devices) {
        Objects.requireNonNull(devices, "Illegal null list of audio devices");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot use unregistered AudioPolicy");
            }
            int[] deviceTypes = new int[devices.size()];
            String[] deviceAddresses = new String[devices.size()];
            int i = 0;
            for (AudioDeviceInfo device : devices) {
                if (device == null) {
                    throw new IllegalArgumentException("Illegal null AudioDeviceInfo in setUserIdDeviceAffinity");
                }
                deviceTypes[i] = AudioDeviceInfo.convertDeviceTypeToInternalDevice(device.getType());
                deviceAddresses[i] = device.getAddress();
                ++i;
            }
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.setUserIdDeviceAffinity(this.cb(), userId, deviceTypes, deviceAddresses);
                return status == 0;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in setUserIdDeviceAffinity", e);
                return false;
            }
        }
    }

    public void reset() {
        this.setRegistration(null);
        this.mConfig.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegistration(String regId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRegistrationId = regId;
            this.mConfig.setRegistration(regId);
            this.mStatus = regId != null ? 2 : 1;
        }
        this.sendMsg(0);
    }

    public String getRegistration() {
        return this.mRegistrationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean policyReadyToUse() {
        boolean canProjectAudio;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                Log.e(TAG, "Cannot use unregistered AudioPolicy");
                return false;
            }
            if (this.mRegistrationId == null) {
                Log.e(TAG, "Cannot use unregistered AudioPolicy");
                return false;
            }
        }
        boolean canModifyAudioRouting = 0 == this.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        boolean canInterceptCallAudio = 0 == this.checkCallingOrSelfPermission("android.permission.CALL_AUDIO_INTERCEPTION");
        try {
            canProjectAudio = this.mProjection != null && this.mProjection.getProjection().canProjectAudio();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to check if MediaProjection#canProjectAudio");
            throw e.rethrowFromSystemServer();
        }
        if (!(this.isLoopbackRenderPolicy() && canProjectAudio || this.isCallRedirectionPolicy() && canInterceptCallAudio || canModifyAudioRouting)) {
            Slog.w(TAG, "Cannot use AudioPolicy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", needs MODIFY_AUDIO_ROUTING or MediaProjection that can project audio.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoopbackRenderPolicy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfig.mMixes.stream().allMatch(mix -> mix.getRouteFlags() == (1 | 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCallRedirectionPolicy() {
        Object object = this.mLock;
        synchronized (object) {
            for (AudioMix mix : this.mConfig.mMixes) {
                if (!mix.isForCallRedirection()) continue;
                return true;
            }
            return false;
        }
    }

    private int checkCallingOrSelfPermission(String permission2) {
        if (this.mContext != null) {
            return this.mContext.checkCallingOrSelfPermission(permission2);
        }
        Slog.v(TAG, "Null context, checking permission via ActivityManager");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        try {
            return ActivityManager.getService().checkPermission(permission2, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void checkMixReadyToUse(AudioMix mix, boolean forTrack) throws IllegalArgumentException {
        if (mix == null) {
            String msg = forTrack ? "Invalid null AudioMix for AudioTrack creation" : "Invalid null AudioMix for AudioRecord creation";
            throw new IllegalArgumentException(msg);
        }
        if (!this.mConfig.mMixes.contains(mix)) {
            throw new IllegalArgumentException("Invalid mix: not part of this policy");
        }
        if ((mix.getRouteFlags() & 2) != 2) {
            throw new IllegalArgumentException("Invalid AudioMix: not defined for loop back");
        }
        if (forTrack && mix.getMixType() != 1) {
            throw new IllegalArgumentException("Invalid AudioMix: not defined for being a recording source");
        }
        if (!forTrack && mix.getMixType() != 0) {
            throw new IllegalArgumentException("Invalid AudioMix: not defined for capturing playback");
        }
    }

    public int getFocusDuckingBehavior() {
        return this.mConfig.mDuckingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFocusDuckingBehavior(int behavior) throws IllegalArgumentException, IllegalStateException {
        if (behavior != 0 && behavior != 1) {
            throw new IllegalArgumentException("Invalid ducking behavior " + behavior);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot change ducking behavior for unregistered policy");
            }
            if (behavior == 1 && this.mFocusListener == null) {
                throw new IllegalStateException("Cannot handle ducking without an audio focus listener");
            }
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.setFocusPropertiesForPolicy(behavior, this.cb());
                if (status == 0) {
                    this.mConfig.mDuckingPolicy = behavior;
                }
                return status;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead object in setFocusPropertiesForPolicy for behavior", e);
                return -1;
            }
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public List<AudioFocusInfo> getFocusStack() {
        try {
            return AudioPolicy.getService().getFocusStack();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public boolean sendFocusLoss(AudioFocusInfo focusLoser) throws IllegalStateException {
        Objects.requireNonNull(focusLoser);
        try {
            return AudioPolicy.getService().sendFocusLoss(focusLoser, this.cb());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioRecord createAudioRecordSink(AudioMix mix) throws IllegalArgumentException {
        if (!this.policyReadyToUse()) {
            Log.e(TAG, "Cannot create AudioRecord sink for AudioMix");
            return null;
        }
        this.checkMixReadyToUse(mix, false);
        AudioFormat mixFormat = new AudioFormat.Builder(mix.getFormat()).setChannelMask(AudioFormat.inChannelMaskFromOutChannelMask(mix.getFormat().getChannelMask())).build();
        AudioAttributes.Builder ab = new AudioAttributes.Builder().setInternalCapturePreset(8).addTag(AudioPolicy.addressForTag(mix)).addTag("fixedVolume");
        if (mix.isForCallRedirection()) {
            ab.setForCallRedirection();
        }
        AudioRecord ar = new AudioRecord(ab.build(), mixFormat, AudioRecord.getMinBufferSize(mix.getFormat().getSampleRate(), 12, mix.getFormat().getEncoding()), 0);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCaptors == null) {
                this.mCaptors = new ArrayList(1);
            }
            this.mCaptors.add(new WeakReference<AudioRecord>(ar));
        }
        return ar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioTrack createAudioTrackSource(AudioMix mix) throws IllegalArgumentException {
        if (!this.policyReadyToUse()) {
            Log.e(TAG, "Cannot create AudioTrack source for AudioMix");
            return null;
        }
        this.checkMixReadyToUse(mix, true);
        AudioAttributes.Builder ab = new AudioAttributes.Builder().setUsage(15).addTag(AudioPolicy.addressForTag(mix));
        if (mix.isForCallRedirection()) {
            ab.setForCallRedirection();
        }
        AudioTrack at = new AudioTrack(ab.build(), mix.getFormat(), AudioTrack.getMinBufferSize(mix.getFormat().getSampleRate(), mix.getFormat().getChannelMask(), mix.getFormat().getEncoding()), 1, 0);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInjectors == null) {
                this.mInjectors = new ArrayList(1);
            }
            this.mInjectors.add(new WeakReference<AudioTrack>(at));
        }
        return at;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCaptorsAndInjectors() {
        if (!this.policyReadyToUse()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            Iterator<WeakReference<AudioRouting>> iterator;
            if (this.mInjectors != null) {
                WeakReference<AudioRouting> weakTrack;
                AudioTrack track;
                iterator = this.mInjectors.iterator();
                while (iterator.hasNext() && (track = (AudioTrack)(weakTrack = iterator.next()).get()) != null) {
                    try {
                        track.stop();
                        track.flush();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            if (this.mCaptors != null) {
                WeakReference<AudioRouting> weakRecord;
                AudioRecord record;
                iterator = this.mCaptors.iterator();
                while (iterator.hasNext() && (record = (AudioRecord)(weakRecord = iterator.next()).get()) != null) {
                    try {
                        record.stop();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
    }

    public int getStatus() {
        return this.mStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPolicyStatusChange() {
        AudioPolicyStatusListener l;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatusListener == null) {
                return;
            }
            l = this.mStatusListener;
        }
        l.onStatusChange();
    }

    public IAudioPolicyCallback cb() {
        return this.mPolicyCb;
    }

    private static String addressForTag(AudioMix mix) {
        return "addr=" + mix.getRegistration();
    }

    private void sendMsg(int msg) {
        if (this.mEventHandler != null) {
            this.mEventHandler.sendEmptyMessage(msg);
        }
    }

    private void sendMsg(int msg, Object obj, int i) {
        if (this.mEventHandler != null) {
            this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(msg, i, 0, obj));
        }
    }

    private static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    public String toLogFriendlyString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicy:\n");
        textDump = textDump + "config=" + this.mConfig.toLogFriendlyString();
        return textDump;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyStatus {
    }

    private class EventHandler
    extends Handler {
        public EventHandler(AudioPolicy ap, Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AudioPolicy.this.onPolicyStatusChange();
                    break;
                }
                case 1: {
                    if (AudioPolicy.this.mFocusListener == null) break;
                    AudioPolicy.this.mFocusListener.onAudioFocusGrant((AudioFocusInfo)msg.obj, msg.arg1);
                    break;
                }
                case 2: {
                    if (AudioPolicy.this.mFocusListener == null) break;
                    AudioPolicy.this.mFocusListener.onAudioFocusLoss((AudioFocusInfo)msg.obj, msg.arg1 != 0);
                    break;
                }
                case 3: {
                    if (AudioPolicy.this.mStatusListener == null) break;
                    AudioPolicy.this.mStatusListener.onMixStateUpdate((AudioMix)msg.obj);
                    break;
                }
                case 4: {
                    if (AudioPolicy.this.mFocusListener != null) {
                        AudioPolicy.this.mFocusListener.onAudioFocusRequest((AudioFocusInfo)msg.obj, msg.arg1);
                        break;
                    }
                    Log.e(AudioPolicy.TAG, "Invalid null focus listener for focus request event");
                    break;
                }
                case 5: {
                    if (AudioPolicy.this.mFocusListener != null) {
                        AudioPolicy.this.mFocusListener.onAudioFocusAbandon((AudioFocusInfo)msg.obj);
                        break;
                    }
                    Log.e(AudioPolicy.TAG, "Invalid null focus listener for focus abandon event");
                    break;
                }
                case 6: {
                    if (AudioPolicy.this.mVolCb != null) {
                        AudioPolicy.this.mVolCb.onVolumeAdjustment(msg.arg1);
                        break;
                    }
                    Log.e(AudioPolicy.TAG, "Invalid null volume event");
                    break;
                }
                default: {
                    Log.e(AudioPolicy.TAG, "Unknown event " + msg.what);
                }
            }
        }
    }

    public static abstract class AudioPolicyVolumeCallback {
        public void onVolumeAdjustment(int adjustment) {
        }
    }

    public static abstract class AudioPolicyFocusListener {
        public void onAudioFocusGrant(AudioFocusInfo afi, int requestResult) {
        }

        public void onAudioFocusLoss(AudioFocusInfo afi, boolean wasNotified) {
        }

        public void onAudioFocusRequest(AudioFocusInfo afi, int requestResult) {
        }

        public void onAudioFocusAbandon(AudioFocusInfo afi) {
        }
    }

    public static abstract class AudioPolicyStatusListener {
        public void onStatusChange() {
        }

        public void onMixStateUpdate(AudioMix mix) {
        }
    }

    public static class Builder {
        private ArrayList<AudioMix> mMixes = new ArrayList();
        private Context mContext;
        private Looper mLooper;
        private AudioPolicyFocusListener mFocusListener;
        private AudioPolicyStatusListener mStatusListener;
        private boolean mIsFocusPolicy = false;
        private boolean mIsTestFocusPolicy = false;
        private AudioPolicyVolumeCallback mVolCb;
        private MediaProjection mProjection;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder addMix(AudioMix mix) throws IllegalArgumentException {
            if (mix == null) {
                throw new IllegalArgumentException("Illegal null AudioMix argument");
            }
            this.mMixes.add(mix);
            return this;
        }

        public Builder setLooper(Looper looper) throws IllegalArgumentException {
            if (looper == null) {
                throw new IllegalArgumentException("Illegal null Looper argument");
            }
            this.mLooper = looper;
            return this;
        }

        public void setAudioPolicyFocusListener(AudioPolicyFocusListener l) {
            this.mFocusListener = l;
        }

        public Builder setIsAudioFocusPolicy(boolean isFocusPolicy) {
            this.mIsFocusPolicy = isFocusPolicy;
            return this;
        }

        public Builder setIsTestFocusPolicy(boolean isTestFocusPolicy) {
            this.mIsTestFocusPolicy = isTestFocusPolicy;
            return this;
        }

        public void setAudioPolicyStatusListener(AudioPolicyStatusListener l) {
            this.mStatusListener = l;
        }

        public Builder setAudioPolicyVolumeCallback(AudioPolicyVolumeCallback vc) {
            if (vc == null) {
                throw new IllegalArgumentException("Invalid null volume callback");
            }
            this.mVolCb = vc;
            return this;
        }

        public Builder setMediaProjection(MediaProjection projection) {
            if (projection == null) {
                throw new IllegalArgumentException("Invalid null volume callback");
            }
            this.mProjection = projection;
            return this;
        }

        public AudioPolicy build() {
            if (this.mStatusListener != null) {
                for (AudioMix mix : this.mMixes) {
                    mix.mCallbackFlags |= 1;
                }
            }
            if (this.mIsFocusPolicy && this.mFocusListener == null) {
                throw new IllegalStateException("Cannot be a focus policy without an AudioPolicyFocusListener");
            }
            return new AudioPolicy(new AudioPolicyConfig(this.mMixes), this.mContext, this.mLooper, this.mFocusListener, this.mStatusListener, this.mIsFocusPolicy, this.mIsTestFocusPolicy, this.mVolCb, this.mProjection);
        }
    }
}

