/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.bluetooth.BluetoothDevice;
import android.media.midi.IMidiDeviceListener;
import android.media.midi.IMidiDeviceOpenCallback;
import android.media.midi.IMidiDeviceServer;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiDeviceStatus;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IMidiManager
extends IInterface {
    public MidiDeviceInfo[] getDevices() throws RemoteException;

    public MidiDeviceInfo[] getDevicesForTransport(int var1) throws RemoteException;

    public void registerListener(IBinder var1, IMidiDeviceListener var2) throws RemoteException;

    public void unregisterListener(IBinder var1, IMidiDeviceListener var2) throws RemoteException;

    public void openDevice(IBinder var1, MidiDeviceInfo var2, IMidiDeviceOpenCallback var3) throws RemoteException;

    public void openBluetoothDevice(IBinder var1, BluetoothDevice var2, IMidiDeviceOpenCallback var3) throws RemoteException;

    public void closeDevice(IBinder var1, IBinder var2) throws RemoteException;

    public MidiDeviceInfo registerDeviceServer(IMidiDeviceServer var1, int var2, int var3, String[] var4, String[] var5, Bundle var6, int var7, int var8) throws RemoteException;

    public void unregisterDeviceServer(IMidiDeviceServer var1) throws RemoteException;

    public MidiDeviceInfo getServiceDeviceInfo(String var1, String var2) throws RemoteException;

    public MidiDeviceStatus getDeviceStatus(MidiDeviceInfo var1) throws RemoteException;

    public void setDeviceStatus(IMidiDeviceServer var1, MidiDeviceStatus var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMidiManager {
        public static final String DESCRIPTOR = "android.media.midi.IMidiManager";
        static final int TRANSACTION_getDevices = 1;
        static final int TRANSACTION_getDevicesForTransport = 2;
        static final int TRANSACTION_registerListener = 3;
        static final int TRANSACTION_unregisterListener = 4;
        static final int TRANSACTION_openDevice = 5;
        static final int TRANSACTION_openBluetoothDevice = 6;
        static final int TRANSACTION_closeDevice = 7;
        static final int TRANSACTION_registerDeviceServer = 8;
        static final int TRANSACTION_unregisterDeviceServer = 9;
        static final int TRANSACTION_getServiceDeviceInfo = 10;
        static final int TRANSACTION_getDeviceStatus = 11;
        static final int TRANSACTION_setDeviceStatus = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMidiManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMidiManager) {
                return (IMidiManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDevices";
                }
                case 2: {
                    return "getDevicesForTransport";
                }
                case 3: {
                    return "registerListener";
                }
                case 4: {
                    return "unregisterListener";
                }
                case 5: {
                    return "openDevice";
                }
                case 6: {
                    return "openBluetoothDevice";
                }
                case 7: {
                    return "closeDevice";
                }
                case 8: {
                    return "registerDeviceServer";
                }
                case 9: {
                    return "unregisterDeviceServer";
                }
                case 10: {
                    return "getServiceDeviceInfo";
                }
                case 11: {
                    return "getDeviceStatus";
                }
                case 12: {
                    return "setDeviceStatus";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Parcelable[] _result = this.getDevices();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getDevicesForTransport(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    IMidiDeviceListener _arg1 = IMidiDeviceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    IMidiDeviceListener _arg1 = IMidiDeviceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    MidiDeviceInfo _arg1 = data.readTypedObject(MidiDeviceInfo.CREATOR);
                    IMidiDeviceOpenCallback _arg2 = IMidiDeviceOpenCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.openDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    IMidiDeviceOpenCallback _arg2 = IMidiDeviceOpenCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.openBluetoothDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.closeDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IMidiDeviceServer _arg0 = IMidiDeviceServer.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String[] _arg3 = data.createStringArray();
                    String[] _arg4 = data.createStringArray();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    MidiDeviceInfo _result = this.registerDeviceServer(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    IMidiDeviceServer _arg0 = IMidiDeviceServer.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDeviceServer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    MidiDeviceInfo _result = this.getServiceDeviceInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    MidiDeviceInfo _arg0 = data.readTypedObject(MidiDeviceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    MidiDeviceStatus _result = this.getDeviceStatus(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    IMidiDeviceServer _arg0 = IMidiDeviceServer.Stub.asInterface(data.readStrongBinder());
                    MidiDeviceStatus _arg1 = data.readTypedObject(MidiDeviceStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDeviceStatus(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IMidiManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MidiDeviceInfo[] getDevices() throws RemoteException {
                MidiDeviceInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(MidiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MidiDeviceInfo[] getDevicesForTransport(int transport) throws RemoteException {
                MidiDeviceInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(transport);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(MidiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(IBinder clientToken, IMidiDeviceListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterListener(IBinder clientToken, IMidiDeviceListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openDevice(IBinder clientToken, MidiDeviceInfo device, IMidiDeviceOpenCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeTypedObject(device, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openBluetoothDevice(IBinder clientToken, BluetoothDevice bluetoothDevice, IMidiDeviceOpenCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeTypedObject(bluetoothDevice, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeDevice(IBinder clientToken, IBinder deviceToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongBinder(deviceToken);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MidiDeviceInfo registerDeviceServer(IMidiDeviceServer server, int numInputPorts, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties2, int type, int defaultProtocol) throws RemoteException {
                MidiDeviceInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(server);
                    _data.writeInt(numInputPorts);
                    _data.writeInt(numOutputPorts);
                    _data.writeStringArray(inputPortNames);
                    _data.writeStringArray(outputPortNames);
                    _data.writeTypedObject(properties2, 0);
                    _data.writeInt(type);
                    _data.writeInt(defaultProtocol);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MidiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDeviceServer(IMidiDeviceServer server) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(server);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MidiDeviceInfo getServiceDeviceInfo(String packageName, String className) throws RemoteException {
                MidiDeviceInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(className);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MidiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MidiDeviceStatus getDeviceStatus(MidiDeviceInfo deviceInfo) throws RemoteException {
                MidiDeviceStatus _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(deviceInfo, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MidiDeviceStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceStatus(IMidiDeviceServer server, MidiDeviceStatus status) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(server);
                    _data.writeTypedObject(status, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMidiManager {
        @Override
        public MidiDeviceInfo[] getDevices() throws RemoteException {
            return null;
        }

        @Override
        public MidiDeviceInfo[] getDevicesForTransport(int transport) throws RemoteException {
            return null;
        }

        @Override
        public void registerListener(IBinder clientToken, IMidiDeviceListener listener2) throws RemoteException {
        }

        @Override
        public void unregisterListener(IBinder clientToken, IMidiDeviceListener listener2) throws RemoteException {
        }

        @Override
        public void openDevice(IBinder clientToken, MidiDeviceInfo device, IMidiDeviceOpenCallback callback2) throws RemoteException {
        }

        @Override
        public void openBluetoothDevice(IBinder clientToken, BluetoothDevice bluetoothDevice, IMidiDeviceOpenCallback callback2) throws RemoteException {
        }

        @Override
        public void closeDevice(IBinder clientToken, IBinder deviceToken) throws RemoteException {
        }

        @Override
        public MidiDeviceInfo registerDeviceServer(IMidiDeviceServer server, int numInputPorts, int numOutputPorts, String[] inputPortNames, String[] outputPortNames, Bundle properties2, int type, int defaultProtocol) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterDeviceServer(IMidiDeviceServer server) throws RemoteException {
        }

        @Override
        public MidiDeviceInfo getServiceDeviceInfo(String packageName, String className) throws RemoteException {
            return null;
        }

        @Override
        public MidiDeviceStatus getDeviceStatus(MidiDeviceInfo deviceInfo) throws RemoteException {
            return null;
        }

        @Override
        public void setDeviceStatus(IMidiDeviceServer server, MidiDeviceStatus status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

