/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.media.projection.IMediaProjectionCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.WindowContainerToken;

public interface IMediaProjection
extends IInterface {
    public void start(IMediaProjectionCallback var1) throws RemoteException;

    public void stop() throws RemoteException;

    public boolean canProjectAudio() throws RemoteException;

    public boolean canProjectVideo() throws RemoteException;

    public boolean canProjectSecureVideo() throws RemoteException;

    public int applyVirtualDisplayFlags(int var1) throws RemoteException;

    public void registerCallback(IMediaProjectionCallback var1) throws RemoteException;

    public void unregisterCallback(IMediaProjectionCallback var1) throws RemoteException;

    public WindowContainerToken getTaskRecordingWindowContainerToken() throws RemoteException;

    public void setTaskRecordingWindowContainerToken(WindowContainerToken var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaProjection {
        public static final String DESCRIPTOR = "android.media.projection.IMediaProjection";
        static final int TRANSACTION_start = 1;
        static final int TRANSACTION_stop = 2;
        static final int TRANSACTION_canProjectAudio = 3;
        static final int TRANSACTION_canProjectVideo = 4;
        static final int TRANSACTION_canProjectSecureVideo = 5;
        static final int TRANSACTION_applyVirtualDisplayFlags = 6;
        static final int TRANSACTION_registerCallback = 7;
        static final int TRANSACTION_unregisterCallback = 8;
        static final int TRANSACTION_getTaskRecordingWindowContainerToken = 9;
        static final int TRANSACTION_setTaskRecordingWindowContainerToken = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaProjection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaProjection) {
                return (IMediaProjection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "start";
                }
                case 2: {
                    return "stop";
                }
                case 3: {
                    return "canProjectAudio";
                }
                case 4: {
                    return "canProjectVideo";
                }
                case 5: {
                    return "canProjectSecureVideo";
                }
                case 6: {
                    return "applyVirtualDisplayFlags";
                }
                case 7: {
                    return "registerCallback";
                }
                case 8: {
                    return "unregisterCallback";
                }
                case 9: {
                    return "getTaskRecordingWindowContainerToken";
                }
                case 10: {
                    return "setTaskRecordingWindowContainerToken";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IMediaProjectionCallback _arg0 = IMediaProjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.start(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.stop();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _result = this.canProjectAudio();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    boolean _result = this.canProjectVideo();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    boolean _result = this.canProjectSecureVideo();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.applyVirtualDisplayFlags(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    IMediaProjectionCallback _arg0 = IMediaProjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IMediaProjectionCallback _arg0 = IMediaProjectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    WindowContainerToken _result = this.getTaskRecordingWindowContainerToken();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    WindowContainerToken _arg0 = data.readTypedObject(WindowContainerToken.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTaskRecordingWindowContainerToken(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IMediaProjection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(IMediaProjectionCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canProjectAudio() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canProjectVideo() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canProjectSecureVideo() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int applyVirtualDisplayFlags(int flags) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IMediaProjectionCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(IMediaProjectionCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContainerToken getTaskRecordingWindowContainerToken() throws RemoteException {
                WindowContainerToken _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContainerToken.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskRecordingWindowContainerToken(WindowContainerToken token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(token, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaProjection {
        @Override
        public void start(IMediaProjectionCallback callback2) throws RemoteException {
        }

        @Override
        public void stop() throws RemoteException {
        }

        @Override
        public boolean canProjectAudio() throws RemoteException {
            return false;
        }

        @Override
        public boolean canProjectVideo() throws RemoteException {
            return false;
        }

        @Override
        public boolean canProjectSecureVideo() throws RemoteException {
            return false;
        }

        @Override
        public int applyVirtualDisplayFlags(int flags) throws RemoteException {
            return 0;
        }

        @Override
        public void registerCallback(IMediaProjectionCallback callback2) throws RemoteException {
        }

        @Override
        public void unregisterCallback(IMediaProjectionCallback callback2) throws RemoteException {
        }

        @Override
        public WindowContainerToken getTaskRecordingWindowContainerToken() throws RemoteException {
            return null;
        }

        @Override
        public void setTaskRecordingWindowContainerToken(WindowContainerToken token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

