/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.media.projection.IMediaProjectionManager;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.view.ContentRecordingSession;
import android.view.Surface;
import android.window.WindowContainerToken;
import java.util.Map;

public class MediaProjection {
    private static final String TAG = "MediaProjection";
    private final IMediaProjection mImpl;
    private final Context mContext;
    private final Map<Callback, CallbackRecord> mCallbacks = new ArrayMap<Callback, CallbackRecord>();
    private IMediaProjectionManager mProjectionService = null;

    public MediaProjection(Context context, IMediaProjection impl) {
        this.mContext = context;
        this.mImpl = impl;
        try {
            this.mImpl.start(new MediaProjectionCallback());
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to start media projection", e);
        }
    }

    public void registerCallback(Callback callback2, Handler handler) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        this.mCallbacks.put(callback2, new CallbackRecord(callback2, handler));
    }

    public void unregisterCallback(Callback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        this.mCallbacks.remove(callback2);
    }

    public VirtualDisplay createVirtualDisplay(String name, int width2, int height2, int dpi2, boolean isSecure, Surface surface2, VirtualDisplay.Callback callback2, Handler handler) {
        int flags = 18;
        if (isSecure) {
            flags |= 4;
        }
        VirtualDisplayConfig.Builder builder2 = new VirtualDisplayConfig.Builder(name, width2, height2, dpi2).setFlags(flags);
        if (surface2 != null) {
            builder2.setSurface(surface2);
        }
        VirtualDisplay virtualDisplay = this.createVirtualDisplay(builder2, callback2, handler);
        return virtualDisplay;
    }

    public VirtualDisplay createVirtualDisplay(String name, int width2, int height2, int dpi2, int flags, Surface surface2, VirtualDisplay.Callback callback2, Handler handler) {
        VirtualDisplayConfig.Builder builder2 = new VirtualDisplayConfig.Builder(name, width2, height2, dpi2).setFlags(flags);
        if (surface2 != null) {
            builder2.setSurface(surface2);
        }
        VirtualDisplay virtualDisplay = this.createVirtualDisplay(builder2, callback2, handler);
        return virtualDisplay;
    }

    public VirtualDisplay createVirtualDisplay(VirtualDisplayConfig.Builder virtualDisplayConfig, VirtualDisplay.Callback callback2, Handler handler) {
        try {
            ContentRecordingSession session;
            WindowContainerToken taskWindowContainerToken = this.mImpl.getTaskRecordingWindowContainerToken();
            Context windowContext = null;
            if (taskWindowContainerToken == null) {
                windowContext = this.mContext.createWindowContext(this.mContext.getDisplayNoVerify(), 2, null);
                session = ContentRecordingSession.createDisplaySession(windowContext.getWindowContextToken());
            } else {
                session = ContentRecordingSession.createTaskSession(taskWindowContainerToken.asBinder());
            }
            virtualDisplayConfig.setWindowManagerMirroring(true);
            DisplayManager dm = this.mContext.getSystemService(DisplayManager.class);
            VirtualDisplay virtualDisplay = dm.createVirtualDisplay(this, virtualDisplayConfig.build(), callback2, handler, windowContext);
            if (virtualDisplay == null) {
                return null;
            }
            session.setDisplayId(virtualDisplay.getDisplay().getDisplayId());
            this.getProjectionService().setContentRecordingSession(session, this.mImpl);
            return virtualDisplay;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IMediaProjectionManager getProjectionService() {
        if (this.mProjectionService == null) {
            this.mProjectionService = IMediaProjectionManager.Stub.asInterface(ServiceManager.getService("media_projection"));
        }
        return this.mProjectionService;
    }

    public void stop() {
        try {
            this.mImpl.stop();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to stop projection", e);
        }
    }

    public IMediaProjection getProjection() {
        return this.mImpl;
    }

    private static class CallbackRecord {
        private final Callback mCallback;
        private final Handler mHandler;

        public CallbackRecord(Callback callback2, Handler handler) {
            this.mCallback = callback2;
            this.mHandler = handler;
        }

        public void onStop() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStop();
                }
            });
        }
    }

    private class MediaProjectionCallback
    extends IMediaProjectionCallback.Stub {
        private MediaProjectionCallback() {
        }

        @Override
        public void onStop() {
            for (CallbackRecord cbr : MediaProjection.this.mCallbacks.values()) {
                cbr.onStop();
            }
        }
    }

    public static abstract class Callback {
        public void onStop() {
        }
    }
}

