/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.AdResponse;
import android.media.tv.AitInfo;
import android.media.tv.BroadcastInfoResponse;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InputChannel;
import java.util.ArrayList;
import java.util.List;

public interface ITvInputClient
extends IInterface {
    public void onSessionCreated(String var1, IBinder var2, InputChannel var3, int var4) throws RemoteException;

    public void onSessionReleased(int var1) throws RemoteException;

    public void onSessionEvent(String var1, Bundle var2, int var3) throws RemoteException;

    public void onChannelRetuned(Uri var1, int var2) throws RemoteException;

    public void onTracksChanged(List<TvTrackInfo> var1, int var2) throws RemoteException;

    public void onTrackSelected(int var1, String var2, int var3) throws RemoteException;

    public void onVideoAvailable(int var1) throws RemoteException;

    public void onVideoUnavailable(int var1, int var2) throws RemoteException;

    public void onContentAllowed(int var1) throws RemoteException;

    public void onContentBlocked(String var1, int var2) throws RemoteException;

    public void onLayoutSurface(int var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onTimeShiftStatusChanged(int var1, int var2) throws RemoteException;

    public void onTimeShiftStartPositionChanged(long var1, int var3) throws RemoteException;

    public void onTimeShiftCurrentPositionChanged(long var1, int var3) throws RemoteException;

    public void onAitInfoUpdated(AitInfo var1, int var2) throws RemoteException;

    public void onSignalStrength(int var1, int var2) throws RemoteException;

    public void onTuned(Uri var1, int var2) throws RemoteException;

    public void onRecordingStopped(Uri var1, int var2) throws RemoteException;

    public void onError(int var1, int var2) throws RemoteException;

    public void onBroadcastInfoResponse(BroadcastInfoResponse var1, int var2) throws RemoteException;

    public void onAdResponse(AdResponse var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputClient {
        public static final String DESCRIPTOR = "android.media.tv.ITvInputClient";
        static final int TRANSACTION_onSessionCreated = 1;
        static final int TRANSACTION_onSessionReleased = 2;
        static final int TRANSACTION_onSessionEvent = 3;
        static final int TRANSACTION_onChannelRetuned = 4;
        static final int TRANSACTION_onTracksChanged = 5;
        static final int TRANSACTION_onTrackSelected = 6;
        static final int TRANSACTION_onVideoAvailable = 7;
        static final int TRANSACTION_onVideoUnavailable = 8;
        static final int TRANSACTION_onContentAllowed = 9;
        static final int TRANSACTION_onContentBlocked = 10;
        static final int TRANSACTION_onLayoutSurface = 11;
        static final int TRANSACTION_onTimeShiftStatusChanged = 12;
        static final int TRANSACTION_onTimeShiftStartPositionChanged = 13;
        static final int TRANSACTION_onTimeShiftCurrentPositionChanged = 14;
        static final int TRANSACTION_onAitInfoUpdated = 15;
        static final int TRANSACTION_onSignalStrength = 16;
        static final int TRANSACTION_onTuned = 17;
        static final int TRANSACTION_onRecordingStopped = 18;
        static final int TRANSACTION_onError = 19;
        static final int TRANSACTION_onBroadcastInfoResponse = 20;
        static final int TRANSACTION_onAdResponse = 21;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITvInputClient) {
                return (ITvInputClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionCreated";
                }
                case 2: {
                    return "onSessionReleased";
                }
                case 3: {
                    return "onSessionEvent";
                }
                case 4: {
                    return "onChannelRetuned";
                }
                case 5: {
                    return "onTracksChanged";
                }
                case 6: {
                    return "onTrackSelected";
                }
                case 7: {
                    return "onVideoAvailable";
                }
                case 8: {
                    return "onVideoUnavailable";
                }
                case 9: {
                    return "onContentAllowed";
                }
                case 10: {
                    return "onContentBlocked";
                }
                case 11: {
                    return "onLayoutSurface";
                }
                case 12: {
                    return "onTimeShiftStatusChanged";
                }
                case 13: {
                    return "onTimeShiftStartPositionChanged";
                }
                case 14: {
                    return "onTimeShiftCurrentPositionChanged";
                }
                case 15: {
                    return "onAitInfoUpdated";
                }
                case 16: {
                    return "onSignalStrength";
                }
                case 17: {
                    return "onTuned";
                }
                case 18: {
                    return "onRecordingStopped";
                }
                case 19: {
                    return "onError";
                }
                case 20: {
                    return "onBroadcastInfoResponse";
                }
                case 21: {
                    return "onAdResponse";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    InputChannel _arg2 = data.readTypedObject(InputChannel.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionCreated(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionReleased(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onChannelRetuned(_arg0, _arg1);
                    break;
                }
                case 5: {
                    ArrayList<TvTrackInfo> _arg0 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTracksChanged(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTrackSelected(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVideoAvailable(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVideoUnavailable(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onContentAllowed(_arg0);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onContentBlocked(_arg0, _arg1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutSurface(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftStatusChanged(_arg0, _arg1);
                    break;
                }
                case 13: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftStartPositionChanged(_arg0, _arg1);
                    break;
                }
                case 14: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftCurrentPositionChanged(_arg0, _arg1);
                    break;
                }
                case 15: {
                    AitInfo _arg0 = data.readTypedObject(AitInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAitInfoUpdated(_arg0, _arg1);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSignalStrength(_arg0, _arg1);
                    break;
                }
                case 17: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTuned(_arg0, _arg1);
                    break;
                }
                case 18: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRecordingStopped(_arg0, _arg1);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                case 20: {
                    BroadcastInfoResponse _arg0 = data.readTypedObject(BroadcastInfoResponse.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastInfoResponse(_arg0, _arg1);
                    break;
                }
                case 21: {
                    AdResponse _arg0 = data.readTypedObject(AdResponse.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAdResponse(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 20;
        }

        private static class Proxy
        implements ITvInputClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(channel, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionReleased(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionEvent(String name, Bundle args, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeTypedObject(args, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChannelRetuned(Uri channelUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTracksChanged(List<TvTrackInfo> tracks, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(tracks);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTrackSelected(int type, String trackId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(trackId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoAvailable(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoUnavailable(int reason, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContentAllowed(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContentBlocked(String rating, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rating);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutSurface(int left, int top, int right2, int bottom2, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(left);
                    _data.writeInt(top);
                    _data.writeInt(right2);
                    _data.writeInt(bottom2);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftStatusChanged(int status, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftStartPositionChanged(long timeMs, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeMs);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftCurrentPositionChanged(long timeMs, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeMs);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAitInfoUpdated(AitInfo aitInfo, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aitInfo, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSignalStrength(int stength, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(stength);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTuned(Uri channelUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecordingStopped(Uri recordedProgramUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(recordedProgramUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(error);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastInfoResponse(BroadcastInfoResponse response, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdResponse(AdResponse response, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInputClient {
        @Override
        public void onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) throws RemoteException {
        }

        @Override
        public void onSessionReleased(int seq) throws RemoteException {
        }

        @Override
        public void onSessionEvent(String name, Bundle args, int seq) throws RemoteException {
        }

        @Override
        public void onChannelRetuned(Uri channelUri, int seq) throws RemoteException {
        }

        @Override
        public void onTracksChanged(List<TvTrackInfo> tracks, int seq) throws RemoteException {
        }

        @Override
        public void onTrackSelected(int type, String trackId, int seq) throws RemoteException {
        }

        @Override
        public void onVideoAvailable(int seq) throws RemoteException {
        }

        @Override
        public void onVideoUnavailable(int reason, int seq) throws RemoteException {
        }

        @Override
        public void onContentAllowed(int seq) throws RemoteException {
        }

        @Override
        public void onContentBlocked(String rating, int seq) throws RemoteException {
        }

        @Override
        public void onLayoutSurface(int left, int top, int right2, int bottom2, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftStatusChanged(int status, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftStartPositionChanged(long timeMs, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftCurrentPositionChanged(long timeMs, int seq) throws RemoteException {
        }

        @Override
        public void onAitInfoUpdated(AitInfo aitInfo, int seq) throws RemoteException {
        }

        @Override
        public void onSignalStrength(int stength, int seq) throws RemoteException {
        }

        @Override
        public void onTuned(Uri channelUri, int seq) throws RemoteException {
        }

        @Override
        public void onRecordingStopped(Uri recordedProgramUri, int seq) throws RemoteException {
        }

        @Override
        public void onError(int error, int seq) throws RemoteException {
        }

        @Override
        public void onBroadcastInfoResponse(BroadcastInfoResponse response, int seq) throws RemoteException {
        }

        @Override
        public void onAdResponse(AdResponse response, int seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

