/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.BroadcastInfoResponse;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

public class TableResponse
extends BroadcastInfoResponse
implements Parcelable {
    private static final int RESPONSE_TYPE = 2;
    public static final Parcelable.Creator<TableResponse> CREATOR = new Parcelable.Creator<TableResponse>(){

        @Override
        public TableResponse createFromParcel(Parcel source) {
            source.readInt();
            return TableResponse.createFromParcelBody(source);
        }

        public TableResponse[] newArray(int size) {
            return new TableResponse[size];
        }
    };
    private final Uri mTableUri;
    private final int mVersion;
    private final int mSize;

    static TableResponse createFromParcelBody(Parcel in) {
        return new TableResponse(in);
    }

    public TableResponse(int requestId, int sequence, int responseResult, Uri tableUri, int version, int size) {
        super(2, requestId, sequence, responseResult);
        this.mTableUri = tableUri;
        this.mVersion = version;
        this.mSize = size;
    }

    TableResponse(Parcel source) {
        super(2, source);
        String uriString = source.readString();
        this.mTableUri = uriString == null ? null : Uri.parse(uriString);
        this.mVersion = source.readInt();
        this.mSize = source.readInt();
    }

    public Uri getTableUri() {
        return this.mTableUri;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public int getSize() {
        return this.mSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        String uriString = this.mTableUri == null ? null : this.mTableUri.toString();
        dest.writeString(uriString);
        dest.writeInt(this.mVersion);
        dest.writeInt(this.mSize);
    }
}

