/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class TunedInfo
implements Parcelable {
    static final String TAG = "TunedInfo";
    public static final int APP_TAG_SELF = 0;
    public static final int APP_TYPE_SELF = 1;
    public static final int APP_TYPE_SYSTEM = 2;
    public static final int APP_TYPE_NON_SYSTEM = 3;
    public static final Parcelable.Creator<TunedInfo> CREATOR = new Parcelable.Creator<TunedInfo>(){

        @Override
        public TunedInfo createFromParcel(Parcel source) {
            try {
                return new TunedInfo(source);
            }
            catch (Exception e) {
                Log.e(TunedInfo.TAG, "Exception creating TunedInfo from parcel", e);
                return null;
            }
        }

        public TunedInfo[] newArray(int size) {
            return new TunedInfo[size];
        }
    };
    private final String mInputId;
    private final Uri mChannelUri;
    private final boolean mIsRecordingSession;
    private final boolean mIsVisible;
    private final boolean mIsMainSession;
    private final int mAppType;
    private final int mAppTag;

    public TunedInfo(String inputId, Uri channelUri, boolean isRecordingSession, boolean isVisible, boolean isMainSession, int appType, int appTag) {
        this.mInputId = inputId;
        this.mChannelUri = channelUri;
        this.mIsRecordingSession = isRecordingSession;
        this.mIsVisible = isVisible;
        this.mIsMainSession = isMainSession;
        this.mAppType = appType;
        this.mAppTag = appTag;
    }

    private TunedInfo(Parcel source) {
        this.mInputId = source.readString();
        String uriString = source.readString();
        this.mChannelUri = uriString == null ? null : Uri.parse(uriString);
        this.mIsRecordingSession = source.readInt() == 1;
        this.mIsVisible = source.readInt() == 1;
        this.mIsMainSession = source.readInt() == 1;
        this.mAppType = source.readInt();
        this.mAppTag = source.readInt();
    }

    public String getInputId() {
        return this.mInputId;
    }

    public Uri getChannelUri() {
        return this.mChannelUri;
    }

    public boolean isRecordingSession() {
        return this.mIsRecordingSession;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public boolean isMainSession() {
        return this.mIsMainSession;
    }

    public int getAppTag() {
        return this.mAppTag;
    }

    public int getAppType() {
        return this.mAppType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mInputId);
        String uriString = this.mChannelUri == null ? null : this.mChannelUri.toString();
        dest.writeString(uriString);
        dest.writeInt(this.mIsRecordingSession ? 1 : 0);
        dest.writeInt(this.mIsVisible ? 1 : 0);
        dest.writeInt(this.mIsMainSession ? 1 : 0);
        dest.writeInt(this.mAppType);
        dest.writeInt(this.mAppTag);
    }

    public String toString() {
        return "inputID=" + this.mInputId + ";channelUri=" + this.mChannelUri + ";isRecording=" + this.mIsRecordingSession + ";isVisible=" + this.mIsVisible + ";isMainSession=" + this.mIsMainSession + ";appType=" + this.mAppType + ";appTag=" + this.mAppTag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TunedInfo)) {
            return false;
        }
        TunedInfo other = (TunedInfo)o;
        return TextUtils.equals(this.mInputId, other.getInputId()) && Objects.equals(this.mChannelUri, other.mChannelUri) && this.mIsRecordingSession == other.mIsRecordingSession && this.mIsVisible == other.mIsVisible && this.mIsMainSession == other.mIsMainSession && this.mAppType == other.mAppType && this.mAppTag == other.mAppTag;
    }

    public int hashCode() {
        return Objects.hash(this.mInputId, this.mChannelUri, this.mIsRecordingSession, this.mIsVisible, this.mIsMainSession, this.mAppType, this.mAppTag);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppType {
    }
}

