/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class TvInteractiveAppServiceInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    private static final String TAG = "TvInteractiveAppServiceInfo";
    private static final String XML_START_TAG_NAME = "tv-interactive-app";
    public static final int INTERACTIVE_APP_TYPE_HBBTV = 1;
    public static final int INTERACTIVE_APP_TYPE_ATSC = 2;
    public static final int INTERACTIVE_APP_TYPE_GINGA = 4;
    private final ResolveInfo mService;
    private final String mId;
    private int mTypes;
    public static final Parcelable.Creator<TvInteractiveAppServiceInfo> CREATOR = new Parcelable.Creator<TvInteractiveAppServiceInfo>(){

        @Override
        public TvInteractiveAppServiceInfo createFromParcel(Parcel in) {
            return new TvInteractiveAppServiceInfo(in);
        }

        public TvInteractiveAppServiceInfo[] newArray(int size) {
            return new TvInteractiveAppServiceInfo[size];
        }
    };

    public TvInteractiveAppServiceInfo(Context context, ComponentName component2) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        Intent intent = new Intent("android.media.tv.interactive.TvInteractiveAppService").setComponent(component2);
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 132);
        if (resolveInfo == null) {
            throw new IllegalArgumentException("Invalid component. Can't find the service.");
        }
        ComponentName componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
        String id2 = TvInteractiveAppServiceInfo.generateInteractiveAppServiceId(componentName);
        ArrayList<String> types = new ArrayList<String>();
        TvInteractiveAppServiceInfo.parseServiceMetadata(resolveInfo, context, types);
        this.mService = resolveInfo;
        this.mId = id2;
        this.mTypes = TvInteractiveAppServiceInfo.toTypesFlag(types);
    }

    private TvInteractiveAppServiceInfo(ResolveInfo service, String id2, int types) {
        this.mService = service;
        this.mId = id2;
        this.mTypes = types;
    }

    private TvInteractiveAppServiceInfo(Parcel in) {
        this.mService = ResolveInfo.CREATOR.createFromParcel(in);
        this.mId = in.readString();
        this.mTypes = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mId);
        dest.writeInt(this.mTypes);
    }

    public String getId() {
        return this.mId;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public int getSupportedTypes() {
        return this.mTypes;
    }

    private static String generateInteractiveAppServiceId(ComponentName name) {
        return name.flattenToShortString();
    }

    private static void parseServiceMetadata(ResolveInfo resolveInfo, Context context, List<String> types) {
        ServiceInfo si = resolveInfo.serviceInfo;
        PackageManager pm = context.getPackageManager();
        try (XmlResourceParser parser = si.loadXmlMetaData(pm, "android.media.tv.interactive.app");){
            CharSequence[] textArr;
            int type;
            if (parser == null) {
                throw new IllegalStateException("No android.media.tv.interactive.app meta-data found for " + si.name);
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!XML_START_TAG_NAME.equals(nodeName)) {
                throw new IllegalStateException("Meta-data does not start with tv-interactive-app tag for " + si.name);
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.TvInteractiveAppService);
            for (CharSequence cs : textArr = sa.getTextArray(0)) {
                types.add(cs.toString().toLowerCase());
            }
            sa.recycle();
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed reading meta-data for " + si.packageName, e);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("No resources found for " + si.packageName, e);
        }
    }

    private static int toTypesFlag(List<String> types) {
        int flag = 0;
        Iterator<String> iterator = types.iterator();
        while (iterator.hasNext()) {
            String type;
            switch (type = iterator.next()) {
                case "hbbtv": {
                    flag |= 1;
                    break;
                }
                case "atsc": {
                    flag |= 2;
                    break;
                }
                case "ginga": {
                    flag |= 4;
                    break;
                }
            }
        }
        return flag;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InteractiveAppType {
    }
}

