/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.interactive;

import android.annotation.NonNull;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.media.tv.TvView;
import android.media.tv.interactive.TvInteractiveAppManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import com.android.internal.util.AnnotationValidations;
import java.util.List;
import java.util.concurrent.Executor;

public class TvInteractiveAppView
extends ViewGroup {
    private static final String TAG = "TvInteractiveAppView";
    private static final boolean DEBUG = false;
    private static final int SET_TVVIEW_SUCCESS = 1;
    private static final int SET_TVVIEW_FAIL = 2;
    private static final int UNSET_TVVIEW_SUCCESS = 3;
    private static final int UNSET_TVVIEW_FAIL = 4;
    public static final String BI_INTERACTIVE_APP_KEY_CERTIFICATE = "certificate";
    public static final String BI_INTERACTIVE_APP_KEY_ALIAS = "alias";
    public static final String BI_INTERACTIVE_APP_KEY_PRIVATE_KEY = "private_key";
    public static final String BI_INTERACTIVE_APP_KEY_HTTP_ADDITIONAL_HEADERS = "http_additional_headers";
    public static final String BI_INTERACTIVE_APP_KEY_HTTP_USER_AGENT = "http_user_agent";
    public static final String ERROR_KEY_METHOD_NAME = "method_name";
    private final TvInteractiveAppManager mTvInteractiveAppManager;
    private final Handler mHandler = new Handler();
    private final Object mCallbackLock = new Object();
    private TvInteractiveAppManager.Session mSession;
    private MySessionCallback mSessionCallback;
    private TvInteractiveAppCallback mCallback;
    private Executor mCallbackExecutor;
    private SurfaceView mSurfaceView;
    private Surface mSurface;
    private boolean mSurfaceChanged;
    private int mSurfaceFormat;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private boolean mUseRequestedSurfaceLayout;
    private int mSurfaceViewLeft;
    private int mSurfaceViewRight;
    private int mSurfaceViewTop;
    private int mSurfaceViewBottom;
    private boolean mMediaViewCreated;
    private Rect mMediaViewFrame;
    private final AttributeSet mAttrs;
    private final int mDefStyleAttr;
    private final XmlResourceParser mParser;
    private OnUnhandledInputEventListener mOnUnhandledInputEventListener;
    private final SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback(){

        @Override
        public void surfaceChanged(SurfaceHolder holder, int format, int width2, int height2) {
            TvInteractiveAppView.this.mSurfaceFormat = format;
            TvInteractiveAppView.this.mSurfaceWidth = width2;
            TvInteractiveAppView.this.mSurfaceHeight = height2;
            TvInteractiveAppView.this.mSurfaceChanged = true;
            TvInteractiveAppView.this.dispatchSurfaceChanged(TvInteractiveAppView.this.mSurfaceFormat, TvInteractiveAppView.this.mSurfaceWidth, TvInteractiveAppView.this.mSurfaceHeight);
        }

        @Override
        public void surfaceCreated(SurfaceHolder holder) {
            TvInteractiveAppView.this.mSurface = holder.getSurface();
            TvInteractiveAppView.this.setSessionSurface(TvInteractiveAppView.this.mSurface);
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder holder) {
            TvInteractiveAppView.this.mSurface = null;
            TvInteractiveAppView.this.mSurfaceChanged = false;
            TvInteractiveAppView.this.setSessionSurface(null);
        }
    };
    private final TvInteractiveAppManager.Session.FinishedInputEventCallback mFinishedInputEventCallback = new TvInteractiveAppManager.Session.FinishedInputEventCallback(){

        @Override
        public void onFinishedInputEvent(Object token, boolean handled) {
            if (handled) {
                return;
            }
            InputEvent event = (InputEvent)token;
            if (TvInteractiveAppView.this.dispatchUnhandledInputEvent(event)) {
                return;
            }
            ViewRootImpl viewRootImpl = TvInteractiveAppView.this.getViewRootImpl();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchUnhandledInputEvent(event);
            }
        }
    };

    public TvInteractiveAppView(Context context) {
        this(context, null, 0);
    }

    public TvInteractiveAppView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TvInteractiveAppView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int sourceResId = Resources.getAttributeSetSourceResId(attrs);
        if (sourceResId != 0) {
            Log.d(TAG, "Build local AttributeSet");
            this.mParser = context.getResources().getXml(sourceResId);
            this.mAttrs = Xml.asAttributeSet(this.mParser);
        } else {
            Log.d(TAG, "Use passed in AttributeSet");
            this.mParser = null;
            this.mAttrs = attrs;
        }
        this.mDefStyleAttr = defStyleAttr;
        this.resetSurfaceView();
        this.mTvInteractiveAppManager = (TvInteractiveAppManager)this.getContext().getSystemService("tv_interactive_app");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Executor executor, TvInteractiveAppCallback callback2) {
        AnnotationValidations.validate(NonNull.class, null, (Object)callback2);
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallbackExecutor = executor;
            this.mCallback = callback2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCallback() {
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = null;
            this.mCallbackExecutor = null;
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.createSessionMediaView();
    }

    @Override
    public void onDetachedFromWindow() {
        this.removeSessionMediaView();
        super.onDetachedFromWindow();
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right2, int bottom2) {
        if (this.mUseRequestedSurfaceLayout) {
            this.mSurfaceView.layout(this.mSurfaceViewLeft, this.mSurfaceViewTop, this.mSurfaceViewRight, this.mSurfaceViewBottom);
        } else {
            this.mSurfaceView.layout(0, 0, right2 - left, bottom2 - top);
        }
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mSurfaceView.measure(widthMeasureSpec, heightMeasureSpec);
        int width2 = this.mSurfaceView.getMeasuredWidth();
        int height2 = this.mSurfaceView.getMeasuredHeight();
        int childState = this.mSurfaceView.getMeasuredState();
        this.setMeasuredDimension(TvInteractiveAppView.resolveSizeAndState(width2, widthMeasureSpec, childState), TvInteractiveAppView.resolveSizeAndState(height2, heightMeasureSpec, childState << 16));
    }

    @Override
    public void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mSurfaceView.setVisibility(visibility);
        if (visibility == 0) {
            this.createSessionMediaView();
        } else {
            this.removeSessionMediaView();
        }
    }

    private void resetSurfaceView() {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceHolderCallback);
            this.removeView(this.mSurfaceView);
        }
        this.mSurface = null;
        this.mSurfaceView = new SurfaceView(this.getContext(), this.mAttrs, this.mDefStyleAttr){

            protected void updateSurface() {
                super.updateSurface();
                TvInteractiveAppView.this.relayoutSessionMediaView();
            }
        };
        this.mSurfaceView.setSecure(true);
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceHolderCallback);
        this.mSurfaceView.getHolder().setFormat(-3);
        this.addView(this.mSurfaceView);
    }

    public void reset() {
        this.resetInternal();
    }

    private void createSessionMediaView() {
        if (this.mSession == null || !this.isAttachedToWindow() || this.mMediaViewCreated) {
            return;
        }
        this.mMediaViewFrame = this.getViewFrameOnScreen();
        this.mSession.createMediaView(this, this.mMediaViewFrame);
        this.mMediaViewCreated = true;
    }

    private void removeSessionMediaView() {
        if (this.mSession == null || !this.mMediaViewCreated) {
            return;
        }
        this.mSession.removeMediaView();
        this.mMediaViewCreated = false;
        this.mMediaViewFrame = null;
    }

    private void relayoutSessionMediaView() {
        if (this.mSession == null || !this.isAttachedToWindow() || !this.mMediaViewCreated) {
            return;
        }
        Rect viewFrame = this.getViewFrameOnScreen();
        if (viewFrame.equals(this.mMediaViewFrame)) {
            return;
        }
        this.mSession.relayoutMediaView(viewFrame);
        this.mMediaViewFrame = viewFrame;
    }

    private Rect getViewFrameOnScreen() {
        Rect frame = new Rect();
        this.getGlobalVisibleRect(frame);
        RectF frameF = new RectF(frame);
        this.getMatrix().mapRect(frameF);
        frameF.round(frame);
        return frame;
    }

    private void setSessionSurface(Surface surface2) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.setSurface(surface2);
    }

    private void dispatchSurfaceChanged(int format, int width2, int height2) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.dispatchSurfaceChanged(format, width2, height2);
    }

    public boolean dispatchUnhandledInputEvent(InputEvent event) {
        if (this.mOnUnhandledInputEventListener != null && this.mOnUnhandledInputEventListener.onUnhandledInputEvent(event)) {
            return true;
        }
        return this.onUnhandledInputEvent(event);
    }

    public boolean onUnhandledInputEvent(InputEvent event) {
        return false;
    }

    public void setOnUnhandledInputEventListener(Executor executor, OnUnhandledInputEventListener listener2) {
        this.mOnUnhandledInputEventListener = listener2;
    }

    public OnUnhandledInputEventListener getOnUnhandledInputEventListener() {
        return this.mOnUnhandledInputEventListener;
    }

    public void clearOnUnhandledInputEventListener() {
        this.mOnUnhandledInputEventListener = null;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (super.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.mSession == null) {
            return false;
        }
        KeyEvent copiedEvent = event.copy();
        int ret = this.mSession.dispatchInputEvent(copiedEvent, copiedEvent, this.mFinishedInputEventCallback, this.mHandler);
        return ret != 0;
    }

    public void prepareInteractiveApp(String iAppServiceId, int type) {
        this.mSessionCallback = new MySessionCallback(iAppServiceId, type);
        if (this.mTvInteractiveAppManager != null) {
            this.mTvInteractiveAppManager.createSession(iAppServiceId, type, this.mSessionCallback, this.mHandler);
        }
    }

    public void startInteractiveApp() {
        if (this.mSession != null) {
            this.mSession.startInteractiveApp();
        }
    }

    public void stopInteractiveApp() {
        if (this.mSession != null) {
            this.mSession.stopInteractiveApp();
        }
    }

    public void resetInteractiveApp() {
        if (this.mSession != null) {
            this.mSession.resetInteractiveApp();
        }
    }

    public void sendCurrentChannelUri(Uri channelUri) {
        if (this.mSession != null) {
            this.mSession.sendCurrentChannelUri(channelUri);
        }
    }

    public void sendCurrentChannelLcn(int lcn) {
        if (this.mSession != null) {
            this.mSession.sendCurrentChannelLcn(lcn);
        }
    }

    public void sendStreamVolume(float volume) {
        if (this.mSession != null) {
            this.mSession.sendStreamVolume(volume);
        }
    }

    public void sendTrackInfoList(List<TvTrackInfo> tracks) {
        if (this.mSession != null) {
            this.mSession.sendTrackInfoList(tracks);
        }
    }

    public void sendCurrentTvInputId(String inputId) {
        if (this.mSession != null) {
            this.mSession.sendCurrentTvInputId(inputId);
        }
    }

    public void sendSigningResult(String signingId, byte[] result) {
        if (this.mSession != null) {
            this.mSession.sendSigningResult(signingId, result);
        }
    }

    public void notifyError(String errMsg, Bundle params) {
        if (this.mSession != null) {
            this.mSession.notifyError(errMsg, params);
        }
    }

    private void resetInternal() {
        this.mSessionCallback = null;
        if (this.mSession != null) {
            this.setSessionSurface(null);
            this.removeSessionMediaView();
            this.mUseRequestedSurfaceLayout = false;
            this.mSession.release();
            this.mSession = null;
            this.resetSurfaceView();
        }
    }

    public void createBiInteractiveApp(Uri biIAppUri, Bundle params) {
        if (this.mSession != null) {
            this.mSession.createBiInteractiveApp(biIAppUri, params);
        }
    }

    public void destroyBiInteractiveApp(String biIAppId) {
        if (this.mSession != null) {
            this.mSession.destroyBiInteractiveApp(biIAppId);
        }
    }

    public TvInteractiveAppManager.Session getInteractiveAppSession() {
        return this.mSession;
    }

    public int setTvView(TvView tvView) {
        if (tvView == null) {
            return this.unsetTvView();
        }
        TvInputManager.Session inputSession = tvView.getInputSession();
        if (inputSession == null || this.mSession == null) {
            return 2;
        }
        this.mSession.setInputSession(inputSession);
        inputSession.setInteractiveAppSession(this.mSession);
        return 1;
    }

    private int unsetTvView() {
        if (this.mSession == null || this.mSession.getInputSession() == null) {
            return 4;
        }
        this.mSession.getInputSession().setInteractiveAppSession(null);
        this.mSession.setInputSession(null);
        return 3;
    }

    public void setTeletextAppEnabled(boolean enable) {
        if (this.mSession != null) {
            this.mSession.setTeletextAppEnabled(enable);
        }
    }

    private class MySessionCallback
    extends TvInteractiveAppManager.SessionCallback {
        final String mIAppServiceId;
        int mType;

        MySessionCallback(String iAppServiceId, int type) {
            this.mIAppServiceId = iAppServiceId;
            this.mType = type;
        }

        @Override
        public void onSessionCreated(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onSessionCreated - session already created");
                if (session != null) {
                    session.release();
                }
                return;
            }
            TvInteractiveAppView.this.mSession = session;
            if (session != null) {
                if (TvInteractiveAppView.this.mSurface != null) {
                    TvInteractiveAppView.this.setSessionSurface(TvInteractiveAppView.this.mSurface);
                    if (TvInteractiveAppView.this.mSurfaceChanged) {
                        TvInteractiveAppView.this.dispatchSurfaceChanged(TvInteractiveAppView.this.mSurfaceFormat, TvInteractiveAppView.this.mSurfaceWidth, TvInteractiveAppView.this.mSurfaceHeight);
                    }
                }
                TvInteractiveAppView.this.createSessionMediaView();
            } else {
                TvInteractiveAppView.this.mSessionCallback = null;
            }
        }

        @Override
        public void onSessionReleased(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onSessionReleased - session not created");
                return;
            }
            TvInteractiveAppView.this.mMediaViewCreated = false;
            TvInteractiveAppView.this.mMediaViewFrame = null;
            TvInteractiveAppView.this.mSessionCallback = null;
            TvInteractiveAppView.this.mSession = null;
        }

        @Override
        public void onLayoutSurface(TvInteractiveAppManager.Session session, int left, int top, int right2, int bottom2) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onLayoutSurface - session not created");
                return;
            }
            TvInteractiveAppView.this.mSurfaceViewLeft = left;
            TvInteractiveAppView.this.mSurfaceViewTop = top;
            TvInteractiveAppView.this.mSurfaceViewRight = right2;
            TvInteractiveAppView.this.mSurfaceViewBottom = bottom2;
            TvInteractiveAppView.this.mUseRequestedSurfaceLayout = true;
            TvInteractiveAppView.this.requestLayout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCommandRequest(TvInteractiveAppManager.Session session, String cmdType, Bundle parameters) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onCommandRequest - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onPlaybackCommandRequest(this.mIAppServiceId, cmdType, parameters);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionStateChanged(TvInteractiveAppManager.Session session, int state, int err) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onSessionStateChanged - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onStateChanged(this.mIAppServiceId, state, err);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBiInteractiveAppCreated(TvInteractiveAppManager.Session session, Uri biIAppUri, String biIAppId) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onBiInteractiveAppCreated - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onBiInteractiveAppCreated(this.mIAppServiceId, biIAppUri, biIAppId);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void onTeletextAppStateChanged(TvInteractiveAppManager.Session session, int state) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onTeletextAppStateChanged - session not created");
                return;
            }
            if (TvInteractiveAppView.this.mCallback != null) {
                TvInteractiveAppView.this.mCallback.onTeletextAppStateChanged(this.mIAppServiceId, state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSetVideoBounds(TvInteractiveAppManager.Session session, Rect rect) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onSetVideoBounds - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onSetVideoBounds(this.mIAppServiceId, rect);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestCurrentChannelUri(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onRequestCurrentChannelUri - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onRequestCurrentChannelUri(this.mIAppServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestCurrentChannelLcn(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onRequestCurrentChannelLcn - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onRequestCurrentChannelLcn(this.mIAppServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestStreamVolume(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onRequestStreamVolume - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onRequestStreamVolume(this.mIAppServiceId);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestTrackInfoList(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onRequestTrackInfoList - session not created");
                return;
            }
            Object object = TvInteractiveAppView.this.mCallbackLock;
            synchronized (object) {
                if (TvInteractiveAppView.this.mCallbackExecutor != null) {
                    TvInteractiveAppView.this.mCallbackExecutor.execute(() -> {
                        Object object = TvInteractiveAppView.this.mCallbackLock;
                        synchronized (object) {
                            if (TvInteractiveAppView.this.mCallback != null) {
                                TvInteractiveAppView.this.mCallback.onRequestTrackInfoList(this.mIAppServiceId);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void onRequestCurrentTvInputId(TvInteractiveAppManager.Session session) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onRequestCurrentTvInputId - session not created");
                return;
            }
            if (TvInteractiveAppView.this.mCallback != null) {
                TvInteractiveAppView.this.mCallback.onRequestCurrentTvInputId(this.mIAppServiceId);
            }
        }

        @Override
        public void onRequestSigning(TvInteractiveAppManager.Session session, String id2, String algorithm, String alias, byte[] data) {
            if (this != TvInteractiveAppView.this.mSessionCallback) {
                Log.w(TvInteractiveAppView.TAG, "onRequestSigning - session not created");
                return;
            }
            if (TvInteractiveAppView.this.mCallback != null) {
                TvInteractiveAppView.this.mCallback.onRequestSigning(this.mIAppServiceId, id2, algorithm, alias, data);
            }
        }
    }

    public static interface OnUnhandledInputEventListener {
        public boolean onUnhandledInputEvent(InputEvent var1);
    }

    public static abstract class TvInteractiveAppCallback {
        public void onPlaybackCommandRequest(String iAppServiceId, String cmdType, Bundle parameters) {
        }

        public void onStateChanged(String iAppServiceId, int state, int err) {
        }

        public void onBiInteractiveAppCreated(String iAppServiceId, Uri biIAppUri, String biIAppId) {
        }

        public void onTeletextAppStateChanged(String iAppServiceId, int state) {
        }

        public void onSetVideoBounds(String iAppServiceId, Rect rect) {
        }

        public void onRequestCurrentChannelUri(String iAppServiceId) {
        }

        public void onRequestCurrentChannelLcn(String iAppServiceId) {
        }

        public void onRequestStreamVolume(String iAppServiceId) {
        }

        public void onRequestTrackInfoList(String iAppServiceId) {
        }

        public void onRequestCurrentTvInputId(String iAppServiceId) {
        }

        public void onRequestSigning(String iAppServiceId, String signingId, String algorithm, String alias, byte[] data) {
        }
    }
}

