/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.nearby.BroadcastRequestParcelable;
import android.nearby.IBroadcastListener;
import android.nearby.IScanListener;
import android.nearby.ScanRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INearbyManager
extends IInterface {
    public static final String DESCRIPTOR = "android.nearby.INearbyManager";

    public int registerScanListener(ScanRequest var1, IScanListener var2, String var3, String var4) throws RemoteException;

    public void unregisterScanListener(IScanListener var1, String var2, String var3) throws RemoteException;

    public void startBroadcast(BroadcastRequestParcelable var1, IBroadcastListener var2, String var3, String var4) throws RemoteException;

    public void stopBroadcast(IBroadcastListener var1, String var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INearbyManager {
        static final int TRANSACTION_registerScanListener = 1;
        static final int TRANSACTION_unregisterScanListener = 2;
        static final int TRANSACTION_startBroadcast = 3;
        static final int TRANSACTION_stopBroadcast = 4;

        public Stub() {
            this.attachInterface(this, INearbyManager.DESCRIPTOR);
        }

        public static INearbyManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INearbyManager.DESCRIPTOR);
            if (iin != null && iin instanceof INearbyManager) {
                return (INearbyManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerScanListener";
                }
                case 2: {
                    return "unregisterScanListener";
                }
                case 3: {
                    return "startBroadcast";
                }
                case 4: {
                    return "stopBroadcast";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INearbyManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ScanRequest _arg0 = data.readTypedObject(ScanRequest.CREATOR);
                    IScanListener _arg1 = IScanListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.registerScanListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    IScanListener _arg0 = IScanListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterScanListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    BroadcastRequestParcelable _arg0 = data.readTypedObject(BroadcastRequestParcelable.CREATOR);
                    IBroadcastListener _arg1 = IBroadcastListener.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.startBroadcast(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBroadcastListener _arg0 = IBroadcastListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.stopBroadcast(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements INearbyManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INearbyManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerScanListener(ScanRequest scanRequest, IScanListener listener2, String packageName, String attributionTag) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyManager.DESCRIPTOR);
                    _data.writeTypedObject(scanRequest, 0);
                    _data.writeStrongInterface(listener2);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanListener(IScanListener listener2, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBroadcast(BroadcastRequestParcelable broadcastRequest, IBroadcastListener callback2, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyManager.DESCRIPTOR);
                    _data.writeTypedObject(broadcastRequest, 0);
                    _data.writeStrongInterface(callback2);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBroadcast(IBroadcastListener callback2, String packageName, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INearbyManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    _data.writeString(packageName);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INearbyManager {
        @Override
        public int registerScanListener(ScanRequest scanRequest, IScanListener listener2, String packageName, String attributionTag) throws RemoteException {
            return 0;
        }

        @Override
        public void unregisterScanListener(IScanListener listener2, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void startBroadcast(BroadcastRequestParcelable broadcastRequest, IBroadcastListener callback2, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public void stopBroadcast(IBroadcastListener callback2, String packageName, String attributionTag) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

