/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.nearby.NearbyDevice;
import android.nearby.PublicCredential;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class NearbyDeviceParcelable
implements Parcelable {
    public static final Parcelable.Creator<NearbyDeviceParcelable> CREATOR = new Parcelable.Creator<NearbyDeviceParcelable>(){

        @Override
        public NearbyDeviceParcelable createFromParcel(Parcel in) {
            Builder builder2 = new Builder();
            builder2.setScanType(in.readInt());
            if (in.readInt() == 1) {
                builder2.setName(in.readString());
            }
            builder2.setMedium(in.readInt());
            builder2.setTxPower(in.readInt());
            builder2.setRssi(in.readInt());
            builder2.setAction(in.readInt());
            builder2.setPublicCredential(in.readParcelable(PublicCredential.class.getClassLoader(), PublicCredential.class));
            if (in.readInt() == 1) {
                builder2.setFastPairModelId(in.readString());
            }
            if (in.readInt() == 1) {
                builder2.setBluetoothAddress(in.readString());
            }
            if (in.readInt() == 1) {
                int dataLength = in.readInt();
                byte[] data = new byte[dataLength];
                in.readByteArray(data);
                builder2.setData(data);
            }
            if (in.readInt() == 1) {
                int saltLength = in.readInt();
                byte[] salt = new byte[saltLength];
                in.readByteArray(salt);
                builder2.setData(salt);
            }
            return builder2.build();
        }

        public NearbyDeviceParcelable[] newArray(int size) {
            return new NearbyDeviceParcelable[size];
        }
    };
    int mScanType;
    private final String mName;
    @NearbyDevice.Medium
    private final int mMedium;
    private final int mTxPower;
    private final int mRssi;
    private final int mAction;
    private final PublicCredential mPublicCredential;
    private final String mBluetoothAddress;
    private final String mFastPairModelId;
    private final byte[] mData;
    private final byte[] mSalt;

    private NearbyDeviceParcelable(int scanType, String name, int medium, int TxPower, int rssi, int action2, PublicCredential publicCredential, String fastPairModelId, String bluetoothAddress, byte[] data, byte[] salt) {
        this.mScanType = scanType;
        this.mName = name;
        this.mMedium = medium;
        this.mTxPower = TxPower;
        this.mRssi = rssi;
        this.mAction = action2;
        this.mPublicCredential = publicCredential;
        this.mFastPairModelId = fastPairModelId;
        this.mBluetoothAddress = bluetoothAddress;
        this.mData = data;
        this.mSalt = salt;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mScanType);
        dest.writeInt(this.mName == null ? 0 : 1);
        if (this.mName != null) {
            dest.writeString(this.mName);
        }
        dest.writeInt(this.mMedium);
        dest.writeInt(this.mTxPower);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mAction);
        dest.writeParcelable(this.mPublicCredential, flags);
        dest.writeInt(this.mFastPairModelId == null ? 0 : 1);
        if (this.mFastPairModelId != null) {
            dest.writeString(this.mFastPairModelId);
        }
        dest.writeInt(this.mBluetoothAddress == null ? 0 : 1);
        if (this.mBluetoothAddress != null) {
            dest.writeString(this.mBluetoothAddress);
        }
        dest.writeInt(this.mData == null ? 0 : 1);
        if (this.mData != null) {
            dest.writeInt(this.mData.length);
            dest.writeByteArray(this.mData);
        }
        dest.writeInt(this.mSalt == null ? 0 : 1);
        if (this.mSalt != null) {
            dest.writeInt(this.mSalt.length);
            dest.writeByteArray(this.mSalt);
        }
    }

    public String toString() {
        return "NearbyDeviceParcelable[scanType=" + this.mScanType + ", name=" + this.mName + ", medium=" + NearbyDevice.mediumToString(this.mMedium) + ", txPower=" + this.mTxPower + ", rssi=" + this.mRssi + ", action=" + this.mAction + ", bluetoothAddress=" + this.mBluetoothAddress + ", fastPairModelId=" + this.mFastPairModelId + ", data=" + Arrays.toString(this.mData) + ", salt=" + Arrays.toString(this.mSalt) + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof NearbyDeviceParcelable) {
            NearbyDeviceParcelable otherNearbyDeviceParcelable = (NearbyDeviceParcelable)other;
            return this.mScanType == otherNearbyDeviceParcelable.mScanType && Objects.equals(this.mName, otherNearbyDeviceParcelable.mName) && this.mMedium == otherNearbyDeviceParcelable.mMedium && this.mTxPower == otherNearbyDeviceParcelable.mTxPower && this.mRssi == otherNearbyDeviceParcelable.mRssi && this.mAction == otherNearbyDeviceParcelable.mAction && Objects.equals(this.mPublicCredential, otherNearbyDeviceParcelable.mPublicCredential) && Objects.equals(this.mBluetoothAddress, otherNearbyDeviceParcelable.mBluetoothAddress) && Objects.equals(this.mFastPairModelId, otherNearbyDeviceParcelable.mFastPairModelId) && Arrays.equals(this.mData, otherNearbyDeviceParcelable.mData) && Arrays.equals(this.mSalt, otherNearbyDeviceParcelable.mSalt);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mScanType, this.mName, this.mMedium, this.mRssi, this.mAction, this.mPublicCredential.hashCode(), this.mBluetoothAddress, this.mFastPairModelId, Arrays.hashCode(this.mData), Arrays.hashCode(this.mSalt));
    }

    public int getScanType() {
        return this.mScanType;
    }

    public String getName() {
        return this.mName;
    }

    @NearbyDevice.Medium
    public int getMedium() {
        return this.mMedium;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getAction() {
        return this.mAction;
    }

    public PublicCredential getPublicCredential() {
        return this.mPublicCredential;
    }

    public String getFastPairModelId() {
        return this.mFastPairModelId;
    }

    public String getBluetoothAddress() {
        return this.mBluetoothAddress;
    }

    public byte[] getData() {
        return this.mData;
    }

    public byte[] getSalt() {
        return this.mSalt;
    }

    public static class Builder {
        private String mName;
        @NearbyDevice.Medium
        private int mMedium;
        private int mTxPower;
        private int mRssi;
        private int mAction;
        private PublicCredential mPublicCredential;
        int mScanType;
        private String mFastPairModelId;
        private String mBluetoothAddress;
        private byte[] mData;
        private byte[] mSalt;

        public Builder setScanType(int scanType) {
            this.mScanType = scanType;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setMedium(@NearbyDevice.Medium int medium) {
            this.mMedium = medium;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.mTxPower = txPower;
            return this;
        }

        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        public Builder setAction(int action2) {
            this.mAction = action2;
            return this;
        }

        public Builder setPublicCredential(PublicCredential publicCredential) {
            this.mPublicCredential = publicCredential;
            return this;
        }

        public Builder setFastPairModelId(String fastPairModelId) {
            this.mFastPairModelId = fastPairModelId;
            return this;
        }

        public Builder setBluetoothAddress(String bluetoothAddress) {
            this.mBluetoothAddress = bluetoothAddress;
            return this;
        }

        public Builder setData(byte[] data) {
            this.mData = data;
            return this;
        }

        public Builder setSalt(byte[] salt) {
            this.mSalt = salt;
            return this;
        }

        public NearbyDeviceParcelable build() {
            return new NearbyDeviceParcelable(this.mScanType, this.mName, this.mMedium, this.mTxPower, this.mRssi, this.mAction, this.mPublicCredential, this.mFastPairModelId, this.mBluetoothAddress, this.mData, this.mSalt);
        }
    }
}

