/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.nearby.BroadcastRequest;
import android.nearby.DataElement;
import android.nearby.PrivateCredential;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PresenceBroadcastRequest
extends BroadcastRequest
implements Parcelable {
    private final byte[] mSalt;
    private final List<Integer> mActions;
    private final PrivateCredential mCredential;
    private final List<DataElement> mExtendedProperties;
    public static final Parcelable.Creator<PresenceBroadcastRequest> CREATOR = new Parcelable.Creator<PresenceBroadcastRequest>(){

        @Override
        public PresenceBroadcastRequest createFromParcel(Parcel in) {
            in.readInt();
            return PresenceBroadcastRequest.createFromParcelBody(in);
        }

        public PresenceBroadcastRequest[] newArray(int size) {
            return new PresenceBroadcastRequest[size];
        }
    };

    private PresenceBroadcastRequest(int version, int txPower, List<Integer> mediums, byte[] salt, List<Integer> actions2, PrivateCredential credential, List<DataElement> extendedProperties) {
        super(3, version, txPower, mediums);
        this.mSalt = salt;
        this.mActions = actions2;
        this.mCredential = credential;
        this.mExtendedProperties = extendedProperties;
    }

    private PresenceBroadcastRequest(Parcel in) {
        super(3, in);
        this.mSalt = new byte[in.readInt()];
        in.readByteArray(this.mSalt);
        this.mActions = new ArrayList<Integer>();
        in.readList(this.mActions, Integer.class.getClassLoader(), Integer.class);
        this.mCredential = in.readParcelable(PrivateCredential.class.getClassLoader(), PrivateCredential.class);
        this.mExtendedProperties = new ArrayList<DataElement>();
        in.readList(this.mExtendedProperties, DataElement.class.getClassLoader(), DataElement.class);
    }

    static PresenceBroadcastRequest createFromParcelBody(Parcel in) {
        return new PresenceBroadcastRequest(in);
    }

    public byte[] getSalt() {
        return this.mSalt;
    }

    public List<Integer> getActions() {
        return this.mActions;
    }

    public PrivateCredential getCredential() {
        return this.mCredential;
    }

    public List<DataElement> getExtendedProperties() {
        return this.mExtendedProperties;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mSalt.length);
        dest.writeByteArray(this.mSalt);
        dest.writeList(this.mActions);
        dest.writeParcelable(this.mCredential, 0);
        dest.writeList(this.mExtendedProperties);
    }

    public static class Builder {
        private final List<Integer> mMediums;
        private final List<Integer> mActions;
        private final List<DataElement> mExtendedProperties;
        private final byte[] mSalt;
        private final PrivateCredential mCredential;
        private int mVersion;
        private int mTxPower;

        public Builder(List<Integer> mediums, byte[] salt, PrivateCredential credential) {
            Preconditions.checkState(!mediums.isEmpty(), "mediums cannot be empty");
            Preconditions.checkState(salt != null && salt.length > 0, "salt cannot be empty");
            this.mVersion = 0;
            this.mTxPower = -127;
            this.mCredential = credential;
            this.mActions = new ArrayList<Integer>();
            this.mExtendedProperties = new ArrayList<DataElement>();
            this.mSalt = salt;
            this.mMediums = mediums;
        }

        public Builder setVersion(int version) {
            this.mVersion = version;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.mTxPower = txPower;
            return this;
        }

        public Builder addAction(int action2) {
            this.mActions.add(action2);
            return this;
        }

        public Builder addExtendedProperty(DataElement dataElement) {
            Objects.requireNonNull(dataElement);
            this.mExtendedProperties.add(dataElement);
            return this;
        }

        public PresenceBroadcastRequest build() {
            return new PresenceBroadcastRequest(this.mVersion, this.mTxPower, this.mMediums, this.mSalt, this.mActions, this.mCredential, this.mExtendedProperties);
        }
    }
}

