/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.SystemApi;
import android.nearby.CredentialElement;
import android.os.Parcel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public abstract class PresenceCredential {
    public static final int CREDENTIAL_TYPE_PRIVATE = 0;
    public static final int CREDENTIAL_TYPE_PUBLIC = 1;
    public static final int IDENTITY_TYPE_UNKNOWN = 0;
    public static final int IDENTITY_TYPE_PRIVATE = 1;
    public static final int IDENTITY_TYPE_PROVISIONED = 2;
    public static final int IDENTITY_TYPE_TRUSTED = 3;
    private final int mType;
    private final int mIdentityType;
    private final byte[] mSecretId;
    private final byte[] mAuthenticityKey;
    private final List<CredentialElement> mCredentialElements;

    PresenceCredential(int type, int identityType, byte[] secretId, byte[] authenticityKey, List<CredentialElement> credentialElements) {
        this.mType = type;
        this.mIdentityType = identityType;
        this.mSecretId = secretId;
        this.mAuthenticityKey = authenticityKey;
        this.mCredentialElements = credentialElements;
    }

    PresenceCredential(int type, Parcel in) {
        this.mType = type;
        this.mIdentityType = in.readInt();
        this.mSecretId = new byte[in.readInt()];
        in.readByteArray(this.mSecretId);
        this.mAuthenticityKey = new byte[in.readInt()];
        in.readByteArray(this.mAuthenticityKey);
        this.mCredentialElements = new ArrayList<CredentialElement>();
        in.readList(this.mCredentialElements, CredentialElement.class.getClassLoader(), CredentialElement.class);
    }

    public int getType() {
        return this.mType;
    }

    public int getIdentityType() {
        return this.mIdentityType;
    }

    public byte[] getSecretId() {
        return this.mSecretId;
    }

    public byte[] getAuthenticityKey() {
        return this.mAuthenticityKey;
    }

    public List<CredentialElement> getCredentialElements() {
        return this.mCredentialElements;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PresenceCredential) {
            PresenceCredential that = (PresenceCredential)obj;
            return this.mType == that.mType && this.mIdentityType == that.mIdentityType && Arrays.equals(this.mSecretId, that.mSecretId) && Arrays.equals(this.mAuthenticityKey, that.mAuthenticityKey) && this.mCredentialElements.equals(that.mCredentialElements);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mIdentityType, Arrays.hashCode(this.mSecretId), Arrays.hashCode(this.mAuthenticityKey), this.mCredentialElements.hashCode());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mIdentityType);
        dest.writeInt(this.mSecretId.length);
        dest.writeByteArray(this.mSecretId);
        dest.writeInt(this.mAuthenticityKey.length);
        dest.writeByteArray(this.mAuthenticityKey);
        dest.writeList(this.mCredentialElements);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IdentityType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CredentialType {
    }
}

