/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.IConnectivityDiagnosticsCallback;
import android.net.IConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class ConnectivityDiagnosticsManager {
    @VisibleForTesting
    public static final Map<ConnectivityDiagnosticsCallback, ConnectivityDiagnosticsBinder> sCallbacks = new ConcurrentHashMap<ConnectivityDiagnosticsCallback, ConnectivityDiagnosticsBinder>();
    private final Context mContext;
    private final IConnectivityManager mService;

    public ConnectivityDiagnosticsManager(Context context, IConnectivityManager service) {
        this.mContext = Objects.requireNonNull(context, "missing context");
        this.mService = Objects.requireNonNull(service, "missing IConnectivityManager");
    }

    @VisibleForTesting
    public static boolean persistableBundleEquals(PersistableBundle a, PersistableBundle b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!Objects.equals(a.keySet(), b.keySet())) {
            return false;
        }
        for (String key : a.keySet()) {
            if (Objects.equals(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }

    public void registerConnectivityDiagnosticsCallback(NetworkRequest request, Executor e, ConnectivityDiagnosticsCallback callback2) {
        ConnectivityDiagnosticsBinder binder = new ConnectivityDiagnosticsBinder(callback2, e);
        if (sCallbacks.putIfAbsent(callback2, binder) != null) {
            throw new IllegalArgumentException("Callback is currently registered");
        }
        try {
            this.mService.registerConnectivityDiagnosticsCallback(binder, request, this.mContext.getOpPackageName());
        }
        catch (RemoteException exception) {
            exception.rethrowFromSystemServer();
        }
    }

    public void unregisterConnectivityDiagnosticsCallback(ConnectivityDiagnosticsCallback callback2) {
        ConnectivityDiagnosticsBinder binder = sCallbacks.remove(callback2);
        if (binder == null) {
            return;
        }
        try {
            this.mService.unregisterConnectivityDiagnosticsCallback(binder);
        }
        catch (RemoteException exception) {
            exception.rethrowFromSystemServer();
        }
    }

    public static abstract class ConnectivityDiagnosticsCallback {
        public void onConnectivityReportAvailable(ConnectivityReport report) {
        }

        public void onDataStallSuspected(DataStallReport report) {
        }

        public void onNetworkConnectivityReported(Network network, boolean hasConnectivity) {
        }
    }

    @VisibleForTesting
    public static class ConnectivityDiagnosticsBinder
    extends IConnectivityDiagnosticsCallback.Stub {
        private final ConnectivityDiagnosticsCallback mCb;
        private final Executor mExecutor;

        @VisibleForTesting
        public ConnectivityDiagnosticsBinder(ConnectivityDiagnosticsCallback cb, Executor executor) {
            this.mCb = cb;
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @VisibleForTesting
        public void onConnectivityReportAvailable(ConnectivityReport report) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCb.onConnectivityReportAvailable(report));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @VisibleForTesting
        public void onDataStallSuspected(DataStallReport report) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCb.onDataStallSuspected(report));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @VisibleForTesting
        public void onNetworkConnectivityReported(Network network, boolean hasConnectivity) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCb.onNetworkConnectivityReported(network, hasConnectivity));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static class DataStallReport
    implements Parcelable {
        public static final int DETECTION_METHOD_DNS_EVENTS = 1;
        public static final int DETECTION_METHOD_TCP_METRICS = 2;
        public static final String KEY_TCP_METRICS_COLLECTION_PERIOD_MILLIS = "tcpMetricsCollectionPeriodMillis";
        public static final String KEY_TCP_PACKET_FAIL_RATE = "tcpPacketFailRate";
        public static final String KEY_DNS_CONSECUTIVE_TIMEOUTS = "dnsConsecutiveTimeouts";
        private final Network mNetwork;
        private long mReportTimestamp;
        private final int mDetectionMethod;
        private final LinkProperties mLinkProperties;
        private final NetworkCapabilities mNetworkCapabilities;
        private final PersistableBundle mStallDetails;
        public static final Parcelable.Creator<DataStallReport> CREATOR = new Parcelable.Creator<DataStallReport>(){

            @Override
            public DataStallReport createFromParcel(Parcel in) {
                return new DataStallReport((Network)in.readParcelable(null), in.readLong(), in.readInt(), (LinkProperties)in.readParcelable(null), (NetworkCapabilities)in.readParcelable(null), (PersistableBundle)in.readParcelable(null));
            }

            public DataStallReport[] newArray(int size) {
                return new DataStallReport[size];
            }
        };

        public DataStallReport(Network network, long reportTimestamp, int detectionMethod, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, PersistableBundle stallDetails) {
            this.mNetwork = network;
            this.mReportTimestamp = reportTimestamp;
            this.mDetectionMethod = detectionMethod;
            this.mLinkProperties = new LinkProperties(linkProperties);
            this.mNetworkCapabilities = new NetworkCapabilities(networkCapabilities);
            this.mStallDetails = stallDetails;
        }

        public Network getNetwork() {
            return this.mNetwork;
        }

        public long getReportTimestamp() {
            return this.mReportTimestamp;
        }

        public int getDetectionMethod() {
            return this.mDetectionMethod;
        }

        public LinkProperties getLinkProperties() {
            return new LinkProperties(this.mLinkProperties);
        }

        public NetworkCapabilities getNetworkCapabilities() {
            return new NetworkCapabilities(this.mNetworkCapabilities);
        }

        public PersistableBundle getStallDetails() {
            return new PersistableBundle(this.mStallDetails);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataStallReport)) {
                return false;
            }
            DataStallReport that = (DataStallReport)o;
            return this.mReportTimestamp == that.mReportTimestamp && this.mDetectionMethod == that.mDetectionMethod && this.mNetwork.equals(that.mNetwork) && this.mLinkProperties.equals(that.mLinkProperties) && this.mNetworkCapabilities.equals(that.mNetworkCapabilities) && ConnectivityDiagnosticsManager.persistableBundleEquals(this.mStallDetails, that.mStallDetails);
        }

        public int hashCode() {
            return Objects.hash(this.mNetwork, this.mReportTimestamp, this.mDetectionMethod, this.mLinkProperties, this.mNetworkCapabilities, this.mStallDetails);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mNetwork, flags);
            dest.writeLong(this.mReportTimestamp);
            dest.writeInt(this.mDetectionMethod);
            dest.writeParcelable(this.mLinkProperties, flags);
            dest.writeParcelable(this.mNetworkCapabilities, flags);
            dest.writeParcelable(this.mStallDetails, flags);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataStallReportBundleKeys {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DetectionMethod {
        }
    }

    public static class ConnectivityReport
    implements Parcelable {
        public static final int NETWORK_VALIDATION_RESULT_INVALID = 0;
        public static final int NETWORK_VALIDATION_RESULT_VALID = 1;
        public static final int NETWORK_VALIDATION_RESULT_PARTIALLY_VALID = 2;
        public static final int NETWORK_VALIDATION_RESULT_SKIPPED = 3;
        public static final String KEY_NETWORK_VALIDATION_RESULT = "networkValidationResult";
        public static final int NETWORK_PROBE_DNS = 4;
        public static final int NETWORK_PROBE_HTTP = 8;
        public static final int NETWORK_PROBE_HTTPS = 16;
        public static final int NETWORK_PROBE_FALLBACK = 32;
        public static final int NETWORK_PROBE_PRIVATE_DNS = 64;
        public static final String KEY_NETWORK_PROBES_SUCCEEDED_BITMASK = "networkProbesSucceeded";
        public static final String KEY_NETWORK_PROBES_ATTEMPTED_BITMASK = "networkProbesAttempted";
        private final Network mNetwork;
        private final long mReportTimestamp;
        private final LinkProperties mLinkProperties;
        private final NetworkCapabilities mNetworkCapabilities;
        private final PersistableBundle mAdditionalInfo;
        public static final Parcelable.Creator<ConnectivityReport> CREATOR = new Parcelable.Creator<ConnectivityReport>(){

            @Override
            public ConnectivityReport createFromParcel(Parcel in) {
                return new ConnectivityReport((Network)in.readParcelable(null), in.readLong(), (LinkProperties)in.readParcelable(null), (NetworkCapabilities)in.readParcelable(null), (PersistableBundle)in.readParcelable(null));
            }

            public ConnectivityReport[] newArray(int size) {
                return new ConnectivityReport[size];
            }
        };

        public ConnectivityReport(Network network, long reportTimestamp, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, PersistableBundle additionalInfo) {
            this.mNetwork = network;
            this.mReportTimestamp = reportTimestamp;
            this.mLinkProperties = new LinkProperties(linkProperties);
            this.mNetworkCapabilities = new NetworkCapabilities(networkCapabilities);
            this.mAdditionalInfo = additionalInfo;
        }

        public Network getNetwork() {
            return this.mNetwork;
        }

        public long getReportTimestamp() {
            return this.mReportTimestamp;
        }

        public LinkProperties getLinkProperties() {
            return new LinkProperties(this.mLinkProperties);
        }

        public NetworkCapabilities getNetworkCapabilities() {
            return new NetworkCapabilities(this.mNetworkCapabilities);
        }

        public PersistableBundle getAdditionalInfo() {
            return new PersistableBundle(this.mAdditionalInfo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectivityReport)) {
                return false;
            }
            ConnectivityReport that = (ConnectivityReport)o;
            return this.mReportTimestamp == that.mReportTimestamp && this.mNetwork.equals(that.mNetwork) && this.mLinkProperties.equals(that.mLinkProperties) && this.mNetworkCapabilities.equals(that.mNetworkCapabilities) && ConnectivityDiagnosticsManager.persistableBundleEquals(this.mAdditionalInfo, that.mAdditionalInfo);
        }

        public int hashCode() {
            return Objects.hash(this.mNetwork, this.mReportTimestamp, this.mLinkProperties, this.mNetworkCapabilities, this.mAdditionalInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mNetwork, flags);
            dest.writeLong(this.mReportTimestamp);
            dest.writeParcelable(this.mLinkProperties, flags);
            dest.writeParcelable(this.mNetworkCapabilities, flags);
            dest.writeParcelable(this.mAdditionalInfo, flags);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConnectivityReportBundleKeys {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NetworkProbe {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NetworkValidationResult {
        }
    }
}

