/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpSecConfig;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransformResponse;
import android.net.IpSecTunnelInterfaceResponse;
import android.net.IpSecUdpEncapResponse;
import android.net.LinkAddress;
import android.net.Network;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IIpSecService
extends IInterface {
    public IpSecSpiResponse allocateSecurityParameterIndex(String var1, int var2, IBinder var3) throws RemoteException;

    public void releaseSecurityParameterIndex(int var1) throws RemoteException;

    public IpSecUdpEncapResponse openUdpEncapsulationSocket(int var1, IBinder var2) throws RemoteException;

    public void closeUdpEncapsulationSocket(int var1) throws RemoteException;

    public IpSecTunnelInterfaceResponse createTunnelInterface(String var1, String var2, Network var3, IBinder var4, String var5) throws RemoteException;

    public void addAddressToTunnelInterface(int var1, LinkAddress var2, String var3) throws RemoteException;

    public void removeAddressFromTunnelInterface(int var1, LinkAddress var2, String var3) throws RemoteException;

    public void setNetworkForTunnelInterface(int var1, Network var2, String var3) throws RemoteException;

    public void deleteTunnelInterface(int var1, String var2) throws RemoteException;

    public IpSecTransformResponse createTransform(IpSecConfig var1, IBinder var2, String var3) throws RemoteException;

    public void deleteTransform(int var1) throws RemoteException;

    public void applyTransportModeTransform(ParcelFileDescriptor var1, int var2, int var3) throws RemoteException;

    public void applyTunnelModeTransform(int var1, int var2, int var3, String var4) throws RemoteException;

    public void removeTransportModeTransforms(ParcelFileDescriptor var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIpSecService {
        public static final String DESCRIPTOR = "android.net.IIpSecService";
        static final int TRANSACTION_allocateSecurityParameterIndex = 1;
        static final int TRANSACTION_releaseSecurityParameterIndex = 2;
        static final int TRANSACTION_openUdpEncapsulationSocket = 3;
        static final int TRANSACTION_closeUdpEncapsulationSocket = 4;
        static final int TRANSACTION_createTunnelInterface = 5;
        static final int TRANSACTION_addAddressToTunnelInterface = 6;
        static final int TRANSACTION_removeAddressFromTunnelInterface = 7;
        static final int TRANSACTION_setNetworkForTunnelInterface = 8;
        static final int TRANSACTION_deleteTunnelInterface = 9;
        static final int TRANSACTION_createTransform = 10;
        static final int TRANSACTION_deleteTransform = 11;
        static final int TRANSACTION_applyTransportModeTransform = 12;
        static final int TRANSACTION_applyTunnelModeTransform = 13;
        static final int TRANSACTION_removeTransportModeTransforms = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIpSecService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIpSecService) {
                return (IIpSecService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "allocateSecurityParameterIndex";
                }
                case 2: {
                    return "releaseSecurityParameterIndex";
                }
                case 3: {
                    return "openUdpEncapsulationSocket";
                }
                case 4: {
                    return "closeUdpEncapsulationSocket";
                }
                case 5: {
                    return "createTunnelInterface";
                }
                case 6: {
                    return "addAddressToTunnelInterface";
                }
                case 7: {
                    return "removeAddressFromTunnelInterface";
                }
                case 8: {
                    return "setNetworkForTunnelInterface";
                }
                case 9: {
                    return "deleteTunnelInterface";
                }
                case 10: {
                    return "createTransform";
                }
                case 11: {
                    return "deleteTransform";
                }
                case 12: {
                    return "applyTransportModeTransform";
                }
                case 13: {
                    return "applyTunnelModeTransform";
                }
                case 14: {
                    return "removeTransportModeTransforms";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IpSecSpiResponse _result = this.allocateSecurityParameterIndex(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseSecurityParameterIndex(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IpSecUdpEncapResponse _result = this.openUdpEncapsulationSocket(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.closeUdpEncapsulationSocket(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Network _arg2 = data.readTypedObject(Network.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    IpSecTunnelInterfaceResponse _result = this.createTunnelInterface(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    LinkAddress _arg1 = data.readTypedObject(LinkAddress.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.addAddressToTunnelInterface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    LinkAddress _arg1 = data.readTypedObject(LinkAddress.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeAddressFromTunnelInterface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    Network _arg1 = data.readTypedObject(Network.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setNetworkForTunnelInterface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteTunnelInterface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IpSecConfig _arg0 = data.readTypedObject(IpSecConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    IpSecTransformResponse _result = this.createTransform(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteTransform(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.applyTransportModeTransform(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.applyTunnelModeTransform(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeTransportModeTransforms(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IIpSecService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IpSecSpiResponse allocateSecurityParameterIndex(String destinationAddress, int requestedSpi, IBinder binder) throws RemoteException {
                IpSecSpiResponse _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(destinationAddress);
                    _data.writeInt(requestedSpi);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IpSecSpiResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSecurityParameterIndex(int resourceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(resourceId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IpSecUdpEncapResponse openUdpEncapsulationSocket(int port, IBinder binder) throws RemoteException {
                IpSecUdpEncapResponse _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(port);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IpSecUdpEncapResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeUdpEncapsulationSocket(int resourceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(resourceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IpSecTunnelInterfaceResponse createTunnelInterface(String localAddr, String remoteAddr, Network underlyingNetwork, IBinder binder, String callingPackage) throws RemoteException {
                IpSecTunnelInterfaceResponse _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(localAddr);
                    _data.writeString(remoteAddr);
                    _data.writeTypedObject(underlyingNetwork, 0);
                    _data.writeStrongBinder(binder);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IpSecTunnelInterfaceResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAddressToTunnelInterface(int tunnelResourceId, LinkAddress localAddr, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(tunnelResourceId);
                    _data.writeTypedObject(localAddr, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAddressFromTunnelInterface(int tunnelResourceId, LinkAddress localAddr, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(tunnelResourceId);
                    _data.writeTypedObject(localAddr, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNetworkForTunnelInterface(int tunnelResourceId, Network underlyingNetwork, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(tunnelResourceId);
                    _data.writeTypedObject(underlyingNetwork, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteTunnelInterface(int resourceId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(resourceId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IpSecTransformResponse createTransform(IpSecConfig c, IBinder binder, String callingPackage) throws RemoteException {
                IpSecTransformResponse _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(c, 0);
                    _data.writeStrongBinder(binder);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IpSecTransformResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteTransform(int transformId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(transformId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyTransportModeTransform(ParcelFileDescriptor socket, int direction, int transformId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(socket, 0);
                    _data.writeInt(direction);
                    _data.writeInt(transformId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyTunnelModeTransform(int tunnelResourceId, int direction, int transformResourceId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(tunnelResourceId);
                    _data.writeInt(direction);
                    _data.writeInt(transformResourceId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeTransportModeTransforms(ParcelFileDescriptor socket) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(socket, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IIpSecService {
        @Override
        public IpSecSpiResponse allocateSecurityParameterIndex(String destinationAddress, int requestedSpi, IBinder binder) throws RemoteException {
            return null;
        }

        @Override
        public void releaseSecurityParameterIndex(int resourceId) throws RemoteException {
        }

        @Override
        public IpSecUdpEncapResponse openUdpEncapsulationSocket(int port, IBinder binder) throws RemoteException {
            return null;
        }

        @Override
        public void closeUdpEncapsulationSocket(int resourceId) throws RemoteException {
        }

        @Override
        public IpSecTunnelInterfaceResponse createTunnelInterface(String localAddr, String remoteAddr, Network underlyingNetwork, IBinder binder, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void addAddressToTunnelInterface(int tunnelResourceId, LinkAddress localAddr, String callingPackage) throws RemoteException {
        }

        @Override
        public void removeAddressFromTunnelInterface(int tunnelResourceId, LinkAddress localAddr, String callingPackage) throws RemoteException {
        }

        @Override
        public void setNetworkForTunnelInterface(int tunnelResourceId, Network underlyingNetwork, String callingPackage) throws RemoteException {
        }

        @Override
        public void deleteTunnelInterface(int resourceId, String callingPackage) throws RemoteException {
        }

        @Override
        public IpSecTransformResponse createTransform(IpSecConfig c, IBinder binder, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void deleteTransform(int transformId) throws RemoteException {
        }

        @Override
        public void applyTransportModeTransform(ParcelFileDescriptor socket, int direction, int transformId) throws RemoteException {
        }

        @Override
        public void applyTunnelModeTransform(int tunnelResourceId, int direction, int transformResourceId, String callingPackage) throws RemoteException {
        }

        @Override
        public void removeTransportModeTransforms(ParcelFileDescriptor socket) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

