/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkOfferCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.INetworkOfferCallback";

    public void onNetworkNeeded(NetworkRequest var1) throws RemoteException;

    public void onNetworkUnneeded(NetworkRequest var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkOfferCallback {
        static final int TRANSACTION_onNetworkNeeded = 1;
        static final int TRANSACTION_onNetworkUnneeded = 2;

        public Stub() {
            this.attachInterface(this, INetworkOfferCallback.DESCRIPTOR);
        }

        public static INetworkOfferCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkOfferCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkOfferCallback) {
                return (INetworkOfferCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onNetworkNeeded";
                }
                case 2: {
                    return "onNetworkUnneeded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkOfferCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    NetworkRequest _arg0 = data.readTypedObject(NetworkRequest.CREATOR);
                    this.onNetworkNeeded(_arg0);
                    break;
                }
                case 2: {
                    NetworkRequest _arg0 = data.readTypedObject(NetworkRequest.CREATOR);
                    this.onNetworkUnneeded(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements INetworkOfferCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkOfferCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkNeeded(NetworkRequest networkRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkOfferCallback.DESCRIPTOR);
                    _data.writeTypedObject(networkRequest, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkUnneeded(NetworkRequest networkRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkOfferCallback.DESCRIPTOR);
                    _data.writeTypedObject(networkRequest, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkOfferCallback {
        @Override
        public void onNetworkNeeded(NetworkRequest networkRequest) throws RemoteException {
        }

        @Override
        public void onNetworkUnneeded(NetworkRequest networkRequest) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

