/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.SubscriptionPlan;

public interface INetworkPolicyListener
extends IInterface {
    public void onUidRulesChanged(int var1, int var2) throws RemoteException;

    public void onMeteredIfacesChanged(String[] var1) throws RemoteException;

    public void onRestrictBackgroundChanged(boolean var1) throws RemoteException;

    public void onUidPoliciesChanged(int var1, int var2) throws RemoteException;

    public void onSubscriptionOverride(int var1, int var2, int var3, int[] var4) throws RemoteException;

    public void onSubscriptionPlansChanged(int var1, SubscriptionPlan[] var2) throws RemoteException;

    public void onBlockedReasonChanged(int var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkPolicyListener {
        public static final String DESCRIPTOR = "android.net.INetworkPolicyListener";
        static final int TRANSACTION_onUidRulesChanged = 1;
        static final int TRANSACTION_onMeteredIfacesChanged = 2;
        static final int TRANSACTION_onRestrictBackgroundChanged = 3;
        static final int TRANSACTION_onUidPoliciesChanged = 4;
        static final int TRANSACTION_onSubscriptionOverride = 5;
        static final int TRANSACTION_onSubscriptionPlansChanged = 6;
        static final int TRANSACTION_onBlockedReasonChanged = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkPolicyListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkPolicyListener) {
                return (INetworkPolicyListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onUidRulesChanged";
                }
                case 2: {
                    return "onMeteredIfacesChanged";
                }
                case 3: {
                    return "onRestrictBackgroundChanged";
                }
                case 4: {
                    return "onUidPoliciesChanged";
                }
                case 5: {
                    return "onSubscriptionOverride";
                }
                case 6: {
                    return "onSubscriptionPlansChanged";
                }
                case 7: {
                    return "onBlockedReasonChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUidRulesChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String[] _arg0 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.onMeteredIfacesChanged(_arg0);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onRestrictBackgroundChanged(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUidPoliciesChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int[] _arg3 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.onSubscriptionOverride(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    SubscriptionPlan[] _arg1 = data.createTypedArray(SubscriptionPlan.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSubscriptionPlansChanged(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBlockedReasonChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements INetworkPolicyListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUidRulesChanged(int uid, int uidRules) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(uidRules);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMeteredIfacesChanged(String[] meteredIfaces) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(meteredIfaces);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRestrictBackgroundChanged(boolean restrictBackground) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(restrictBackground);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUidPoliciesChanged(int uid, int uidPolicies) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(uidPolicies);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(overrideMask);
                    _data.writeInt(overrideValue);
                    _data.writeIntArray(networkTypes);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscriptionPlansChanged(int subId, SubscriptionPlan[] plans) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedArray(plans, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBlockedReasonChanged(int uid, int oldBlockedReason, int newBlockedReason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(oldBlockedReason);
                    _data.writeInt(newBlockedReason);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkPolicyListener {
        @Override
        public void onUidRulesChanged(int uid, int uidRules) throws RemoteException {
        }

        @Override
        public void onMeteredIfacesChanged(String[] meteredIfaces) throws RemoteException {
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) throws RemoteException {
        }

        @Override
        public void onUidPoliciesChanged(int uid, int uidPolicies) throws RemoteException {
        }

        @Override
        public void onSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes) throws RemoteException {
        }

        @Override
        public void onSubscriptionPlansChanged(int subId, SubscriptionPlan[] plans) throws RemoteException {
        }

        @Override
        public void onBlockedReasonChanged(int uid, int oldBlockedReason, int newBlockedReason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

