/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.ProxyInfo;
import android.net.StaticIpConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class IpConfiguration
implements Parcelable {
    private static final String TAG = "IpConfiguration";
    public IpAssignment ipAssignment;
    public StaticIpConfiguration staticIpConfiguration;
    public ProxySettings proxySettings;
    @UnsupportedAppUsage
    public ProxyInfo httpProxy;
    public static final Parcelable.Creator<IpConfiguration> CREATOR = new Parcelable.Creator<IpConfiguration>(){

        @Override
        public IpConfiguration createFromParcel(Parcel in) {
            IpConfiguration config = new IpConfiguration();
            config.ipAssignment = IpAssignment.valueOf(in.readString());
            config.proxySettings = ProxySettings.valueOf(in.readString());
            config.staticIpConfiguration = (StaticIpConfiguration)in.readParcelable(null);
            config.httpProxy = (ProxyInfo)in.readParcelable(null);
            return config;
        }

        public IpConfiguration[] newArray(int size) {
            return new IpConfiguration[size];
        }
    };

    private void init(IpAssignment ipAssignment, ProxySettings proxySettings, StaticIpConfiguration staticIpConfiguration, ProxyInfo httpProxy) {
        this.ipAssignment = ipAssignment;
        this.proxySettings = proxySettings;
        this.staticIpConfiguration = staticIpConfiguration == null ? null : new StaticIpConfiguration(staticIpConfiguration);
        this.httpProxy = httpProxy == null ? null : new ProxyInfo(httpProxy);
    }

    @SystemApi
    public IpConfiguration() {
        this.init(IpAssignment.UNASSIGNED, ProxySettings.UNASSIGNED, null, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IpConfiguration(IpAssignment ipAssignment, ProxySettings proxySettings, StaticIpConfiguration staticIpConfiguration, ProxyInfo httpProxy) {
        this.init(ipAssignment, proxySettings, staticIpConfiguration, httpProxy);
    }

    @SystemApi
    public IpConfiguration(IpConfiguration source) {
        this();
        if (source != null) {
            this.init(source.ipAssignment, source.proxySettings, source.staticIpConfiguration, source.httpProxy);
        }
    }

    @SystemApi
    public IpAssignment getIpAssignment() {
        return this.ipAssignment;
    }

    @SystemApi
    public void setIpAssignment(IpAssignment ipAssignment) {
        this.ipAssignment = ipAssignment;
    }

    public StaticIpConfiguration getStaticIpConfiguration() {
        return this.staticIpConfiguration;
    }

    @SystemApi
    public void setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this.staticIpConfiguration = staticIpConfiguration;
    }

    @SystemApi
    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    @SystemApi
    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public ProxyInfo getHttpProxy() {
        return this.httpProxy;
    }

    @SystemApi
    public void setHttpProxy(ProxyInfo httpProxy) {
        this.httpProxy = httpProxy;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("IP assignment: " + this.ipAssignment.toString());
        sbuf.append("\n");
        if (this.staticIpConfiguration != null) {
            sbuf.append("Static configuration: " + this.staticIpConfiguration.toString());
            sbuf.append("\n");
        }
        sbuf.append("Proxy settings: " + this.proxySettings.toString());
        sbuf.append("\n");
        if (this.httpProxy != null) {
            sbuf.append("HTTP proxy: " + this.httpProxy.toString());
            sbuf.append("\n");
        }
        return sbuf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpConfiguration)) {
            return false;
        }
        IpConfiguration other = (IpConfiguration)o;
        return this.ipAssignment == other.ipAssignment && this.proxySettings == other.proxySettings && Objects.equals(this.staticIpConfiguration, other.staticIpConfiguration) && Objects.equals(this.httpProxy, other.httpProxy);
    }

    public int hashCode() {
        return 13 + (this.staticIpConfiguration != null ? this.staticIpConfiguration.hashCode() : 0) + 17 * this.ipAssignment.ordinal() + 47 * this.proxySettings.ordinal() + 83 * this.httpProxy.hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.ipAssignment.name());
        dest.writeString(this.proxySettings.name());
        dest.writeParcelable(this.staticIpConfiguration, flags);
        dest.writeParcelable(this.httpProxy, flags);
    }

    public static class Builder {
        private StaticIpConfiguration mStaticIpConfiguration;
        private ProxyInfo mProxyInfo;

        public Builder setStaticIpConfiguration(StaticIpConfiguration config) {
            this.mStaticIpConfiguration = config;
            return this;
        }

        public Builder setHttpProxy(ProxyInfo proxyInfo) {
            this.mProxyInfo = proxyInfo;
            return this;
        }

        public IpConfiguration build() {
            IpConfiguration config = new IpConfiguration();
            config.setStaticIpConfiguration(this.mStaticIpConfiguration);
            config.setIpAssignment(this.mStaticIpConfiguration == null ? IpAssignment.DHCP : IpAssignment.STATIC);
            config.setHttpProxy(this.mProxyInfo);
            if (this.mProxyInfo == null) {
                config.setProxySettings(ProxySettings.NONE);
            } else {
                config.setProxySettings(this.mProxyInfo.getPacFileUrl() == null ? ProxySettings.STATIC : ProxySettings.PAC);
            }
            return config;
        }
    }

    @SystemApi
    @SuppressLint(value={"Enum"})
    public static enum ProxySettings {
        NONE,
        STATIC,
        UNASSIGNED,
        PAC;

    }

    @SystemApi
    @SuppressLint(value={"Enum"})
    public static enum IpAssignment {
        STATIC,
        DHCP,
        UNASSIGNED;

    }
}

