/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IConnectivityManager;
import android.net.Network;
import android.net.SocketKeepalive;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.net.InetAddress;
import java.util.concurrent.Executor;

public class NattSocketKeepalive
extends SocketKeepalive {
    public static final int NATT_PORT = 4500;
    private final InetAddress mSource;
    private final InetAddress mDestination;
    private final int mResourceId;

    NattSocketKeepalive(IConnectivityManager service, Network network, ParcelFileDescriptor pfd, int resourceId, InetAddress source, InetAddress destination, Executor executor, SocketKeepalive.Callback callback2) {
        super(service, network, pfd, executor, callback2);
        this.mSource = source;
        this.mDestination = destination;
        this.mResourceId = resourceId;
    }

    @Override
    void startImpl(int intervalSec) {
        this.mExecutor.execute(() -> {
            try {
                this.mService.startNattKeepaliveWithFd(this.mNetwork, this.mPfd, this.mResourceId, intervalSec, this.mCallback, this.mSource.getHostAddress(), this.mDestination.getHostAddress());
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error starting socket keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }

    @Override
    void stopImpl() {
        this.mExecutor.execute(() -> {
            try {
                if (this.mSlot != null) {
                    this.mService.stopKeepalive(this.mNetwork, this.mSlot);
                }
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error stopping socket keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }
}

