/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.MatchAllNetworkSpecifier;
import android.net.Network;
import android.net.NetworkSpecifier;
import android.net.TransportInfo;
import android.net.UidRange;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.connectivity.com.android.net.module.util.NetworkCapabilitiesUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Range;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class NetworkCapabilities
implements Parcelable {
    private static final String TAG = "NetworkCapabilities";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long REDACT_NONE = 0L;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long REDACT_FOR_ACCESS_FINE_LOCATION = 1L;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long REDACT_FOR_LOCAL_MAC_ADDRESS = 2L;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long REDACT_FOR_NETWORK_SETTINGS = 4L;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long REDACT_ALL = -1L;
    private boolean mPrivateDnsBroken;
    private List<Network> mUnderlyingNetworks;
    private int mRequestorUid;
    private String mRequestorPackageName;
    public static final int NET_ENTERPRISE_ID_1 = 1;
    public static final int NET_ENTERPRISE_ID_2 = 2;
    public static final int NET_ENTERPRISE_ID_3 = 3;
    public static final int NET_ENTERPRISE_ID_4 = 4;
    public static final int NET_ENTERPRISE_ID_5 = 5;
    private int mEnterpriseId;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mNetworkCapabilities;
    private long mForbiddenNetworkCapabilities;
    public static final int NET_CAPABILITY_MMS = 0;
    public static final int NET_CAPABILITY_SUPL = 1;
    public static final int NET_CAPABILITY_DUN = 2;
    public static final int NET_CAPABILITY_FOTA = 3;
    public static final int NET_CAPABILITY_IMS = 4;
    public static final int NET_CAPABILITY_CBS = 5;
    public static final int NET_CAPABILITY_WIFI_P2P = 6;
    public static final int NET_CAPABILITY_IA = 7;
    public static final int NET_CAPABILITY_RCS = 8;
    public static final int NET_CAPABILITY_XCAP = 9;
    public static final int NET_CAPABILITY_EIMS = 10;
    public static final int NET_CAPABILITY_NOT_METERED = 11;
    public static final int NET_CAPABILITY_INTERNET = 12;
    public static final int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static final int NET_CAPABILITY_TRUSTED = 14;
    public static final int NET_CAPABILITY_NOT_VPN = 15;
    public static final int NET_CAPABILITY_VALIDATED = 16;
    public static final int NET_CAPABILITY_CAPTIVE_PORTAL = 17;
    public static final int NET_CAPABILITY_NOT_ROAMING = 18;
    public static final int NET_CAPABILITY_FOREGROUND = 19;
    public static final int NET_CAPABILITY_NOT_CONGESTED = 20;
    public static final int NET_CAPABILITY_NOT_SUSPENDED = 21;
    @SystemApi
    public static final int NET_CAPABILITY_OEM_PAID = 22;
    public static final int NET_CAPABILITY_MCX = 23;
    @SystemApi
    public static final int NET_CAPABILITY_PARTIAL_CONNECTIVITY = 24;
    public static final int NET_CAPABILITY_TEMPORARILY_NOT_METERED = 25;
    @SystemApi
    public static final int NET_CAPABILITY_OEM_PRIVATE = 26;
    @SystemApi
    public static final int NET_CAPABILITY_VEHICLE_INTERNAL = 27;
    @SystemApi
    public static final int NET_CAPABILITY_NOT_VCN_MANAGED = 28;
    public static final int NET_CAPABILITY_ENTERPRISE = 29;
    @SystemApi
    public static final int NET_CAPABILITY_VSIM = 30;
    @SystemApi
    public static final int NET_CAPABILITY_BIP = 31;
    public static final int NET_CAPABILITY_HEAD_UNIT = 32;
    public static final int NET_CAPABILITY_MMTEL = 33;
    public static final int NET_CAPABILITY_PRIORITIZE_LATENCY = 34;
    public static final int NET_CAPABILITY_PRIORITIZE_BANDWIDTH = 35;
    private static final int MIN_NET_CAPABILITY = 0;
    private static final int MAX_NET_CAPABILITY = 35;
    private static final long MUTABLE_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(14, 16, 17, 18, 19, 20, 21, 24, 25, 28, 32);
    private static final long NON_REQUESTABLE_CAPABILITIES = MUTABLE_CAPABILITIES & 0xFFFFFFFFFFFFBFFFL & 0xFFFFFFFFEFFFFFFFL;
    private static final long DEFAULT_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(13, 14, 15);
    private static final long CONNECTIVITY_MANAGED_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(16, 17, 19, 24);
    private static final long TEST_NETWORKS_ALLOWED_CAPABILITIES = NetworkCapabilitiesUtils.packBitList(11, 25, 13, 15, 18, 20, 21, 28);
    private long mTransportTypes;
    public static final int TRANSPORT_CELLULAR = 0;
    public static final int TRANSPORT_WIFI = 1;
    public static final int TRANSPORT_BLUETOOTH = 2;
    public static final int TRANSPORT_ETHERNET = 3;
    public static final int TRANSPORT_VPN = 4;
    public static final int TRANSPORT_WIFI_AWARE = 5;
    public static final int TRANSPORT_LOWPAN = 6;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int TRANSPORT_TEST = 7;
    public static final int TRANSPORT_USB = 8;
    public static final int MIN_TRANSPORT = 0;
    public static final int MAX_TRANSPORT = 8;
    private static final String[] TRANSPORT_NAMES = new String[]{"CELLULAR", "WIFI", "BLUETOOTH", "ETHERNET", "VPN", "WIFI_AWARE", "LOWPAN", "TEST", "USB"};
    private static final long UNRESTRICTED_TEST_NETWORKS_ALLOWED_TRANSPORTS = NetworkCapabilitiesUtils.packBitList(7, 3, 4);
    private int mOwnerUid = -1;
    private int[] mAdministratorUids = new int[0];
    public static final int LINK_BANDWIDTH_UNSPECIFIED = 0;
    private int mLinkUpBandwidthKbps = 0;
    private int mLinkDownBandwidthKbps = 0;
    private NetworkSpecifier mNetworkSpecifier = null;
    private TransportInfo mTransportInfo = null;
    public static final int SIGNAL_STRENGTH_UNSPECIFIED = Integer.MIN_VALUE;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mSignalStrength = Integer.MIN_VALUE;
    private ArraySet<UidRange> mUids = null;
    private final ArraySet<Integer> mAllowedUids = new ArraySet();
    private String mSSID;
    public static final Parcelable.Creator<NetworkCapabilities> CREATOR = new Parcelable.Creator<NetworkCapabilities>(){

        @Override
        public NetworkCapabilities createFromParcel(Parcel in) {
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.mNetworkCapabilities = in.readLong();
            netCap.mForbiddenNetworkCapabilities = in.readLong();
            netCap.mTransportTypes = in.readLong();
            netCap.mLinkUpBandwidthKbps = in.readInt();
            netCap.mLinkDownBandwidthKbps = in.readInt();
            netCap.mNetworkSpecifier = (NetworkSpecifier)in.readParcelable(null);
            netCap.mTransportInfo = (TransportInfo)in.readParcelable(null);
            netCap.mSignalStrength = in.readInt();
            netCap.mUids = this.readParcelableArraySet(in, null);
            int[] allowedUids = in.createIntArray();
            netCap.mAllowedUids.ensureCapacity(allowedUids.length);
            for (int uid : allowedUids) {
                netCap.mAllowedUids.add(uid);
            }
            netCap.mSSID = in.readString();
            netCap.mPrivateDnsBroken = in.readBoolean();
            netCap.setAdministratorUids(in.createIntArray());
            netCap.mOwnerUid = in.readInt();
            netCap.mRequestorUid = in.readInt();
            netCap.mRequestorPackageName = in.readString();
            netCap.mSubIds = new ArraySet();
            int[] subIdInts = Objects.requireNonNull(in.createIntArray());
            for (int i = 0; i < subIdInts.length; ++i) {
                netCap.mSubIds.add(subIdInts[i]);
            }
            netCap.setUnderlyingNetworks(in.createTypedArrayList(Network.CREATOR));
            netCap.mEnterpriseId = in.readInt();
            return netCap;
        }

        public NetworkCapabilities[] newArray(int size) {
            return new NetworkCapabilities[size];
        }

        private <T extends Parcelable> ArraySet<T> readParcelableArraySet(Parcel in, ClassLoader loader) {
            int size = in.readInt();
            if (size < 0) {
                return null;
            }
            ArraySet result = new ArraySet(size);
            for (int i = 0; i < size; ++i) {
                Object value2 = in.readParcelable(loader);
                result.add(value2);
            }
            return result;
        }
    };
    private ArraySet<Integer> mSubIds = new ArraySet();

    public int[] getEnterpriseIds() {
        if (this.hasCapability(29) && this.mEnterpriseId == 0) {
            return new int[]{1};
        }
        return NetworkCapabilitiesUtils.unpackBits(this.mEnterpriseId);
    }

    public boolean hasEnterpriseId(int enterpriseId) {
        if (enterpriseId == 1 && this.hasCapability(29) && this.mEnterpriseId == 0) {
            return true;
        }
        return NetworkCapabilities.isValidEnterpriseId(enterpriseId) && ((long)this.mEnterpriseId & 1L << enterpriseId) != 0L;
    }

    public NetworkCapabilities() {
        this.clearAll();
        this.mNetworkCapabilities = DEFAULT_CAPABILITIES;
    }

    public NetworkCapabilities(NetworkCapabilities nc) {
        this(nc, 0L);
    }

    public NetworkCapabilities(NetworkCapabilities nc, long redactions) {
        if (nc != null) {
            this.set(nc);
        }
        if (this.mTransportInfo != null) {
            this.mTransportInfo = nc.mTransportInfo.makeCopy(redactions);
        }
    }

    public void clearAll() {
        this.mForbiddenNetworkCapabilities = 0L;
        this.mTransportTypes = 0L;
        this.mNetworkCapabilities = 0L;
        this.mLinkDownBandwidthKbps = 0;
        this.mLinkUpBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mTransportInfo = null;
        this.mSignalStrength = Integer.MIN_VALUE;
        this.mUids = null;
        this.mAllowedUids.clear();
        this.mAdministratorUids = new int[0];
        this.mOwnerUid = -1;
        this.mSSID = null;
        this.mPrivateDnsBroken = false;
        this.mRequestorUid = -1;
        this.mRequestorPackageName = null;
        this.mSubIds = new ArraySet();
        this.mUnderlyingNetworks = null;
        this.mEnterpriseId = 0;
    }

    public void set(NetworkCapabilities nc) {
        this.mNetworkCapabilities = nc.mNetworkCapabilities;
        this.mTransportTypes = nc.mTransportTypes;
        this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
        this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
        this.mNetworkSpecifier = nc.mNetworkSpecifier;
        if (nc.getTransportInfo() != null) {
            this.setTransportInfo(nc.getTransportInfo());
        } else {
            this.setTransportInfo(null);
        }
        this.mSignalStrength = nc.mSignalStrength;
        this.mUids = nc.mUids == null ? null : new ArraySet<UidRange>(nc.mUids);
        this.setAllowedUids(nc.mAllowedUids);
        this.setAdministratorUids(nc.getAdministratorUids());
        this.mOwnerUid = nc.mOwnerUid;
        this.mForbiddenNetworkCapabilities = nc.mForbiddenNetworkCapabilities;
        this.mSSID = nc.mSSID;
        this.mPrivateDnsBroken = nc.mPrivateDnsBroken;
        this.mRequestorUid = nc.mRequestorUid;
        this.mRequestorPackageName = nc.mRequestorPackageName;
        this.mSubIds = new ArraySet<Integer>(nc.mSubIds);
        this.mUnderlyingNetworks = nc.mUnderlyingNetworks;
        this.mEnterpriseId = nc.mEnterpriseId;
    }

    public NetworkCapabilities addCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mNetworkCapabilities |= 1L << capability;
        this.mForbiddenNetworkCapabilities &= 1L << capability ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public void addForbiddenCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mForbiddenNetworkCapabilities |= 1L << capability;
        this.mNetworkCapabilities &= 1L << capability ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public NetworkCapabilities removeCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        long mask = 1L << capability ^ 0xFFFFFFFFFFFFFFFFL;
        this.mNetworkCapabilities &= mask;
        return this;
    }

    public NetworkCapabilities removeForbiddenCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mForbiddenNetworkCapabilities &= 1L << capability ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public NetworkCapabilities setCapability(int capability, boolean value2) {
        if (value2) {
            this.addCapability(capability);
        } else {
            this.removeCapability(capability);
        }
        return this;
    }

    public int[] getCapabilities() {
        return NetworkCapabilitiesUtils.unpackBits(this.mNetworkCapabilities);
    }

    public int[] getForbiddenCapabilities() {
        return NetworkCapabilitiesUtils.unpackBits(this.mForbiddenNetworkCapabilities);
    }

    public void setCapabilities(int[] capabilities, int[] forbiddenCapabilities) {
        this.mNetworkCapabilities = NetworkCapabilitiesUtils.packBits(capabilities);
        this.mForbiddenNetworkCapabilities = NetworkCapabilitiesUtils.packBits(forbiddenCapabilities);
    }

    @Deprecated
    public void setCapabilities(int[] capabilities) {
        this.setCapabilities(capabilities, new int[0]);
    }

    public NetworkCapabilities addEnterpriseId(int enterpriseId) {
        NetworkCapabilities.checkValidEnterpriseId(enterpriseId);
        this.mEnterpriseId |= 1 << enterpriseId;
        return this;
    }

    private NetworkCapabilities removeEnterpriseId(int enterpriseId) {
        NetworkCapabilities.checkValidEnterpriseId(enterpriseId);
        int mask = ~(1 << enterpriseId);
        this.mEnterpriseId &= mask;
        return this;
    }

    public void setUnderlyingNetworks(List<Network> networks) {
        this.mUnderlyingNetworks = networks == null ? null : Collections.unmodifiableList(new ArrayList<Network>(networks));
    }

    @SystemApi
    @SuppressLint(value={"NullableCollection"})
    public List<Network> getUnderlyingNetworks() {
        return this.mUnderlyingNetworks;
    }

    private boolean equalsUnderlyingNetworks(NetworkCapabilities nc) {
        return Objects.equals(this.getUnderlyingNetworks(), nc.getUnderlyingNetworks());
    }

    public boolean hasCapability(int capability) {
        return NetworkCapabilities.isValidCapability(capability) && (this.mNetworkCapabilities & 1L << capability) != 0L;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean hasForbiddenCapability(int capability) {
        return NetworkCapabilities.isValidCapability(capability) && (this.mForbiddenNetworkCapabilities & 1L << capability) != 0L;
    }

    public boolean hasConnectivityManagedCapability() {
        return (this.mNetworkCapabilities & CONNECTIVITY_MANAGED_CAPABILITIES) != 0L;
    }

    @SystemApi
    public static String getCapabilityCarrierName(int capability) {
        if (capability == 29) {
            return NetworkCapabilities.capabilityNameOf(capability);
        }
        return null;
    }

    public String describeFirstNonRequestableCapability() {
        long nonRequestable = (this.mNetworkCapabilities | this.mForbiddenNetworkCapabilities) & NON_REQUESTABLE_CAPABILITIES;
        if (nonRequestable != 0L) {
            return NetworkCapabilities.capabilityNameOf(NetworkCapabilitiesUtils.unpackBits(nonRequestable)[0]);
        }
        if (this.mLinkUpBandwidthKbps != 0 || this.mLinkDownBandwidthKbps != 0) {
            return "link bandwidth";
        }
        if (this.hasSignalStrength()) {
            return "signalStrength";
        }
        if (this.isPrivateDnsBroken()) {
            return "privateDnsBroken";
        }
        return null;
    }

    private boolean equalsEnterpriseCapabilitiesId(NetworkCapabilities nc) {
        return nc.mEnterpriseId == this.mEnterpriseId;
    }

    private boolean satisfiedByEnterpriseCapabilitiesId(NetworkCapabilities nc) {
        int providedEnterpriseCapabailitiesId = nc.mEnterpriseId;
        int requestedEnterpriseCapabilitiesId = this.mEnterpriseId;
        if ((providedEnterpriseCapabailitiesId & requestedEnterpriseCapabilitiesId) == requestedEnterpriseCapabilitiesId) {
            return true;
        }
        return providedEnterpriseCapabailitiesId == 0 && (long)requestedEnterpriseCapabilitiesId == 2L;
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        long requestedCapabilities = this.mNetworkCapabilities;
        long requestedForbiddenCapabilities = this.mForbiddenNetworkCapabilities;
        long providedCapabilities = nc.mNetworkCapabilities;
        if (onlyImmutable) {
            requestedCapabilities &= MUTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL;
            requestedForbiddenCapabilities &= MUTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (providedCapabilities & requestedCapabilities) == requestedCapabilities && (requestedForbiddenCapabilities & providedCapabilities) == 0L;
    }

    public boolean equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities && nc.mForbiddenNetworkCapabilities == this.mForbiddenNetworkCapabilities;
    }

    private boolean equalsNetCapabilitiesRequestable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & (NON_REQUESTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL)) == (that.mNetworkCapabilities & (NON_REQUESTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL)) && (this.mForbiddenNetworkCapabilities & (NON_REQUESTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL)) == (that.mForbiddenNetworkCapabilities & (NON_REQUESTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public void maybeMarkCapabilitiesRestricted() {
        if (NetworkCapabilitiesUtils.inferRestrictedCapability(this)) {
            this.removeCapability(13);
        }
    }

    @Deprecated
    public void restrictCapabilitesForTestNetwork(int creatorUid) {
        this.restrictCapabilitiesForTestNetwork(creatorUid);
    }

    public void restrictCapabilitiesForTestNetwork(int creatorUid) {
        long originalCapabilities = this.mNetworkCapabilities;
        long originalTransportTypes = this.mTransportTypes;
        NetworkSpecifier originalSpecifier = this.mNetworkSpecifier;
        int originalSignalStrength = this.mSignalStrength;
        int originalOwnerUid = this.getOwnerUid();
        int[] originalAdministratorUids = this.getAdministratorUids();
        TransportInfo originalTransportInfo = this.getTransportInfo();
        Set<Integer> originalSubIds = this.getSubscriptionIds();
        ArraySet<Integer> originalAllowedUids = new ArraySet<Integer>(this.mAllowedUids);
        this.clearAll();
        if (0L != (originalCapabilities & 0x2000L)) {
            this.mTransportTypes = originalTransportTypes & UNRESTRICTED_TEST_NETWORKS_ALLOWED_TRANSPORTS | 0x80L;
            this.setSubscriptionIds(originalSubIds);
        } else {
            this.mTransportTypes = originalTransportTypes | 0x80L;
        }
        this.mNetworkCapabilities = originalCapabilities & TEST_NETWORKS_ALLOWED_CAPABILITIES;
        this.mNetworkSpecifier = originalSpecifier;
        this.mSignalStrength = originalSignalStrength;
        this.mTransportInfo = originalTransportInfo;
        this.mAllowedUids.addAll((Collection<Integer>)originalAllowedUids);
        if (originalOwnerUid == creatorUid) {
            this.setOwnerUid(creatorUid);
        }
        if (CollectionUtils.contains(originalAdministratorUids, creatorUid)) {
            this.setAdministratorUids(new int[]{creatorUid});
        }
    }

    public static boolean isValidTransport(int transportType) {
        return 0 <= transportType && transportType <= 8;
    }

    public NetworkCapabilities addTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public NetworkCapabilities removeTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public NetworkCapabilities setTransportType(int transportType, boolean value2) {
        if (value2) {
            this.addTransportType(transportType);
        } else {
            this.removeTransportType(transportType);
        }
        return this;
    }

    @SystemApi
    public int[] getTransportTypes() {
        return NetworkCapabilitiesUtils.unpackBits(this.mTransportTypes);
    }

    public void setTransportTypes(int[] transportTypes) {
        this.mTransportTypes = NetworkCapabilitiesUtils.packBits(transportTypes);
    }

    public boolean hasTransport(int transportType) {
        return NetworkCapabilities.isValidTransport(transportType) && (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    public boolean hasSingleTransport(int transportType) {
        return this.mTransportTypes == (long)(1 << transportType);
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    public boolean equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    public NetworkCapabilities setOwnerUid(int uid) {
        this.mOwnerUid = uid;
        return this;
    }

    public int getOwnerUid() {
        return this.mOwnerUid;
    }

    private boolean equalsOwnerUid(NetworkCapabilities nc) {
        return this.mOwnerUid == nc.mOwnerUid;
    }

    public NetworkCapabilities setAdministratorUids(int[] administratorUids) {
        this.mAdministratorUids = Arrays.copyOf(administratorUids, administratorUids.length);
        Arrays.sort(this.mAdministratorUids);
        for (int i = 0; i < this.mAdministratorUids.length - 1; ++i) {
            if (this.mAdministratorUids[i] < this.mAdministratorUids[i + 1]) continue;
            throw new IllegalArgumentException("All administrator UIDs must be unique");
        }
        return this;
    }

    @SystemApi
    public int[] getAdministratorUids() {
        return Arrays.copyOf(this.mAdministratorUids, this.mAdministratorUids.length);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public boolean equalsAdministratorUids(NetworkCapabilities nc) {
        return Arrays.equals(this.mAdministratorUids, nc.mAdministratorUids);
    }

    public NetworkCapabilities setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
        return this;
    }

    public int getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    public NetworkCapabilities setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
        return this;
    }

    public int getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    public static int minBandwidth(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    public static int maxBandwidth(int a, int b) {
        return Math.max(a, b);
    }

    public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        if (networkSpecifier != null && this.mTransportTypes != 128L && Long.bitCount(this.mTransportTypes & 0xFFFFFFFFFFFFFF7FL) != 1) {
            throw new IllegalStateException("Must have a single non-test transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
        return this;
    }

    public NetworkCapabilities setTransportInfo(TransportInfo transportInfo) {
        this.mTransportInfo = transportInfo;
        return this;
    }

    public NetworkSpecifier getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    public TransportInfo getTransportInfo() {
        return this.mTransportInfo;
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities nc) {
        return this.mNetworkSpecifier == null || this.mNetworkSpecifier.canBeSatisfiedBy(nc.mNetworkSpecifier) || nc.mNetworkSpecifier instanceof MatchAllNetworkSpecifier;
    }

    private boolean equalsSpecifier(NetworkCapabilities nc) {
        return Objects.equals(this.mNetworkSpecifier, nc.mNetworkSpecifier);
    }

    private boolean equalsTransportInfo(NetworkCapabilities nc) {
        return Objects.equals(this.mTransportInfo, nc.mTransportInfo);
    }

    public NetworkCapabilities setSignalStrength(int signalStrength) {
        this.mSignalStrength = signalStrength;
        return this;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean hasSignalStrength() {
        return this.mSignalStrength > Integer.MIN_VALUE;
    }

    public int getSignalStrength() {
        return this.mSignalStrength;
    }

    private boolean satisfiedBySignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength <= nc.mSignalStrength;
    }

    private boolean equalsSignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength == nc.mSignalStrength;
    }

    public NetworkCapabilities setSingleUid(int uid) {
        this.mUids = new ArraySet(1);
        this.mUids.add(new UidRange(uid, uid));
        return this;
    }

    public NetworkCapabilities setUids(Set<Range<Integer>> uids) {
        this.mUids = UidRange.fromIntRanges(uids);
        return this;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"NullableCollection"})
    public Set<Range<Integer>> getUids() {
        return UidRange.toIntRanges(this.mUids);
    }

    public Set<UidRange> getUidRanges() {
        if (this.mUids == null) {
            return null;
        }
        return new ArraySet<UidRange>(this.mUids);
    }

    public boolean appliesToUid(int uid) {
        if (null == this.mUids) {
            return true;
        }
        for (UidRange range : this.mUids) {
            if (!range.contains(uid)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public boolean equalsUids(NetworkCapabilities nc) {
        return UidRange.hasSameUids(nc.mUids, this.mUids);
    }

    public boolean satisfiedByUids(NetworkCapabilities nc) {
        if (null == nc.mUids || null == this.mUids) {
            return true;
        }
        for (UidRange requiredRange : this.mUids) {
            if (requiredRange.contains(nc.mOwnerUid)) {
                return true;
            }
            if (nc.appliesToUidRange(requiredRange)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public boolean appliesToUidRange(UidRange requiredRange) {
        if (null == this.mUids) {
            return true;
        }
        for (UidRange uidRange : this.mUids) {
            if (!uidRange.containsRange(requiredRange)) continue;
            return true;
        }
        return false;
    }

    public void setAllowedUids(Set<Integer> uids) {
        if (uids == this.mAllowedUids) {
            return;
        }
        Objects.requireNonNull(uids);
        this.mAllowedUids.clear();
        this.mAllowedUids.addAll(uids);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.NETWORK_FACTORY")
    public Set<Integer> getAllowedUids() {
        return new ArraySet<Integer>(this.mAllowedUids);
    }

    public ArraySet<Integer> getAllowedUidsNoCopy() {
        return this.mAllowedUids;
    }

    public boolean isUidWithAccess(int uid) {
        return this.mAllowedUids.contains(uid);
    }

    public boolean hasAllowedUids() {
        return !this.mAllowedUids.isEmpty();
    }

    private boolean equalsAllowedUids(NetworkCapabilities other) {
        return this.mAllowedUids.equals(other.mAllowedUids);
    }

    public NetworkCapabilities setSSID(String ssid) {
        this.mSSID = ssid;
        return this;
    }

    @SystemApi
    public String getSsid() {
        return this.mSSID;
    }

    public boolean equalsSSID(NetworkCapabilities nc) {
        return Objects.equals(this.mSSID, nc.mSSID);
    }

    public boolean satisfiedBySSID(NetworkCapabilities nc) {
        return this.mSSID == null || this.mSSID.equals(nc.mSSID);
    }

    private boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        return !(nc == null || !this.satisfiedByNetCapabilities(nc, onlyImmutable) || !this.satisfiedByTransportTypes(nc) || !onlyImmutable && !this.satisfiedByLinkBandwidths(nc) || !this.satisfiedBySpecifier(nc) || !this.satisfiedByEnterpriseCapabilitiesId(nc) || !onlyImmutable && !this.satisfiedBySignalStrength(nc) || !onlyImmutable && !this.satisfiedByUids(nc) || !onlyImmutable && !this.satisfiedBySSID(nc) || !onlyImmutable && !this.satisfiedByRequestor(nc) || !onlyImmutable && !this.satisfiedBySubscriptionIds(nc));
    }

    @SystemApi
    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, false);
    }

    public boolean satisfiedByImmutableNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, true);
    }

    public String describeImmutableDifferences(NetworkCapabilities that) {
        Object after;
        Object before;
        if (that == null) {
            return "other NetworkCapabilities was null";
        }
        StringJoiner joiner = new StringJoiner(", ");
        long mask = (MUTABLE_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFF7FFL;
        long oldImmutableCapabilities = this.mNetworkCapabilities & mask;
        long newImmutableCapabilities = that.mNetworkCapabilities & mask;
        if (oldImmutableCapabilities != newImmutableCapabilities) {
            before = NetworkCapabilities.capabilityNamesOf(NetworkCapabilitiesUtils.unpackBits(oldImmutableCapabilities));
            after = NetworkCapabilities.capabilityNamesOf(NetworkCapabilitiesUtils.unpackBits(newImmutableCapabilities));
            joiner.add(String.format("immutable capabilities changed: %s -> %s", before, after));
        }
        if (!this.equalsSpecifier(that)) {
            before = this.getNetworkSpecifier();
            after = that.getNetworkSpecifier();
            joiner.add(String.format("specifier changed: %s -> %s", before, after));
        }
        if (!this.equalsTransportTypes(that)) {
            before = NetworkCapabilities.transportNamesOf(this.getTransportTypes());
            after = NetworkCapabilities.transportNamesOf(that.getTransportTypes());
            joiner.add(String.format("transports changed: %s -> %s", before, after));
        }
        return joiner.toString();
    }

    public boolean equalRequestableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesRequestable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSignalStrength(that) && this.equalsSpecifier(that) && this.equalsTransportInfo(that) && this.equalsUids(that) && this.equalsAllowedUids(that) && this.equalsSSID(that) && this.equalsOwnerUid(that) && this.equalsPrivateDnsBroken(that) && this.equalsRequestor(that) && this.equalsAdministratorUids(that) && this.equalsSubscriptionIds(that) && this.equalsUnderlyingNetworks(that) && this.equalsEnterpriseCapabilitiesId(that);
    }

    public int hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mForbiddenNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mForbiddenNetworkCapabilities >> 32) * 7 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 11 + (int)(this.mTransportTypes >> 32) * 13 + this.mLinkUpBandwidthKbps * 17 + this.mLinkDownBandwidthKbps * 19 + Objects.hashCode(this.mNetworkSpecifier) * 23 + this.mSignalStrength * 29 + this.mOwnerUid * 31 + Objects.hashCode(this.mUids) * 37 + Objects.hashCode(this.mAllowedUids) * 41 + Objects.hashCode(this.mSSID) * 43 + Objects.hashCode(this.mTransportInfo) * 47 + Objects.hashCode(this.mPrivateDnsBroken) * 53 + Objects.hashCode(this.mRequestorUid) * 59 + Objects.hashCode(this.mRequestorPackageName) * 61 + Arrays.hashCode(this.mAdministratorUids) * 67 + Objects.hashCode(this.mSubIds) * 71 + Objects.hashCode(this.mUnderlyingNetworks) * 73 + this.mEnterpriseId * 79;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private <T extends Parcelable> void writeParcelableArraySet(Parcel in, ArraySet<T> val, int flags) {
        int size = val != null ? val.size() : -1;
        in.writeInt(size);
        for (int i = 0; i < size; ++i) {
            in.writeParcelable((Parcelable)val.valueAt(i), flags);
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mForbiddenNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeParcelable((Parcelable)((Object)this.mNetworkSpecifier), flags);
        dest.writeParcelable((Parcelable)((Object)this.mTransportInfo), flags);
        dest.writeInt(this.mSignalStrength);
        this.writeParcelableArraySet(dest, this.mUids, flags);
        dest.writeIntArray(CollectionUtils.toIntArray(this.mAllowedUids));
        dest.writeString(this.mSSID);
        dest.writeBoolean(this.mPrivateDnsBroken);
        dest.writeIntArray(this.getAdministratorUids());
        dest.writeInt(this.mOwnerUid);
        dest.writeInt(this.mRequestorUid);
        dest.writeString(this.mRequestorPackageName);
        dest.writeIntArray(CollectionUtils.toIntArray(this.mSubIds));
        dest.writeTypedList(this.mUnderlyingNetworks);
        dest.writeInt(this.mEnterpriseId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (0L != this.mTransportTypes) {
            sb.append(" Transports: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mTransportTypes, NetworkCapabilities::transportNameOf, "|");
        }
        if (0L != this.mNetworkCapabilities) {
            sb.append(" Capabilities: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mNetworkCapabilities, NetworkCapabilities::capabilityNameOf, "&");
        }
        if (0L != this.mForbiddenNetworkCapabilities) {
            sb.append(" Forbidden: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mForbiddenNetworkCapabilities, NetworkCapabilities::capabilityNameOf, "&");
        }
        if (this.mLinkUpBandwidthKbps > 0) {
            sb.append(" LinkUpBandwidth>=").append(this.mLinkUpBandwidthKbps).append("Kbps");
        }
        if (this.mLinkDownBandwidthKbps > 0) {
            sb.append(" LinkDnBandwidth>=").append(this.mLinkDownBandwidthKbps).append("Kbps");
        }
        if (this.mNetworkSpecifier != null) {
            sb.append(" Specifier: <").append(this.mNetworkSpecifier).append(">");
        }
        if (this.mTransportInfo != null) {
            sb.append(" TransportInfo: <").append(this.mTransportInfo).append(">");
        }
        if (this.hasSignalStrength()) {
            sb.append(" SignalStrength: ").append(this.mSignalStrength);
        }
        if (null != this.mUids) {
            if (1 == this.mUids.size() && this.mUids.valueAt(0).count() == 1) {
                sb.append(" Uid: ").append(this.mUids.valueAt((int)0).start);
            } else {
                sb.append(" Uids: <").append(this.mUids).append(">");
            }
        }
        if (this.hasAllowedUids()) {
            sb.append(" AllowedUids: <").append(this.mAllowedUids).append(">");
        }
        if (this.mOwnerUid != -1) {
            sb.append(" OwnerUid: ").append(this.mOwnerUid);
        }
        if (this.mAdministratorUids != null && this.mAdministratorUids.length != 0) {
            sb.append(" AdminUids: ").append(Arrays.toString(this.mAdministratorUids));
        }
        if (this.mRequestorUid != -1) {
            sb.append(" RequestorUid: ").append(this.mRequestorUid);
        }
        if (this.mRequestorPackageName != null) {
            sb.append(" RequestorPkg: ").append(this.mRequestorPackageName);
        }
        if (null != this.mSSID) {
            sb.append(" SSID: ").append(this.mSSID);
        }
        if (this.mPrivateDnsBroken) {
            sb.append(" PrivateDnsBroken");
        }
        if (!this.mSubIds.isEmpty()) {
            sb.append(" SubscriptionIds: ").append(this.mSubIds);
        }
        if (0 != this.mEnterpriseId) {
            sb.append(" EnterpriseId: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mEnterpriseId, NetworkCapabilities::enterpriseIdNameOf, "&");
        }
        sb.append(" UnderlyingNetworks: ");
        if (this.mUnderlyingNetworks != null) {
            sb.append("[");
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 0; i < this.mUnderlyingNetworks.size(); ++i) {
                joiner.add(this.mUnderlyingNetworks.get(i).toString());
            }
            sb.append(joiner.toString());
            sb.append("]");
        } else {
            sb.append("Null");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void appendStringRepresentationOfBitMaskToStringBuilder(StringBuilder sb, long bitMask, NameOf nameFetcher, String separator) {
        int bitPos = 0;
        boolean firstElementAdded = false;
        while (bitMask != 0L) {
            if ((bitMask & 1L) != 0L) {
                if (firstElementAdded) {
                    sb.append(separator);
                } else {
                    firstElementAdded = true;
                }
                sb.append(nameFetcher.nameOf(bitPos));
            }
            bitMask >>= 1;
            ++bitPos;
        }
    }

    public static String capabilityNamesOf(int[] capabilities) {
        StringJoiner joiner = new StringJoiner("|");
        if (capabilities != null) {
            for (int c : capabilities) {
                joiner.add(NetworkCapabilities.capabilityNameOf(c));
            }
        }
        return joiner.toString();
    }

    public static String capabilityNameOf(int capability) {
        switch (capability) {
            case 0: {
                return "MMS";
            }
            case 1: {
                return "SUPL";
            }
            case 2: {
                return "DUN";
            }
            case 3: {
                return "FOTA";
            }
            case 4: {
                return "IMS";
            }
            case 5: {
                return "CBS";
            }
            case 6: {
                return "WIFI_P2P";
            }
            case 7: {
                return "IA";
            }
            case 8: {
                return "RCS";
            }
            case 9: {
                return "XCAP";
            }
            case 10: {
                return "EIMS";
            }
            case 11: {
                return "NOT_METERED";
            }
            case 12: {
                return "INTERNET";
            }
            case 13: {
                return "NOT_RESTRICTED";
            }
            case 14: {
                return "TRUSTED";
            }
            case 15: {
                return "NOT_VPN";
            }
            case 16: {
                return "VALIDATED";
            }
            case 17: {
                return "CAPTIVE_PORTAL";
            }
            case 18: {
                return "NOT_ROAMING";
            }
            case 19: {
                return "FOREGROUND";
            }
            case 20: {
                return "NOT_CONGESTED";
            }
            case 21: {
                return "NOT_SUSPENDED";
            }
            case 22: {
                return "OEM_PAID";
            }
            case 23: {
                return "MCX";
            }
            case 24: {
                return "PARTIAL_CONNECTIVITY";
            }
            case 25: {
                return "TEMPORARILY_NOT_METERED";
            }
            case 26: {
                return "OEM_PRIVATE";
            }
            case 27: {
                return "VEHICLE_INTERNAL";
            }
            case 28: {
                return "NOT_VCN_MANAGED";
            }
            case 29: {
                return "ENTERPRISE";
            }
            case 30: {
                return "VSIM";
            }
            case 31: {
                return "BIP";
            }
            case 32: {
                return "HEAD_UNIT";
            }
            case 33: {
                return "MMTEL";
            }
            case 34: {
                return "PRIORITIZE_LATENCY";
            }
            case 35: {
                return "PRIORITIZE_BANDWIDTH";
            }
        }
        return Integer.toString(capability);
    }

    private static String enterpriseIdNameOf(int capability) {
        return Integer.toString(capability);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String transportNamesOf(int[] types) {
        StringJoiner joiner = new StringJoiner("|");
        if (types != null) {
            for (int t : types) {
                joiner.add(NetworkCapabilities.transportNameOf(t));
            }
        }
        return joiner.toString();
    }

    public static String transportNameOf(int transport) {
        if (!NetworkCapabilities.isValidTransport(transport)) {
            return "UNKNOWN";
        }
        return TRANSPORT_NAMES[transport];
    }

    private static void checkValidTransportType(int transport) {
        if (!NetworkCapabilities.isValidTransport(transport)) {
            throw new IllegalArgumentException("Invalid TransportType " + transport);
        }
    }

    private static boolean isValidCapability(int capability) {
        return capability >= 0 && capability <= 35;
    }

    private static void checkValidCapability(int capability) {
        if (!NetworkCapabilities.isValidCapability(capability)) {
            throw new IllegalArgumentException("NetworkCapability " + capability + " out of range");
        }
    }

    private static boolean isValidEnterpriseId(int enterpriseId) {
        return enterpriseId >= 1 && enterpriseId <= 5;
    }

    private static void checkValidEnterpriseId(int enterpriseId) {
        if (!NetworkCapabilities.isValidEnterpriseId(enterpriseId)) {
            throw new IllegalArgumentException("enterprise capability identifier " + enterpriseId + " is out of range");
        }
    }

    public boolean isMetered() {
        return !this.hasCapability(11);
    }

    @SystemApi
    public boolean isPrivateDnsBroken() {
        return this.mPrivateDnsBroken;
    }

    public void setPrivateDnsBroken(boolean broken) {
        this.mPrivateDnsBroken = broken;
    }

    private boolean equalsPrivateDnsBroken(NetworkCapabilities nc) {
        return this.mPrivateDnsBroken == nc.mPrivateDnsBroken;
    }

    public NetworkCapabilities setRequestorUid(int uid) {
        this.mRequestorUid = uid;
        return this;
    }

    public int getRequestorUid() {
        return this.mRequestorUid;
    }

    public NetworkCapabilities setRequestorPackageName(String packageName) {
        this.mRequestorPackageName = packageName;
        return this;
    }

    public String getRequestorPackageName() {
        return this.mRequestorPackageName;
    }

    public NetworkCapabilities setRequestorUidAndPackageName(int uid, String packageName) {
        return this.setRequestorUid(uid).setRequestorPackageName(packageName);
    }

    private boolean satisfiedByRequestor(NetworkCapabilities nc) {
        if (this.mRequestorUid == -1 || nc.mRequestorUid == -1) {
            return true;
        }
        if (this.mRequestorUid != nc.mRequestorUid) {
            return false;
        }
        if (null == nc.mRequestorPackageName || null == this.mRequestorPackageName) {
            return true;
        }
        return TextUtils.equals(this.mRequestorPackageName, nc.mRequestorPackageName);
    }

    private boolean equalsRequestor(NetworkCapabilities nc) {
        return this.mRequestorUid == nc.mRequestorUid && TextUtils.equals(this.mRequestorPackageName, nc.mRequestorPackageName);
    }

    public NetworkCapabilities setSubscriptionIds(Set<Integer> subIds) {
        this.mSubIds = new ArraySet(Objects.requireNonNull(subIds));
        return this;
    }

    @SystemApi
    public Set<Integer> getSubscriptionIds() {
        return new ArraySet<Integer>(this.mSubIds);
    }

    private boolean equalsSubscriptionIds(NetworkCapabilities nc) {
        return Objects.equals(this.mSubIds, nc.mSubIds);
    }

    private boolean satisfiedBySubscriptionIds(NetworkCapabilities nc) {
        if (this.mSubIds.isEmpty()) {
            return true;
        }
        if (nc.mSubIds.isEmpty()) {
            return false;
        }
        for (Integer subId : nc.mSubIds) {
            if (!this.mSubIds.contains(subId)) continue;
            return true;
        }
        return false;
    }

    public long getApplicableRedactions() {
        if (this.mTransportInfo == null) {
            return 0L;
        }
        return this.mTransportInfo.getApplicableRedactions();
    }

    private NetworkCapabilities removeDefaultCapabilites() {
        this.mNetworkCapabilities &= DEFAULT_CAPABILITIES ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    @SystemApi
    public static class Builder {
        private final NetworkCapabilities mCaps;

        public Builder() {
            this.mCaps = new NetworkCapabilities();
        }

        public Builder(NetworkCapabilities nc) {
            Objects.requireNonNull(nc);
            this.mCaps = new NetworkCapabilities(nc);
        }

        public static Builder withoutDefaultCapabilities() {
            NetworkCapabilities nc = new NetworkCapabilities();
            nc.removeDefaultCapabilites();
            return new Builder(nc);
        }

        public Builder addTransportType(int transportType) {
            NetworkCapabilities.checkValidTransportType(transportType);
            this.mCaps.addTransportType(transportType);
            return this;
        }

        public Builder removeTransportType(int transportType) {
            NetworkCapabilities.checkValidTransportType(transportType);
            this.mCaps.removeTransportType(transportType);
            return this;
        }

        public Builder addCapability(int capability) {
            this.mCaps.setCapability(capability, true);
            return this;
        }

        public Builder removeCapability(int capability) {
            this.mCaps.setCapability(capability, false);
            return this;
        }

        public Builder addEnterpriseId(int enterpriseId) {
            this.mCaps.addEnterpriseId(enterpriseId);
            return this;
        }

        public Builder removeEnterpriseId(int enterpriseId) {
            this.mCaps.removeEnterpriseId(enterpriseId);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setOwnerUid(int ownerUid) {
            this.mCaps.setOwnerUid(ownerUid);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setAdministratorUids(int[] administratorUids) {
            Objects.requireNonNull(administratorUids);
            this.mCaps.setAdministratorUids(administratorUids);
            return this;
        }

        public Builder setLinkUpstreamBandwidthKbps(int upKbps) {
            this.mCaps.setLinkUpstreamBandwidthKbps(upKbps);
            return this;
        }

        public Builder setLinkDownstreamBandwidthKbps(int downKbps) {
            this.mCaps.setLinkDownstreamBandwidthKbps(downKbps);
            return this;
        }

        public Builder setNetworkSpecifier(NetworkSpecifier specifier) {
            this.mCaps.setNetworkSpecifier(specifier);
            return this;
        }

        public Builder setTransportInfo(TransportInfo info) {
            this.mCaps.setTransportInfo(info);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_SIGNAL_STRENGTH_WAKEUP")
        public Builder setSignalStrength(int signalStrength) {
            this.mCaps.setSignalStrength(signalStrength);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setSsid(String ssid) {
            this.mCaps.setSSID(ssid);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setRequestorUid(int uid) {
            this.mCaps.setRequestorUid(uid);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setRequestorPackageName(String packageName) {
            this.mCaps.setRequestorPackageName(packageName);
            return this;
        }

        @SystemApi
        public Builder setSubscriptionIds(Set<Integer> subIds) {
            this.mCaps.setSubscriptionIds(subIds);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public Builder setUids(Set<Range<Integer>> uids) {
            this.mCaps.setUids(uids);
            return this;
        }

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setAllowedUids(Set<Integer> uids) {
            Objects.requireNonNull(uids);
            this.mCaps.setAllowedUids(uids);
            return this;
        }

        @RequiresPermission(value="android.permission.NETWORK_FACTORY")
        public Builder setUnderlyingNetworks(List<Network> networks) {
            this.mCaps.setUnderlyingNetworks(networks);
            return this;
        }

        public NetworkCapabilities build() {
            if (this.mCaps.getOwnerUid() != -1 && !CollectionUtils.contains(this.mCaps.getAdministratorUids(), this.mCaps.getOwnerUid())) {
                throw new IllegalStateException("The owner UID must be included in  administrator UIDs.");
            }
            if (this.mCaps.getEnterpriseIds().length != 0 && !this.mCaps.hasCapability(29)) {
                throw new IllegalStateException("Enterprise capability identifier is applicable only with ENTERPRISE capability.");
            }
            return new NetworkCapabilities(this.mCaps);
        }
    }

    private static interface NameOf {
        public String nameOf(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnterpriseId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RedactionType {
    }
}

