/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.connectivity.com.android.net.module.util.NetworkStatsUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.VisibleForTesting;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import libcore.util.EmptyArray;

@SystemApi
public class NetworkStats
implements Parcelable,
Iterable<Entry> {
    private static final String TAG = "NetworkStats";
    public static final String IFACE_ALL = null;
    public static final String IFACE_VT = "vt_data0";
    public static final int UID_ALL = -1;
    public static final int UID_TETHERING = -5;
    public static final int TAG_ALL = -1;
    public static final int SET_ALL = -1;
    public static final int SET_DEFAULT = 0;
    public static final int SET_FOREGROUND = 1;
    public static final int SET_DEBUG_START = 1000;
    public static final int SET_DBG_VPN_IN = 1001;
    public static final int SET_DBG_VPN_OUT = 1002;
    public static final String[] INTERFACES_ALL = null;
    public static final int TAG_NONE = 0;
    public static final int METERED_ALL = -1;
    public static final int METERED_NO = 0;
    public static final int METERED_YES = 1;
    public static final int ROAMING_ALL = -1;
    public static final int ROAMING_NO = 0;
    public static final int ROAMING_YES = 1;
    public static final int DEFAULT_NETWORK_ALL = -1;
    public static final int DEFAULT_NETWORK_NO = 0;
    public static final int DEFAULT_NETWORK_YES = 1;
    public static final int STATS_PER_IFACE = 0;
    public static final int STATS_PER_UID = 1;
    private static final String CLATD_INTERFACE_PREFIX = "v4-";
    private static final int IPV4V6_HEADER_DELTA = 20;
    private long elapsedRealtime;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int size;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int capacity;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String[] iface;
    @UnsupportedAppUsage
    private int[] uid;
    @UnsupportedAppUsage
    private int[] set;
    @UnsupportedAppUsage
    private int[] tag;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] metered;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] roaming;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] defaultNetwork;
    @UnsupportedAppUsage
    private long[] rxBytes;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long[] rxPackets;
    @UnsupportedAppUsage
    private long[] txBytes;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long[] txPackets;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long[] operations;
    public static final Parcelable.Creator<NetworkStats> CREATOR = new Parcelable.Creator<NetworkStats>(){

        @Override
        public NetworkStats createFromParcel(Parcel in) {
            return new NetworkStats(in);
        }

        public NetworkStats[] newArray(int size) {
            return new NetworkStats[size];
        }
    };

    public NetworkStats(long elapsedRealtime, int initialSize) {
        this.elapsedRealtime = elapsedRealtime;
        this.size = 0;
        if (initialSize > 0) {
            this.capacity = initialSize;
            this.iface = new String[initialSize];
            this.uid = new int[initialSize];
            this.set = new int[initialSize];
            this.tag = new int[initialSize];
            this.metered = new int[initialSize];
            this.roaming = new int[initialSize];
            this.defaultNetwork = new int[initialSize];
            this.rxBytes = new long[initialSize];
            this.rxPackets = new long[initialSize];
            this.txBytes = new long[initialSize];
            this.txPackets = new long[initialSize];
            this.operations = new long[initialSize];
        } else {
            this.clear();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public NetworkStats(Parcel parcel) {
        this.elapsedRealtime = parcel.readLong();
        this.size = parcel.readInt();
        this.capacity = parcel.readInt();
        this.iface = parcel.createStringArray();
        this.uid = parcel.createIntArray();
        this.set = parcel.createIntArray();
        this.tag = parcel.createIntArray();
        this.metered = parcel.createIntArray();
        this.roaming = parcel.createIntArray();
        this.defaultNetwork = parcel.createIntArray();
        this.rxBytes = parcel.createLongArray();
        this.rxPackets = parcel.createLongArray();
        this.txBytes = parcel.createLongArray();
        this.txPackets = parcel.createLongArray();
        this.operations = parcel.createLongArray();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.elapsedRealtime);
        dest.writeInt(this.size);
        dest.writeInt(this.capacity);
        dest.writeStringArray(this.iface);
        dest.writeIntArray(this.uid);
        dest.writeIntArray(this.set);
        dest.writeIntArray(this.tag);
        dest.writeIntArray(this.metered);
        dest.writeIntArray(this.roaming);
        dest.writeIntArray(this.defaultNetwork);
        dest.writeLongArray(this.rxBytes);
        dest.writeLongArray(this.rxPackets);
        dest.writeLongArray(this.txBytes);
        dest.writeLongArray(this.txPackets);
        dest.writeLongArray(this.operations);
    }

    public NetworkStats clone() {
        NetworkStats clone = new NetworkStats(this.elapsedRealtime, this.size);
        Entry entry = null;
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            clone.insertEntry(entry);
        }
        return clone;
    }

    public void clear() {
        this.capacity = 0;
        this.iface = EmptyArray.STRING;
        this.uid = EmptyArray.INT;
        this.set = EmptyArray.INT;
        this.tag = EmptyArray.INT;
        this.metered = EmptyArray.INT;
        this.roaming = EmptyArray.INT;
        this.defaultNetwork = EmptyArray.INT;
        this.rxBytes = EmptyArray.LONG;
        this.rxPackets = EmptyArray.LONG;
        this.txBytes = EmptyArray.LONG;
        this.txPackets = EmptyArray.LONG;
        this.operations = EmptyArray.LONG;
    }

    @VisibleForTesting
    public NetworkStats insertEntry(String iface, long rxBytes, long rxPackets, long txBytes, long txPackets) {
        return this.insertEntry(iface, -1, 0, 0, rxBytes, rxPackets, txBytes, txPackets, 0L);
    }

    @VisibleForTesting
    public NetworkStats insertEntry(String iface, int uid, int set, int tag2, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.insertEntry(new Entry(iface, uid, set, tag2, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    @VisibleForTesting
    public NetworkStats insertEntry(String iface, int uid, int set, int tag2, int metered, int roaming, int defaultNetwork, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.insertEntry(new Entry(iface, uid, set, tag2, metered, roaming, defaultNetwork, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    public NetworkStats insertEntry(Entry entry) {
        if (this.size >= this.capacity) {
            int newLength = Math.max(this.size, 10) * 3 / 2;
            this.iface = Arrays.copyOf(this.iface, newLength);
            this.uid = Arrays.copyOf(this.uid, newLength);
            this.set = Arrays.copyOf(this.set, newLength);
            this.tag = Arrays.copyOf(this.tag, newLength);
            this.metered = Arrays.copyOf(this.metered, newLength);
            this.roaming = Arrays.copyOf(this.roaming, newLength);
            this.defaultNetwork = Arrays.copyOf(this.defaultNetwork, newLength);
            this.rxBytes = Arrays.copyOf(this.rxBytes, newLength);
            this.rxPackets = Arrays.copyOf(this.rxPackets, newLength);
            this.txBytes = Arrays.copyOf(this.txBytes, newLength);
            this.txPackets = Arrays.copyOf(this.txPackets, newLength);
            this.operations = Arrays.copyOf(this.operations, newLength);
            this.capacity = newLength;
        }
        this.setValues(this.size, entry);
        ++this.size;
        return this;
    }

    private void setValues(int i, Entry entry) {
        this.iface[i] = entry.iface;
        this.uid[i] = entry.uid;
        this.set[i] = entry.set;
        this.tag[i] = entry.tag;
        this.metered[i] = entry.metered;
        this.roaming[i] = entry.roaming;
        this.defaultNetwork[i] = entry.defaultNetwork;
        this.rxBytes[i] = entry.rxBytes;
        this.rxPackets[i] = entry.rxPackets;
        this.txBytes[i] = entry.txBytes;
        this.txPackets[i] = entry.txPackets;
        this.operations[i] = entry.operations;
    }

    @Override
    @SystemApi
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            int mIndex = 0;

            @Override
            public boolean hasNext() {
                return this.mIndex < NetworkStats.this.size;
            }

            @Override
            public Entry next() {
                return NetworkStats.this.getValues(this.mIndex++, null);
            }
        };
    }

    @UnsupportedAppUsage
    public Entry getValues(int i, Entry recycle) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = this.iface[i];
        entry.uid = this.uid[i];
        entry.set = this.set[i];
        entry.tag = this.tag[i];
        entry.metered = this.metered[i];
        entry.roaming = this.roaming[i];
        entry.defaultNetwork = this.defaultNetwork[i];
        entry.rxBytes = this.rxBytes[i];
        entry.rxPackets = this.rxPackets[i];
        entry.txBytes = this.txBytes[i];
        entry.txPackets = this.txPackets[i];
        entry.operations = this.operations[i];
        return entry;
    }

    private void maybeCopyEntry(int dest, int src) {
        if (dest == src) {
            return;
        }
        this.iface[dest] = this.iface[src];
        this.uid[dest] = this.uid[src];
        this.set[dest] = this.set[src];
        this.tag[dest] = this.tag[src];
        this.metered[dest] = this.metered[src];
        this.roaming[dest] = this.roaming[src];
        this.defaultNetwork[dest] = this.defaultNetwork[src];
        this.rxBytes[dest] = this.rxBytes[src];
        this.rxPackets[dest] = this.rxPackets[src];
        this.txBytes[dest] = this.txBytes[src];
        this.txPackets[dest] = this.txPackets[src];
        this.operations[dest] = this.operations[src];
    }

    public long getElapsedRealtime() {
        return this.elapsedRealtime;
    }

    public void setElapsedRealtime(long time) {
        this.elapsedRealtime = time;
    }

    public long getElapsedRealtimeAge() {
        return SystemClock.elapsedRealtime() - this.elapsedRealtime;
    }

    @UnsupportedAppUsage
    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public int internalSize() {
        return this.capacity;
    }

    @Deprecated
    public NetworkStats combineValues(String iface, int uid, int tag2, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(iface, uid, 0, tag2, rxBytes, rxPackets, txBytes, txPackets, operations);
    }

    public NetworkStats combineValues(String iface, int uid, int set, int tag2, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(new Entry(iface, uid, set, tag2, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    public NetworkStats combineValues(Entry entry) {
        int i = this.findIndex(entry.iface, entry.uid, entry.set, entry.tag, entry.metered, entry.roaming, entry.defaultNetwork);
        if (i == -1) {
            this.insertEntry(entry);
        } else {
            int n = i;
            this.rxBytes[n] = this.rxBytes[n] + entry.rxBytes;
            int n2 = i;
            this.rxPackets[n2] = this.rxPackets[n2] + entry.rxPackets;
            int n3 = i;
            this.txBytes[n3] = this.txBytes[n3] + entry.txBytes;
            int n4 = i;
            this.txPackets[n4] = this.txPackets[n4] + entry.txPackets;
            int n5 = i;
            this.operations[n5] = this.operations[n5] + entry.operations;
        }
        return this;
    }

    public NetworkStats addEntry(Entry entry) {
        return this.clone().combineValues(entry);
    }

    public NetworkStats add(NetworkStats another) {
        NetworkStats ret = this.clone();
        ret.combineAllValues(another);
        return ret;
    }

    public void combineAllValues(NetworkStats another) {
        Entry entry = null;
        for (int i = 0; i < another.size; ++i) {
            entry = another.getValues(i, entry);
            this.combineValues(entry);
        }
    }

    public int findIndex(String iface, int uid, int set, int tag2, int metered, int roaming, int defaultNetwork) {
        for (int i = 0; i < this.size; ++i) {
            if (uid != this.uid[i] || set != this.set[i] || tag2 != this.tag[i] || metered != this.metered[i] || roaming != this.roaming[i] || defaultNetwork != this.defaultNetwork[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    @VisibleForTesting
    public int findIndexHinted(String iface, int uid, int set, int tag2, int metered, int roaming, int defaultNetwork, int hintIndex) {
        for (int offset2 = 0; offset2 < this.size; ++offset2) {
            int halfOffset = offset2 / 2;
            int i = offset2 % 2 == 0 ? (hintIndex + halfOffset) % this.size : (this.size + hintIndex - halfOffset - 1) % this.size;
            if (uid != this.uid[i] || set != this.set[i] || tag2 != this.tag[i] || metered != this.metered[i] || roaming != this.roaming[i] || defaultNetwork != this.defaultNetwork[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    public void spliceOperationsFrom(NetworkStats stats) {
        for (int i = 0; i < this.size; ++i) {
            int j = stats.findIndex(this.iface[i], this.uid[i], this.set[i], this.tag[i], this.metered[i], this.roaming[i], this.defaultNetwork[i]);
            this.operations[i] = j == -1 ? 0L : stats.operations[j];
        }
    }

    public String[] getUniqueIfaces() {
        HashSet<String> ifaces = new HashSet<String>();
        for (String iface : this.iface) {
            if (iface == IFACE_ALL) continue;
            ifaces.add(iface);
        }
        return ifaces.toArray(new String[ifaces.size()]);
    }

    @UnsupportedAppUsage
    public int[] getUniqueUids() {
        SparseBooleanArray uids = new SparseBooleanArray();
        for (int uid : this.uid) {
            uids.put(uid, true);
        }
        int size = uids.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = uids.keyAt(i);
        }
        return result;
    }

    @UnsupportedAppUsage
    public long getTotalBytes() {
        Entry entry = this.getTotal(null);
        return entry.rxBytes + entry.txBytes;
    }

    @UnsupportedAppUsage
    public Entry getTotal(Entry recycle) {
        return this.getTotal(recycle, null, -1, false);
    }

    @UnsupportedAppUsage
    public Entry getTotal(Entry recycle, int limitUid) {
        return this.getTotal(recycle, null, limitUid, false);
    }

    public Entry getTotal(Entry recycle, HashSet<String> limitIface) {
        return this.getTotal(recycle, limitIface, -1, false);
    }

    @UnsupportedAppUsage
    public Entry getTotalIncludingTags(Entry recycle) {
        return this.getTotal(recycle, null, -1, true);
    }

    private Entry getTotal(Entry recycle, HashSet<String> limitIface, int limitUid, boolean includeTags) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = IFACE_ALL;
        entry.uid = limitUid;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.defaultNetwork = -1;
        entry.rxBytes = 0L;
        entry.rxPackets = 0L;
        entry.txBytes = 0L;
        entry.txPackets = 0L;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            boolean matchesIface;
            boolean matchesUid = limitUid == -1 || limitUid == this.uid[i];
            boolean bl = matchesIface = limitIface == null || limitIface.contains(this.iface[i]);
            if (!matchesUid || !matchesIface || this.tag[i] != 0 && !includeTags) continue;
            entry.rxBytes += this.rxBytes[i];
            entry.rxPackets += this.rxPackets[i];
            entry.txBytes += this.txBytes[i];
            entry.txPackets += this.txPackets[i];
            entry.operations += this.operations[i];
        }
        return entry;
    }

    public long getTotalPackets() {
        long total = 0L;
        for (int i = this.size - 1; i >= 0; --i) {
            total += this.rxPackets[i] + this.txPackets[i];
        }
        return total;
    }

    public NetworkStats subtract(NetworkStats right2) {
        return NetworkStats.subtract(this, right2, null, null);
    }

    public static <C> NetworkStats subtract(NetworkStats left, NetworkStats right2, NonMonotonicObserver<C> observer, C cookie) {
        return NetworkStats.subtract(left, right2, observer, cookie, null);
    }

    public static <C> NetworkStats subtract(NetworkStats left, NetworkStats right2, NonMonotonicObserver<C> observer, C cookie, NetworkStats recycle) {
        NetworkStats result;
        long deltaRealtime = left.elapsedRealtime - right2.elapsedRealtime;
        if (deltaRealtime < 0L) {
            if (observer != null) {
                observer.foundNonMonotonic(left, -1, right2, -1, cookie);
            }
            deltaRealtime = 0L;
        }
        Entry entry = new Entry();
        if (recycle != null && recycle.capacity >= left.size) {
            result = recycle;
            result.size = 0;
            result.elapsedRealtime = deltaRealtime;
        } else {
            result = new NetworkStats(deltaRealtime, left.size);
        }
        for (int i = 0; i < left.size; ++i) {
            entry.iface = left.iface[i];
            entry.uid = left.uid[i];
            entry.set = left.set[i];
            entry.tag = left.tag[i];
            entry.metered = left.metered[i];
            entry.roaming = left.roaming[i];
            entry.defaultNetwork = left.defaultNetwork[i];
            entry.rxBytes = left.rxBytes[i];
            entry.rxPackets = left.rxPackets[i];
            entry.txBytes = left.txBytes[i];
            entry.txPackets = left.txPackets[i];
            entry.operations = left.operations[i];
            int j = right2.findIndexHinted(entry.iface, entry.uid, entry.set, entry.tag, entry.metered, entry.roaming, entry.defaultNetwork, i);
            if (j != -1) {
                entry.rxBytes -= right2.rxBytes[j];
                entry.rxPackets -= right2.rxPackets[j];
                entry.txBytes -= right2.txBytes[j];
                entry.txPackets -= right2.txPackets[j];
                entry.operations -= right2.operations[j];
            }
            if (entry.isNegative()) {
                if (observer != null) {
                    observer.foundNonMonotonic(left, i, right2, j, cookie);
                }
                entry.rxBytes = Math.max(entry.rxBytes, 0L);
                entry.rxPackets = Math.max(entry.rxPackets, 0L);
                entry.txBytes = Math.max(entry.txBytes, 0L);
                entry.txPackets = Math.max(entry.txPackets, 0L);
                entry.operations = Math.max(entry.operations, 0L);
            }
            result.insertEntry(entry);
        }
        return result;
    }

    public static void apply464xlatAdjustments(NetworkStats baseTraffic, NetworkStats stackedTraffic, Map<String, String> stackedIfaces) {
        Entry entry = null;
        for (int i = 0; i < stackedTraffic.size; ++i) {
            if ((entry = stackedTraffic.getValues(i, entry)) == null || entry.iface == null || !entry.iface.startsWith(CLATD_INTERFACE_PREFIX)) continue;
            entry.rxBytes += entry.rxPackets * 20L;
            entry.txBytes += entry.txPackets * 20L;
            stackedTraffic.setValues(i, entry);
        }
    }

    public void apply464xlatAdjustments(Map<String, String> stackedIfaces) {
        NetworkStats.apply464xlatAdjustments(this, this, stackedIfaces);
    }

    public NetworkStats groupedByIface() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.uid = -1;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.defaultNetwork = -1;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.iface = this.iface[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    public NetworkStats groupedByUid() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.iface = IFACE_ALL;
        entry.set = -1;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        entry.defaultNetwork = -1;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.uid = this.uid[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            entry.operations = this.operations[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    public void removeUids(int[] uids) {
        this.filter(e -> !CollectionUtils.contains(uids, e.uid));
    }

    public NetworkStats removeEmptyEntries() {
        NetworkStats ret = this.clone();
        ret.filter(e -> e.rxBytes != 0L || e.rxPackets != 0L || e.txBytes != 0L || e.txPackets != 0L || e.operations != 0L);
        return ret;
    }

    public void clearInterfaces() {
        for (int i = 0; i < this.size; ++i) {
            this.iface[i] = null;
        }
    }

    public void filter(int limitUid, String[] limitIfaces, int limitTag) {
        if (limitUid == -1 && limitTag == -1 && limitIfaces == INTERFACES_ALL) {
            return;
        }
        this.filter(e -> !(limitUid != -1 && limitUid != e.uid || limitTag != -1 && limitTag != e.tag || limitIfaces != INTERFACES_ALL && !CollectionUtils.contains(limitIfaces, e.iface)));
    }

    public void filterDebugEntries() {
        this.filter(e -> e.set < 1000);
    }

    private void filter(Predicate<Entry> predicate) {
        Entry entry = new Entry();
        int nextOutputEntry = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(entry = this.getValues(i, entry))) continue;
            if (nextOutputEntry != i) {
                this.setValues(nextOutputEntry, entry);
            }
            ++nextOutputEntry;
        }
        this.size = nextOutputEntry;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("NetworkStats: elapsedRealtime=");
        pw.println(this.elapsedRealtime);
        for (int i = 0; i < this.size; ++i) {
            pw.print(prefix);
            pw.print("  [");
            pw.print(i);
            pw.print("]");
            pw.print(" iface=");
            pw.print(this.iface[i]);
            pw.print(" uid=");
            pw.print(this.uid[i]);
            pw.print(" set=");
            pw.print(NetworkStats.setToString(this.set[i]));
            pw.print(" tag=");
            pw.print(NetworkStats.tagToString(this.tag[i]));
            pw.print(" metered=");
            pw.print(NetworkStats.meteredToString(this.metered[i]));
            pw.print(" roaming=");
            pw.print(NetworkStats.roamingToString(this.roaming[i]));
            pw.print(" defaultNetwork=");
            pw.print(NetworkStats.defaultNetworkToString(this.defaultNetwork[i]));
            pw.print(" rxBytes=");
            pw.print(this.rxBytes[i]);
            pw.print(" rxPackets=");
            pw.print(this.rxPackets[i]);
            pw.print(" txBytes=");
            pw.print(this.txBytes[i]);
            pw.print(" txPackets=");
            pw.print(this.txPackets[i]);
            pw.print(" operations=");
            pw.println(this.operations[i]);
        }
    }

    public static String setToString(int set) {
        switch (set) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "FOREGROUND";
            }
            case 1001: {
                return "DBG_VPN_IN";
            }
            case 1002: {
                return "DBG_VPN_OUT";
            }
        }
        return "UNKNOWN";
    }

    public static String setToCheckinString(int set) {
        switch (set) {
            case -1: {
                return "all";
            }
            case 0: {
                return "def";
            }
            case 1: {
                return "fg";
            }
            case 1001: {
                return "vpnin";
            }
            case 1002: {
                return "vpnout";
            }
        }
        return "unk";
    }

    public static boolean setMatches(int querySet, int dataSet) {
        if (querySet == dataSet) {
            return true;
        }
        return querySet == -1 && dataSet < 1000;
    }

    public static String tagToString(int tag2) {
        return "0x" + Integer.toHexString(tag2);
    }

    public static String meteredToString(int metered) {
        switch (metered) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public static String roamingToString(int roaming) {
        switch (roaming) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public static String defaultNetworkToString(int defaultNetwork) {
        switch (defaultNetwork) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump("", new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void migrateTun(int tunUid, String tunIface, List<String> underlyingIfaces) {
        Entry tunIfaceTotal = new Entry();
        Entry[] perInterfaceTotal = new Entry[underlyingIfaces.size()];
        Entry underlyingIfacesTotal = new Entry();
        for (int i = 0; i < perInterfaceTotal.length; ++i) {
            perInterfaceTotal[i] = new Entry();
        }
        this.tunAdjustmentInit(tunUid, tunIface, underlyingIfaces, tunIfaceTotal, perInterfaceTotal, underlyingIfacesTotal);
        Entry[] moved = this.addTrafficToApplications(tunUid, tunIface, underlyingIfaces, tunIfaceTotal, perInterfaceTotal, underlyingIfacesTotal);
        this.deductTrafficFromVpnApp(tunUid, underlyingIfaces, moved);
    }

    private void tunAdjustmentInit(int tunUid, String tunIface, List<String> underlyingIfaces, Entry tunIfaceTotal, Entry[] perInterfaceTotal, Entry underlyingIfacesTotal) {
        Entry recycle = new Entry();
        block0: for (int i = 0; i < this.size; ++i) {
            this.getValues(i, recycle);
            if (recycle.uid == -1) {
                throw new IllegalStateException("Cannot adjust VPN accounting on an iface aggregated NetworkStats.");
            }
            if (recycle.set == 1001 || recycle.set == 1002) {
                throw new IllegalStateException("Cannot adjust VPN accounting on a NetworkStats containing SET_DBG_VPN_*");
            }
            if (recycle.tag != 0) continue;
            if (tunUid == 1000) {
                if (!tunIface.equals(recycle.iface)) continue;
                tunIfaceTotal.add(recycle);
                underlyingIfacesTotal.add(recycle);
                if (perInterfaceTotal.length <= 0) continue;
                perInterfaceTotal[0].add(recycle);
                continue;
            }
            if (recycle.uid == tunUid) {
                for (int j = 0; j < underlyingIfaces.size(); ++j) {
                    if (!Objects.equals(underlyingIfaces.get(j), recycle.iface)) continue;
                    perInterfaceTotal[j].add(recycle);
                    underlyingIfacesTotal.add(recycle);
                    continue block0;
                }
                continue;
            }
            if (!tunIface.equals(recycle.iface)) continue;
            tunIfaceTotal.add(recycle);
        }
    }

    private Entry[] addTrafficToApplications(int tunUid, String tunIface, List<String> underlyingIfaces, Entry tunIfaceTotal, Entry[] perInterfaceTotal, Entry underlyingIfacesTotal) {
        Entry[] moved = new Entry[underlyingIfaces.size()];
        for (int i = 0; i < underlyingIfaces.size(); ++i) {
            moved[i] = new Entry();
        }
        Entry tmpEntry = new Entry();
        int origSize = this.size;
        for (int i = 0; i < origSize; ++i) {
            if (!Objects.equals(this.iface[i], tunIface) || this.uid[i] == tunUid && tunUid != 1000) continue;
            tmpEntry.uid = this.uid[i];
            tmpEntry.tag = this.tag[i];
            tmpEntry.metered = this.metered[i];
            tmpEntry.roaming = this.roaming[i];
            tmpEntry.defaultNetwork = this.defaultNetwork[i];
            long totalRxBytes = 0L;
            if (tunIfaceTotal.rxBytes > 0L) {
                long rxBytesAcrossUnderlyingIfaces = NetworkStatsUtils.multiplySafeByRational(underlyingIfacesTotal.rxBytes, this.rxBytes[i], tunIfaceTotal.rxBytes);
                totalRxBytes = Math.min(this.rxBytes[i], rxBytesAcrossUnderlyingIfaces);
            }
            long totalRxPackets = 0L;
            if (tunIfaceTotal.rxPackets > 0L) {
                long rxPacketsAcrossUnderlyingIfaces = NetworkStatsUtils.multiplySafeByRational(underlyingIfacesTotal.rxPackets, this.rxPackets[i], tunIfaceTotal.rxPackets);
                totalRxPackets = Math.min(this.rxPackets[i], rxPacketsAcrossUnderlyingIfaces);
            }
            long totalTxBytes = 0L;
            if (tunIfaceTotal.txBytes > 0L) {
                long txBytesAcrossUnderlyingIfaces = NetworkStatsUtils.multiplySafeByRational(underlyingIfacesTotal.txBytes, this.txBytes[i], tunIfaceTotal.txBytes);
                totalTxBytes = Math.min(this.txBytes[i], txBytesAcrossUnderlyingIfaces);
            }
            long totalTxPackets = 0L;
            if (tunIfaceTotal.txPackets > 0L) {
                long txPacketsAcrossUnderlyingIfaces = NetworkStatsUtils.multiplySafeByRational(underlyingIfacesTotal.txPackets, this.txPackets[i], tunIfaceTotal.txPackets);
                totalTxPackets = Math.min(this.txPackets[i], txPacketsAcrossUnderlyingIfaces);
            }
            long totalOperations = 0L;
            if (tunIfaceTotal.operations > 0L) {
                long operationsAcrossUnderlyingIfaces = NetworkStatsUtils.multiplySafeByRational(underlyingIfacesTotal.operations, this.operations[i], tunIfaceTotal.operations);
                totalOperations = Math.min(this.operations[i], operationsAcrossUnderlyingIfaces);
            }
            for (int j = 0; j < underlyingIfaces.size(); ++j) {
                tmpEntry.iface = underlyingIfaces.get(j);
                tmpEntry.rxBytes = 0L;
                tmpEntry.set = this.set[i];
                if (underlyingIfacesTotal.rxBytes > 0L) {
                    tmpEntry.rxBytes = NetworkStatsUtils.multiplySafeByRational(totalRxBytes, perInterfaceTotal[j].rxBytes, underlyingIfacesTotal.rxBytes);
                }
                tmpEntry.rxPackets = 0L;
                if (underlyingIfacesTotal.rxPackets > 0L) {
                    tmpEntry.rxPackets = NetworkStatsUtils.multiplySafeByRational(totalRxPackets, perInterfaceTotal[j].rxPackets, underlyingIfacesTotal.rxPackets);
                }
                tmpEntry.txBytes = 0L;
                if (underlyingIfacesTotal.txBytes > 0L) {
                    tmpEntry.txBytes = NetworkStatsUtils.multiplySafeByRational(totalTxBytes, perInterfaceTotal[j].txBytes, underlyingIfacesTotal.txBytes);
                }
                tmpEntry.txPackets = 0L;
                if (underlyingIfacesTotal.txPackets > 0L) {
                    tmpEntry.txPackets = NetworkStatsUtils.multiplySafeByRational(totalTxPackets, perInterfaceTotal[j].txPackets, underlyingIfacesTotal.txPackets);
                }
                tmpEntry.operations = 0L;
                if (underlyingIfacesTotal.operations > 0L) {
                    tmpEntry.operations = NetworkStatsUtils.multiplySafeByRational(totalOperations, perInterfaceTotal[j].operations, underlyingIfacesTotal.operations);
                }
                this.combineValues(tmpEntry);
                if (this.tag[i] != 0) continue;
                moved[j].add(tmpEntry);
                tmpEntry.set = 1001;
                this.combineValues(tmpEntry);
            }
        }
        return moved;
    }

    private void deductTrafficFromVpnApp(int tunUid, List<String> underlyingIfaces, Entry[] moved) {
        if (tunUid == 1000) {
            return;
        }
        for (int i = 0; i < underlyingIfaces.size(); ++i) {
            int idxVpnForeground;
            moved[i].uid = tunUid;
            moved[i].set = 1002;
            moved[i].tag = 0;
            moved[i].iface = underlyingIfaces.get(i);
            moved[i].metered = -1;
            moved[i].roaming = -1;
            moved[i].defaultNetwork = -1;
            this.combineValues(moved[i]);
            int idxVpnBackground = this.findIndex(underlyingIfaces.get(i), tunUid, 0, 0, 0, 0, 0);
            if (idxVpnBackground != -1) {
                NetworkStats.tunSubtract(idxVpnBackground, this, moved[i]);
            }
            if ((idxVpnForeground = this.findIndex(underlyingIfaces.get(i), tunUid, 1, 0, 0, 0, 0)) == -1) continue;
            NetworkStats.tunSubtract(idxVpnForeground, this, moved[i]);
        }
    }

    private static void tunSubtract(int i, NetworkStats left, Entry right2) {
        long rxBytes = Math.min(left.rxBytes[i], right2.rxBytes);
        int n = i;
        left.rxBytes[n] = left.rxBytes[n] - rxBytes;
        right2.rxBytes -= rxBytes;
        long rxPackets = Math.min(left.rxPackets[i], right2.rxPackets);
        int n2 = i;
        left.rxPackets[n2] = left.rxPackets[n2] - rxPackets;
        right2.rxPackets -= rxPackets;
        long txBytes = Math.min(left.txBytes[i], right2.txBytes);
        int n3 = i;
        left.txBytes[n3] = left.txBytes[n3] - txBytes;
        right2.txBytes -= txBytes;
        long txPackets = Math.min(left.txPackets[i], right2.txPackets);
        int n4 = i;
        left.txPackets[n4] = left.txPackets[n4] - txPackets;
        right2.txPackets -= txPackets;
    }

    public static interface NonMonotonicObserver<C> {
        public void foundNonMonotonic(NetworkStats var1, int var2, NetworkStats var3, int var4, C var5);

        public void foundNonMonotonic(NetworkStats var1, int var2, C var3);
    }

    @SystemApi
    public static class Entry {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public String iface;
        @UnsupportedAppUsage
        public int uid;
        @UnsupportedAppUsage
        public int set;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int tag;
        public int metered;
        public int roaming;
        public int defaultNetwork;
        @UnsupportedAppUsage
        public long rxBytes;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long rxPackets;
        @UnsupportedAppUsage
        public long txBytes;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long txPackets;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long operations;

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Entry() {
            this(IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        }

        public Entry(long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this(IFACE_ALL, -1, 0, 0, rxBytes, rxPackets, txBytes, txPackets, operations);
        }

        public Entry(String iface, int uid, int set, int tag2, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this(iface, uid, set, tag2, 0, 0, 0, rxBytes, rxPackets, txBytes, txPackets, operations);
        }

        public Entry(String iface, int uid, int set, int tag2, int metered, int roaming, int defaultNetwork, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this.iface = iface;
            this.uid = uid;
            this.set = set;
            this.tag = tag2;
            this.metered = metered;
            this.roaming = roaming;
            this.defaultNetwork = defaultNetwork;
            this.rxBytes = rxBytes;
            this.rxPackets = rxPackets;
            this.txBytes = txBytes;
            this.txPackets = txPackets;
            this.operations = operations;
        }

        public boolean isNegative() {
            return this.rxBytes < 0L || this.rxPackets < 0L || this.txBytes < 0L || this.txPackets < 0L || this.operations < 0L;
        }

        public boolean isEmpty() {
            return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L && this.operations == 0L;
        }

        public void add(Entry another) {
            this.rxBytes += another.rxBytes;
            this.rxPackets += another.rxPackets;
            this.txBytes += another.txBytes;
            this.txPackets += another.txPackets;
            this.operations += another.operations;
        }

        public String getIface() {
            return this.iface;
        }

        public int getUid() {
            return this.uid;
        }

        public int getSet() {
            return this.set;
        }

        public int getTag() {
            return this.tag;
        }

        public int getMetered() {
            return this.metered;
        }

        public int getRoaming() {
            return this.roaming;
        }

        public int getDefaultNetwork() {
            return this.defaultNetwork;
        }

        public long getRxBytes() {
            return this.rxBytes;
        }

        public long getRxPackets() {
            return this.rxPackets;
        }

        public long getTxBytes() {
            return this.txBytes;
        }

        public long getTxPackets() {
            return this.txPackets;
        }

        public long getOperations() {
            return this.operations;
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            builder2.append("iface=").append(this.iface);
            builder2.append(" uid=").append(this.uid);
            builder2.append(" set=").append(NetworkStats.setToString(this.set));
            builder2.append(" tag=").append(NetworkStats.tagToString(this.tag));
            builder2.append(" metered=").append(NetworkStats.meteredToString(this.metered));
            builder2.append(" roaming=").append(NetworkStats.roamingToString(this.roaming));
            builder2.append(" defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.defaultNetwork));
            builder2.append(" rxBytes=").append(this.rxBytes);
            builder2.append(" rxPackets=").append(this.rxPackets);
            builder2.append(" txBytes=").append(this.txBytes);
            builder2.append(" txPackets=").append(this.txPackets);
            builder2.append(" operations=").append(this.operations);
            return builder2.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return this.uid == e.uid && this.set == e.set && this.tag == e.tag && this.metered == e.metered && this.roaming == e.roaming && this.defaultNetwork == e.defaultNetwork && this.rxBytes == e.rxBytes && this.rxPackets == e.rxPackets && this.txBytes == e.txBytes && this.txPackets == e.txPackets && this.operations == e.operations && TextUtils.equals(this.iface, e.iface);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.uid, this.set, this.tag, this.metered, this.roaming, this.defaultNetwork, this.iface);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatsType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DefaultNetwork {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Roaming {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Meteredness {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

