/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.app.usage.NetworkStatsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.connectivity.com.android.net.module.util.CollectionUtils;
import android.net.connectivity.com.android.net.module.util.NetworkIdentityUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkTemplate
implements Parcelable {
    public static final int MATCH_MOBILE = 1;
    public static final int MATCH_WIFI = 4;
    public static final int MATCH_ETHERNET = 5;
    public static final int MATCH_MOBILE_WILDCARD = 6;
    public static final int MATCH_WIFI_WILDCARD = 7;
    public static final int MATCH_BLUETOOTH = 8;
    public static final int MATCH_PROXY = 9;
    public static final int MATCH_CARRIER = 10;
    public static final String WIFI_NETWORKID_ALL;
    public static final String WIFI_NETWORK_KEY_ALL;
    public static final int NETWORK_TYPE_ALL = -1;
    public static final int OEM_MANAGED_ALL = -1;
    public static final int OEM_MANAGED_NO = 0;
    public static final int OEM_MANAGED_YES = -2;
    public static final int OEM_MANAGED_PAID = 1;
    public static final int OEM_MANAGED_PRIVATE = 2;
    private final int mMatchRule;
    private final String mSubscriberId;
    private final String[] mMatchSubscriberIds;
    private final String[] mMatchWifiNetworkKeys;
    private final int mMetered;
    private final int mRoaming;
    private final int mDefaultNetwork;
    private final int mRatType;
    private final int mSubscriberIdMatchRule;
    private final int mOemManaged;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<NetworkTemplate> CREATOR;

    private static boolean isKnownMatchRule(int rule) {
        switch (rule) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateMobileAll(String subscriberId) {
        return new NetworkTemplate(1, subscriberId, null);
    }

    public static NetworkTemplate buildTemplateMobileWithRatType(String subscriberId, int ratType, int metered) {
        if (TextUtils.isEmpty(subscriberId)) {
            return new NetworkTemplate(6, null, null, new String[0], metered, -1, -1, ratType, -1, 0);
        }
        return new NetworkTemplate(1, subscriberId, new String[]{subscriberId}, new String[0], metered, -1, -1, ratType, -1, 0);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static NetworkTemplate buildTemplateMobileWildcard() {
        return new NetworkTemplate(6, null, null);
    }

    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateWifiWildcard() {
        return new NetworkTemplate(7, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    public static NetworkTemplate buildTemplateWifi(String wifiNetworkKey) {
        Objects.requireNonNull(wifiNetworkKey);
        return new NetworkTemplate(4, null, new String[]{null}, new String[]{wifiNetworkKey}, -1, -1, -1, -1, -1, 1);
    }

    public static NetworkTemplate buildTemplateWifi(String wifiNetworkKey, String subscriberId) {
        String[] stringArray;
        String[] stringArray2 = new String[]{subscriberId};
        if (wifiNetworkKey != null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = wifiNetworkKey;
        } else {
            stringArray = new String[]{};
        }
        return new NetworkTemplate(4, subscriberId, stringArray2, stringArray, -1, -1, -1, -1, -1, 0);
    }

    @UnsupportedAppUsage
    public static NetworkTemplate buildTemplateEthernet() {
        return new NetworkTemplate(5, null, null);
    }

    public static NetworkTemplate buildTemplateBluetooth() {
        return new NetworkTemplate(8, null, null);
    }

    public static NetworkTemplate buildTemplateProxy() {
        return new NetworkTemplate(9, null, null);
    }

    public static NetworkTemplate buildTemplateCarrierMetered(String subscriberId) {
        Objects.requireNonNull(subscriberId);
        return new NetworkTemplate(10, subscriberId, new String[]{subscriberId}, new String[0], 1, -1, -1, -1, -1, 0);
    }

    private static void checkValidSubscriberIdMatchRule(int matchRule, int subscriberIdMatchRule) {
        switch (matchRule) {
            case 1: 
            case 10: {
                if (subscriberIdMatchRule == 1) {
                    throw new IllegalArgumentException("Invalid SubscriberIdMatchRule on match rule: " + NetworkTemplate.getMatchRuleName(matchRule));
                }
                return;
            }
        }
    }

    @UnsupportedAppUsage
    public NetworkTemplate(int matchRule, String subscriberId, String wifiNetworkKey) {
        this(matchRule, subscriberId, new String[]{subscriberId}, wifiNetworkKey);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String wifiNetworkKey) {
        String[] stringArray;
        if (wifiNetworkKey != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = wifiNetworkKey;
        } else {
            stringArray = new String[]{};
        }
        this(matchRule, subscriberId, matchSubscriberIds, stringArray, matchRule == 1 || matchRule == 6 || matchRule == 10 ? 1 : -1, -1, -1, -1, -1, 0);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String wifiNetworkKey, int metered, int roaming, int defaultNetwork, int ratType, int oemManaged) {
        String[] stringArray;
        if (wifiNetworkKey != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = wifiNetworkKey;
        } else {
            stringArray = new String[]{};
        }
        this(matchRule, subscriberId, matchSubscriberIds, stringArray, metered, roaming, defaultNetwork, ratType, oemManaged, 0);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String[] matchWifiNetworkKeys, int metered, int roaming, int defaultNetwork, int ratType, int oemManaged, int subscriberIdMatchRule) {
        Objects.requireNonNull(matchWifiNetworkKeys);
        this.mMatchRule = matchRule;
        this.mSubscriberId = subscriberId;
        this.mMatchSubscriberIds = matchSubscriberIds;
        this.mMatchWifiNetworkKeys = matchWifiNetworkKeys;
        this.mMetered = metered;
        this.mRoaming = roaming;
        this.mDefaultNetwork = defaultNetwork;
        this.mRatType = ratType;
        this.mOemManaged = oemManaged;
        this.mSubscriberIdMatchRule = subscriberIdMatchRule;
        NetworkTemplate.checkValidSubscriberIdMatchRule(matchRule, subscriberIdMatchRule);
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            throw new IllegalArgumentException("Unknown network template rule " + matchRule + " will not match any identity.");
        }
    }

    private NetworkTemplate(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mSubscriberId = in.readString();
        this.mMatchSubscriberIds = in.createStringArray();
        this.mMatchWifiNetworkKeys = in.createStringArray();
        this.mMetered = in.readInt();
        this.mRoaming = in.readInt();
        this.mDefaultNetwork = in.readInt();
        this.mRatType = in.readInt();
        this.mOemManaged = in.readInt();
        this.mSubscriberIdMatchRule = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeString(this.mSubscriberId);
        dest.writeStringArray(this.mMatchSubscriberIds);
        dest.writeStringArray(this.mMatchWifiNetworkKeys);
        dest.writeInt(this.mMetered);
        dest.writeInt(this.mRoaming);
        dest.writeInt(this.mDefaultNetwork);
        dest.writeInt(this.mRatType);
        dest.writeInt(this.mOemManaged);
        dest.writeInt(this.mSubscriberIdMatchRule);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder("NetworkTemplate: ");
        builder2.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mSubscriberId != null) {
            builder2.append(", subscriberId=").append(NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mMatchSubscriberIds != null) {
            builder2.append(", matchSubscriberIds=").append(Arrays.toString(NetworkIdentityUtils.scrubSubscriberIds(this.mMatchSubscriberIds)));
        }
        builder2.append(", matchWifiNetworkKeys=").append(Arrays.toString(this.mMatchWifiNetworkKeys));
        if (this.mMetered != -1) {
            builder2.append(", metered=").append(NetworkStats.meteredToString(this.mMetered));
        }
        if (this.mRoaming != -1) {
            builder2.append(", roaming=").append(NetworkStats.roamingToString(this.mRoaming));
        }
        if (this.mDefaultNetwork != -1) {
            builder2.append(", defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.mDefaultNetwork));
        }
        if (this.mRatType != -1) {
            builder2.append(", ratType=").append(this.mRatType);
        }
        if (this.mOemManaged != -1) {
            builder2.append(", oemManaged=").append(NetworkTemplate.getOemManagedNames(this.mOemManaged));
        }
        builder2.append(", subscriberIdMatchRule=").append(NetworkTemplate.subscriberIdMatchRuleToString(this.mSubscriberIdMatchRule));
        return builder2.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mMatchRule, this.mSubscriberId, Arrays.hashCode(this.mMatchWifiNetworkKeys), this.mMetered, this.mRoaming, this.mDefaultNetwork, this.mRatType, this.mOemManaged, this.mSubscriberIdMatchRule);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && Objects.equals(this.mSubscriberId, other.mSubscriberId) && this.mMetered == other.mMetered && this.mRoaming == other.mRoaming && this.mDefaultNetwork == other.mDefaultNetwork && this.mRatType == other.mRatType && this.mOemManaged == other.mOemManaged && this.mSubscriberIdMatchRule == other.mSubscriberIdMatchRule && Arrays.equals(this.mMatchWifiNetworkKeys, other.mMatchWifiNetworkKeys);
        }
        return false;
    }

    private static String subscriberIdMatchRuleToString(int rule) {
        switch (rule) {
            case 0: {
                return "EXACT_MATCH";
            }
            case 1: {
                return "ALL";
            }
        }
        return "Unknown rule " + rule;
    }

    public boolean isMatchRuleMobile() {
        switch (this.mMatchRule) {
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    public int getMatchRule() {
        switch (this.mMatchRule) {
            case 6: {
                return 1;
            }
            case 7: {
                return 4;
            }
        }
        return this.mMatchRule;
    }

    @UnsupportedAppUsage
    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public Set<String> getSubscriberIds() {
        return new ArraySet<String>(Arrays.asList(this.mMatchSubscriberIds));
    }

    public Set<String> getWifiNetworkKeys() {
        return new ArraySet<String>(Arrays.asList(this.mMatchWifiNetworkKeys));
    }

    public String getNetworkId() {
        return this.getWifiNetworkKeys().isEmpty() ? null : this.getWifiNetworkKeys().iterator().next();
    }

    public int getMeteredness() {
        return this.mMetered;
    }

    public int getRoaming() {
        return this.mRoaming;
    }

    public int getDefaultNetworkStatus() {
        return this.mDefaultNetwork;
    }

    public int getRatType() {
        return this.mRatType;
    }

    public int getOemManaged() {
        return this.mOemManaged;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean matches(NetworkIdentity ident) {
        Objects.requireNonNull(ident);
        if (!this.matchesMetered(ident)) {
            return false;
        }
        if (!this.matchesRoaming(ident)) {
            return false;
        }
        if (!this.matchesDefaultNetwork(ident)) {
            return false;
        }
        if (!this.matchesOemNetwork(ident)) {
            return false;
        }
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
            case 6: {
                return this.matchesMobileWildcard(ident);
            }
            case 7: {
                return this.matchesWifiWildcard(ident);
            }
            case 8: {
                return this.matchesBluetooth(ident);
            }
            case 9: {
                return this.matchesProxy(ident);
            }
            case 10: {
                return this.matchesCarrier(ident);
            }
        }
        return false;
    }

    private boolean matchesMetered(NetworkIdentity ident) {
        return this.mMetered == -1 || this.mMetered == 1 && ident.mMetered || this.mMetered == 0 && !ident.mMetered;
    }

    private boolean matchesRoaming(NetworkIdentity ident) {
        return this.mRoaming == -1 || this.mRoaming == 1 && ident.mRoaming || this.mRoaming == 0 && !ident.mRoaming;
    }

    private boolean matchesDefaultNetwork(NetworkIdentity ident) {
        return this.mDefaultNetwork == -1 || this.mDefaultNetwork == 1 && ident.mDefaultNetwork || this.mDefaultNetwork == 0 && !ident.mDefaultNetwork;
    }

    private boolean matchesOemNetwork(NetworkIdentity ident) {
        return this.mOemManaged == -1 || this.mOemManaged == -2 && ident.mOemManaged != 0 || this.mOemManaged == ident.mOemManaged;
    }

    private boolean matchesCollapsedRatType(NetworkIdentity ident) {
        return this.mRatType == -1 || NetworkStatsManager.getCollapsedRatType(this.mRatType) == NetworkStatsManager.getCollapsedRatType(ident.mRatType);
    }

    public boolean matchesSubscriberId(String subscriberId) {
        return this.mSubscriberIdMatchRule == 1 || CollectionUtils.contains(this.mMatchSubscriberIds, subscriberId);
    }

    private boolean matchesWifiNetworkKey(String wifiNetworkKey) {
        Objects.requireNonNull(wifiNetworkKey);
        return CollectionUtils.isEmpty(this.mMatchWifiNetworkKeys) || CollectionUtils.contains(this.mMatchWifiNetworkKeys, wifiNetworkKey);
    }

    private boolean matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return ident.mType == 0 && !CollectionUtils.isEmpty(this.mMatchSubscriberIds) && CollectionUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId) && this.matchesCollapsedRatType(ident);
    }

    private boolean matchesWifi(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: {
                return this.matchesSubscriberId(ident.mSubscriberId) && this.matchesWifiNetworkKey(ident.mWifiNetworkKey);
            }
        }
        return false;
    }

    private boolean matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private boolean matchesCarrier(NetworkIdentity ident) {
        return ident.mSubscriberId != null && !CollectionUtils.isEmpty(this.mMatchSubscriberIds) && CollectionUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId);
    }

    private boolean matchesMobileWildcard(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return ident.mType == 0 && this.matchesCollapsedRatType(ident);
    }

    private boolean matchesWifiWildcard(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean matchesBluetooth(NetworkIdentity ident) {
        return ident.mType == 7;
    }

    private boolean matchesProxy(NetworkIdentity ident) {
        return ident.mType == 16;
    }

    private static String getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 1: {
                return "MOBILE";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 6: {
                return "MOBILE_WILDCARD";
            }
            case 7: {
                return "WIFI_WILDCARD";
            }
            case 8: {
                return "BLUETOOTH";
            }
            case 9: {
                return "PROXY";
            }
            case 10: {
                return "CARRIER";
            }
        }
        return "UNKNOWN(" + matchRule + ")";
    }

    private static String getOemManagedNames(int oemManaged) {
        switch (oemManaged) {
            case -1: {
                return "OEM_MANAGED_ALL";
            }
            case 0: {
                return "OEM_MANAGED_NO";
            }
            case -2: {
                return "OEM_MANAGED_YES";
            }
        }
        return NetworkIdentity.getOemManagedNames(oemManaged);
    }

    @UnsupportedAppUsage
    public static NetworkTemplate normalize(NetworkTemplate template, String[] merged) {
        return NetworkTemplate.normalize(template, Arrays.asList(new String[][]{merged}));
    }

    public static NetworkTemplate normalize(NetworkTemplate template, List<String[]> mergedList) {
        if (template.mSubscriberId == null) {
            return template;
        }
        for (String[] merged : mergedList) {
            if (!CollectionUtils.contains(merged, template.mSubscriberId)) continue;
            String[] matchWifiNetworkKeys = template.mMatchWifiNetworkKeys;
            return new NetworkTemplate(template.mMatchRule, merged[0], merged, CollectionUtils.isEmpty(matchWifiNetworkKeys) ? null : matchWifiNetworkKeys[0]);
        }
        return template;
    }

    static {
        WIFI_NETWORK_KEY_ALL = WIFI_NETWORKID_ALL = null;
        CREATOR = new Parcelable.Creator<NetworkTemplate>(){

            @Override
            public NetworkTemplate createFromParcel(Parcel in) {
                return new NetworkTemplate(in);
            }

            public NetworkTemplate[] newArray(int size) {
                return new NetworkTemplate[size];
            }
        };
    }

    public static class Builder {
        private final int mMatchRule;
        private final SortedSet<String> mMatchSubscriberIds = new TreeSet(Comparator.nullsFirst(Comparator.naturalOrder()));
        private final SortedSet<String> mMatchWifiNetworkKeys = new TreeSet<String>();
        private int mMetered;
        private int mRoaming;
        private int mDefaultNetwork;
        private int mRatType;
        private int mOemManaged;

        public Builder(int matchRule) {
            Builder.assertRequestableMatchRule(matchRule);
            this.mMatchRule = matchRule;
            this.mMetered = -1;
            this.mRoaming = -1;
            this.mDefaultNetwork = -1;
            this.mRatType = -1;
            this.mOemManaged = -1;
        }

        public Builder setSubscriberIds(Set<String> subscriberIds) {
            Objects.requireNonNull(subscriberIds);
            this.mMatchSubscriberIds.clear();
            this.mMatchSubscriberIds.addAll(subscriberIds);
            return this;
        }

        public Builder setWifiNetworkKeys(Set<String> wifiNetworkKeys) {
            Objects.requireNonNull(wifiNetworkKeys);
            for (String key : wifiNetworkKeys) {
                if (key != null) continue;
                throw new IllegalArgumentException("Null is not a valid key");
            }
            this.mMatchWifiNetworkKeys.clear();
            this.mMatchWifiNetworkKeys.addAll(wifiNetworkKeys);
            return this;
        }

        public Builder setMeteredness(int metered) {
            this.mMetered = metered;
            return this;
        }

        public Builder setRoaming(int roaming) {
            this.mRoaming = roaming;
            return this;
        }

        public Builder setDefaultNetworkStatus(int defaultNetwork) {
            this.mDefaultNetwork = defaultNetwork;
            return this;
        }

        public Builder setRatType(int ratType) {
            this.mRatType = ratType;
            return this;
        }

        public Builder setOemManaged(int oemManaged) {
            this.mOemManaged = oemManaged;
            return this;
        }

        private static void assertRequestableMatchRule(int matchRule) {
            if (!NetworkTemplate.isKnownMatchRule(matchRule) || matchRule == 9 || matchRule == 6 || matchRule == 7) {
                throw new IllegalArgumentException("Invalid match rule: " + NetworkTemplate.getMatchRuleName(matchRule));
            }
        }

        private void assertRequestableParameters() {
            this.validateWifiNetworkKeys();
        }

        private void validateWifiNetworkKeys() {
            if (this.mMatchRule != 4 && !this.mMatchWifiNetworkKeys.isEmpty()) {
                throw new IllegalArgumentException("Trying to build non wifi match rule: " + this.mMatchRule + " with wifi network keys");
            }
        }

        private int getWildcardDeducedMatchRule() {
            if (this.mMatchRule == 1 && this.mMatchSubscriberIds.isEmpty()) {
                return 6;
            }
            if (this.mMatchRule == 4 && this.mMatchSubscriberIds.isEmpty() && this.mMatchWifiNetworkKeys.isEmpty()) {
                return 7;
            }
            return this.mMatchRule;
        }

        public NetworkTemplate build() {
            this.assertRequestableParameters();
            int subscriberIdMatchRule = this.mMatchSubscriberIds.isEmpty() ? 1 : 0;
            return new NetworkTemplate(this.getWildcardDeducedMatchRule(), this.mMatchSubscriberIds.isEmpty() ? null : (String)this.mMatchSubscriberIds.iterator().next(), this.mMatchSubscriberIds.toArray(new String[0]), this.mMatchWifiNetworkKeys.toArray(new String[0]), this.mMetered, this.mRoaming, this.mDefaultNetwork, this.mRatType, this.mOemManaged, subscriberIdMatchRule);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OemManaged {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TemplateMatchRule {
    }
}

