/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.usage.NetworkStatsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;

public class TrafficStats {
    private static final String TAG;
    public static final int UNSUPPORTED = -1;
    @Deprecated
    public static final long KB_IN_BYTES = 1024L;
    @Deprecated
    public static final long MB_IN_BYTES = 0x100000L;
    @Deprecated
    public static final long GB_IN_BYTES = 0x40000000L;
    @Deprecated
    public static final long TB_IN_BYTES = 0x10000000000L;
    @Deprecated
    public static final long PB_IN_BYTES = 0x4000000000000L;
    public static final int UID_REMOVED = -4;
    public static final int UID_TETHERING = -5;
    @SystemApi
    public static final int TAG_NETWORK_STACK_RANGE_START = -768;
    @SystemApi
    public static final int TAG_NETWORK_STACK_RANGE_END = -257;
    @SystemApi
    public static final int TAG_SYSTEM_IMPERSONATION_RANGE_START = -256;
    @SystemApi
    public static final int TAG_SYSTEM_IMPERSONATION_RANGE_END = -241;
    @SystemApi
    public static final int TAG_NETWORK_STACK_IMPERSONATION_RANGE_START = -128;
    @SystemApi
    public static final int TAG_NETWORK_STACK_IMPERSONATION_RANGE_END = -113;
    public static final int TAG_SYSTEM_DOWNLOAD = -255;
    public static final int TAG_SYSTEM_MEDIA = -254;
    public static final int TAG_SYSTEM_BACKUP = -253;
    public static final int TAG_SYSTEM_RESTORE = -252;
    public static final int TAG_SYSTEM_APP = -251;
    public static final int TAG_SYSTEM_PROBE = -190;
    private static INetworkStatsService sStatsService;
    private static NetworkStats sActiveProfilingStart;
    private static Object sProfilingLock;
    private static final String LOOPBACK_IFACE = "lo";
    private static ThreadLocal<UidTag> sThreadUidTag;
    public static final int TYPE_RX_BYTES = 0;
    public static final int TYPE_RX_PACKETS = 1;
    public static final int TYPE_TX_BYTES = 2;
    public static final int TYPE_TX_PACKETS = 3;
    public static final int TYPE_TCP_RX_PACKETS = 4;
    public static final int TYPE_TCP_TX_PACKETS = 5;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=130143562L)
    private static synchronized INetworkStatsService getStatsService() {
        if (sStatsService == null) {
            throw new IllegalStateException("TrafficStats not initialized, uid=" + Binder.getCallingUid());
        }
        return sStatsService;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"VisiblySynchronized"})
    public static synchronized void init(Context context) {
        if (sStatsService != null) {
            throw new IllegalStateException("TrafficStats is already initialized, uid=" + Binder.getCallingUid());
        }
        NetworkStatsManager statsManager = context.getSystemService(NetworkStatsManager.class);
        if (statsManager == null) {
            Log.e(TAG, "TrafficStats not initialized, uid=" + Binder.getCallingUid());
            return;
        }
        sStatsService = statsManager.getBinder();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void attachSocketTagger() {
        dalvik.system.SocketTagger.set(new SocketTagger());
    }

    private static int native_tagSocketFd(FileDescriptor fileDescriptor, int n, int n2) {
        return OverrideMethod.invokeI("android.net.TrafficStats#native_tagSocketFd(Ljava/io/FileDescriptor;II)I", true, null);
    }

    private static int native_untagSocketFd(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.net.TrafficStats#native_untagSocketFd(Ljava/io/FileDescriptor;)I", true, null);
    }

    public static void setThreadStatsTag(int tag2) {
        TrafficStats.getAndSetThreadStatsTag(tag2);
    }

    public static int getAndSetThreadStatsTag(int tag2) {
        int old = TrafficStats.sThreadUidTag.get().tag;
        TrafficStats.sThreadUidTag.get().tag = tag2;
        return old;
    }

    @SystemApi
    public static void setThreadStatsTagBackup() {
        TrafficStats.setThreadStatsTag(-253);
    }

    @SystemApi
    public static void setThreadStatsTagRestore() {
        TrafficStats.setThreadStatsTag(-252);
    }

    @SystemApi
    public static void setThreadStatsTagApp() {
        TrafficStats.setThreadStatsTag(-251);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setThreadStatsTagDownload() {
        TrafficStats.setThreadStatsTag(-255);
    }

    public static int getThreadStatsTag() {
        return TrafficStats.sThreadUidTag.get().tag;
    }

    public static void clearThreadStatsTag() {
        TrafficStats.sThreadUidTag.get().tag = -1;
    }

    @SuppressLint(value={"RequiresPermission"})
    public static void setThreadStatsUid(int uid) {
        TrafficStats.sThreadUidTag.get().uid = uid;
    }

    public static int getThreadStatsUid() {
        return TrafficStats.sThreadUidTag.get().uid;
    }

    @Deprecated
    public static void setThreadStatsUidSelf() {
        TrafficStats.setThreadStatsUid(Process.myUid());
    }

    @SuppressLint(value={"RequiresPermission"})
    public static void clearThreadStatsUid() {
        TrafficStats.setThreadStatsUid(-1);
    }

    public static void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public static void tagDatagramSocket(DatagramSocket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagDatagramSocket(DatagramSocket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public static void tagFileDescriptor(FileDescriptor fd) throws IOException {
        SocketTagger.get().tag(fd);
    }

    public static void untagFileDescriptor(FileDescriptor fd) throws IOException {
        SocketTagger.get().untag(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart != null) {
                throw new IllegalStateException("already profiling data");
            }
            sActiveProfilingStart = TrafficStats.getDataLayerSnapshotForUid(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkStats stopDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart == null) {
                throw new IllegalStateException("not profiling data");
            }
            NetworkStats profilingStop = TrafficStats.getDataLayerSnapshotForUid(context);
            NetworkStats profilingDelta = NetworkStats.subtract(profilingStop, sActiveProfilingStart, null, null);
            sActiveProfilingStart = null;
            return profilingDelta;
        }
    }

    public static void incrementOperationCount(int operationCount) {
        int tag2 = TrafficStats.getThreadStatsTag();
        TrafficStats.incrementOperationCount(tag2, operationCount);
    }

    public static void incrementOperationCount(int tag2, int operationCount) {
        int uid = Process.myUid();
        try {
            TrafficStats.getStatsService().incrementOperationCount(uid, tag2, operationCount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void closeQuietly(INetworkStatsSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static long addIfSupported(long stat) {
        return stat == -1L ? 0L : stat;
    }

    public static long getMobileTxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getTxPackets(iface));
        }
        return total;
    }

    public static long getMobileRxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getRxPackets(iface));
        }
        return total;
    }

    public static long getMobileTxBytes() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getTxBytes(iface));
        }
        return total;
    }

    public static long getMobileRxBytes() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            total += TrafficStats.addIfSupported(TrafficStats.getRxBytes(iface));
        }
        return total;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getMobileTcpRxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            long stat = -1L;
            try {
                stat = TrafficStats.getStatsService().getIfaceStats(iface, 4);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            total += TrafficStats.addIfSupported(stat);
        }
        return total;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getMobileTcpTxPackets() {
        long total = 0L;
        for (String iface : TrafficStats.getMobileIfaces()) {
            long stat = -1L;
            try {
                stat = TrafficStats.getStatsService().getIfaceStats(iface, 5);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            total += TrafficStats.addIfSupported(stat);
        }
        return total;
    }

    public static long getTxPackets(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getRxPackets(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTxBytes(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getRxBytes(String iface) {
        try {
            return TrafficStats.getStatsService().getIfaceStats(iface, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackTxPackets() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackRxPackets() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackTxBytes() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getLoopbackRxBytes() {
        try {
            return TrafficStats.getStatsService().getIfaceStats(LOOPBACK_IFACE, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalTxPackets() {
        try {
            return TrafficStats.getStatsService().getTotalStats(3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalRxPackets() {
        try {
            return TrafficStats.getStatsService().getTotalStats(1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalTxBytes() {
        try {
            return TrafficStats.getStatsService().getTotalStats(2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getTotalRxBytes() {
        try {
            return TrafficStats.getStatsService().getTotalStats(0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getUidTxBytes(int uid) {
        try {
            return TrafficStats.getStatsService().getUidStats(uid, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getUidRxBytes(int uid) {
        try {
            return TrafficStats.getStatsService().getUidStats(uid, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getUidTxPackets(int uid) {
        try {
            return TrafficStats.getStatsService().getUidStats(uid, 3);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static long getUidRxPackets(int uid) {
        try {
            return TrafficStats.getStatsService().getUidStats(uid, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public static long getUidTcpTxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxBytes(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpTxSegments(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidTcpRxSegments(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpTxPackets(int uid) {
        return -1L;
    }

    @Deprecated
    public static long getUidUdpRxPackets(int uid) {
        return -1L;
    }

    private static NetworkStats getDataLayerSnapshotForUid(Context context) {
        int uid = Process.myUid();
        try {
            return TrafficStats.getStatsService().getDataLayerSnapshotForUid(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=130143562L)
    private static String[] getMobileIfaces() {
        try {
            return TrafficStats.getStatsService().getMobileIfaces();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static {
        System_Delegate.loadLibrary("framework-connectivity-tiramisu-jni");
        TAG = TrafficStats.class.getSimpleName();
        sProfilingLock = new Object();
        sThreadUidTag = new ThreadLocal<UidTag>(){

            @Override
            protected UidTag initialValue() {
                return new UidTag();
            }
        };
    }

    private static class UidTag {
        public int tag = -1;
        public int uid = -1;

        private UidTag() {
        }
    }

    private static class SocketTagger
    extends dalvik.system.SocketTagger {
        private static final boolean LOGD = true;

        SocketTagger() {
        }

        @Override
        public void tag(FileDescriptor fd) throws SocketException {
            UidTag tagInfo = sThreadUidTag.get();
            Log.d(TAG, "tagSocket(" + fd.getInt$() + ") with statsTag=0x" + Integer.toHexString(tagInfo.tag) + ", statsUid=" + tagInfo.uid);
            if (tagInfo.tag == -1) {
                StrictMode.noteUntaggedSocket();
            }
            if (tagInfo.tag == -1 && tagInfo.uid == -1) {
                return;
            }
            int errno = TrafficStats.native_tagSocketFd(fd, tagInfo.tag, tagInfo.uid);
            if (errno < 0) {
                Log.i(TAG, "tagSocketFd(" + fd.getInt$() + ", " + tagInfo.tag + ", " + tagInfo.uid + ") failed with errno" + errno);
            }
        }

        @Override
        public void untag(FileDescriptor fd) throws SocketException {
            Log.i(TAG, "untagSocket(" + fd.getInt$() + ")");
            UidTag tagInfo = sThreadUidTag.get();
            if (tagInfo.tag == -1 && tagInfo.uid == -1) {
                return;
            }
            int errno = TrafficStats.native_untagSocketFd(fd);
            if (errno < 0) {
                Log.w(TAG, "untagSocket(" + fd.getInt$() + ") failed with errno " + errno);
            }
        }
    }
}

