/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.StringJoiner;

public class VpnProfileState
implements Parcelable {
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_FAILED = 3;
    private final int mState;
    private final String mSessionKey;
    private final boolean mAlwaysOn;
    private final boolean mLockdown;
    public static final Parcelable.Creator<VpnProfileState> CREATOR = new Parcelable.Creator<VpnProfileState>(){

        @Override
        public VpnProfileState createFromParcel(Parcel in) {
            return new VpnProfileState(in);
        }

        public VpnProfileState[] newArray(int size) {
            return new VpnProfileState[size];
        }
    };

    public VpnProfileState(int state, String sessionKey, boolean alwaysOn, boolean lockdown) {
        this.mState = state;
        this.mSessionKey = sessionKey;
        this.mAlwaysOn = alwaysOn;
        this.mLockdown = lockdown;
    }

    public int getState() {
        return this.mState;
    }

    public String getSessionId() {
        return this.mSessionKey;
    }

    public boolean isAlwaysOn() {
        return this.mAlwaysOn;
    }

    public boolean isLockdownEnabled() {
        return this.mLockdown;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mState);
        out.writeString(this.mSessionKey);
        out.writeBoolean(this.mAlwaysOn);
        out.writeBoolean(this.mLockdown);
    }

    private VpnProfileState(Parcel in) {
        this.mState = in.readInt();
        this.mSessionKey = in.readString();
        this.mAlwaysOn = in.readBoolean();
        this.mLockdown = in.readBoolean();
    }

    private String convertStateToString(int state) {
        switch (state) {
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 0: {
                return "DISCONNECTED";
            }
            case 3: {
                return "FAILED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        StringJoiner resultJoiner = new StringJoiner(", ", "{", "}");
        resultJoiner.add("State: " + this.convertStateToString(this.getState()));
        resultJoiner.add("SessionId: " + this.getSessionId());
        resultJoiner.add("Always-on: " + this.isAlwaysOn());
        resultJoiner.add("Lockdown: " + this.isLockdownEnabled());
        return resultJoiner.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VpnProfileState)) {
            return false;
        }
        VpnProfileState that = (VpnProfileState)obj;
        return this.getState() == that.getState() && Objects.equals(this.getSessionId(), that.getSessionId()) && this.isAlwaysOn() == that.isAlwaysOn() && this.isLockdownEnabled() == that.isLockdownEnabled();
    }

    public int hashCode() {
        return Objects.hash(this.getState(), this.getSessionId(), this.isAlwaysOn(), this.isLockdownEnabled());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

