/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.ipsec.ike.ChildSaProposal;
import android.net.ipsec.ike.ChildSessionParams;
import android.net.ipsec.ike.IkeTrafficSelector;
import android.os.PersistableBundle;
import java.util.Objects;

public class TransportModeChildSessionParams
extends ChildSessionParams {
    private TransportModeChildSessionParams(IkeTrafficSelector[] inboundTs, IkeTrafficSelector[] outboundTs, ChildSaProposal[] proposals, int hardLifetimeSec, int softLifetimeSec) {
        super(inboundTs, outboundTs, proposals, hardLifetimeSec, softLifetimeSec, true);
    }

    public static TransportModeChildSessionParams fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle not provided");
        Builder builder2 = new Builder();
        for (ChildSaProposal p : TransportModeChildSessionParams.getProposalsFromPersistableBundle(in)) {
            builder2.addSaProposal(p);
        }
        for (IkeTrafficSelector ts : TransportModeChildSessionParams.getTsFromPersistableBundle(in, "mInboundTrafficSelectors")) {
            builder2.addInboundTrafficSelectors(ts);
        }
        for (IkeTrafficSelector ts : TransportModeChildSessionParams.getTsFromPersistableBundle(in, "mOutboundTrafficSelectors")) {
            builder2.addOutboundTrafficSelectors(ts);
        }
        builder2.setLifetimeSeconds(in.getInt("mHardLifetimeSec"), in.getInt("mSoftLifetimeSec"));
        return builder2.build();
    }

    public static class Builder
    extends ChildSessionParams.Builder {
        public Builder() {
        }

        public Builder(TransportModeChildSessionParams childParams) {
            super(childParams);
        }

        @Deprecated
        @SystemApi
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addSaProposal(ChildSaProposal proposal) {
            return this.addChildSaProposal(proposal);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addChildSaProposal(ChildSaProposal proposal) {
            Objects.requireNonNull(proposal, "Required argument not provided");
            this.addProposal(proposal);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInboundTrafficSelectors(IkeTrafficSelector trafficSelector) {
            Objects.requireNonNull(trafficSelector, "Required argument not provided");
            this.addInboundTs(trafficSelector);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addOutboundTrafficSelectors(IkeTrafficSelector trafficSelector) {
            Objects.requireNonNull(trafficSelector, "Required argument not provided");
            this.addOutboundTs(trafficSelector);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) {
            this.validateAndSetLifetime(hardLifetimeSeconds, softLifetimeSeconds);
            this.mHardLifetimeSec = hardLifetimeSeconds;
            this.mSoftLifetimeSec = softLifetimeSeconds;
            return this;
        }

        public TransportModeChildSessionParams build() {
            this.addDefaultTsIfNotConfigured();
            this.validateOrThrow();
            return new TransportModeChildSessionParams(this.mInboundTsList.toArray(new IkeTrafficSelector[0]), this.mOutboundTsList.toArray(new IkeTrafficSelector[0]), this.mSaProposalList.toArray(new ChildSaProposal[0]), this.mHardLifetimeSec, this.mSoftLifetimeSec);
        }
    }
}

