/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike.exceptions;

import android.net.ipsec.ike.exceptions.IkeProtocolException;
import java.util.Objects;

public class InvalidSelectorsException
extends IkeProtocolException {
    private static final int EXPECTED_ERROR_DATA_LEN_MIN = 28;
    private final int mIpSecSpi;
    private final byte[] mIpSecPacketInfo;

    public InvalidSelectorsException(int spi, byte[] packetInfo) {
        super(39, packetInfo);
        Objects.requireNonNull(packetInfo, "packetInfo is null");
        this.mIpSecSpi = spi;
        this.mIpSecPacketInfo = (byte[])packetInfo.clone();
    }

    @Override
    protected boolean isValidDataLength(int dataLen) {
        return 28 <= dataLen;
    }

    public int getIpSecSpi() {
        return this.mIpSecSpi;
    }

    public byte[] getIpSecPacketInfo() {
        return this.mIpSecPacketInfo;
    }
}

