/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.IpPrefix;
import android.net.lowpan.LowpanIdentity;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILowpanInterfaceListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.lowpan.ILowpanInterfaceListener";

    public void onEnabledChanged(boolean var1) throws RemoteException;

    public void onConnectedChanged(boolean var1) throws RemoteException;

    public void onUpChanged(boolean var1) throws RemoteException;

    public void onRoleChanged(String var1) throws RemoteException;

    public void onStateChanged(String var1) throws RemoteException;

    public void onLowpanIdentityChanged(LowpanIdentity var1) throws RemoteException;

    public void onLinkNetworkAdded(IpPrefix var1) throws RemoteException;

    public void onLinkNetworkRemoved(IpPrefix var1) throws RemoteException;

    public void onLinkAddressAdded(String var1) throws RemoteException;

    public void onLinkAddressRemoved(String var1) throws RemoteException;

    public void onReceiveFromCommissioner(byte[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILowpanInterfaceListener {
        static final int TRANSACTION_onEnabledChanged = 1;
        static final int TRANSACTION_onConnectedChanged = 2;
        static final int TRANSACTION_onUpChanged = 3;
        static final int TRANSACTION_onRoleChanged = 4;
        static final int TRANSACTION_onStateChanged = 5;
        static final int TRANSACTION_onLowpanIdentityChanged = 6;
        static final int TRANSACTION_onLinkNetworkAdded = 7;
        static final int TRANSACTION_onLinkNetworkRemoved = 8;
        static final int TRANSACTION_onLinkAddressAdded = 9;
        static final int TRANSACTION_onLinkAddressRemoved = 10;
        static final int TRANSACTION_onReceiveFromCommissioner = 11;

        public Stub() {
            this.attachInterface(this, ILowpanInterfaceListener.DESCRIPTOR);
        }

        public static ILowpanInterfaceListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILowpanInterfaceListener.DESCRIPTOR);
            if (iin != null && iin instanceof ILowpanInterfaceListener) {
                return (ILowpanInterfaceListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnabledChanged";
                }
                case 2: {
                    return "onConnectedChanged";
                }
                case 3: {
                    return "onUpChanged";
                }
                case 4: {
                    return "onRoleChanged";
                }
                case 5: {
                    return "onStateChanged";
                }
                case 6: {
                    return "onLowpanIdentityChanged";
                }
                case 7: {
                    return "onLinkNetworkAdded";
                }
                case 8: {
                    return "onLinkNetworkRemoved";
                }
                case 9: {
                    return "onLinkAddressAdded";
                }
                case 10: {
                    return "onLinkAddressRemoved";
                }
                case 11: {
                    return "onReceiveFromCommissioner";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILowpanInterfaceListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onEnabledChanged(_arg0);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onConnectedChanged(_arg0);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onUpChanged(_arg0);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onRoleChanged(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onStateChanged(_arg0);
                    break;
                }
                case 6: {
                    LowpanIdentity _arg0 = data.readTypedObject(LowpanIdentity.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLowpanIdentityChanged(_arg0);
                    break;
                }
                case 7: {
                    IpPrefix _arg0 = data.readTypedObject(IpPrefix.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLinkNetworkAdded(_arg0);
                    break;
                }
                case 8: {
                    IpPrefix _arg0 = data.readTypedObject(IpPrefix.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLinkNetworkRemoved(_arg0);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onLinkAddressAdded(_arg0);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onLinkAddressRemoved(_arg0);
                    break;
                }
                case 11: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onReceiveFromCommissioner(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements ILowpanInterfaceListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILowpanInterfaceListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnabledChanged(boolean value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeBoolean(value2);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectedChanged(boolean value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeBoolean(value2);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpChanged(boolean value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeBoolean(value2);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRoleChanged(String value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeString(value2);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateChanged(String value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeString(value2);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLowpanIdentityChanged(LowpanIdentity value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeTypedObject(value2, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLinkNetworkAdded(IpPrefix value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeTypedObject(value2, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLinkNetworkRemoved(IpPrefix value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeTypedObject(value2, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLinkAddressAdded(String value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeString(value2);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLinkAddressRemoved(String value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeString(value2);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveFromCommissioner(byte[] packet) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanInterfaceListener.DESCRIPTOR);
                    _data.writeByteArray(packet);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILowpanInterfaceListener {
        @Override
        public void onEnabledChanged(boolean value2) throws RemoteException {
        }

        @Override
        public void onConnectedChanged(boolean value2) throws RemoteException {
        }

        @Override
        public void onUpChanged(boolean value2) throws RemoteException {
        }

        @Override
        public void onRoleChanged(String value2) throws RemoteException {
        }

        @Override
        public void onStateChanged(String value2) throws RemoteException {
        }

        @Override
        public void onLowpanIdentityChanged(LowpanIdentity value2) throws RemoteException {
        }

        @Override
        public void onLinkNetworkAdded(IpPrefix value2) throws RemoteException {
        }

        @Override
        public void onLinkNetworkRemoved(IpPrefix value2) throws RemoteException {
        }

        @Override
        public void onLinkAddressAdded(String value2) throws RemoteException {
        }

        @Override
        public void onLinkAddressRemoved(String value2) throws RemoteException {
        }

        @Override
        public void onReceiveFromCommissioner(byte[] packet) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

