/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.ILowpanInterface;
import android.net.lowpan.ILowpanManagerListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILowpanManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.lowpan.ILowpanManager";
    public static final String LOWPAN_SERVICE_NAME = "lowpan";

    public ILowpanInterface getInterface(String var1) throws RemoteException;

    public String[] getInterfaceList() throws RemoteException;

    public void addListener(ILowpanManagerListener var1) throws RemoteException;

    public void removeListener(ILowpanManagerListener var1) throws RemoteException;

    public void addInterface(ILowpanInterface var1) throws RemoteException;

    public void removeInterface(ILowpanInterface var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILowpanManager {
        static final int TRANSACTION_getInterface = 1;
        static final int TRANSACTION_getInterfaceList = 2;
        static final int TRANSACTION_addListener = 3;
        static final int TRANSACTION_removeListener = 4;
        static final int TRANSACTION_addInterface = 5;
        static final int TRANSACTION_removeInterface = 6;

        public Stub() {
            this.attachInterface(this, ILowpanManager.DESCRIPTOR);
        }

        public static ILowpanManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILowpanManager.DESCRIPTOR);
            if (iin != null && iin instanceof ILowpanManager) {
                return (ILowpanManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getInterface";
                }
                case 2: {
                    return "getInterfaceList";
                }
                case 3: {
                    return "addListener";
                }
                case 4: {
                    return "removeListener";
                }
                case 5: {
                    return "addInterface";
                }
                case 6: {
                    return "removeInterface";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILowpanManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ILowpanInterface _result = this.getInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    String[] _result = this.getInterfaceList();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 3: {
                    ILowpanManagerListener _arg0 = ILowpanManagerListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ILowpanManagerListener _arg0 = ILowpanManagerListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ILowpanInterface _arg0 = ILowpanInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addInterface(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ILowpanInterface _arg0 = ILowpanInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeInterface(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ILowpanManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILowpanManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ILowpanInterface getInterface(String name) throws RemoteException {
                ILowpanInterface _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ILowpanInterface.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getInterfaceList() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(ILowpanManagerListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(ILowpanManagerListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addInterface(ILowpanInterface lowpan_interface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManager.DESCRIPTOR);
                    _data.writeStrongInterface(lowpan_interface);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeInterface(ILowpanInterface lowpan_interface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILowpanManager.DESCRIPTOR);
                    _data.writeStrongInterface(lowpan_interface);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILowpanManager {
        @Override
        public ILowpanInterface getInterface(String name) throws RemoteException {
            return null;
        }

        @Override
        public String[] getInterfaceList() throws RemoteException {
            return null;
        }

        @Override
        public void addListener(ILowpanManagerListener listener2) throws RemoteException {
        }

        @Override
        public void removeListener(ILowpanManagerListener listener2) throws RemoteException {
        }

        @Override
        public void addInterface(ILowpanInterface lowpan_interface) throws RemoteException {
        }

        @Override
        public void removeInterface(ILowpanInterface lowpan_interface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

