/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.IpPrefix;
import android.net.lowpan.ILowpanInterface;
import android.net.lowpan.ILowpanInterfaceListener;
import android.net.lowpan.LowpanBeaconInfo;
import android.net.lowpan.LowpanIdentity;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;

public class LowpanCommissioningSession {
    private final ILowpanInterface mBinder;
    private final LowpanBeaconInfo mBeaconInfo;
    private final ILowpanInterfaceListener mInternalCallback = new InternalCallback();
    private final Looper mLooper;
    private Handler mHandler;
    private Callback mCallback = null;
    private volatile boolean mIsClosed = false;

    LowpanCommissioningSession(ILowpanInterface binder, LowpanBeaconInfo beaconInfo, Looper looper) {
        this.mBinder = binder;
        this.mBeaconInfo = beaconInfo;
        this.mLooper = looper;
        this.mHandler = this.mLooper != null ? new Handler(this.mLooper) : new Handler();
        try {
            this.mBinder.addListener(this.mInternalCallback);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    private void lockedCleanup() {
        if (!this.mIsClosed) {
            try {
                this.mBinder.removeListener(this.mInternalCallback);
            }
            catch (DeadObjectException deadObjectException) {
            }
            catch (RemoteException x) {
                throw x.rethrowAsRuntimeException();
            }
            if (this.mCallback != null) {
                this.mHandler.post(() -> this.mCallback.onClosed());
            }
        }
        this.mCallback = null;
        this.mIsClosed = true;
    }

    public LowpanBeaconInfo getBeaconInfo() {
        return this.mBeaconInfo;
    }

    public void sendToCommissioner(byte[] packet) {
        if (!this.mIsClosed) {
            try {
                this.mBinder.sendToCommissioner(packet);
            }
            catch (DeadObjectException deadObjectException) {
            }
            catch (RemoteException x) {
                throw x.rethrowAsRuntimeException();
            }
        }
    }

    public synchronized void setCallback(Callback cb, Handler handler) {
        if (!this.mIsClosed) {
            this.mHandler = handler != null ? handler : (this.mLooper != null ? new Handler(this.mLooper) : new Handler());
            this.mCallback = cb;
        }
    }

    public synchronized void close() {
        if (!this.mIsClosed) {
            try {
                this.mBinder.closeCommissioningSession();
                this.lockedCleanup();
            }
            catch (DeadObjectException deadObjectException) {
            }
            catch (RemoteException x) {
                throw x.rethrowAsRuntimeException();
            }
        }
    }

    private class InternalCallback
    extends ILowpanInterfaceListener.Stub {
        private InternalCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStateChanged(String value2) {
            if (!LowpanCommissioningSession.this.mIsClosed) {
                switch (value2) {
                    case "offline": 
                    case "fault": {
                        LowpanCommissioningSession lowpanCommissioningSession = LowpanCommissioningSession.this;
                        synchronized (lowpanCommissioningSession) {
                            LowpanCommissioningSession.this.lockedCleanup();
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void onReceiveFromCommissioner(byte[] packet) {
            LowpanCommissioningSession.this.mHandler.post(() -> {
                LowpanCommissioningSession lowpanCommissioningSession = LowpanCommissioningSession.this;
                synchronized (lowpanCommissioningSession) {
                    if (!LowpanCommissioningSession.this.mIsClosed && LowpanCommissioningSession.this.mCallback != null) {
                        LowpanCommissioningSession.this.mCallback.onReceiveFromCommissioner(packet);
                    }
                }
            });
        }

        @Override
        public void onEnabledChanged(boolean value2) {
        }

        @Override
        public void onConnectedChanged(boolean value2) {
        }

        @Override
        public void onUpChanged(boolean value2) {
        }

        @Override
        public void onRoleChanged(String value2) {
        }

        @Override
        public void onLowpanIdentityChanged(LowpanIdentity value2) {
        }

        @Override
        public void onLinkNetworkAdded(IpPrefix value2) {
        }

        @Override
        public void onLinkNetworkRemoved(IpPrefix value2) {
        }

        @Override
        public void onLinkAddressAdded(String value2) {
        }

        @Override
        public void onLinkAddressRemoved(String value2) {
        }
    }

    public static abstract class Callback {
        public void onReceiveFromCommissioner(byte[] packet) {
        }

        public void onClosed() {
        }
    }
}

