/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.net.nsd.NsdServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INsdServiceConnector
extends IInterface {
    public static final String DESCRIPTOR = "android.net.nsd.INsdServiceConnector";

    public void registerService(int var1, NsdServiceInfo var2) throws RemoteException;

    public void unregisterService(int var1) throws RemoteException;

    public void discoverServices(int var1, NsdServiceInfo var2) throws RemoteException;

    public void stopDiscovery(int var1) throws RemoteException;

    public void resolveService(int var1, NsdServiceInfo var2) throws RemoteException;

    public void startDaemon() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INsdServiceConnector {
        static final int TRANSACTION_registerService = 1;
        static final int TRANSACTION_unregisterService = 2;
        static final int TRANSACTION_discoverServices = 3;
        static final int TRANSACTION_stopDiscovery = 4;
        static final int TRANSACTION_resolveService = 5;
        static final int TRANSACTION_startDaemon = 6;

        public Stub() {
            this.attachInterface(this, INsdServiceConnector.DESCRIPTOR);
        }

        public static INsdServiceConnector asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INsdServiceConnector.DESCRIPTOR);
            if (iin != null && iin instanceof INsdServiceConnector) {
                return (INsdServiceConnector)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerService";
                }
                case 2: {
                    return "unregisterService";
                }
                case 3: {
                    return "discoverServices";
                }
                case 4: {
                    return "stopDiscovery";
                }
                case 5: {
                    return "resolveService";
                }
                case 6: {
                    return "startDaemon";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INsdServiceConnector.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    NsdServiceInfo _arg1 = data.readTypedObject(NsdServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerService(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterService(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    NsdServiceInfo _arg1 = data.readTypedObject(NsdServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.discoverServices(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopDiscovery(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    NsdServiceInfo _arg1 = data.readTypedObject(NsdServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.resolveService(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.startDaemon();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements INsdServiceConnector {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INsdServiceConnector.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerService(int listenerKey, NsdServiceInfo serviceInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INsdServiceConnector.DESCRIPTOR);
                    _data.writeInt(listenerKey);
                    _data.writeTypedObject(serviceInfo, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterService(int listenerKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INsdServiceConnector.DESCRIPTOR);
                    _data.writeInt(listenerKey);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void discoverServices(int listenerKey, NsdServiceInfo serviceInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INsdServiceConnector.DESCRIPTOR);
                    _data.writeInt(listenerKey);
                    _data.writeTypedObject(serviceInfo, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDiscovery(int listenerKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INsdServiceConnector.DESCRIPTOR);
                    _data.writeInt(listenerKey);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolveService(int listenerKey, NsdServiceInfo serviceInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INsdServiceConnector.DESCRIPTOR);
                    _data.writeInt(listenerKey);
                    _data.writeTypedObject(serviceInfo, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDaemon() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INsdServiceConnector.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INsdServiceConnector {
        @Override
        public void registerService(int listenerKey, NsdServiceInfo serviceInfo) throws RemoteException {
        }

        @Override
        public void unregisterService(int listenerKey) throws RemoteException {
        }

        @Override
        public void discoverServices(int listenerKey, NsdServiceInfo serviceInfo) throws RemoteException {
        }

        @Override
        public void stopDiscovery(int listenerKey) throws RemoteException {
        }

        @Override
        public void resolveService(int listenerKey, NsdServiceInfo serviceInfo) throws RemoteException {
        }

        @Override
        public void startDaemon() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

