/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.net.connectivity.android.net.mdns.aidl.DiscoveryInfo;
import android.net.connectivity.android.net.mdns.aidl.GetAddressInfo;
import android.net.connectivity.android.net.mdns.aidl.IMDns;
import android.net.connectivity.android.net.mdns.aidl.IMDnsEventListener;
import android.net.connectivity.android.net.mdns.aidl.RegistrationInfo;
import android.net.connectivity.android.net.mdns.aidl.ResolutionInfo;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;

public class MDnsManager {
    private static final String TAG = MDnsManager.class.getSimpleName();
    private final IMDns mMdns;
    public static final String MDNS_SERVICE = "mdns";
    private static final int NO_RESULT = -1;
    private static final int NETID_UNSET = 0;

    public MDnsManager(IMDns mdns) {
        this.mMdns = mdns;
    }

    public void startDaemon() {
        try {
            this.mMdns.startDaemon();
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Start mdns failed.", e);
        }
    }

    public void stopDaemon() {
        try {
            this.mMdns.stopDaemon();
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Stop mdns failed.", e);
        }
    }

    public boolean registerService(int id2, String serviceName, String registrationType, int port, byte[] txtRecord, int interfaceIdx) {
        RegistrationInfo info = new RegistrationInfo(id2, -1, serviceName, registrationType, port, txtRecord, interfaceIdx);
        try {
            this.mMdns.registerService(info);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Register service failed.", e);
            return false;
        }
        return true;
    }

    public boolean discover(int id2, String registrationType, int interfaceIdx) {
        DiscoveryInfo info = new DiscoveryInfo(id2, -1, "", registrationType, "", interfaceIdx, 0);
        try {
            this.mMdns.discover(info);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Discover service failed.", e);
            return false;
        }
        return true;
    }

    public boolean resolve(int id2, String serviceName, String registrationType, String domain, int interfaceIdx) {
        ResolutionInfo info = new ResolutionInfo(id2, -1, serviceName, registrationType, domain, "", "", 0, new byte[0], interfaceIdx);
        try {
            this.mMdns.resolve(info);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Resolve service failed.", e);
            return false;
        }
        return true;
    }

    public boolean getServiceAddress(int id2, String hostname, int interfaceIdx) {
        GetAddressInfo info = new GetAddressInfo(id2, -1, hostname, "", interfaceIdx, 0);
        try {
            this.mMdns.getServiceAddress(info);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Get service address failed.", e);
            return false;
        }
        return true;
    }

    public boolean stopOperation(int id2) {
        try {
            this.mMdns.stopOperation(id2);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Stop operation failed.", e);
            return false;
        }
        return true;
    }

    public void registerEventListener(IMDnsEventListener listener2) {
        try {
            this.mMdns.registerEventListener(listener2);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Register listener failed.", e);
        }
    }

    public void unregisterEventListener(IMDnsEventListener listener2) {
        try {
            this.mMdns.unregisterEventListener(listener2);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Unregister listener failed.", e);
        }
    }
}

