/*
 * Decompiled with CFR 0.152.
 */
package android.net.sntp;

import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;

public class Timestamp64 {
    public static final Timestamp64 ZERO = Timestamp64.fromComponents(0L, 0);
    static final int SUB_MILLIS_BITS_TO_RANDOMIZE = 22;
    static final long OFFSET_1900_TO_1970 = 2208988800L;
    static final long MAX_SECONDS_IN_ERA = 0xFFFFFFFFL;
    static final long SECONDS_IN_ERA = 0x100000000L;
    static final int NANOS_PER_SECOND = 1000000000;
    private final long mEraSeconds;
    private final int mFractionBits;

    public static Timestamp64 fromComponents(long eraSeconds, int fractionBits) {
        return new Timestamp64(eraSeconds, fractionBits);
    }

    public static Timestamp64 fromString(String string2) {
        int requiredLength = 17;
        if (string2.length() != 17 || string2.charAt(8) != '.') {
            throw new IllegalArgumentException(string2);
        }
        String eraSecondsString = string2.substring(0, 8);
        String fractionString = string2.substring(9);
        long eraSeconds = Long.parseLong(eraSecondsString, 16);
        long fractionBitsAsLong = Long.parseLong(fractionString, 16);
        if (fractionBitsAsLong < 0L || fractionBitsAsLong > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid fractionBits:" + fractionString);
        }
        return new Timestamp64(eraSeconds, (int)fractionBitsAsLong);
    }

    public static Timestamp64 fromInstant(Instant instant) {
        long ntpEraSeconds = instant.getEpochSecond() + 2208988800L;
        if (ntpEraSeconds < 0L) {
            ntpEraSeconds = 0x100000000L - -ntpEraSeconds % 0x100000000L;
        }
        long nanos = instant.getNano();
        int fractionBits = Timestamp64.nanosToFractionBits(nanos);
        return new Timestamp64(ntpEraSeconds %= 0x100000000L, fractionBits);
    }

    private Timestamp64(long eraSeconds, int fractionBits) {
        if (eraSeconds < 0L || eraSeconds > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid parameters. seconds=" + eraSeconds + ", fraction=" + fractionBits);
        }
        this.mEraSeconds = eraSeconds;
        this.mFractionBits = fractionBits;
    }

    public long getEraSeconds() {
        return this.mEraSeconds;
    }

    public int getFractionBits() {
        return this.mFractionBits;
    }

    public String toString() {
        return TextUtils.formatSimple("%08x.%08x", this.mEraSeconds, this.mFractionBits);
    }

    public Instant toInstant(int ntpEra) {
        long secondsSinceEpoch = this.mEraSeconds - 2208988800L;
        int nanos = Timestamp64.fractionBitsToNanos(this.mFractionBits);
        return Instant.ofEpochSecond(secondsSinceEpoch += (long)ntpEra * 0x100000000L, nanos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp64 that = (Timestamp64)o;
        return this.mEraSeconds == that.mEraSeconds && this.mFractionBits == that.mFractionBits;
    }

    public int hashCode() {
        return Objects.hash(this.mEraSeconds, this.mFractionBits);
    }

    static int fractionBitsToNanos(int fractionBits) {
        long fractionBitsLong = (long)fractionBits & 0xFFFFFFFFL;
        return (int)(fractionBitsLong * 1000000000L >>> 32);
    }

    static int nanosToFractionBits(long nanos) {
        if (nanos > 1000000000L) {
            throw new IllegalArgumentException();
        }
        return (int)((nanos << 32) / 1000000000L);
    }

    public Timestamp64 randomizeSubMillis(Random random) {
        int randomizedFractionBits = Timestamp64.randomizeLowestBits(random, this.mFractionBits, 22);
        return new Timestamp64(this.mEraSeconds, randomizedFractionBits);
    }

    @VisibleForTesting
    public static int randomizeLowestBits(Random random, int value2, int bitsToRandomize) {
        if (bitsToRandomize < 1 || bitsToRandomize >= 32) {
            throw new IllegalArgumentException(Integer.toString(bitsToRandomize));
        }
        int upperBitMask = -1 << bitsToRandomize;
        int lowerBitMask = ~upperBitMask;
        int randomValue = random.nextInt();
        return value2 & upperBitMask | randomValue & lowerBitMask;
    }
}

