/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.annotation.SuppressLint;
import android.net.ipsec.ike.IkeTunnelConnectionParams;
import android.net.vcn.VcnCellUnderlyingNetworkTemplate;
import android.net.vcn.VcnUnderlyingNetworkTemplate;
import android.net.vcn.VcnWifiUnderlyingNetworkTemplate;
import android.net.vcn.persistablebundleutils.TunnelConnectionParamsUtils;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.vcn.repackaged.util.PersistableBundleUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class VcnGatewayConnectionConfig {
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    static final int MIN_MTU_V6 = 1280;
    public static final Set<Integer> ALLOWED_CAPABILITIES;
    private static final int DEFAULT_MAX_MTU = 1500;
    private static final int MAX_RETRY_INTERVAL_COUNT = 10;
    private static final long MINIMUM_REPEATING_RETRY_INTERVAL_MS;
    private static final long[] DEFAULT_RETRY_INTERVALS_MS;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final List<VcnUnderlyingNetworkTemplate> DEFAULT_UNDERLYING_NETWORK_TEMPLATES;
    private static final String GATEWAY_CONNECTION_NAME_KEY = "mGatewayConnectionName";
    private final String mGatewayConnectionName;
    private static final String TUNNEL_CONNECTION_PARAMS_KEY = "mTunnelConnectionParams";
    private IkeTunnelConnectionParams mTunnelConnectionParams;
    private static final String EXPOSED_CAPABILITIES_KEY = "mExposedCapabilities";
    private final SortedSet<Integer> mExposedCapabilities;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final String UNDERLYING_NETWORK_TEMPLATES_KEY = "mUnderlyingNetworkTemplates";
    private final List<VcnUnderlyingNetworkTemplate> mUnderlyingNetworkTemplates;
    private static final String MAX_MTU_KEY = "mMaxMtu";
    private final int mMaxMtu;
    private static final String RETRY_INTERVAL_MS_KEY = "mRetryIntervalsMs";
    private final long[] mRetryIntervalsMs;

    private VcnGatewayConnectionConfig(String gatewayConnectionName, IkeTunnelConnectionParams tunnelConnectionParams, Set<Integer> exposedCapabilities, List<VcnUnderlyingNetworkTemplate> underlyingNetworkTemplates, long[] retryIntervalsMs, int maxMtu) {
        this.mGatewayConnectionName = gatewayConnectionName;
        this.mTunnelConnectionParams = tunnelConnectionParams;
        this.mExposedCapabilities = new TreeSet<Integer>(exposedCapabilities);
        this.mRetryIntervalsMs = retryIntervalsMs;
        this.mMaxMtu = maxMtu;
        this.mUnderlyingNetworkTemplates = new ArrayList<VcnUnderlyingNetworkTemplate>(underlyingNetworkTemplates);
        if (this.mUnderlyingNetworkTemplates.isEmpty()) {
            this.mUnderlyingNetworkTemplates.addAll(DEFAULT_UNDERLYING_NETWORK_TEMPLATES);
        }
        this.validate();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public VcnGatewayConnectionConfig(PersistableBundle in) {
        PersistableBundle tunnelConnectionParamsBundle = in.getPersistableBundle(TUNNEL_CONNECTION_PARAMS_KEY);
        Objects.requireNonNull(tunnelConnectionParamsBundle, "tunnelConnectionParamsBundle was null");
        PersistableBundle exposedCapsBundle = in.getPersistableBundle(EXPOSED_CAPABILITIES_KEY);
        this.mGatewayConnectionName = in.getString(GATEWAY_CONNECTION_NAME_KEY);
        this.mTunnelConnectionParams = TunnelConnectionParamsUtils.fromPersistableBundle(tunnelConnectionParamsBundle);
        this.mExposedCapabilities = new TreeSet<Integer>(PersistableBundleUtils.toList(exposedCapsBundle, PersistableBundleUtils.INTEGER_DESERIALIZER));
        PersistableBundle networkTemplatesBundle = in.getPersistableBundle(UNDERLYING_NETWORK_TEMPLATES_KEY);
        this.mUnderlyingNetworkTemplates = networkTemplatesBundle == null ? new ArrayList<VcnUnderlyingNetworkTemplate>(DEFAULT_UNDERLYING_NETWORK_TEMPLATES) : PersistableBundleUtils.toList(networkTemplatesBundle, VcnUnderlyingNetworkTemplate::fromPersistableBundle);
        this.mRetryIntervalsMs = in.getLongArray(RETRY_INTERVAL_MS_KEY);
        this.mMaxMtu = in.getInt(MAX_MTU_KEY);
        this.validate();
    }

    private void validate() {
        Objects.requireNonNull(this.mGatewayConnectionName, "gatewayConnectionName was null");
        Objects.requireNonNull(this.mTunnelConnectionParams, "tunnel connection parameter was null");
        Preconditions.checkArgument(this.mExposedCapabilities != null && !this.mExposedCapabilities.isEmpty(), "exposedCapsBundle was null or empty");
        for (Integer cap : this.getAllExposedCapabilities()) {
            VcnGatewayConnectionConfig.checkValidCapability(cap);
        }
        VcnGatewayConnectionConfig.validateNetworkTemplateList(this.mUnderlyingNetworkTemplates);
        Objects.requireNonNull(this.mRetryIntervalsMs, "retryIntervalsMs was null");
        VcnGatewayConnectionConfig.validateRetryInterval(this.mRetryIntervalsMs);
        Preconditions.checkArgument(this.mMaxMtu >= 1280, "maxMtu must be at least IPv6 min MTU (1280)");
    }

    private static void checkValidCapability(int capability) {
        Preconditions.checkArgument(ALLOWED_CAPABILITIES.contains(capability), "NetworkCapability " + capability + "out of range");
    }

    private static void validateRetryInterval(long[] retryIntervalsMs) {
        Preconditions.checkArgument(retryIntervalsMs != null && retryIntervalsMs.length > 0 && retryIntervalsMs.length <= 10, "retryIntervalsMs was null, empty or exceed max interval count");
        long repeatingInterval = retryIntervalsMs[retryIntervalsMs.length - 1];
        if (repeatingInterval < MINIMUM_REPEATING_RETRY_INTERVAL_MS) {
            throw new IllegalArgumentException("Repeating retry interval was too short, must be a minimum of 15 minutes: " + repeatingInterval);
        }
    }

    private static void validateNetworkTemplateList(List<VcnUnderlyingNetworkTemplate> networkPriorityRules) {
        Objects.requireNonNull(networkPriorityRules, "networkPriorityRules is null");
        ArraySet<VcnUnderlyingNetworkTemplate> existingRules = new ArraySet<VcnUnderlyingNetworkTemplate>();
        for (VcnUnderlyingNetworkTemplate rule : networkPriorityRules) {
            Objects.requireNonNull(rule, "Found null value VcnUnderlyingNetworkTemplate");
            if (existingRules.add(rule)) continue;
            throw new IllegalArgumentException("Found duplicate VcnUnderlyingNetworkTemplate");
        }
    }

    public String getGatewayConnectionName() {
        return this.mGatewayConnectionName;
    }

    public IkeTunnelConnectionParams getTunnelConnectionParams() {
        return this.mTunnelConnectionParams;
    }

    public int[] getExposedCapabilities() {
        return ArrayUtils.convertToIntArray(new ArrayList<Integer>(this.mExposedCapabilities));
    }

    @Deprecated
    public Set<Integer> getAllExposedCapabilities() {
        return Collections.unmodifiableSet(this.mExposedCapabilities);
    }

    public List<VcnUnderlyingNetworkTemplate> getVcnUnderlyingNetworkPriorities() {
        return new ArrayList<VcnUnderlyingNetworkTemplate>(this.mUnderlyingNetworkTemplates);
    }

    public long[] getRetryIntervalsMillis() {
        return Arrays.copyOf(this.mRetryIntervalsMs, this.mRetryIntervalsMs.length);
    }

    public int getMaxMtu() {
        return this.mMaxMtu;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        PersistableBundle tunnelConnectionParamsBundle = TunnelConnectionParamsUtils.toPersistableBundle(this.mTunnelConnectionParams);
        PersistableBundle exposedCapsBundle = PersistableBundleUtils.fromList(new ArrayList<Integer>(this.mExposedCapabilities), PersistableBundleUtils.INTEGER_SERIALIZER);
        PersistableBundle networkTemplatesBundle = PersistableBundleUtils.fromList(this.mUnderlyingNetworkTemplates, VcnUnderlyingNetworkTemplate::toPersistableBundle);
        result.putString(GATEWAY_CONNECTION_NAME_KEY, this.mGatewayConnectionName);
        result.putPersistableBundle(TUNNEL_CONNECTION_PARAMS_KEY, tunnelConnectionParamsBundle);
        result.putPersistableBundle(EXPOSED_CAPABILITIES_KEY, exposedCapsBundle);
        result.putPersistableBundle(UNDERLYING_NETWORK_TEMPLATES_KEY, networkTemplatesBundle);
        result.putLongArray(RETRY_INTERVAL_MS_KEY, this.mRetryIntervalsMs);
        result.putInt(MAX_MTU_KEY, this.mMaxMtu);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.mGatewayConnectionName, this.mTunnelConnectionParams, this.mExposedCapabilities, this.mUnderlyingNetworkTemplates, Arrays.hashCode(this.mRetryIntervalsMs), this.mMaxMtu);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VcnGatewayConnectionConfig)) {
            return false;
        }
        VcnGatewayConnectionConfig rhs = (VcnGatewayConnectionConfig)other;
        return this.mGatewayConnectionName.equals(rhs.mGatewayConnectionName) && this.mTunnelConnectionParams.equals(rhs.mTunnelConnectionParams) && this.mExposedCapabilities.equals(rhs.mExposedCapabilities) && this.mUnderlyingNetworkTemplates.equals(rhs.mUnderlyingNetworkTemplates) && Arrays.equals(this.mRetryIntervalsMs, rhs.mRetryIntervalsMs) && this.mMaxMtu == rhs.mMaxMtu;
    }

    static {
        ArraySet<Integer> allowedCaps = new ArraySet<Integer>();
        allowedCaps.add(0);
        allowedCaps.add(1);
        allowedCaps.add(2);
        allowedCaps.add(3);
        allowedCaps.add(4);
        allowedCaps.add(5);
        allowedCaps.add(7);
        allowedCaps.add(8);
        allowedCaps.add(9);
        allowedCaps.add(10);
        allowedCaps.add(12);
        allowedCaps.add(23);
        ALLOWED_CAPABILITIES = Collections.unmodifiableSet(allowedCaps);
        MINIMUM_REPEATING_RETRY_INTERVAL_MS = TimeUnit.MINUTES.toMillis(15L);
        DEFAULT_RETRY_INTERVALS_MS = new long[]{TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(5L), TimeUnit.SECONDS.toMillis(30L), TimeUnit.MINUTES.toMillis(1L), TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(15L)};
        DEFAULT_UNDERLYING_NETWORK_TEMPLATES = new ArrayList<VcnUnderlyingNetworkTemplate>();
        DEFAULT_UNDERLYING_NETWORK_TEMPLATES.add(new VcnCellUnderlyingNetworkTemplate.Builder().setOpportunistic(1).build());
        DEFAULT_UNDERLYING_NETWORK_TEMPLATES.add(new VcnWifiUnderlyingNetworkTemplate.Builder().build());
        DEFAULT_UNDERLYING_NETWORK_TEMPLATES.add(new VcnCellUnderlyingNetworkTemplate.Builder().build());
    }

    public static class Builder {
        private final String mGatewayConnectionName;
        private final IkeTunnelConnectionParams mTunnelConnectionParams;
        private final Set<Integer> mExposedCapabilities = new ArraySet<Integer>();
        private final List<VcnUnderlyingNetworkTemplate> mUnderlyingNetworkTemplates = new ArrayList<VcnUnderlyingNetworkTemplate>(DEFAULT_UNDERLYING_NETWORK_TEMPLATES);
        private long[] mRetryIntervalsMs = DEFAULT_RETRY_INTERVALS_MS;
        private int mMaxMtu = 1500;

        public Builder(String gatewayConnectionName, IkeTunnelConnectionParams tunnelConnectionParams) {
            Objects.requireNonNull(gatewayConnectionName, "gatewayConnectionName was null");
            Objects.requireNonNull(tunnelConnectionParams, "tunnelConnectionParams was null");
            if (!tunnelConnectionParams.getIkeSessionParams().hasIkeOption(2)) {
                throw new IllegalArgumentException("MOBIKE must be configured for the provided IkeSessionParams");
            }
            this.mGatewayConnectionName = gatewayConnectionName;
            this.mTunnelConnectionParams = tunnelConnectionParams;
        }

        public Builder addExposedCapability(int exposedCapability) {
            VcnGatewayConnectionConfig.checkValidCapability(exposedCapability);
            this.mExposedCapabilities.add(exposedCapability);
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        public Builder removeExposedCapability(int exposedCapability) {
            VcnGatewayConnectionConfig.checkValidCapability(exposedCapability);
            this.mExposedCapabilities.remove(exposedCapability);
            return this;
        }

        public Builder setVcnUnderlyingNetworkPriorities(List<VcnUnderlyingNetworkTemplate> underlyingNetworkTemplates) {
            VcnGatewayConnectionConfig.validateNetworkTemplateList(underlyingNetworkTemplates);
            this.mUnderlyingNetworkTemplates.clear();
            if (underlyingNetworkTemplates.isEmpty()) {
                this.mUnderlyingNetworkTemplates.addAll(DEFAULT_UNDERLYING_NETWORK_TEMPLATES);
            } else {
                this.mUnderlyingNetworkTemplates.addAll(underlyingNetworkTemplates);
            }
            return this;
        }

        public Builder setRetryIntervalsMillis(long[] retryIntervalsMs) {
            VcnGatewayConnectionConfig.validateRetryInterval(retryIntervalsMs);
            this.mRetryIntervalsMs = retryIntervalsMs;
            return this;
        }

        public Builder setMaxMtu(int maxMtu) {
            Preconditions.checkArgument(maxMtu >= 1280, "maxMtu must be at least IPv6 min MTU (1280)");
            this.mMaxMtu = maxMtu;
            return this;
        }

        public VcnGatewayConnectionConfig build() {
            return new VcnGatewayConnectionConfig(this.mGatewayConnectionName, this.mTunnelConnectionParams, this.mExposedCapabilities, this.mUnderlyingNetworkTemplates, this.mRetryIntervalsMs, this.mMaxMtu);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VcnSupportedCapability {
    }
}

