/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.IScoreUpdateObserver;
import android.net.wifi.WifiConnectedSessionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiConnectedNetworkScorer
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IWifiConnectedNetworkScorer";

    public void onStart(WifiConnectedSessionInfo var1) throws RemoteException;

    public void onStop(int var1) throws RemoteException;

    public void onSetScoreUpdateObserver(IScoreUpdateObserver var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiConnectedNetworkScorer {
        static final int TRANSACTION_onStart = 1;
        static final int TRANSACTION_onStop = 2;
        static final int TRANSACTION_onSetScoreUpdateObserver = 3;

        public Stub() {
            this.attachInterface(this, IWifiConnectedNetworkScorer.DESCRIPTOR);
        }

        public static IWifiConnectedNetworkScorer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiConnectedNetworkScorer.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiConnectedNetworkScorer) {
                return (IWifiConnectedNetworkScorer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiConnectedNetworkScorer.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    WifiConnectedSessionInfo _arg0 = data.readTypedObject(WifiConnectedSessionInfo.CREATOR);
                    this.onStart(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    this.onStop(_arg0);
                    break;
                }
                case 3: {
                    IScoreUpdateObserver _arg0 = IScoreUpdateObserver.Stub.asInterface(data.readStrongBinder());
                    this.onSetScoreUpdateObserver(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IWifiConnectedNetworkScorer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiConnectedNetworkScorer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStart(WifiConnectedSessionInfo sessionInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiConnectedNetworkScorer.DESCRIPTOR);
                    _data.writeTypedObject(sessionInfo, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStop(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiConnectedNetworkScorer.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetScoreUpdateObserver(IScoreUpdateObserver observerImpl) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiConnectedNetworkScorer.DESCRIPTOR);
                    _data.writeStrongInterface(observerImpl);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiConnectedNetworkScorer {
        @Override
        public void onStart(WifiConnectedSessionInfo sessionInfo) throws RemoteException {
        }

        @Override
        public void onStop(int sessionId) throws RemoteException {
        }

        @Override
        public void onSetScoreUpdateObserver(IScoreUpdateObserver observerImpl) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

