/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class MloLink
implements Parcelable {
    public static final int INVALID_MLO_LINK_ID = -1;
    public static final int MIN_MLO_LINK_ID = 0;
    public static final int MAX_MLO_LINK_ID = 15;
    public static final int MLO_LINK_STATE_INVALID = 0;
    public static final int MLO_LINK_STATE_UNASSOCIATED = 1;
    public static final int MLO_LINK_STATE_IDLE = 2;
    public static final int MLO_LINK_STATE_ACTIVE = 3;
    private int mLinkId;
    private MacAddress mApMacAddress;
    private MacAddress mStaMacAddress;
    private int mState;
    private int mBand;
    private int mChannel;
    public static final Parcelable.Creator<MloLink> CREATOR = new Parcelable.Creator<MloLink>(){

        @Override
        public MloLink createFromParcel(Parcel in) {
            MloLink link2 = new MloLink();
            link2.mBand = in.readInt();
            link2.mChannel = in.readInt();
            link2.mLinkId = in.readInt();
            link2.mState = in.readInt();
            link2.mApMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            link2.mStaMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            return link2;
        }

        public MloLink[] newArray(int size) {
            return new MloLink[size];
        }
    };

    public MloLink() {
        this.mBand = 0;
        this.mChannel = 0;
        this.mState = 1;
        this.mApMacAddress = null;
        this.mStaMacAddress = null;
        this.mLinkId = -1;
    }

    public MloLink(MloLink source, long redactions) {
        this.mBand = source.mBand;
        this.mChannel = source.mChannel;
        this.mLinkId = source.mLinkId;
        this.mState = source.mState;
        this.mStaMacAddress = (redactions & 2L) != 0L || source.mStaMacAddress == null ? null : MacAddress.fromString(source.mStaMacAddress.toString());
        this.mApMacAddress = (redactions & 1L) != 0L || source.mApMacAddress == null ? null : MacAddress.fromString(source.mApMacAddress.toString());
    }

    public int getBand() {
        return this.mBand;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getLinkId() {
        return this.mLinkId;
    }

    public int getState() {
        return this.mState;
    }

    public MacAddress getApMacAddress() {
        return this.mApMacAddress;
    }

    public MacAddress getStaMacAddress() {
        return this.mStaMacAddress;
    }

    public void setChannel(int channel) {
        this.mChannel = channel;
    }

    public void setBand(int band) {
        this.mBand = band;
    }

    public void setLinkId(int linkId) {
        this.mLinkId = linkId;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public void setApMacAddress(MacAddress address) {
        this.mApMacAddress = address;
    }

    public void setStaMacAddress(MacAddress address) {
        this.mStaMacAddress = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MloLink that = (MloLink)o;
        return this.mBand == that.mBand && this.mChannel == that.mChannel && this.mLinkId == that.mLinkId && Objects.equals(this.mApMacAddress, that.mApMacAddress) && Objects.equals(this.mStaMacAddress, that.mStaMacAddress) && this.mState == that.mState;
    }

    public int hashCode() {
        return Objects.hash(this.mBand, this.mChannel, this.mLinkId, this.mApMacAddress, this.mStaMacAddress, this.mState);
    }

    private String getStateString(int state) {
        switch (state) {
            case 0: {
                return "MLO_LINK_STATE_INVALID";
            }
            case 1: {
                return "MLO_LINK_STATE_UNASSOCIATED";
            }
            case 2: {
                return "MLO_LINK_STATE_IDLE";
            }
            case 3: {
                return "MLO_LINK_STATE_ACTIVE";
            }
        }
        return "Unknown MLO link state";
    }

    public static boolean isValidState(int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MloLink{");
        if (this.mBand == 1) {
            sb.append("2.4GHz");
        } else if (this.mBand == 2) {
            sb.append("5GHz");
        } else if (this.mBand == 8) {
            sb.append("6GHz");
        } else {
            sb.append("UNKNOWN BAND");
        }
        sb.append(", channel: ").append(this.mChannel);
        sb.append(", id: ").append(this.mLinkId);
        sb.append(", state: ").append(this.getStateString(this.mState));
        if (this.mApMacAddress != null) {
            sb.append(", AP MAC Address: ").append(this.mApMacAddress.toString());
        }
        if (this.mStaMacAddress != null) {
            sb.append(", STA MAC Address: ").append(this.mStaMacAddress.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mBand);
        dest.writeInt(this.mChannel);
        dest.writeInt(this.mLinkId);
        dest.writeInt(this.mState);
        dest.writeParcelable(this.mApMacAddress, flags);
        dest.writeParcelable(this.mStaMacAddress, flags);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MloLinkState {
    }
}

