/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.RttManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.net.wifi.rtt.IWifiRttManager;
import android.net.wifi.rtt.WifiRttManager;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;

@SystemApi
public class WifiFrameworkInitializer {
    @VisibleForTesting
    public static Looper getInstanceLooper() {
        return NoPreloadHolder.INSTANCE.getLooper();
    }

    private WifiFrameworkInitializer() {
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("wifi", WifiManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                return null;
            }
            IWifiManager service = IWifiManager.Stub.asInterface(serviceBinder);
            return new WifiManager(context, service, WifiFrameworkInitializer.getInstanceLooper());
        });
        SystemServiceRegistry.registerContextAwareService("wifip2p", WifiP2pManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.direct")) {
                return null;
            }
            IWifiP2pManager service = IWifiP2pManager.Stub.asInterface(serviceBinder);
            return new WifiP2pManager(service);
        });
        SystemServiceRegistry.registerContextAwareService("wifiaware", WifiAwareManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.aware")) {
                return null;
            }
            IWifiAwareManager service = IWifiAwareManager.Stub.asInterface(serviceBinder);
            return new WifiAwareManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("wifiscanner", WifiScanner.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
                return null;
            }
            IWifiScanner service = IWifiScanner.Stub.asInterface(serviceBinder);
            return new WifiScanner(context, service, WifiFrameworkInitializer.getInstanceLooper());
        });
        SystemServiceRegistry.registerContextAwareService("wifirtt", WifiRttManager.class, (context, serviceBinder) -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.rtt")) {
                return null;
            }
            IWifiRttManager service = IWifiRttManager.Stub.asInterface(serviceBinder);
            return new WifiRttManager(context, service);
        });
        SystemServiceRegistry.registerContextAwareService("rttmanager", RttManager.class, context -> {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.wifi.rtt")) {
                return null;
            }
            WifiRttManager wifiRttManager = context.getSystemService(WifiRttManager.class);
            return new RttManager(context, wifiRttManager);
        });
    }

    private static class NoPreloadHolder {
        private static final HandlerThread INSTANCE = NoPreloadHolder.createInstance();

        private NoPreloadHolder() {
        }

        private static HandlerThread createInstance() {
            HandlerThread thread = new HandlerThread("WifiManagerThread");
            thread.start();
            return thread;
        }
    }
}

