/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.wifi.aware.MacAddrMapping;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiAwareMacAddressProvider
extends IInterface {
    public void macAddress(MacAddrMapping[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiAwareMacAddressProvider {
        public static final String DESCRIPTOR = "android.net.wifi.aware.IWifiAwareMacAddressProvider";
        static final int TRANSACTION_macAddress = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiAwareMacAddressProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiAwareMacAddressProvider) {
                return (IWifiAwareMacAddressProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    MacAddrMapping[] _arg0 = data.createTypedArray(MacAddrMapping.CREATOR);
                    this.macAddress(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IWifiAwareMacAddressProvider {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void macAddress(MacAddrMapping[] peerIdToMacList) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(peerIdToMacList, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiAwareMacAddressProvider {
        @Override
        public void macAddress(MacAddrMapping[] peerIdToMacList) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

